/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.nuage.vsp.acs.client.api.NuageVspAclClient;
import net.nuage.vsp.acs.client.api.impl.NuageVspRestApi;
import net.nuage.vsp.acs.client.api.model.Protocol;
import net.nuage.vsp.acs.client.api.model.VspAclRule;
import net.nuage.vsp.acs.client.api.model.VspHost;
import net.nuage.vsp.acs.client.api.model.VspNetwork;
import net.nuage.vsp.acs.client.api.model.VspStaticRoute;
import net.nuage.vsp.acs.client.common.NuageVspConstants;
import net.nuage.vsp.acs.client.common.model.Acl;
import net.nuage.vsp.acs.client.common.model.AclRulesDetails;
import net.nuage.vsp.acs.client.common.model.NuageVspAttribute;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;
import net.nuage.vsp.acs.client.common.model.NuageVspObject;
import net.nuage.vsp.acs.client.common.utils.Logger;
import net.nuage.vsp.acs.client.common.utils.NetUtils;
import net.nuage.vsp.acs.client.common.utils.UuidUtils;
import net.nuage.vsp.acs.client.exception.NuageVspApiException;
import net.nuage.vsp.acs.client.exception.NuageVspException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class NuageVspAclClientImpl
extends NuageVspRestApi
implements NuageVspAclClient {
    private static final Logger s_logger = new Logger(NuageVspAclClientImpl.class);
    public static final Random RANDOM = new Random();

    public NuageVspAclClientImpl(VspHost vspHost) {
        super(vspHost);
    }

    @Override
    public NuageVspObject getOnlyACLTemplateAssociatedToDomain(String networkUuid, NuageVspEntity domainType, String domainId, NuageVspEntity aclTemplateType) throws NuageVspException {
        return (NuageVspObject)Iterables.getOnlyElement(this.getACLTemplatesAssociatedToDomain(networkUuid, domainType, domainId, aclTemplateType, NuageVspAclClient.AclTemplatePriorityType.NONE, true));
    }

    @Override
    public String getACLTemplateId(NuageVspEntity parentType, String parentId, NuageVspEntity aclTemplateType, NuageVspAclClient.AclTemplatePriorityType priorityType, Integer priority) throws NuageVspApiException {
        String aclTemplates;
        switch (priorityType) {
            case TOP: 
            case BOTTOM: {
                aclTemplates = this.getResources(parentType, parentId, aclTemplateType, NuageVspAttribute.ACLTEMPLATES_PRIORITY_TYPE, priorityType.name());
                break;
            }
            default: {
                aclTemplates = this.getResources(parentType, parentId, aclTemplateType, NuageVspAttribute.ACLTEMPLATES_PRIORITY, priority);
            }
        }
        if (StringUtils.isNotBlank((String)aclTemplates)) {
            return this.getOnlyJsonEntity(aclTemplateType, aclTemplates).getId();
        }
        return null;
    }

    @Override
    public String getOrCreateACLTemplate(String vpcOrSubnetUuid, NuageVspEntity parentType, String parentId, NuageVspEntity aclTemplateType, NuageVspAclClient.AclTemplatePriorityType priorityType, Integer priority, boolean forLoadBalancing) throws NuageVspApiException {
        String aclTemplateId = this.getACLTemplateId(parentType, parentId, aclTemplateType, priorityType, priority);
        if (StringUtils.isNotBlank((String)aclTemplateId)) {
            return aclTemplateId;
        }
        NuageVspObject aclTemplate = new NuageVspObject(this.vspHost.getApiVersion(), aclTemplateType);
        aclTemplate.set(NuageVspAttribute.EXTERNAL_ID, vpcOrSubnetUuid);
        StringBuilder name = new StringBuilder();
        switch (aclTemplateType) {
            case INGRESS_ACLTEMPLATES: {
                name.append("Ingress");
                break;
            }
            case EGRESS_ACLTEMPLATES: {
                name.append("Egress");
                break;
            }
            case EGRESS_DOMAIN_FIP_ACLTEMPLATES: {
                name.append("Egress Domain FIP");
            }
        }
        if (forLoadBalancing) {
            name.append(" LB");
        }
        name.append(" ACL");
        switch (priorityType) {
            case TOP: {
                name.append(" Top");
                break;
            }
            case BOTTOM: {
                name.append(" Bottom");
                break;
            }
        }
        aclTemplate.set(NuageVspAttribute.NAME, name.toString());
        aclTemplate.set(NuageVspAttribute.ACLTEMPLATES_ACTIVE, true);
        aclTemplate.set(NuageVspAttribute.ACLTEMPLATES_PRIORITY_TYPE, priorityType.name());
        aclTemplate.set(NuageVspAttribute.ACLTEMPLATES_PRIORITY, priority);
        aclTemplate.set(NuageVspAttribute.ACLTEMPLATES_ALLOW_IP, false);
        aclTemplate.set(NuageVspAttribute.ACLTEMPLATES_ALLOW_NON_IP, false);
        String aclEntry = null;
        try {
            aclEntry = this.createResource(parentType, parentId, aclTemplateType, aclTemplate, false);
        }
        catch (NuageVspException e) {
            throw new NuageVspApiException("Failed to create ACL Template", e);
        }
        s_logger.debug("Created Default ACLTemplate for network %s in VSP . Response from VSP is %s.", vpcOrSubnetUuid, aclEntry);
        return this.getEntityId(aclTemplateType, aclEntry);
    }

    @Override
    public List<NuageVspObject> getACLTemplatesAssociatedToDomain(String networkUuid, NuageVspEntity domainType, String domainId, NuageVspEntity aclTemplateType, NuageVspAclClient.AclTemplatePriorityType priorityType, boolean throwExceptionIfNotPresent) throws NuageVspException {
        String aclTemplates = priorityType != null ? this.getResources(domainType, domainId, aclTemplateType, NuageVspAttribute.ACLTEMPLATES_PRIORITY_TYPE, priorityType.name()) : this.getResources(domainType, domainId, aclTemplateType);
        if (StringUtils.isNotBlank((String)aclTemplates)) {
            return this.parseJsonString(aclTemplateType, aclTemplates);
        }
        if (throwExceptionIfNotPresent) {
            throw new NuageVspApiException((Object)((Object)aclTemplateType) + " ACL corresponding to network " + networkUuid + " does not exist in VSP. There is a data sync issue. Please a check VSP or create a new network");
        }
        return null;
    }

    @Override
    public List<NuageVspObject> getACLEntriesAssociatedToLocation(String aclNetworkLocationId, NuageVspEntity aclTemplateType, String aclTemplateId) throws NuageVspApiException {
        NuageVspEntity aclEntryType = null;
        if (aclTemplateType == NuageVspEntity.INGRESS_ACLTEMPLATES) {
            aclEntryType = NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES;
        } else if (aclTemplateType == NuageVspEntity.EGRESS_ACLTEMPLATES) {
            aclEntryType = NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES;
        } else if (aclTemplateType == NuageVspEntity.EGRESS_DOMAIN_FIP_ACLTEMPLATES) {
            aclEntryType = NuageVspEntity.EGRESS_DOMAIN_FIP_ACLTEMPLATES_ENTRIES;
        }
        if (aclEntryType == null) {
            return Collections.emptyList();
        }
        String aclTemplateEntries = null;
        aclTemplateEntries = aclNetworkLocationId != null ? this.getResources(aclTemplateType, aclTemplateId, aclEntryType, NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID, aclNetworkLocationId) : this.getResources(aclTemplateType, aclTemplateId, aclEntryType, String.format("%s != '%s'", new Object[]{NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_TYPE.getAttributeName(), NuageVspConstants.AclEntryLocationType.SUBNET}));
        if (StringUtils.isNotBlank((String)aclTemplateEntries)) {
            return this.parseJsonString(aclEntryType, aclTemplateEntries);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, NuageVspObject> getACLEntriesAssociatedToLocationByExternalId(String aclNetworkLocationId, NuageVspEntity aclTemplateType, String aclTemplateId) throws NuageVspApiException {
        List<NuageVspObject> entries = this.getACLEntriesAssociatedToLocation(aclNetworkLocationId, aclTemplateType, aclTemplateId);
        return this.groupByExternalId(entries);
    }

    @Override
    public void createDefaultIngressAndEgressAcls(boolean isVpc, String vpcOrSubnetUuid, boolean egressDefaultAllowPolicy, NuageVspEntity nuageVspEntity, String nuageVspEntityId, String networkName) throws NuageVspApiException {
        String domainTemplateId;
        NuageVspEntity domainTemplateType;
        if (nuageVspEntity == NuageVspEntity.DOMAIN_TEMPLATE || nuageVspEntity == NuageVspEntity.L2DOMAIN_TEMPLATE) {
            domainTemplateType = nuageVspEntity;
            domainTemplateId = nuageVspEntityId;
        } else if (nuageVspEntity == NuageVspEntity.DOMAIN || nuageVspEntity == NuageVspEntity.L2DOMAIN) {
            try {
                String domainJson = this.getResource(nuageVspEntity, nuageVspEntityId);
                List<NuageVspObject> domain = this.parseJsonString(nuageVspEntity, domainJson);
                domainTemplateId = (String)((NuageVspObject)Iterables.getOnlyElement(domain)).get(NuageVspAttribute.DOMAIN_TEMPLATE_ID);
                domainTemplateType = nuageVspEntity == NuageVspEntity.DOMAIN ? NuageVspEntity.DOMAIN_TEMPLATE : NuageVspEntity.L2DOMAIN_TEMPLATE;
            }
            catch (NuageVspException e) {
                throw NuageVspAclClientImpl.handleException("Failed to create Default Ingress Rules ", e, new Object[0]);
            }
        } else {
            return;
        }
        this.createDefaultIngressAcls(isVpc, egressDefaultAllowPolicy, vpcOrSubnetUuid, domainTemplateType, domainTemplateId, networkName);
        this.createDefaultEgressAcls(isVpc, egressDefaultAllowPolicy, vpcOrSubnetUuid, domainTemplateType, domainTemplateId, networkName);
    }

    @Override
    public void createAclTemplates(String vpcOrSubnetUuid, NuageVspEntity domainType, String domainId, Integer priority) throws NuageVspApiException {
        this.getOrCreateACLTemplate(vpcOrSubnetUuid, domainType, domainId, NuageVspEntity.INGRESS_ACLTEMPLATES, NuageVspAclClient.AclTemplatePriorityType.NONE, priority, false);
        this.getOrCreateACLTemplate(vpcOrSubnetUuid, domainType, domainId, NuageVspEntity.EGRESS_ACLTEMPLATES, NuageVspAclClient.AclTemplatePriorityType.NONE, priority, false);
    }

    private void createDefaultIngressAcls(boolean isVpc, boolean egressDefaultAllowPolicy, String vpcOrSubnetUuid, NuageVspEntity domainType, String domainId, String networkName) throws NuageVspApiException {
        try {
            String topTemplateId = this.getOrCreateACLTemplate(vpcOrSubnetUuid, domainType, domainId, NuageVspEntity.INGRESS_ACLTEMPLATES, NuageVspAclClient.AclTemplatePriorityType.TOP, 0, false);
            String bottomTemplateId = this.getOrCreateACLTemplate(vpcOrSubnetUuid, domainType, domainId, NuageVspEntity.INGRESS_ACLTEMPLATES, NuageVspAclClient.AclTemplatePriorityType.BOTTOM, 0, false);
            Map<Integer, NuageVspObject> currentTopAclEntries = this.getDefaultAclEntries(NuageVspEntity.INGRESS_ACLTEMPLATES, topTemplateId);
            Map<Integer, NuageVspObject> currentBottomAclEntries = this.getDefaultAclEntries(NuageVspEntity.INGRESS_ACLTEMPLATES, bottomTemplateId);
            this.ensureDefaultIngressAclEntry(currentTopAclEntries, topTemplateId, false, Protocol.ANY, "FORWARD", 0, "Default Intra-Subnet Allow ACL", NuageVspConstants.AclEntryLocationType.ANY, null, NuageVspConstants.AclEntryNetworkType.ENDPOINT_SUBNET, networkName, vpcOrSubnetUuid);
            if (isVpc || egressDefaultAllowPolicy) {
                this.ensureDefaultIngressAclEntry(currentBottomAclEntries, bottomTemplateId, true, Protocol.TCP, "FORWARD", 1, "Default Allow TCP", NuageVspConstants.AclEntryLocationType.ANY, null, NuageVspConstants.AclEntryNetworkType.ANY, networkName, vpcOrSubnetUuid);
                this.ensureDefaultIngressAclEntry(currentBottomAclEntries, bottomTemplateId, true, Protocol.UDP, "FORWARD", 2, "Default Allow UDP", NuageVspConstants.AclEntryLocationType.ANY, null, NuageVspConstants.AclEntryNetworkType.ANY, networkName, vpcOrSubnetUuid);
                this.ensureDefaultIngressAclEntry(currentBottomAclEntries, bottomTemplateId, false, Protocol.ICMP, "FORWARD", 3, "Default Allow ICMP", NuageVspConstants.AclEntryLocationType.ANY, null, NuageVspConstants.AclEntryNetworkType.ANY, networkName, vpcOrSubnetUuid);
            } else {
                this.deleteDefaultAclEntry(currentBottomAclEntries, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, 1);
                this.deleteDefaultAclEntry(currentBottomAclEntries, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, 2);
                this.deleteDefaultAclEntry(currentBottomAclEntries, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, 3);
            }
        }
        catch (NuageVspException exception) {
            throw new NuageVspApiException("Failed to create default Ingress ACL for network " + vpcOrSubnetUuid + ".", exception);
        }
    }

    @Override
    public boolean createDefaultFIPEgressAcls(String vpcOrSubnetUuid, NuageVspEntity domainType, String domainTemplateId, String networkName) throws NuageVspException {
        String tempId = this.getOrCreateACLTemplate(vpcOrSubnetUuid, domainType, domainTemplateId, NuageVspEntity.EGRESS_DOMAIN_FIP_ACLTEMPLATES, NuageVspAclClient.AclTemplatePriorityType.TOP, 0, false);
        Map<Integer, NuageVspObject> currentAclEntries = this.getDefaultAclEntries(NuageVspEntity.EGRESS_DOMAIN_FIP_ACLTEMPLATES, tempId);
        int priority = 1;
        boolean success = false;
        for (Integer port : NuageVspConstants.DefaultAcl.FIP_ACL_BLOCKED_PORTS) {
            success |= this.ensureDefaultFipAclEntry(currentAclEntries, tempId, priority++, port, networkName);
        }
        return success;
    }

    private void createDefaultEgressAcls(boolean isVpc, boolean egressDefaultAllowPolicy, String vpcOrSubnetUuid, NuageVspEntity domainType, String domainTemplateId, String networkName) throws NuageVspApiException {
        try {
            String topTemplateId = this.getOrCreateACLTemplate(vpcOrSubnetUuid, domainType, domainTemplateId, NuageVspEntity.EGRESS_ACLTEMPLATES, NuageVspAclClient.AclTemplatePriorityType.TOP, 0, false);
            String bottomTemplateId = this.getOrCreateACLTemplate(vpcOrSubnetUuid, domainType, domainTemplateId, NuageVspEntity.EGRESS_ACLTEMPLATES, NuageVspAclClient.AclTemplatePriorityType.BOTTOM, 0, false);
            Map<Integer, NuageVspObject> currentTopAclEntries = this.getDefaultAclEntries(NuageVspEntity.EGRESS_ACLTEMPLATES, topTemplateId);
            Map<Integer, NuageVspObject> currentBottomAclEntries = this.getDefaultAclEntries(NuageVspEntity.EGRESS_ACLTEMPLATES, bottomTemplateId);
            this.ensureDefaultEgressAclEntry(currentTopAclEntries, topTemplateId, false, Protocol.ANY, "FORWARD", 0, "Default Intra-Subnet Allow ACL", NuageVspConstants.AclEntryNetworkType.ENDPOINT_SUBNET, networkName);
            if (isVpc) {
                this.createDefaultFIPEgressAcls(vpcOrSubnetUuid, domainType, domainTemplateId, networkName);
            }
            if (isVpc) {
                this.ensureDefaultEgressAclEntry(currentBottomAclEntries, bottomTemplateId, false, Protocol.ANY, "DROP", 0, "Default Intra-Domain Deny ACL", NuageVspConstants.AclEntryNetworkType.ENDPOINT_DOMAIN, networkName);
            }
            if (egressDefaultAllowPolicy) {
                this.ensureDefaultEgressAclEntry(currentBottomAclEntries, bottomTemplateId, false, Protocol.ICMP, "FORWARD", 3, "Default Allow ICMP", NuageVspConstants.AclEntryNetworkType.ANY, networkName);
            } else {
                this.deleteDefaultAclEntry(currentBottomAclEntries, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, 3);
            }
        }
        catch (NuageVspException exception) {
            throw new NuageVspApiException("Failed to create default Egress ACL for network " + vpcOrSubnetUuid + ".", exception);
        }
    }

    private void deleteDefaultAclEntry(Map<Integer, NuageVspObject> currentAclEntries, NuageVspEntity aclType, int aclPriority) {
        if (!currentAclEntries.containsKey(aclPriority)) {
            return;
        }
        NuageVspObject aclEntry = currentAclEntries.get(aclPriority);
        String id = (String)aclEntry.get(NuageVspAttribute.ID);
        this.cleanUpVspStaleObjects(aclType, id);
    }

    private boolean ensureDefaultFipAclEntry(Map<Integer, NuageVspObject> currentAclEntries, String aclTemplateId, int aclPriority, int port, String networkName) throws NuageVspException {
        if (currentAclEntries.containsKey(aclPriority)) {
            return false;
        }
        NuageVspObject egressACLEntryEntity = new NuageVspObject(this.vspHost.getApiVersion(), NuageVspEntity.EGRESS_DOMAIN_FIP_ACLTEMPLATES_ENTRIES);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ETHER_TYPE, Acl.AclEtherType.IPv4);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ACTION, "DROP");
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_TYPE, (Object)Acl.AclEntryLocationType.ANY);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, (Object)Acl.AclEntryNetworkType.ANY);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PROTOCOL, Protocol.TCP.getProtocolNumber());
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_SOURCE_PORT, "*");
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DEST_PORT, String.valueOf(port));
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DSCP, "*");
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_REFLEXIVE, false);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DESCRIPTION, "Default Deny FIP ACL TCP Port " + port);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY, aclPriority);
        String egressACLEntryJson = this.createResource(NuageVspEntity.EGRESS_DOMAIN_FIP_ACLTEMPLATES, aclTemplateId, NuageVspEntity.EGRESS_DOMAIN_FIP_ACLTEMPLATES_ENTRIES, egressACLEntryEntity, false);
        List<NuageVspObject> egressACLEntry = this.parseJsonString(NuageVspEntity.EGRESS_DOMAIN_FIP_ACLTEMPLATES_ENTRIES, egressACLEntryJson);
        currentAclEntries.put(aclPriority, (NuageVspObject)Iterables.getOnlyElement(egressACLEntry));
        s_logger.debug("Created Default egressACLTemplateEntry for network " + networkName + " in VSP . Response from VSP is " + egressACLEntryJson, new Object[0]);
        return true;
    }

    private void ensureDefaultEgressAclEntry(Map<Integer, NuageVspObject> currentAclEntries, String aclTemplateId, boolean isReflexive, Protocol protocol, String action, int aclPriority, String aclEntryDescription, NuageVspConstants.AclEntryNetworkType sourceNetwork, String networkName) throws NuageVspException {
        if (currentAclEntries.containsKey(aclPriority)) {
            return;
        }
        NuageVspObject egressACLEntryEntity = new NuageVspObject(this.vspHost.getApiVersion(), NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ETHER_TYPE, "0x0800");
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ACTION, action);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_TYPE, "ANY");
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, (Object)sourceNetwork);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PROTOCOL, protocol.getProtocolNumber());
        if (protocol.hasPort()) {
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_SOURCE_PORT, "*");
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DEST_PORT, "*");
        }
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DSCP, "*");
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_REFLEXIVE, isReflexive);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DESCRIPTION, aclEntryDescription);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY, aclPriority);
        String egressACLEntryJson = this.createResource(NuageVspEntity.EGRESS_ACLTEMPLATES, aclTemplateId, NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, egressACLEntryEntity, false);
        List<NuageVspObject> egressACLEntry = this.parseJsonString(NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, egressACLEntryJson);
        currentAclEntries.put(aclPriority, (NuageVspObject)Iterables.getOnlyElement(egressACLEntry));
        s_logger.debug("Created Default egressACLTemplateEntry for network " + networkName + " in VSP . Response from VSP is " + egressACLEntryJson, new Object[0]);
    }

    private void ensureDefaultIngressAclEntry(Map<Integer, NuageVspObject> currentAclEntries, String aclTemplateId, boolean isReflexive, Protocol protocol, String action, int aclPriority, String aclEntryDescription, NuageVspConstants.AclEntryLocationType locationType, String locationId, NuageVspConstants.AclEntryNetworkType destinationNetwork, String networkName, String networkUuid) throws NuageVspException {
        if (currentAclEntries != null && currentAclEntries.containsKey(aclPriority)) {
            return;
        }
        NuageVspObject ingressACLEntryEntity = new NuageVspObject(this.vspHost.getApiVersion(), NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES);
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ETHER_TYPE, "0x0800");
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ACTION, action);
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_TYPE, (Object)locationType);
        if (locationId != null) {
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID, locationId);
        }
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, (Object)destinationNetwork);
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PROTOCOL, protocol.getProtocolNumber());
        if (protocol.hasPort()) {
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_SOURCE_PORT, "*");
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DEST_PORT, "*");
        }
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DSCP, "*");
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_REFLEXIVE, isReflexive);
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DESCRIPTION, aclEntryDescription);
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY, aclPriority);
        ingressACLEntryEntity.set(NuageVspAttribute.EXTERNAL_ID, "(" + networkUuid + ")");
        String ingressACLEntryJson = this.createResource(NuageVspEntity.INGRESS_ACLTEMPLATES, aclTemplateId, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, ingressACLEntryEntity, false);
        List<NuageVspObject> ingressACLEntry = this.parseJsonString(NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, ingressACLEntryJson);
        currentAclEntries.put(aclPriority, (NuageVspObject)Iterables.getOnlyElement(ingressACLEntry));
        s_logger.debug("Created Default IngressACLTemplateEntry for network " + networkName + " in VSP . Response from VSP is " + ingressACLEntryJson, new Object[0]);
    }

    @Override
    public String createAclEntry(NuageVspEntity aclTemplateType, NuageVspEntity aclTemplateEntryType, String vsdEnterpriseId, VspAclRule rule, String destVmIp, long networkId, String vspSubnetId, String sourceCidr, String aclTemplateId) throws NuageVspException {
        NuageVspObject aclEntryEntity = null;
        boolean isEgress = aclTemplateType.equals((Object)NuageVspEntity.EGRESS_ACLTEMPLATES);
        aclEntryEntity = isEgress ? this.buildEgressAclEntryByCidr(vsdEnterpriseId, rule, destVmIp, vspSubnetId, networkId, sourceCidr, false, -1) : this.buildIngressAclEntryByCidr(vsdEnterpriseId, rule, vspSubnetId, networkId, sourceCidr, false, -1);
        return this.createAclEntry(aclTemplateType, aclTemplateEntryType, aclTemplateId, aclEntryEntity);
    }

    @Override
    public String createAclEntry(NuageVspEntity aclTemplateType, NuageVspEntity aclTemplateEntryType, String aclTemplateId, NuageVspObject aclEntryEntity) throws NuageVspException {
        String aclEntryJson = this.createResource(aclTemplateType, aclTemplateId, aclTemplateEntryType, (Object)aclEntryEntity, false, Lists.newArrayList((Object[])new Integer[]{2591}));
        s_logger.debug("Created " + (Object)((Object)aclTemplateEntryType) + " ACL Entry in VSP. Response from VSP is " + aclEntryJson, new Object[0]);
        return this.getEntityId(aclTemplateEntryType, aclEntryJson);
    }

    @Override
    public boolean createOrModifyACLitems(String enterpriseId, VspNetwork network, AclRulesDetails aclRulesDetails, NuageVspAclClient.AclProgress state, VspAclRule vspAclRule) throws NuageVspApiException {
        boolean isNetworkAcl = aclRulesDetails.isNetworkAcl();
        String vspSubnetId = aclRulesDetails.getAclNetworkLocationId();
        String ingressACLTempId = aclRulesDetails.getIngressAclTemplateId();
        String egressACLTempId = aclRulesDetails.getEgressAclTemplateId();
        Object errorMap = null;
        String filter = NuageVspAttribute.EXTERNAL_ID.getAttributeName() + " BEGINSWITH '" + vspAclRule.getUuid() + "' and " + NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID.getAttributeName() + " == '" + vspSubnetId + "'";
        boolean isAcsEgressAcls = false;
        if (vspAclRule.getTrafficType().equals((Object)VspAclRule.ACLTrafficType.Ingress)) {
            String ingressEntry;
            if (isNetworkAcl && vspAclRule.getState().equals((Object)VspAclRule.ACLState.Add) && StringUtils.isNotBlank((String)(ingressEntry = this.getResources(NuageVspEntity.INGRESS_ACLTEMPLATES, ingressACLTempId, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES)))) {
                String ingressEntryId = this.getEntityId(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, ingressEntry);
                s_logger.debug("ACS Ingress %s is getting added to network %s but an VSP Ingress rule is with same UUID %s already exists in VSP. This means the existing CS Egress rule type has been modified to CS Ingress. So, delete this rule from VSP and create a new Egress rule", vspAclRule, network.getName(), vspAclRule.getUuid());
                this.cleanUpVspStaleObjects(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, ingressEntryId);
            }
            String destVmIp = vspAclRule.getSourceIpAddress();
            String egressEntry = this.getResources(NuageVspEntity.EGRESS_ACLTEMPLATES, egressACLTempId, NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, filter);
            if (StringUtils.isBlank((String)egressEntry)) {
                this.createEgressACLEntryInVsp(isNetworkAcl, enterpriseId, egressACLTempId, vspAclRule, destVmIp, vspSubnetId, network.getId(), state.successfullyAddedEgressACls);
                if (destVmIp != null) {
                    String debugMsg = "ACS Ingress rule %s is getting added to network %s and it does not exists in VSP. The source IP is %s. Enterprise macro with same source IP network will be either created if its not present in VSP. Then a rule will be created using the macro.";
                    s_logger.debug(debugMsg, vspAclRule, network.getName(), destVmIp);
                } else {
                    String debugMsg = "ACS Ingress rule %s is getting added to network %s and it does not exists in VSP. The source IP is %s. So, ACL rule is created on the L3 Subnet/L2 Domain with network locationId %s on which the ACL rule is added.";
                    s_logger.debug(debugMsg, vspAclRule, network.getName(), destVmIp, vspSubnetId);
                }
            } else if (isNetworkAcl) {
                NuageVspObject egressEntryData = this.getFirstJsonEntity(NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, egressEntry);
                String egressEntryId = egressEntryData.getId();
                int oldPriority = (Integer)egressEntryData.get(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY);
                this.updateEgressACLEntryInVsp(enterpriseId, egressEntryId, egressEntryData, vspAclRule, destVmIp, vspSubnetId, network.getId(), oldPriority);
            }
        } else if (vspAclRule.getTrafficType().equals((Object)VspAclRule.ACLTrafficType.Egress)) {
            String ingressEntry;
            String egressEntry;
            if (isNetworkAcl && vspAclRule.getState().equals((Object)VspAclRule.ACLState.Add) && StringUtils.isNotBlank((String)(egressEntry = this.getResources(NuageVspEntity.EGRESS_ACLTEMPLATES, egressACLTempId, NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, filter)))) {
                String egressEntryId = this.getEntityId(NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, egressEntry);
                this.cleanUpVspStaleObjects(NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, egressEntryId);
                s_logger.debug("ACS Egress rule " + vspAclRule + " associated to network " + network.getName() + " is getting added but an VSP Egress rule is with same UUID " + vspAclRule.getUuid() + " already exists in VSP. This means the existing CS Inress rule type has been modified to CS Egress. So, this rule needs is deleted from VSP and a new Ingress rule is created", new Object[0]);
            }
            if (StringUtils.isBlank((String)(ingressEntry = this.getResources(NuageVspEntity.INGRESS_ACLTEMPLATES, ingressACLTempId, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, filter)))) {
                this.createIngressACLEntryInVsp(isNetworkAcl, enterpriseId, ingressACLTempId, vspAclRule, vspSubnetId, network.getId(), state.successfullyAddedIngressACls);
                s_logger.debug("ACS Egress rule " + vspAclRule + " associated to network " + network.getName() + " is getting added and does not exists in VSP.So, ACL rule is created on the L3 Subnet/L2 Domain with network locationId " + vspSubnetId + " on which the ACL rule is added.", new Object[0]);
            } else if (isNetworkAcl) {
                NuageVspObject ingressEntryData = this.getFirstJsonEntity(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, ingressEntry);
                String ingressEntryId = ingressEntryData.getId();
                int oldPriority = (Integer)ingressEntryData.get(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY);
                this.updateIngressACLEntryInVsp(enterpriseId, ingressEntryId, ingressEntryData, vspAclRule, vspSubnetId, network.getId(), oldPriority);
            }
            isAcsEgressAcls = isNetworkAcl && vspAclRule.getAction().equals((Object)VspAclRule.ACLAction.Allow);
        }
        return isAcsEgressAcls;
    }

    @Override
    public void createOrDeleteDefaultIngressSubnetBlockAcl(String networkName, Long networkId, String aclNetworkLocationId, String networkUuid, String ingressACLTempId, int noOfActiveOrAddedIngressAcls) throws NuageVspException {
        block7: {
            try {
                int priority = (int)(10800000L + networkId);
                String defaultIngressAcl = this.getResources(NuageVspEntity.INGRESS_ACLTEMPLATES, ingressACLTempId, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY, String.valueOf(priority));
                if (noOfActiveOrAddedIngressAcls > 0) {
                    if (!StringUtils.isBlank((String)defaultIngressAcl)) break block7;
                    try {
                        this.ensureDefaultIngressAclEntry(null, ingressACLTempId, false, Protocol.ANY, "DROP", priority, "Default Subnet ACL to block traffic as there is an ACL list associated with it", NuageVspConstants.AclEntryLocationType.SUBNET, aclNetworkLocationId, NuageVspConstants.AclEntryNetworkType.ANY, networkName, networkUuid);
                        s_logger.debug("Default ACL to block subnets traffic is added with priority " + priority, new Object[0]);
                    }
                    catch (NuageVspApiException e) {
                        if (e.getHttpErrorCode() == 409 && e.getNuageErrorCode() == 2591) {
                            s_logger.debug("Looks like the ACL Entry with priority " + priority + " already exists. So, it is not re-created", new Object[0]);
                        }
                        break block7;
                    }
                }
                if (!StringUtils.isBlank((String)defaultIngressAcl)) {
                    List<NuageVspObject> ingressAclEntry = this.parseJsonString(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, defaultIngressAcl);
                    s_logger.debug("There are no Egress ACLs added to the network " + networkName + ". So, delete default subnet block ACL", new Object[0]);
                    this.cleanUpVspStaleObjects(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, (String)ingressAclEntry.iterator().next().get(NuageVspAttribute.ID));
                }
            }
            catch (NuageVspException e) {
                throw new NuageVspException("Failed to create default Subnet ACL to block traffic for network " + networkName + ". Json response from VSP REST API is " + e.getMessage());
            }
        }
    }

    @Override
    public Map<VspAclRule, List<String>> createEgressACLEntryInVsp(boolean isNetworkAcl, String vsdEnterpriseId, String egressAclTemplateId, VspAclRule rule, String destVmIp, String vspSubnetId, long networkId, List<String> successfullyAddedEgressACls) throws NuageVspApiException {
        HashMap<VspAclRule, List<String>> errorMap = new HashMap<VspAclRule, List<String>>();
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (String sourceCidr : rule.getSourceCidrList()) {
            try {
                String egressAclEntryId = this.createAclEntry(NuageVspEntity.EGRESS_ACLTEMPLATES, NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, vsdEnterpriseId, rule, destVmIp, networkId, vspSubnetId, sourceCidr, egressAclTemplateId);
                successfullyAddedEgressACls.add(egressAclEntryId);
            }
            catch (NuageVspException exception) {
                errorMessages.add("Failed to create Egress ACL Entry for rule " + rule + " in VSP enterprise " + vsdEnterpriseId + ". " + exception.getMessage());
            }
        }
        if (errorMessages.size() > 0) {
            errorMap.put(rule, errorMessages);
        }
        return errorMap;
    }

    @Override
    public void updateEgressACLEntryInVsp(String vsdEnterpriseId, String egressAclEntryId, NuageVspObject egressEntryData, VspAclRule rule, String sourceIp, String aclNetworkLocationId, long networkId, int oldPriority) throws NuageVspApiException {
        for (String sourceCidr : rule.getSourceCidrList()) {
            try {
                NuageVspObject modifiedEgressACLEntryEntity = this.buildEgressAclEntryByCidr(vsdEnterpriseId, rule, sourceIp, aclNetworkLocationId, networkId, sourceCidr, true, oldPriority);
                if (!this.isModified(modifiedEgressACLEntryEntity, egressEntryData)) continue;
                String ingressAclEntryJson = this.updateResource(modifiedEgressACLEntryEntity, false);
                s_logger.debug("Updated Ingress ACL Entry for rule %s with CIDR %s in VSP. Response from VSP is %s", rule, sourceCidr, ingressAclEntryJson);
            }
            catch (NuageVspException exception) {
                if (exception.isNoChangeInEntityException()) continue;
                throw NuageVspAclClientImpl.handleException("Failed to Modify Egress ACL Entry for rule %s with CIDR %s in VSP enterprise %s. ", exception, rule, sourceCidr, vsdEnterpriseId);
            }
        }
    }

    @Override
    public void createIngressACLEntryInVsp(boolean isNetworkAcl, String vsdEnterpriseId, String ingressAclTemplateId, VspAclRule rule, String aclNetworkLocationId, long networkId, List<String> successfullyAddedIngressACls) throws NuageVspApiException {
        for (String sourceCidr : rule.getSourceCidrList()) {
            try {
                String ingressAclEntryId = this.createAclEntry(NuageVspEntity.INGRESS_ACLTEMPLATES, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, vsdEnterpriseId, rule, null, networkId, aclNetworkLocationId, sourceCidr, ingressAclTemplateId);
                successfullyAddedIngressACls.add(ingressAclEntryId);
            }
            catch (NuageVspException exception) {
                throw NuageVspAclClientImpl.handleException("Failed to create Ingress ACL Entry for rule %s with CIDR %s in VSP enterprise %s. ", exception, rule, sourceCidr, vsdEnterpriseId);
            }
        }
    }

    private boolean isModified(NuageVspObject origRule, NuageVspObject newRule) {
        return !origRule.entriesEqualTo(newRule);
    }

    @Override
    public void updateIngressACLEntryInVsp(String vsdEnterpriseId, String ingressAclEntryId, NuageVspObject ingressEntryData, VspAclRule rule, String aclNetworkLocationId, long networkId, int oldPriority) throws NuageVspApiException {
        for (String sourceCidr : rule.getSourceCidrList()) {
            try {
                NuageVspObject modifiedIngressACLEntryEntity = this.buildIngressAclEntryByCidr(vsdEnterpriseId, rule, aclNetworkLocationId, networkId, sourceCidr, true, oldPriority);
                if (!this.isModified(modifiedIngressACLEntryEntity, ingressEntryData)) continue;
                String ingressAclEntryJson = this.updateResource(modifiedIngressACLEntryEntity, false);
                s_logger.debug("Updated Ingress ACL Entry for rule " + rule + " with CIDR " + sourceCidr + " in VSP. Response from VSP is " + ingressAclEntryJson, new Object[0]);
            }
            catch (NuageVspException exception) {
                if (exception.isNoChangeInEntityException()) continue;
                throw NuageVspAclClientImpl.handleException("Failed to Modify Ingress ACL Entry for rule %s with CIDR %s in VSP enterprise %s. ", exception, rule, sourceCidr, vsdEnterpriseId);
            }
        }
    }

    @Override
    public List<String> cleanStaleAclsFromVsp(List<VspAclRule> rules, Map<String, NuageVspObject> vspIngressAclEntriesExtUuidToAcl, Map<String, NuageVspObject> vspEgressAclEntriesExtUuidToAcl, Boolean acsIngressFirewall) {
        String id;
        ArrayList<String> cleanedUpVspAclEntryIds = new ArrayList<String>();
        Set<String> ruleUuids = NuageVspAclClientImpl.getRuleUuids(rules);
        if (acsIngressFirewall == null || acsIngressFirewall == Boolean.TRUE) {
            for (Map.Entry<String, NuageVspObject> egressAclEntry : vspEgressAclEntriesExtUuidToAcl.entrySet()) {
                if (ruleUuids.contains("Ingress_" + egressAclEntry.getKey())) continue;
                id = (String)egressAclEntry.getValue().get(NuageVspAttribute.ID);
                this.cleanUpVspStaleObjects(NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, id);
                cleanedUpVspAclEntryIds.add(id);
            }
        }
        if (acsIngressFirewall == null || acsIngressFirewall == Boolean.FALSE) {
            for (Map.Entry<String, NuageVspObject> ingressAclEntry : vspIngressAclEntriesExtUuidToAcl.entrySet()) {
                if (ruleUuids.contains("Egress_" + ingressAclEntry.getKey())) continue;
                id = (String)ingressAclEntry.getValue().get(NuageVspAttribute.ID);
                this.cleanUpVspStaleObjects(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, id);
                cleanedUpVspAclEntryIds.add(id);
            }
        }
        return cleanedUpVspAclEntryIds;
    }

    private static Set<String> getRuleUuids(List<VspAclRule> rules) {
        HashSet<String> result = new HashSet<String>();
        if (rules != null) {
            for (VspAclRule rule : rules) {
                result.add(String.format("%s_%s", new Object[]{rule.getTrafficType(), rule.getUuid()}));
            }
        }
        return result;
    }

    @Override
    public Pair<NuageVspConstants.AclEntryNetworkType, String> getAclEntryNetworkForCidr(String vsdEnterpriseId, String sourceCidr, String ruleUuid) throws NuageVspApiException {
        if (sourceCidr.endsWith("/0")) {
            return Pair.of((Object)((Object)NuageVspConstants.AclEntryNetworkType.ANY), null);
        }
        String macroId = this.getOrCreatePublicMacroInEnterprise(vsdEnterpriseId, sourceCidr, ruleUuid);
        return Pair.of((Object)((Object)NuageVspConstants.AclEntryNetworkType.ENTERPRISE_NETWORK), (Object)macroId);
    }

    @Override
    public NuageVspObject buildAclEntryBySubnet(String vsdEnterpriseId, VspAclRule rule, String sourceIp, String aclNetworkLocationId, long networkId, String vsdSubnetId, boolean isUpdate, int oldPriority) throws NuageVspApiException {
        if (rule.getTrafficType() == VspAclRule.ACLTrafficType.Ingress) {
            return this.buildIngressAclEntryBySubnet(vsdEnterpriseId, rule, aclNetworkLocationId, networkId, vsdSubnetId, isUpdate, oldPriority);
        }
        return this.buildEgressAclEntryBySubnet(vsdEnterpriseId, rule, sourceIp, aclNetworkLocationId, networkId, vsdSubnetId, isUpdate, oldPriority);
    }

    private NuageVspObject buildEgressAclEntryByCidr(String vsdEnterpriseId, VspAclRule rule, String sourceIp, String aclNetworkLocationId, long networkId, String sourceCidr, boolean isUpdate, int oldPriority) throws NuageVspApiException {
        NuageVspObject egressACLEntryEntity = this.buildEgressAclEntry(vsdEnterpriseId, rule, sourceIp, aclNetworkLocationId, networkId, isUpdate, oldPriority);
        String macroId = this.getOrCreatePublicMacroInEnterprise(vsdEnterpriseId, sourceCidr, rule.getUuid());
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, (Object)NuageVspConstants.AclEntryNetworkType.ENTERPRISE_NETWORK);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_ID, macroId);
        return egressACLEntryEntity;
    }

    @Override
    public NuageVspObject buildEgressAclEntryBySubnet(String vsdEnterpriseId, VspAclRule rule, String sourceIp, String aclNetworkLocationId, long networkId, String vsdSubnetId, boolean isUpdate, int oldPriority) throws NuageVspApiException {
        NuageVspObject egressACLEntryEntity = this.buildEgressAclEntry(vsdEnterpriseId, rule, sourceIp, aclNetworkLocationId, networkId, isUpdate, oldPriority);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, (Object)NuageVspConstants.AclEntryNetworkType.SUBNET);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_ID, vsdSubnetId);
        return egressACLEntryEntity;
    }

    private NuageVspObject buildEgressAclEntry(String vsdEnterpriseId, VspAclRule rule, String sourceIp, String aclNetworkLocationId, long networkId, boolean isUpdate, int oldPriority) throws NuageVspApiException {
        NuageVspObject egressACLEntryEntity = new NuageVspObject(this.vspHost.getApiVersion(), NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ETHER_TYPE, "0x0800");
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ACTION, rule.getAction().equals((Object)VspAclRule.ACLAction.Allow) ? "FORWARD" : "DROP");
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PROTOCOL, rule.getProtocol().getProtocolNumber());
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DSCP, "*");
        egressACLEntryEntity.set(NuageVspAttribute.EXTERNAL_ID, rule.getUuid());
        rule = this.updatePriorityForAcl(rule, networkId, isUpdate, oldPriority);
        if (rule.getPriority() < 0 || rule.getPriority() >= 10000000) {
            String error = "Rule number " + rule.getPriority() + " can not be greater than " + 10000000 + " as it is used as rule numbers for predefined rules in VSP";
            s_logger.error((Object)error, new Object[0]);
            throw new NuageVspApiException(error);
        }
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY, rule.getPriority());
        if (sourceIp != null) {
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ADDR_OVERRIDE, sourceIp);
        }
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_TYPE, (Object)NuageVspConstants.AclEntryLocationType.SUBNET);
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID, aclNetworkLocationId);
        if (rule.getProtocol().hasPort()) {
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DEST_PORT, rule.getPortRange());
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_SOURCE_PORT, "*");
        }
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_REFLEXIVE, rule.isReflexive());
        return egressACLEntryEntity;
    }

    private NuageVspObject buildIngressAclEntryByCidr(String vsdEnterpriseId, VspAclRule rule, String aclNetworkLocationId, long networkId, String sourceCidr, boolean isUpdate, int oldPriority) throws NuageVspApiException {
        NuageVspObject ingressACLEntryEntity = this.buildIngressAclEntry(vsdEnterpriseId, rule, aclNetworkLocationId, networkId, sourceCidr, isUpdate, oldPriority);
        if (rule.getType().equals((Object)VspAclRule.ACLType.NetworkACL)) {
            String macroId = this.getOrCreatePublicMacroInEnterprise(vsdEnterpriseId, sourceCidr, rule.getUuid());
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, (Object)NuageVspConstants.AclEntryNetworkType.ENTERPRISE_NETWORK);
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_ID, macroId);
        }
        return ingressACLEntryEntity;
    }

    @Override
    public NuageVspObject buildIngressAclEntryBySubnet(String vsdEnterpriseId, VspAclRule rule, String aclNetworkLocationId, long networkId, String vsdSubnetId, boolean isUpdate, int oldPriority) throws NuageVspApiException {
        NuageVspObject egressACLEntryEntity = this.buildIngressAclEntry(vsdEnterpriseId, rule, aclNetworkLocationId, networkId, null, isUpdate, oldPriority);
        if (rule.getType().equals((Object)VspAclRule.ACLType.NetworkACL)) {
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, (Object)NuageVspConstants.AclEntryNetworkType.SUBNET);
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_ID, vsdSubnetId);
        }
        return egressACLEntryEntity;
    }

    private NuageVspObject buildIngressAclEntry(String vsdEnterpriseId, VspAclRule rule, String aclNetworkLocationId, long networkId, String sourceCidr, boolean isUpdate, int oldPriority) throws NuageVspApiException {
        NuageVspObject ingressACLEntryEntity = new NuageVspObject(this.vspHost.getApiVersion(), NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES);
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ETHER_TYPE, "0x0800");
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ACTION, rule.getAction().equals((Object)VspAclRule.ACLAction.Allow) ? "FORWARD" : "DROP");
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PROTOCOL, rule.getProtocol().getProtocolNumber());
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DSCP, "*");
        ingressACLEntryEntity.set(NuageVspAttribute.EXTERNAL_ID, rule.getUuid());
        rule = this.updatePriorityForAcl(rule, networkId, isUpdate, oldPriority);
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY, rule.getPriority());
        if (rule.getType().equals((Object)VspAclRule.ACLType.Firewall)) {
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ADDR_OVERRIDE, sourceCidr);
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, "ANY");
        }
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_TYPE, (Object)NuageVspConstants.AclEntryLocationType.SUBNET);
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID, aclNetworkLocationId);
        if (rule.getProtocol().hasPort()) {
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DEST_PORT, rule.getPortRange());
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_SOURCE_PORT, "*");
        }
        ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_REFLEXIVE, rule.isReflexive());
        return ingressACLEntryEntity;
    }

    private VspAclRule updatePriorityForAcl(VspAclRule rule, long networkId, boolean isUpdate, int oldPriority) throws NuageVspApiException {
        int newPriority;
        switch (rule.getType()) {
            case NetworkACL: {
                if (rule.getPriority() > 9999) {
                    String error = "Rule number can not be greater than 9999 as it is used to generate a unique rule per tier in VSP";
                    s_logger.error((Object)error, new Object[0]);
                    throw new NuageVspApiException(error);
                }
                newPriority = Integer.valueOf(String.valueOf(networkId) + String.valueOf(rule.getPriority()));
                break;
            }
            default: {
                newPriority = isUpdate ? oldPriority : this.getRandomPriority();
            }
        }
        return new VspAclRule.Builder().fromObject(rule).priority(newPriority).build();
    }

    private int getRandomPriority() {
        return (int)(RANDOM.nextDouble() * 99999.0) % 1000000 + 1;
    }

    @Override
    public String getOrCreatePublicMacroInEnterprise(String vsdEnterpriseId, String sourceCidr, String ruleUuid) throws NuageVspApiException {
        try {
            Pair<String, String> subnetmask = NetUtils.cidrToSubnetNetmask(sourceCidr);
            String macroJsonString = this.getResources(NuageVspEntity.ENTERPRISE, vsdEnterpriseId, NuageVspEntity.ENTERPRISE_NTWK_MACRO, NuageVspAttribute.ENTERPRISE_NTWK_MACRO_ADDRESS.getAttributeName() + " == '" + (String)subnetmask.getLeft() + "' and " + NuageVspAttribute.ENTERPRISE_NTWK_MACRO_NETMASK.getAttributeName() + " == '" + (String)subnetmask.getRight() + "'");
            if (StringUtils.isBlank((String)macroJsonString)) {
                try {
                    String networkMacroUuid = UuidUtils.generateUuidFromCidr(sourceCidr);
                    NuageVspObject macroEntity = this.createNuageVspObject(NuageVspEntity.ENTERPRISE_NTWK_MACRO);
                    macroEntity.set(NuageVspAttribute.ENTERPRISE_NTWK_MACRO_NAME, "CIDR " + sourceCidr.replace('.', ' ').replace("/", " - "));
                    macroEntity.set(NuageVspAttribute.ENTERPRISE_NTWK_MACRO_ADDRESS, subnetmask.getLeft());
                    macroEntity.set(NuageVspAttribute.ENTERPRISE_NTWK_MACRO_NETMASK, subnetmask.getRight());
                    macroEntity.set(NuageVspAttribute.EXTERNAL_ID, networkMacroUuid);
                    String macroJson = this.createResource(NuageVspEntity.ENTERPRISE, vsdEnterpriseId, NuageVspEntity.ENTERPRISE_NTWK_MACRO, macroEntity, true);
                    s_logger.debug("Created Enterprise Network Macro in VSP. Response from VSP is " + macroJson, new Object[0]);
                    return this.getEntityId(NuageVspEntity.ENTERPRISE_NTWK_MACRO, macroJson);
                }
                catch (Exception exception) {
                    String errorMessage = "Failed to create Enterprise network macro " + sourceCidr + " in VSP enterprise " + vsdEnterpriseId + ".  Json response from VSP REST API is  " + exception.getMessage();
                    s_logger.error((Object)errorMessage, exception);
                    throw new NuageVspApiException(errorMessage);
                }
            }
            return this.getEntityId(NuageVspEntity.ENTERPRISE_NTWK_MACRO, macroJsonString);
        }
        catch (NuageVspException exception) {
            String errorMessage = "Failed to read Public network macro " + sourceCidr + " in VSP enterprise " + vsdEnterpriseId + ".  Json response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
            throw new NuageVspApiException(errorMessage);
        }
    }

    @Override
    public Map<String, NuageVspObject> groupByExternalId(List<NuageVspObject> aclEntries) {
        HashMap<String, NuageVspObject> externalUuidToAcl = new HashMap<String, NuageVspObject>();
        for (NuageVspObject entry : aclEntries) {
            String externalUuid = (String)entry.get(NuageVspAttribute.EXTERNAL_ID);
            if (externalUuid == null) continue;
            externalUuidToAcl.put(externalUuid, entry);
        }
        return externalUuidToAcl;
    }

    @Override
    public Map<Integer, NuageVspObject> getDefaultAclEntries(NuageVspEntity aclTempType, String aclTempId) throws NuageVspException {
        List<NuageVspObject> defaultVspAclEntries = this.getACLEntriesAssociatedToLocation(null, aclTempType, aclTempId);
        HashMap<Integer, NuageVspObject> aclPriorityToEntry = new HashMap<Integer, NuageVspObject>();
        for (NuageVspObject aclEntry : defaultVspAclEntries) {
            Integer priority = (Integer)aclEntry.get(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY);
            aclPriorityToEntry.put(priority, aclEntry);
        }
        return aclPriorityToEntry;
    }

    @Override
    public void applyFIPAccessControl(NuageVspEntity domainType, String domainId, String networkUuid, String staticNatIpUuid, boolean accessControl) throws NuageVspApiException {
        String fipExternalId = networkUuid + ":" + staticNatIpUuid;
        try {
            NuageVspObject floatingIp = this.getEntityByExternalId(domainType, domainId, NuageVspEntity.FLOATING_IP, fipExternalId);
            if (floatingIp != null) {
                floatingIp.set(NuageVspAttribute.FLOATING_IP_ACCESS_CONTROL, accessControl);
                this.updateResource(floatingIp);
            }
        }
        catch (NuageVspException exception) {
            throw NuageVspAclClientImpl.handleException("Failed to apply FIP Access control", exception, new Object[0]);
        }
    }

    @Override
    public void applyStaticRoutes(String vpcUuid, String enterpriseId, Collection<VspStaticRoute> staticRoutes) throws NuageVspApiException {
        try {
            NuageVspObject domain = this.getEntityByExternalId(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN, vpcUuid);
            if (domain == null) {
                throw new NuageVspApiException("Domain not found on VSD");
            }
            for (VspStaticRoute staticRoute : staticRoutes) {
                Pair<String, String> subnetNetmask = NetUtils.cidrToSubnetNetmask(staticRoute.getCidr());
                EnumMap filter = Maps.newEnumMap(NuageVspAttribute.class);
                filter.put(NuageVspAttribute.STATIC_ROUTE_ADDRESS, subnetNetmask.getLeft());
                filter.put(NuageVspAttribute.STATIC_ROUTE_NETMASK, subnetNetmask.getRight());
                NuageVspObject entry = this.getEntityByExternalId(NuageVspEntity.DOMAIN, domain.getId(), NuageVspEntity.STATIC_ROUTE, staticRoute.getUuid());
                if (entry == null) {
                    if (staticRoute.isRevoke()) continue;
                    entry = new NuageVspObject(this.vspHost.getApiVersion(), NuageVspEntity.STATIC_ROUTE);
                    entry.set(NuageVspAttribute.STATIC_ROUTE_ADDRESS, subnetNetmask.getLeft());
                    entry.set(NuageVspAttribute.STATIC_ROUTE_NETMASK, subnetNetmask.getRight());
                    entry.set(NuageVspAttribute.STATIC_ROUTE_NEXTHOP, staticRoute.getNextHop());
                    entry.setExternalId(staticRoute.getUuid());
                    this.createResource(domain, entry, false);
                    continue;
                }
                if (staticRoute.isRevoke()) {
                    this.deleteResource(entry, false);
                    continue;
                }
                if (staticRoute.getNextHop().equals(entry.get(NuageVspAttribute.STATIC_ROUTE_NEXTHOP))) continue;
                entry.set(NuageVspAttribute.STATIC_ROUTE_ADDRESS, subnetNetmask.getLeft());
                entry.set(NuageVspAttribute.STATIC_ROUTE_NETMASK, subnetNetmask.getRight());
                entry.set(NuageVspAttribute.STATIC_ROUTE_NEXTHOP, staticRoute.getNextHop());
                entry.setExternalId(staticRoute.getUuid());
                this.updateResource(entry, false);
            }
        }
        catch (NuageVspException exception) {
            throw NuageVspAclClientImpl.handleException("Failed to apply FIP Access control", exception, new Object[0]);
        }
    }
}

