/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import net.nuage.vsp.acs.client.api.NuageVspApiClient;
import net.nuage.vsp.acs.client.api.impl.NuageVspRestApi;
import net.nuage.vsp.acs.client.api.model.VspAclRule;
import net.nuage.vsp.acs.client.api.model.VspAddressRange;
import net.nuage.vsp.acs.client.api.model.VspDhcpDomainOption;
import net.nuage.vsp.acs.client.api.model.VspHost;
import net.nuage.vsp.acs.client.api.model.VspNetwork;
import net.nuage.vsp.acs.client.api.model.VspNic;
import net.nuage.vsp.acs.client.api.model.VspStaticNat;
import net.nuage.vsp.acs.client.api.model.VspVm;
import net.nuage.vsp.acs.client.common.ConfigUtil;
import net.nuage.vsp.acs.client.common.model.DhcpOption;
import net.nuage.vsp.acs.client.common.model.DhcpOptions;
import net.nuage.vsp.acs.client.common.model.NetworkDetails;
import net.nuage.vsp.acs.client.common.model.NuageVspAttribute;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;
import net.nuage.vsp.acs.client.common.model.NuageVspObject;
import net.nuage.vsp.acs.client.common.model.Pair;
import net.nuage.vsp.acs.client.common.model.StaleAclRulesDetails;
import net.nuage.vsp.acs.client.common.utils.Logger;
import net.nuage.vsp.acs.client.common.utils.NetUtils;
import net.nuage.vsp.acs.client.common.utils.UuidUtils;
import net.nuage.vsp.acs.client.exception.NuageVspApiException;
import net.nuage.vsp.acs.client.exception.NuageVspException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.util.SubnetUtils;

public class NuageVspApiClientImpl
extends NuageVspRestApi
implements NuageVspApiClient {
    private static final Logger s_logger = new Logger(NuageVspApiClientImpl.class);

    public NuageVspApiClientImpl(VspHost vspHost) {
        super(vspHost);
    }

    @Override
    public boolean entityExists(NuageVspEntity entityType, String entityUuid) throws NuageVspException {
        String entityJson = this.findEntityByExternalUuid(entityType, null, null, entityUuid);
        return StringUtils.isNotBlank((String)entityJson);
    }

    public List<NuageVspObject> createVMInVSP(VspNetwork vspNetwork, VspVm vspVm, VspNic vspNic, NetworkDetails attachedNetworkDetails, DhcpOptions dhcpOptions) throws NuageVspException {
        s_logger.debug("VM with UUID " + vspVm.getUuid() + " does not exist in VSP. So, just add the new VM", new Object[0]);
        List<NuageVspObject> vmInterfacesList = this.buildVmInterfacesList(vspVm, vspNic);
        this.createVportInVsp(vspNetwork, vmInterfacesList, attachedNetworkDetails, dhcpOptions);
        NuageVspObject vmEntity = this.createNuageVspObject(NuageVspEntity.VM);
        vmEntity.set(NuageVspAttribute.VM_NAME, vspVm.getName());
        vmEntity.set(NuageVspAttribute.VM_UUID, vspVm.getUuid());
        vmEntity.set(NuageVspAttribute.VM_INTERFACES, vmInterfacesList);
        vmEntity.set(NuageVspAttribute.EXTERNAL_ID, vspVm.getUuid());
        try {
            String vmJsonString = this.createResource(vmEntity, vspNetwork.getAccountUuid(), vspNetwork.getVspDomain().getUuid());
            List<NuageVspObject> vmDetails = this.parseJsonString(NuageVspEntity.VM, vmJsonString);
            s_logger.debug("Created VM in Nuage. Response from VSP is " + vmJsonString, new Object[0]);
            String vmInterfacesJson = (String)vmDetails.iterator().next().get(NuageVspAttribute.VM_INTERFACES);
            return this.parseJson(vmInterfacesJson, NuageVspEntity.VM_INTERFACE);
        }
        catch (NuageVspApiException e) {
            String errorMessage = "Failed to create VM in VSP using REST API. Json response from VSP REST API is  " + e.getMessage();
            s_logger.error((Object)errorMessage, e);
            throw new NuageVspException(errorMessage);
        }
    }

    public List<NuageVspObject> addVMInterfaceToVM(VspNetwork vspNetwork, VspVm vspVm, VspNic vspNic, NetworkDetails attachedNetworkDetails, NuageVspObject vm, DhcpOptions dhcpOptions) throws NuageVspException {
        s_logger.debug("VM with UUID " + vspVm.getUuid() + " already exists in VSP. So, just add the VM new VM interface", new Object[0]);
        String vmId = (String)vm.get(NuageVspAttribute.ID);
        String vmInterfacesFromNuageVSP = (String)vm.get(NuageVspAttribute.VM_INTERFACES);
        NuageVspObject vmInterface = this.findVMInterface(vmInterfacesFromNuageVSP, vspNic.getMacAddress());
        if (vmInterface == null) {
            try {
                List<NuageVspObject> vmInterfacesList = this.buildVmInterfacesList(vspVm, vspNic);
                this.createVportInVsp(vspNetwork, vmInterfacesList, attachedNetworkDetails, dhcpOptions);
                String vmInterfaceJson = this.createResource(NuageVspEntity.VM, vmId, vmInterfacesList.get(0), vspNetwork.getAccountUuid(), vspNetwork.getVspDomain().getUuid());
                s_logger.debug("Added VM interface to VM in Nuage. Response from VSP is " + vmInterfaceJson, new Object[0]);
                return this.parseJson(vmInterfaceJson, NuageVspEntity.VM_INTERFACE);
            }
            catch (NuageVspApiException exception) {
                String errorMessage = "Failed to add VM Interface for the VM with UUID " + vspVm.getUuid() + " for network " + vspNetwork.getUuid() + ".  Json response from VSP REST API is  " + exception.getMessage();
                s_logger.error((Object)errorMessage, exception);
                throw new NuageVspException(errorMessage);
            }
        }
        String vmInterfaceIp = (String)vmInterface.get(NuageVspAttribute.VM_INTERFACE_IPADDRESS);
        if (!StringUtils.equals((String)vmInterfaceIp, (String)vspNic.getIp())) {
            try {
                if (vspNetwork.isShared()) {
                    boolean subnetMove;
                    String vportId = (String)vmInterface.get(NuageVspAttribute.VM_INTERFACE_VPORT_ID);
                    String vmInterfaceUuid = (String)vmInterface.get(NuageVspAttribute.EXTERNAL_ID);
                    if (vspNetwork.isPublicAccess()) {
                        this.releaseFIPFromVsp(attachedNetworkDetails, vportId, vmInterfaceUuid, null);
                    }
                    boolean bl = subnetMove = !NetUtils.isIpWithinCidrRange(vmInterfaceIp, vspNetwork.getCidr());
                    if (subnetMove) {
                        this.cleanUpVspStaleObjects(NuageVspEntity.VM_INTERFACE, (String)vmInterface.get(NuageVspAttribute.ID));
                        this.cleanUpVspStaleObjects(NuageVspEntity.VPORT, vportId);
                        List<NuageVspObject> vmInterfacesList = this.buildVmInterfacesList(vspVm, vspNic);
                        this.createVportInVsp(vspNetwork, vmInterfacesList, attachedNetworkDetails, dhcpOptions);
                        String vmInterfaceJson = this.createResource(NuageVspEntity.VM, vmId, vmInterfacesList.get(0), vspNetwork.getAccountUuid(), vspNetwork.getVspDomain().getUuid());
                        s_logger.debug("Added VM interface to VM in Nuage. Response from VSP is " + vmInterfaceJson, new Object[0]);
                        return this.parseJson(vmInterfaceJson, NuageVspEntity.VM_INTERFACE);
                    }
                    if (vspNetwork.isPublicAccess()) {
                        String netmask = NetUtils.getCidrNetmask(vspNetwork.getCidr());
                        String externalIdFromGateway = UuidUtils.generateUuidFromExternalIdAndIp(vspNetwork.getUuid(), vspNetwork.getGateway());
                        String sharedResourceJson = this.findSharedResource(true, "FLOATING", externalIdFromGateway, vspNetwork.getGateway(), netmask);
                        if (StringUtils.isBlank((String)sharedResourceJson)) {
                            String errorMessage = "Failed to find the Floating IP subnet related to shared network " + vspNetwork.getUuid() + ".";
                            s_logger.error((Object)errorMessage, new Object[0]);
                            throw new NuageVspException(errorMessage);
                        }
                        String sharedResourceId = this.getEntityId(sharedResourceJson, NuageVspEntity.SHARED_NETWORK);
                        this.allocateFIPToVPortInVsp(attachedNetworkDetails, vportId, sharedResourceId, vspNic.getIp(), vmInterfaceUuid, null, null);
                    }
                }
                String vmInterfaceId = (String)vmInterface.get(NuageVspAttribute.ID);
                NuageVspObject updatedVmInterface = this.createNuageVspObject(NuageVspEntity.VM_INTERFACE);
                updatedVmInterface.set(NuageVspAttribute.VM_INTERFACE_IPADDRESS, vspNic.getIp());
                this.updateResource(vmInterfaceId, updatedVmInterface, false);
                s_logger.debug("Updated VM interface IP from " + vmInterfaceIp + " to " + vspNic.getIp(), new Object[0]);
            }
            catch (NuageVspApiException exception) {
                String errorMessage = "Failed to update VM Interface with a new IP for the VM with UUID " + vspVm.getUuid() + " for network " + vspNetwork.getUuid() + ".  Json response from VSP REST API is  " + exception.getMessage();
                s_logger.error((Object)errorMessage, exception);
                throw new NuageVspException(errorMessage);
            }
        }
        if (dhcpOptions != null) {
            String vportVsdId = this.findEntityIdByExternalUuid(NuageVspEntity.SUBNET, attachedNetworkDetails.getSubnetId(), NuageVspEntity.VPORT, vspNic.getUuid());
            this.createDhcpOptions(false, NuageVspEntity.VPORT, vportVsdId, vspNic.getUuid(), vspNetwork, dhcpOptions);
        }
        return null;
    }

    private List<NuageVspObject> buildVmInterfacesList(VspVm vspVm, VspNic ... vspNics) {
        ArrayList<NuageVspObject> vmInterfaceList = new ArrayList<NuageVspObject>(vspNics.length);
        for (VspNic vspNic : vspNics) {
            NuageVspObject vmInterfaces = this.createNuageVspObject(NuageVspEntity.VM_INTERFACE);
            vmInterfaces.set(NuageVspAttribute.VM_INTERFACE_NAME, vspNic.getUuid());
            vmInterfaces.set(NuageVspAttribute.VM_INTERFACE_MAC, vspNic.getMacAddress());
            vmInterfaces.set(NuageVspAttribute.EXTERNAL_ID, vspNic.getUuid());
            if (vspVm.getDomainRouter() == Boolean.TRUE) {
                vmInterfaces.set(NuageVspAttribute.VM_INTERFACE_IPADDRESS, vspVm.getDomainRouterIp());
            } else if (vspNic.getUseStaticIp() == Boolean.TRUE) {
                vmInterfaces.set(NuageVspAttribute.VM_INTERFACE_IPADDRESS, vspNic.getIp());
            }
            vmInterfaceList.add(vmInterfaces);
        }
        return vmInterfaceList;
    }

    public void deleteVmInterface(String vmUuid, String macAddr, String vmInterfaceID) throws NuageVspException {
        try {
            this.deleteResource(NuageVspEntity.VM_INTERFACE, vmInterfaceID, false);
            s_logger.debug("VM Interface is getting destroyed for VM with UUID " + vmUuid + " and it exists in NuageVSP. Deleted the VM interface " + vmInterfaceID + " from Nuage VSP", new Object[0]);
        }
        catch (NuageVspApiException exception) {
            String errorMessage = "Failed to delete VM Interface with MAC " + macAddr + " for the VM with UUID " + vmUuid + " from NUAGE VSP. Json response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
        }
    }

    public void deleteVM(String vmUuid, String vmId) {
        try {
            this.deleteResource(NuageVspEntity.VM, vmId, false);
            s_logger.debug("VM " + vmUuid + " is getting destroyed and it exists in NuageVSP. Deleted the VM " + vmId + " from Nuage VSP", new Object[0]);
        }
        catch (NuageVspApiException exception) {
            s_logger.error((Object)("VM " + vmUuid + " is getting destroyed. REST API failed to delete the VM " + vmId + " from NuageVsp. Json response from REST API is " + exception.getMessage()), exception);
        }
    }

    public NuageVspObject getVMDetails(String vmUuid) throws NuageVspException {
        String vmJsonString;
        try {
            vmJsonString = this.getResources(NuageVspEntity.VM, NuageVspAttribute.VM_UUID.getAttributeName() + " == '" + vmUuid + "'");
        }
        catch (NuageVspApiException exception) {
            String errorMessage = "Failed to execute REST API call to VSP to get VM with UUID " + vmUuid + ". So, Failed to get IP for the VM from VSP address for VM " + vmUuid + ".  Json response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
            throw new NuageVspException(errorMessage);
        }
        return (NuageVspObject)Iterables.getFirst(this.parseJson(vmJsonString, NuageVspEntity.VM), null);
    }

    public String getOrCreateVSPEnterprise(String domainUuid, String domainName, String domainPath) throws NuageVspException {
        String enterpriseId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, null, null, domainUuid);
        if (StringUtils.isBlank((String)enterpriseId)) {
            enterpriseId = this.createEnterpriseInVSP(domainUuid, this.getEnterpriseName(domainName, domainPath));
        }
        return enterpriseId;
    }

    public Pair<String, String> getOrCreateVSPEnterpriseAndGroup(String networksDomainName, String networksDomainPath, String networksDomainUuid, String networksAccountName, String networksAccountUuid) throws NuageVspException {
        String userGroupId;
        String userId;
        String enterpriseId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, null, null, networksDomainUuid);
        if (StringUtils.isBlank((String)enterpriseId)) {
            enterpriseId = this.createEnterpriseInVSP(networksDomainUuid, this.getEnterpriseName(networksDomainName, networksDomainPath));
        }
        if (StringUtils.isBlank((String)(userId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.USER, networksAccountUuid)))) {
            userId = this.createUserInEnterprise(enterpriseId, networksAccountUuid, "FN_" + networksAccountUuid, "LN_" + networksAccountUuid, "defaultemail@email.com", DigestUtils.shaHex((String)"default"));
        }
        if (StringUtils.isBlank((String)(userGroupId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.GROUP, networksAccountUuid)))) {
            userGroupId = this.createGroupInEnterprise(networksAccountName, networksAccountUuid, enterpriseId);
        }
        this.addUserToGroup(userGroupId, userId);
        return Pair.of(enterpriseId, userGroupId);
    }

    private String getOrCreatePublicMacroInEnterprise(String vsdEnterpriseId, String sourceCidr, String ruleUuid) throws NuageVspException {
        try {
            String subnet = NetUtils.getCidrSubNet(sourceCidr);
            long cidrSize = new Long(sourceCidr.substring(sourceCidr.indexOf("/") + 1));
            String netmask = cidrSize == 0L ? "0.0.0.0" : NetUtils.getCidrNetmask(sourceCidr);
            String macroJsonString = this.findEntityUsingFilter(NuageVspEntity.ENTERPRISE, vsdEnterpriseId, NuageVspEntity.ENTERPRISE_NTWK_MACRO, NuageVspAttribute.ENTERPRISE_NTWK_MACRO_ADDRESS.getAttributeName() + " == '" + subnet + "' and " + NuageVspAttribute.ENTERPRISE_NTWK_MACRO_NETMASK.getAttributeName() + " == '" + netmask + "'");
            if (StringUtils.isBlank((String)macroJsonString)) {
                try {
                    NuageVspObject macroEntity = this.createNuageVspObject(NuageVspEntity.ENTERPRISE_NTWK_MACRO);
                    macroEntity.set(NuageVspAttribute.ENTERPRISE_NTWK_MACRO_NAME, ruleUuid);
                    macroEntity.set(NuageVspAttribute.ENTERPRISE_NTWK_MACRO_ADDRESS, subnet);
                    macroEntity.set(NuageVspAttribute.ENTERPRISE_NTWK_MACRO_NETMASK, netmask);
                    String macroJson = this.createResource(NuageVspEntity.ENTERPRISE, vsdEnterpriseId, macroEntity);
                    s_logger.debug("Created Enterprise Network Macro in VSP. Response from VSP is " + macroJson, new Object[0]);
                    return this.getEntityId(macroJson, NuageVspEntity.ENTERPRISE_NTWK_MACRO);
                }
                catch (NuageVspApiException exception) {
                    String errorMessage = "Failed to create Enterprise network macro " + sourceCidr + " in VSP enterprise " + vsdEnterpriseId + ".  Json response from VSP REST API is  " + exception.getMessage();
                    s_logger.error((Object)errorMessage, exception);
                    throw new NuageVspException(errorMessage);
                }
            }
            return this.getEntityId(macroJsonString, NuageVspEntity.ENTERPRISE_NTWK_MACRO);
        }
        catch (NuageVspApiException exception) {
            String errorMessage = "Failed to read Public network macro " + sourceCidr + " in VSP enterprise " + vsdEnterpriseId + ".  Json response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
            throw new NuageVspException(errorMessage);
        }
    }

    public String createEnterpriseInVSP(String enterpriseExternalUuid, String enterpriseDescription) throws NuageVspException {
        s_logger.debug("Enterprise with domainUuid " + enterpriseDescription + " does not exist in VSP. So, just create the new Enterprise", new Object[0]);
        String enterpriseProfileId = this.createEnterpriseProfileInVsp(enterpriseExternalUuid, enterpriseDescription);
        NuageVspObject enterpriseEntity = this.createNuageVspObject(NuageVspEntity.ENTERPRISE);
        enterpriseEntity.set(NuageVspAttribute.ENTERPRISE_NAME, enterpriseExternalUuid);
        enterpriseEntity.set(NuageVspAttribute.ENTERPRISE_DESCRIPTION, enterpriseDescription);
        enterpriseEntity.set(NuageVspAttribute.EXTERNAL_ID, enterpriseExternalUuid);
        enterpriseEntity.set(NuageVspAttribute.ENTERPRISE_PROFILE_ID, enterpriseProfileId);
        try {
            String enterpriseJsonString = this.createResource(enterpriseEntity);
            return this.getEntityId(enterpriseJsonString, NuageVspEntity.ENTERPRISE);
        }
        catch (NuageVspApiException e) {
            String errorMessage = "Failed to create Enterprise in VSP using REST API. So, Enterprise could not be created in VSP  for domain " + enterpriseExternalUuid + ".  Json response from VSP REST API is  " + e.getMessage();
            s_logger.error((Object)errorMessage, e);
            this.cleanUpVspStaleObjects(NuageVspEntity.ENTERPRISE_PROFILE, enterpriseProfileId);
            throw new NuageVspException(errorMessage);
        }
    }

    private String createEnterpriseProfileInVsp(String enterpriseExternalUuid, String enterpriseDescription) throws NuageVspException {
        String enterpriseProfileId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE_PROFILE, null, null, enterpriseExternalUuid);
        if (StringUtils.isBlank((String)enterpriseProfileId)) {
            NuageVspObject enterpriseProfileEntity = this.createNuageVspObject(NuageVspEntity.ENTERPRISE_PROFILE);
            enterpriseProfileEntity.set(NuageVspAttribute.ENTERPRISE_PROFILE_NAME, enterpriseExternalUuid);
            enterpriseProfileEntity.set(NuageVspAttribute.ENTERPRISE_PROFILE_DESCRIPTION, enterpriseDescription);
            enterpriseProfileEntity.set(NuageVspAttribute.EXTERNAL_ID, enterpriseExternalUuid);
            Integer floatingIpQuota = ConfigUtil.getPropertyInteger("floatingIPQuota", 100);
            Boolean allowGatewayMgmt = ConfigUtil.getPropertyBoolean("allowGatewayMgmt", false);
            Boolean allowAdvancedQOS = ConfigUtil.getPropertyBoolean("allowAdvancedQOS", false);
            enterpriseProfileEntity.set(NuageVspAttribute.ENTERPRISE_PROFILE_ADV_QOS, allowAdvancedQOS);
            enterpriseProfileEntity.set(NuageVspAttribute.ENTERPRISE_PROFILE_FLOATING_IP_QUOTA, floatingIpQuota);
            enterpriseProfileEntity.set(NuageVspAttribute.ENTERPRISE_PROFILE_GATEWAY_MGMT, allowGatewayMgmt);
            String availableFwdClass = ConfigUtil.getProperty("availableFwdClass", "C,D,E,F,G,H");
            List<String> fwdClassJsonArray = Arrays.asList(availableFwdClass.split(","));
            enterpriseProfileEntity.set(NuageVspAttribute.ENTERPRISE_PROFILE_FWD_CLASSES, fwdClassJsonArray);
            try {
                String enterpriseJsonString = this.createResource(enterpriseProfileEntity);
                return this.getEntityId(enterpriseJsonString, NuageVspEntity.ENTERPRISE_PROFILE);
            }
            catch (NuageVspApiException e) {
                String errorMessage = "Failed to create Enterprise Profile in VSP using REST API. So, Enterprise could not be created in VSP  for domain " + enterpriseExternalUuid + ".  Json response from VSP REST API is  " + e.getMessage();
                s_logger.error((Object)errorMessage, e);
                throw new NuageVspException(errorMessage);
            }
        }
        return enterpriseProfileId;
    }

    public void deleteEnterpriseInVsp(String enterpriseExternalUuid, String enterpriseDescription) throws NuageVspException {
        try {
            String enterpriseId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, null, null, enterpriseExternalUuid);
            if (StringUtils.isNotBlank((String)enterpriseId)) {
                this.deleteResource(NuageVspEntity.ENTERPRISE, enterpriseId, false);
                s_logger.debug("Enterprise " + enterpriseDescription + " is getting removed and it exists in NuageVSP. Deleted the enterprise " + enterpriseId + " from Nuage VSP", new Object[0]);
                this.deleteEnterpriseProfileInVsp(enterpriseExternalUuid, enterpriseDescription);
            }
        }
        catch (NuageVspApiException e) {
            String errorMessage = "Failed to delete Enterprise in VPS using REST API. Json response from VSP REST API is " + e.getMessage();
            s_logger.error((Object)errorMessage, e);
            throw new NuageVspException(errorMessage);
        }
    }

    private void deleteEnterpriseProfileInVsp(String enterpriseExternalUuid, String enterpriseDescription) throws NuageVspException {
        try {
            String enterpriseProfileId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE_PROFILE, null, null, enterpriseExternalUuid);
            if (StringUtils.isNotBlank((String)enterpriseProfileId)) {
                this.deleteResource(NuageVspEntity.ENTERPRISE_PROFILE, enterpriseProfileId, false);
                s_logger.debug("Enterprise Profile " + enterpriseDescription + " is getting removed and it exists in NuageVSP. Deleted the enterprise profile " + enterpriseProfileId + " from Nuage VSP", new Object[0]);
            }
        }
        catch (NuageVspApiException e) {
            String errorMessage = "Failed to delete Enterprise Profile in VPS using REST API. Json response from VSP REST API is " + e.getMessage();
            s_logger.error((Object)errorMessage, e);
            throw new NuageVspException(errorMessage);
        }
    }

    public String createUserInEnterprise(String vsdEnterpriseId, String userNameUuid, String firstName, String lastName, String email, String password) throws NuageVspException {
        try {
            NuageVspObject userEntity = this.createNuageVspObject(NuageVspEntity.USER);
            userEntity.set(NuageVspAttribute.EXTERNAL_ID, userNameUuid);
            userEntity.set(NuageVspAttribute.USER_USERNAME, userNameUuid.replaceAll("-", ""));
            userEntity.set(NuageVspAttribute.USER_EMAIL, email);
            userEntity.set(NuageVspAttribute.USER_PASSWORD, password);
            userEntity.set(NuageVspAttribute.USER_FIRSTNAME, firstName);
            userEntity.set(NuageVspAttribute.USER_LASTNAME, lastName);
            String userJson = this.createResource(NuageVspEntity.ENTERPRISE, vsdEnterpriseId, userEntity);
            s_logger.debug("Created user in VSP. Response from VSP is " + userJson, new Object[0]);
            return this.getEntityId(userJson, NuageVspEntity.USER);
        }
        catch (NuageVspApiException exception) {
            String errorMessage = "Failed to create User for VSP enterprise " + vsdEnterpriseId + ".  Json response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
            throw new NuageVspException(errorMessage);
        }
    }

    public void addPermission(NuageVspEntity entityType, String entityId, Set<String> groupIds) throws NuageVspException {
        try {
            this.setRelatedEntities(entityType, entityId, NuageVspEntity.GROUP, groupIds);
            s_logger.debug("Added permission for entity " + (Object)((Object)entityType) + " id " + entityId + " with groups " + groupIds, new Object[0]);
        }
        catch (NuageVspApiException exception) {
            String errorMessage = "Failed to add permission for entity " + (Object)((Object)entityType) + " id " + entityId + ".  Json response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
            throw new NuageVspException(errorMessage);
        }
    }

    public String createGroupInEnterprise(String projectOrAccountName, String projectOrAccountUuid, String vsdEnterpriseId) throws NuageVspException {
        try {
            NuageVspObject groupEntity = this.createNuageVspObject(NuageVspEntity.GROUP);
            groupEntity.set(NuageVspAttribute.GROUP_NAME, projectOrAccountUuid);
            groupEntity.set(NuageVspAttribute.GROUP_DESCRIPTION, projectOrAccountName);
            groupEntity.set(NuageVspAttribute.EXTERNAL_ID, projectOrAccountUuid);
            String groupJson = this.createResource(NuageVspEntity.ENTERPRISE, vsdEnterpriseId, groupEntity);
            s_logger.debug("Created group for project or account " + projectOrAccountUuid + " in VSP . Response from VSP is " + groupJson, new Object[0]);
            return this.getEntityId(groupJson, NuageVspEntity.GROUP);
        }
        catch (NuageVspApiException exception) {
            String errorMessage = "Failed to create Group for project or account " + projectOrAccountUuid + ".  Json response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
            throw new NuageVspException(errorMessage);
        }
    }

    public void addUserToGroup(String vsdGroupId, String userId) throws NuageVspException {
        try {
            this.linkRelatedEntity(NuageVspEntity.GROUP, vsdGroupId, NuageVspEntity.USER, userId);
        }
        catch (NuageVspApiException exception) {
            String errorMessage = "Failed to add Users for project or account in VSD " + vsdGroupId + ".  Json response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
            throw new NuageVspException(errorMessage);
        }
    }

    public Pair<String, String> createNetworkConfigurationWithDefaultACLs(VspNetwork vspNetwork, VspDhcpDomainOption vspDhcpOptions) throws NuageVspException {
        String subnetId;
        String domainId;
        block13: {
            boolean predefinedDomainTemplateSet;
            Pair<String, String> enterpriseAndGroupId = this.getOrCreateVSPEnterpriseAndGroup(vspNetwork.getVspDomain().getName(), vspNetwork.getVspDomain().getPath(), vspNetwork.getVspDomain().getUuid(), vspNetwork.getAccountName(), vspNetwork.getAccountUuid());
            s_logger.debug("Create or find a VPC/Isolated/Shared network associated to network " + vspNetwork.getName() + " in VSP", new Object[0]);
            boolean isVpc = vspNetwork.isVpc();
            Pair<String, String> vpcOrSubnetInfo = vspNetwork.getVpcOrSubnetInfo();
            String domainTemplateId = null;
            String vsdDomainTemplateId = null;
            String vsdDomainTemplateName = null;
            if (StringUtils.isNotBlank((String)vspNetwork.getDomainTemplateName())) {
                String vsdDomainTemplateEntity = this.findEntityUsingFilter(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), NuageVspEntity.DOMAIN_TEMPLATE, NuageVspAttribute.DOMAIN_TEMPLATE_NAME, vspNetwork.getDomainTemplateName());
                NuageVspObject vsdDomainTemplate = this.getFirstJsonEntity(NuageVspEntity.DOMAIN_TEMPLATE, vsdDomainTemplateEntity);
                if (vsdDomainTemplate != null) {
                    vsdDomainTemplateId = vsdDomainTemplate.getId();
                    vsdDomainTemplateName = (String)vsdDomainTemplate.get(NuageVspAttribute.DOMAIN_TEMPLATE_NAME);
                }
                if (StringUtils.isBlank(vsdDomainTemplateId) || !StringUtils.equals(vsdDomainTemplateName, (String)vspNetwork.getDomainTemplateName())) {
                    String errorMessage = "Preconfigured DomainTemplate '" + vspNetwork.getDomainTemplateName() + "' could not be found.";
                    if (isVpc) {
                        errorMessage = errorMessage + " Please remove the VPC Tier before trying again.";
                    }
                    s_logger.error((Object)errorMessage, new Object[0]);
                    throw new NuageVspException(errorMessage);
                }
            }
            boolean createDefaultAcls = !(predefinedDomainTemplateSet = StringUtils.isNotBlank(vsdDomainTemplateId));
            try {
                if (predefinedDomainTemplateSet) {
                    domainId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), NuageVspEntity.DOMAIN, vpcOrSubnetInfo.getLeft());
                    if (StringUtils.isNotBlank((String)domainId)) {
                        subnetId = this.validateDomain(domainId, vspNetwork, vspDhcpOptions);
                    } else {
                        Pair<String, String> domainAndSubnetId = this.createDomainZoneAndSubnet(enterpriseAndGroupId, vsdDomainTemplateId, createDefaultAcls, vspNetwork, vspDhcpOptions);
                        domainId = domainAndSubnetId.getLeft();
                        subnetId = domainAndSubnetId.getRight();
                    }
                    break block13;
                }
                domainTemplateId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), NuageVspEntity.DOMAIN_TEMPLATE, vpcOrSubnetInfo.getLeft());
                if (StringUtils.isNotBlank((String)domainTemplateId)) {
                    s_logger.debug("Domain Template " + domainTemplateId + " already exists for network " + vspNetwork.getName() + " in VSP", new Object[0]);
                    domainId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), NuageVspEntity.DOMAIN, vpcOrSubnetInfo.getLeft());
                    if (StringUtils.isNotBlank((String)domainId)) {
                        subnetId = this.validateDomain(domainId, vspNetwork, vspDhcpOptions);
                        break block13;
                    }
                    throw new NuageVspException("Domain is not found under the DomainTemplate " + domainTemplateId + " for network " + vspNetwork.getName() + " in VSP. There is a network sync issue with VSD");
                }
                NuageVspObject domainTemplateEntity = this.createNuageVspObject(NuageVspEntity.DOMAIN_TEMPLATE);
                domainTemplateEntity.set(NuageVspAttribute.DOMAIN_TEMPLATE_NAME, vpcOrSubnetInfo.getLeft());
                domainTemplateEntity.set(NuageVspAttribute.DOMAIN_TEMPLATE_DESCRIPTION, vpcOrSubnetInfo.getRight());
                domainTemplateEntity.set(NuageVspAttribute.EXTERNAL_ID, vpcOrSubnetInfo.getLeft());
                try {
                    String domainTemplateJson = this.createResource(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), domainTemplateEntity, false);
                    s_logger.debug("Created DomainTemplate for network " + vspNetwork.getName() + " in VSP . Response from VSP is " + domainTemplateJson, new Object[0]);
                    domainTemplateId = this.getEntityId(domainTemplateJson, NuageVspEntity.DOMAIN_TEMPLATE);
                }
                catch (NuageVspApiException exception) {
                    throw new NuageVspException(" Failed to create DomainTemplate for network " + vspNetwork.getName() + ". Json response from VSP REST API is " + exception.getMessage());
                }
                Pair<String, String> domainAndSubnetId = this.createDomainZoneAndSubnet(enterpriseAndGroupId, domainTemplateId, createDefaultAcls, vspNetwork, vspDhcpOptions);
                domainId = domainAndSubnetId.getLeft();
                subnetId = domainAndSubnetId.getRight();
            }
            catch (NuageVspException e) {
                this.cleanUpVspStaleObjects(NuageVspEntity.DOMAIN_TEMPLATE, domainTemplateId);
                throw e;
            }
        }
        return Pair.of(domainId, subnetId);
    }

    private String validateDomain(String domainId, VspNetwork vspNetwork, VspDhcpDomainOption vspDhcpOptions) throws NuageVspException {
        String subnetId = this.findEntityIdByExternalUuid(NuageVspEntity.DOMAIN, domainId, NuageVspEntity.SUBNET, vspNetwork.getSubnetExternalId());
        if (!vspNetwork.shouldReuseDomain() && StringUtils.isBlank((String)subnetId)) {
            throw new NuageVspException("Subnet is not found under the Domain " + domainId + " for network " + vspNetwork.getName() + " in VSP. There is a network sync issue with VSD");
        }
        if (vspNetwork.shouldReuseDomain()) {
            String zoneExternalUuid = vspNetwork.getVpcOrSubnetInfo().getLeft();
            String zoneId = this.findEntityIdByExternalUuid(NuageVspEntity.DOMAIN, domainId, NuageVspEntity.ZONE, zoneExternalUuid);
            if (StringUtils.isBlank((String)zoneId)) {
                throw new NuageVspException("Zone corresponding to network " + zoneExternalUuid + " does not exist in VSP. There is a data sync issue. Please a check VSP or create a new network");
            }
            if (StringUtils.isBlank((String)subnetId)) {
                subnetId = this.createL3Subnet(zoneId, vspNetwork, vspDhcpOptions);
            } else {
                s_logger.debug(" Subnet " + subnetId + " already exists for network " + vspNetwork.getName() + " in VSP", new Object[0]);
            }
        } else {
            s_logger.debug(" Domain and Subnet " + subnetId + " already exists for network " + vspNetwork.getName() + " in VSP", new Object[0]);
        }
        return subnetId;
    }

    private Pair<String, String> createDomainZoneAndSubnet(Pair<String, String> enterpriseAndGroupId, String domainTemplateId, boolean createDefaultAcls, VspNetwork vspNetwork, VspDhcpDomainOption vspDhcpOptions) throws NuageVspException {
        String zoneId;
        String domainId;
        String ingressAclTemplId = null;
        String egressAclTemplId = null;
        Pair<String, String> vpcOrSubnetInfo = vspNetwork.getVpcOrSubnetInfo();
        try {
            NuageVspObject domainEntity = this.createNuageVspObject(NuageVspEntity.DOMAIN);
            domainEntity.set(NuageVspAttribute.DOMAIN_NAME, vpcOrSubnetInfo.getLeft());
            domainEntity.set(NuageVspAttribute.DOMAIN_DESCRIPTION, vpcOrSubnetInfo.getRight());
            domainEntity.set(NuageVspAttribute.EXTERNAL_ID, vpcOrSubnetInfo.getLeft());
            domainEntity.set(NuageVspAttribute.DOMAIN_TEMPLATE_ID, domainTemplateId);
            domainEntity.set(NuageVspAttribute.DOMAIN_PATENABLED, "ENABLED");
            domainEntity.set(NuageVspAttribute.DOMAIN_UNDERLAYENABLED, "ENABLED");
            String domainJson = this.createResource(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), domainEntity, false);
            s_logger.debug("Created Domain for network " + vspNetwork.getName() + " in VSP . Response from VSP is " + domainJson, new Object[0]);
            domainId = this.getEntityId(domainJson, NuageVspEntity.DOMAIN);
            if (createDefaultAcls) {
                ingressAclTemplId = this.createDefaultAclTemplate(NuageVspEntity.INGRESS_ACLTEMPLATES, NuageVspEntity.DOMAIN, domainId, vspNetwork);
                egressAclTemplId = this.createDefaultAclTemplate(NuageVspEntity.EGRESS_ACLTEMPLATES, NuageVspEntity.DOMAIN, domainId, vspNetwork);
            }
        }
        catch (NuageVspException exception) {
            throw new NuageVspException("Failed to instantiate DomainTemplate for network " + vspNetwork.getName() + ". Json response from VSP REST API is " + exception.getMessage());
        }
        if (createDefaultAcls) {
            this.createDefaultAcls(NuageVspEntity.DOMAIN, domainId, ingressAclTemplId, new HashMap<Integer, NuageVspObject>(0), egressAclTemplId, new HashMap<Integer, NuageVspObject>(0), vspNetwork);
        }
        try {
            NuageVspObject zoneEntity = this.createNuageVspObject(NuageVspEntity.ZONE);
            zoneEntity.set(NuageVspAttribute.ZONE_NAME, "zone_" + vpcOrSubnetInfo.getLeft());
            zoneEntity.set(NuageVspAttribute.ZONE_DESCRIPTION, vpcOrSubnetInfo.getRight());
            zoneEntity.set(NuageVspAttribute.EXTERNAL_ID, vpcOrSubnetInfo.getLeft());
            zoneEntity.set(NuageVspAttribute.ZONE_PUBLIC, vspNetwork.isShared());
            String zoneJson = this.createResource(NuageVspEntity.DOMAIN, domainId, zoneEntity, false);
            zoneId = this.getEntityId(zoneJson, NuageVspEntity.ZONE);
            s_logger.debug("Created Zone for network " + vspNetwork.getName() + " in VSP. Response from VSP is " + zoneJson, new Object[0]);
            ImmutableSet groupIds = ImmutableSet.of((Object)enterpriseAndGroupId.getRight());
            this.addPermission(NuageVspEntity.ZONE, zoneId, (Set<String>)groupIds);
        }
        catch (NuageVspException exception) {
            throw new NuageVspException("Failed to create Zone for network " + vspNetwork.getName() + ". Json response from VSP REST API is " + exception.getMessage());
        }
        String subnetId = this.createL3Subnet(zoneId, vspNetwork, vspDhcpOptions);
        return Pair.of(domainId, subnetId);
    }

    private String createL3Subnet(String zoneId, VspNetwork vspNetwork, VspDhcpDomainOption vspDhcpOptions) throws NuageVspException {
        String subnetId;
        try {
            SubnetUtils.SubnetInfo subnetInfo = new SubnetUtils(vspNetwork.getCidr()).getInfo();
            NuageVspObject subnetEntity = this.createNuageVspObject(NuageVspEntity.SUBNET);
            subnetEntity.set(NuageVspAttribute.SUBNET_NAME, vspNetwork.getSubnetExternalId());
            subnetEntity.set(NuageVspAttribute.SUBNET_DESCRIPTION, vspNetwork.getName());
            subnetEntity.set(NuageVspAttribute.SUBNET_ADDRESS, subnetInfo.getNetworkAddress());
            subnetEntity.set(NuageVspAttribute.SUBNET_NETMASK, subnetInfo.getNetmask());
            subnetEntity.set(NuageVspAttribute.SUBNET_GATEWAY, vspNetwork.getGateway());
            subnetEntity.set(NuageVspAttribute.EXTERNAL_ID, vspNetwork.getSubnetExternalId());
            DhcpOptions dhcpOptions = null;
            if (vspDhcpOptions != null) {
                dhcpOptions = vspDhcpOptions.getVrIsDnsProvider() != false ? new DhcpOptions(vspNetwork.getVirtualRouterIp(), vspDhcpOptions.getDnsServers(), vspDhcpOptions.getNetworkDomain()) : new DhcpOptions(null, vspDhcpOptions.getDnsServers(), null);
            }
            if (vspNetwork.isShared()) {
                String sharedL3SubnetId = this.createL3SubnetSharedResources(vspNetwork, subnetInfo, dhcpOptions);
                subnetEntity.set(NuageVspAttribute.ASSOC_SHARED_NTWK_ID, sharedL3SubnetId);
            }
            String subnetJson = this.createResource(NuageVspEntity.ZONE, zoneId, subnetEntity, false);
            s_logger.debug("Created subnet for network " + vspNetwork.getName() + " in VSP. Response from VSP is " + subnetJson, new Object[0]);
            subnetId = this.getEntityId(subnetJson, NuageVspEntity.SUBNET);
            if (!vspNetwork.isShared() && dhcpOptions != null) {
                this.createDhcpOptions(true, NuageVspEntity.SUBNET, subnetId, vspNetwork.getUuid(), vspNetwork, dhcpOptions);
            }
        }
        catch (NuageVspException exception) {
            throw new NuageVspException("Failed to create Subnet for network " + vspNetwork.getName() + ". Json response from VSP REST API is " + exception.getMessage());
        }
        return subnetId;
    }

    private String createL3SubnetSharedResources(VspNetwork vspNetwork, SubnetUtils.SubnetInfo subnetInfo, DhcpOptions dhcpOptions) throws NuageVspException {
        String[] stringArray;
        String sharedL3SubnetId = null;
        if (vspNetwork.isPublicAccess()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "FLOATING";
            stringArray = stringArray2;
            stringArray2[1] = "PUBLIC";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "PUBLIC";
        }
        String[] resourceTypes = stringArray;
        String externalIdFromGateway = UuidUtils.generateUuidFromExternalIdAndIp(vspNetwork.getUuid(), vspNetwork.getGateway());
        for (String resourceType : resourceTypes) {
            Object sharedResource;
            String sharedResourceJson = this.findSharedResource(true, resourceType, externalIdFromGateway, vspNetwork.getGateway(), subnetInfo.getNetmask());
            if (StringUtils.isNotBlank((String)sharedResourceJson)) {
                s_logger.debug("Shared resource with UUID " + externalIdFromGateway + " and gateway " + vspNetwork.getGateway() + " is already created", new Object[0]);
                if (!resourceType.equals("PUBLIC")) continue;
                sharedResource = (NuageVspObject)Iterables.getFirst(this.parseJson(sharedResourceJson, NuageVspEntity.SHARED_NETWORK), null);
                sharedL3SubnetId = (String)((NuageVspObject)sharedResource).get(NuageVspAttribute.ID);
                continue;
            }
            sharedResource = vspNetwork.getAddressRanges().iterator();
            while (sharedResource.hasNext()) {
                VspAddressRange vspAddressRange = sharedResource.next();
                String externalId = UuidUtils.generateUuidFromExternalIdAndIp(vspNetwork.getUuid(), vspAddressRange.getGateway());
                sharedResourceJson = this.findSharedResource(true, resourceType, externalId, vspAddressRange.getGateway(), vspAddressRange.getNetmask());
                if (!StringUtils.isNotBlank((String)sharedResourceJson)) continue;
                break;
            }
            String sharedResourceParentId = (sharedResource = (NuageVspObject)Iterables.getFirst(this.parseJson(sharedResourceJson, NuageVspEntity.SHARED_NETWORK), null)) != null ? (String)((NuageVspObject)sharedResource).get(NuageVspAttribute.PARENT_ID) : null;
            String sharedResourceId = this.createSharedResource(resourceType, sharedResourceParentId, externalIdFromGateway, vspNetwork.getGateway(), subnetInfo.getNetmask(), false, vspNetwork.getName());
            if (dhcpOptions != null) {
                this.createDhcpOptions(true, NuageVspEntity.SHARED_NETWORK, sharedResourceId, externalIdFromGateway, vspNetwork, dhcpOptions);
            }
            if (!resourceType.equals("PUBLIC")) continue;
            sharedL3SubnetId = sharedResourceId;
        }
        return sharedL3SubnetId;
    }

    public void createDhcpOptions(boolean isCreateDhcpOption, NetworkDetails attachedNetworkDetails, VspNetwork vspNetwork, DhcpOptions dhcpOptions) throws NuageVspException {
        if (vspNetwork.isShared()) {
            String externalIdFromGateway = UuidUtils.generateUuidFromExternalIdAndIp(vspNetwork.getUuid(), vspNetwork.getGateway());
            String sharedResourceJson = this.findSharedResource(true, "PUBLIC", externalIdFromGateway, vspNetwork.getGateway(), NetUtils.getCidrNetmask(vspNetwork.getCidr()));
            String sharedResourceId = this.getEntityId(sharedResourceJson, NuageVspEntity.SHARED_NETWORK);
            this.createDhcpOptions(isCreateDhcpOption, NuageVspEntity.SHARED_NETWORK, sharedResourceId, externalIdFromGateway, vspNetwork, dhcpOptions);
        } else {
            this.createDhcpOptions(isCreateDhcpOption, attachedNetworkDetails.getSubnetType(), attachedNetworkDetails.getSubnetId(), vspNetwork.getUuid(), vspNetwork, dhcpOptions);
        }
    }

    public void createDhcpOptions(boolean isCreateDhcpOption, NuageVspEntity nuageVspEntity, String nuageVspEntityId, String nuageVspEntityUuid, VspNetwork vspNetwork, DhcpOptions dhcpOptions) throws NuageVspException {
        String dhcpOptionsJson;
        List<Object> existingDhcpOptions = Lists.newArrayList();
        if (!isCreateDhcpOption && !StringUtils.isBlank((String)(dhcpOptionsJson = this.findEntityByExternalUuid(nuageVspEntity, nuageVspEntityId, NuageVspEntity.DHCP_OPTIONS, nuageVspEntityUuid)))) {
            existingDhcpOptions = this.parseJson(dhcpOptionsJson, NuageVspEntity.DHCP_OPTIONS);
        }
        for (final DhcpOption dhcpOption : dhcpOptions.getOptions()) {
            NuageVspObject existingDhcpOption = (NuageVspObject)Iterables.find((Iterable)existingDhcpOptions, (Predicate)new Predicate<NuageVspObject>(){

                public boolean apply(NuageVspObject existingDhcpOption) {
                    return existingDhcpOption.get(NuageVspAttribute.DHCP_OPTIONS_TYPE).equals(dhcpOption.getCode());
                }
            }, null);
            if (existingDhcpOption == null) {
                NuageVspObject dhcpOptionToCreate = this.createDhcpOption(nuageVspEntityUuid, dhcpOption);
                String dhcpResponseJson = this.createResource(nuageVspEntity, nuageVspEntityId, dhcpOptionToCreate);
                s_logger.debug("Created DHCP options for network " + vspNetwork.getName() + " in VSP. Response from VSP is " + dhcpResponseJson, new Object[0]);
                continue;
            }
            String dhcpOptionValue = (String)existingDhcpOption.get(NuageVspAttribute.DHCP_OPTIONS_VALUE);
            if (!dhcpOptionValue.equals(dhcpOption.getValue())) {
                String dhcpOptionId = existingDhcpOption.getId();
                NuageVspObject dhcpOptionToUpdate = this.createDhcpOption(nuageVspEntityUuid, dhcpOption);
                this.updateResource(dhcpOptionId, dhcpOptionToUpdate, false);
                s_logger.debug("Network (" + vspNetwork.getName() + ") DNS server's setting " + dhcpOptionValue + " is changed to new value " + dhcpOption.getValue() + ". So, the DHCPOption for the network is updated", new Object[0]);
            }
            existingDhcpOptions.remove(existingDhcpOption);
        }
        for (NuageVspObject nuageVspObject : existingDhcpOptions) {
            s_logger.debug("Network (" + nuageVspEntityUuid + ") DNS server's setting " + nuageVspObject.get(NuageVspAttribute.DHCP_OPTIONS_VALUE) + " is removed. So, delete the DHCPOption for the network", new Object[0]);
            String dhcpOptionId = nuageVspObject.getId();
            this.cleanUpVspStaleObjects(NuageVspEntity.DHCP_OPTIONS, dhcpOptionId);
        }
    }

    private NuageVspObject createDhcpOption(String externalId, DhcpOption dhcpOption) {
        NuageVspObject existingDhcpOption = this.createNuageVspObject(NuageVspEntity.DHCP_OPTIONS);
        existingDhcpOption.set(NuageVspAttribute.DHCP_OPTIONS_LENGTH, dhcpOption.getLength());
        existingDhcpOption.set(NuageVspAttribute.DHCP_OPTIONS_TYPE, dhcpOption.getCode());
        existingDhcpOption.set(NuageVspAttribute.DHCP_OPTIONS_VALUE, dhcpOption.getValue());
        existingDhcpOption.set(NuageVspAttribute.EXTERNAL_ID, externalId);
        return existingDhcpOption;
    }

    private String getPaddedHexValue(String dnsServer) {
        String value = Long.toHexString(this.ip2Long(dnsServer));
        int valueLength = 8 - value.length();
        if (valueLength > 0) {
            StringBuilder pad = new StringBuilder();
            for (int i = 0; i < valueLength; ++i) {
                pad.append("0");
            }
            value = pad + value;
        }
        return value;
    }

    private long ip2Long(String ip) {
        String[] tokens = ip.split("[.]");
        assert (tokens.length == 4);
        long result = 0L;
        for (String token : tokens) {
            try {
                result = result << 8 | (long)Integer.parseInt(token);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Incorrect number", e);
            }
        }
        return result;
    }

    public String createIsolatedL2NetworkWithDefaultACLs(VspNetwork vspNetwork) throws NuageVspException {
        Pair<String, String> enterpriseAndGroupId = this.getOrCreateVSPEnterpriseAndGroup(vspNetwork.getVspDomain().getName(), vspNetwork.getVspDomain().getPath(), vspNetwork.getVspDomain().getUuid(), vspNetwork.getAccountName(), vspNetwork.getAccountUuid());
        ImmutableSet groupIds = ImmutableSet.of((Object)enterpriseAndGroupId.getRight());
        SubnetUtils.SubnetInfo subnetInfo = new SubnetUtils(vspNetwork.getCidr()).getInfo();
        s_logger.debug("Create or find Isolated L2 Domain for network " + vspNetwork.getUuid() + " in VSP", new Object[0]);
        String l2DomainId = null;
        StringBuffer errorMessage = new StringBuffer();
        String l2DomainTemplateId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), NuageVspEntity.L2DOMAIN_TEMPLATE, vspNetwork.getUuid());
        if (StringUtils.isNotBlank((String)l2DomainTemplateId)) {
            s_logger.debug("L2Domain Template " + l2DomainTemplateId + " already exists.", new Object[0]);
            l2DomainId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), NuageVspEntity.L2DOMAIN, vspNetwork.getUuid());
            if (StringUtils.isNotBlank((String)l2DomainId)) {
                s_logger.debug("L2Domain " + l2DomainId + " already exists for network " + vspNetwork.getName() + " in VSP.", new Object[0]);
            } else {
                errorMessage.append("L2Domain is not found under the L2DomainTemplate ").append(l2DomainTemplateId).append(" for network ").append(vspNetwork.getName()).append(" in VSP. There is a network sync issue with VSD");
            }
        } else {
            NuageVspObject l2DomainTemplateEntity = this.createNuageVspObject(NuageVspEntity.L2DOMAIN_TEMPLATE);
            l2DomainTemplateEntity.set(NuageVspAttribute.L2DOMAIN_TEMPLATE_NAME, vspNetwork.getUuid());
            l2DomainTemplateEntity.set(NuageVspAttribute.L2DOMAIN_TEMPLATE_DESCRIPTION, vspNetwork.getName());
            l2DomainTemplateEntity.set(NuageVspAttribute.EXTERNAL_ID, vspNetwork.getUuid());
            l2DomainTemplateEntity.set(NuageVspAttribute.L2DOMAIN_TEMPLATE_ADDRESS, subnetInfo.getNetworkAddress());
            l2DomainTemplateEntity.set(NuageVspAttribute.L2DOMAIN_TEMPLATE_NETMASK, subnetInfo.getNetmask());
            l2DomainTemplateEntity.set(NuageVspAttribute.L2DOMAIN_TEMPLATE_GATEWAY, vspNetwork.getGateway());
            try {
                String l2DomainTemplateJson = this.createResource(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), l2DomainTemplateEntity, false);
                s_logger.debug("Created L2DomainTemplate for network " + vspNetwork.getName() + " in VSP . Response from VSP is " + l2DomainTemplateJson, new Object[0]);
                l2DomainTemplateId = this.getEntityId(l2DomainTemplateJson, NuageVspEntity.L2DOMAIN_TEMPLATE);
            }
            catch (NuageVspApiException exception) {
                String error = "Failed to create L2DomainTemplate for network " + vspNetwork.getName() + ".  Json response from VSP REST API is  " + exception.getMessage();
                s_logger.error((Object)error, exception);
                throw new NuageVspException(error);
            }
            try {
                if (errorMessage.length() == 0) {
                    NuageVspObject l2DomainEntity = this.createNuageVspObject(NuageVspEntity.L2DOMAIN);
                    l2DomainEntity.set(NuageVspAttribute.L2DOMAIN_NAME, vspNetwork.getUuid());
                    l2DomainEntity.set(NuageVspAttribute.L2DOMAIN_DESCRIPTION, vspNetwork.getName());
                    l2DomainEntity.set(NuageVspAttribute.EXTERNAL_ID, vspNetwork.getUuid());
                    l2DomainEntity.set(NuageVspAttribute.L2DOMAIN_TEMPLATE_ID, l2DomainTemplateId);
                    String l2DomainJson = this.createResource(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), l2DomainEntity, false);
                    s_logger.debug("Created L2Domain for network " + vspNetwork.getName() + " in VSP . Response from VSP is " + l2DomainJson, new Object[0]);
                    l2DomainId = this.getEntityId(l2DomainJson, NuageVspEntity.L2DOMAIN);
                    l2DomainEntity.setId(l2DomainId);
                    try {
                        this.addPermission(NuageVspEntity.L2DOMAIN, l2DomainId, (Set<String>)groupIds);
                    }
                    catch (Exception e) {
                        errorMessage.append(e.getMessage());
                    }
                }
            }
            catch (NuageVspApiException exception) {
                errorMessage.append("Failed to instantiate L2DomainTemplate for network ").append(vspNetwork.getName()).append(".  Json response from VSP REST API is  ").append(exception.getMessage());
            }
            this.createDefaultAcls(NuageVspEntity.L2DOMAIN, l2DomainId, null, Maps.newHashMap(), null, Maps.newHashMap(), vspNetwork);
        }
        if (errorMessage.length() != 0) {
            s_logger.error((Object)errorMessage, new Object[0]);
            this.cleanUpVspStaleObjects(NuageVspEntity.L2DOMAIN_TEMPLATE, l2DomainTemplateId);
            throw new NuageVspException(errorMessage.toString());
        }
        return l2DomainId;
    }

    public void createDefaultAcls(NuageVspEntity nuageVspEntity, String nuageVspEntityId, String ingressACLTempId, Map<Integer, NuageVspObject> defaultIngressAclEntries, String egressACLTempId, Map<Integer, NuageVspObject> defaultEgressAclEntries, VspNetwork vspNetwork) throws NuageVspException {
        try {
            this.createDefaultIngressAcl(nuageVspEntity, nuageVspEntityId, ingressACLTempId, defaultIngressAclEntries, vspNetwork);
        }
        catch (NuageVspException exception) {
            throw new NuageVspException("Failed to create default Ingress ACL for network " + vspNetwork.getName() + ". Json response from VSP REST API is " + exception.getMessage());
        }
        try {
            this.createDefaultEgressAcl(nuageVspEntity, nuageVspEntityId, egressACLTempId, defaultEgressAclEntries, vspNetwork);
        }
        catch (NuageVspException exception) {
            throw new NuageVspException("Failed to create default Egress ACL for network " + vspNetwork.getName() + ". Json response from VSP REST API is " + exception.getMessage());
        }
    }

    public String getEnterprise(String domainUuid) throws NuageVspException {
        String enterpriseId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, null, null, domainUuid);
        if (StringUtils.isBlank((String)enterpriseId)) {
            String errorMessage = "Enterprise corresponding to CS domain " + domainUuid + " does not exist in VSP. There is a data sync issue. Please a check VSP or create a new network";
            s_logger.error((Object)errorMessage, new Object[0]);
            throw new NuageVspException(errorMessage);
        }
        return enterpriseId;
    }

    public Pair<String, String> getIsolatedSubNetwork(String enterpriseId, VspNetwork vspNetwork) throws NuageVspException {
        return this.getIsolatedSubNetwork(true, enterpriseId, vspNetwork);
    }

    public Pair<String, String> getIsolatedSubNetwork(boolean throwExceptionWhenNotFound, String enterpriseId, VspNetwork vspNetwork) throws NuageVspException {
        Pair<String, String> vpcOrSubnetInfo = vspNetwork.getVpcOrSubnetInfo();
        try {
            String domainId = this.getIsolatedDomain(enterpriseId, NuageVspEntity.DOMAIN, vpcOrSubnetInfo.getLeft());
            if (domainId == null) {
                return null;
            }
            String zoneId = this.findEntityIdByExternalUuid(NuageVspEntity.DOMAIN, domainId, NuageVspEntity.ZONE, vpcOrSubnetInfo.getLeft());
            if (StringUtils.isBlank((String)zoneId)) {
                if (throwExceptionWhenNotFound) {
                    throw new NuageVspException("Zone corresponding to network " + vpcOrSubnetInfo.getLeft() + " does not exist in VSP. There is a data sync issue. Please a check VSP or create a new network");
                }
                return null;
            }
            String subnetId = this.findEntityIdByExternalUuid(NuageVspEntity.ZONE, zoneId, NuageVspEntity.SUBNET, vspNetwork.getSubnetExternalId());
            if (StringUtils.isBlank((String)subnetId)) {
                if (throwExceptionWhenNotFound) {
                    throw new NuageVspException("Subnet corresponding to network " + vspNetwork.getUuid() + " does not exist in VSP. There is a data sync issue. Please a check VSP or create a new network");
                }
                return null;
            }
            return Pair.of(domainId, subnetId);
        }
        catch (NuageVspApiException exception) {
            String errorMessage = "Failed to get Subnet corresponding to network " + vspNetwork.getUuid() + ".  Json response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
            throw new NuageVspException(errorMessage);
        }
    }

    public String getIsolatedDomain(String enterpriseId, NuageVspEntity attachedNetworkType, String vpcOrSubnetUuid) throws NuageVspException {
        return this.getIsolatedDomain(true, enterpriseId, attachedNetworkType, vpcOrSubnetUuid);
    }

    public String getIsolatedDomain(boolean throwExceptionWhenNotFound, String enterpriseId, NuageVspEntity attachedNetworkType, String vpcOrSubnetUuid) throws NuageVspException {
        String domainId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, attachedNetworkType, vpcOrSubnetUuid);
        if (StringUtils.isBlank((String)domainId)) {
            if (throwExceptionWhenNotFound) {
                throw new NuageVspException((Object)((Object)attachedNetworkType) + " corresponding to network " + vpcOrSubnetUuid + " does not exist in VSP. There is a data sync issue. Please a check VSP or create a new network");
            }
            return null;
        }
        return domainId;
    }

    public List<NuageVspObject> getACLAssociatedToDomain(boolean ingress, NuageVspEntity domainType, String domainUuid, String networkUuid) throws NuageVspException {
        NuageVspEntity aclType = ingress ? NuageVspEntity.INGRESS_ACLTEMPLATES : NuageVspEntity.EGRESS_ACLTEMPLATES;
        String aclTemplates = this.getResources(domainType, domainUuid, aclType);
        if (StringUtils.isNotBlank((String)aclTemplates)) {
            return this.parseJson(aclTemplates, aclType);
        }
        throw new NuageVspException((Object)((Object)aclType) + " ACL corresponding to network " + networkUuid + " does not exist in VSP. There is a data sync issue. Please a check VSP or create a new network");
    }

    public List<NuageVspObject> getACLEntriesAssociatedToLocation(String aclNetworkLocationId, NuageVspEntity aclTemplateType, String aclTemplateId) throws NuageVspException {
        NuageVspEntity aclEntryType = aclTemplateType.equals((Object)NuageVspEntity.INGRESS_ACLTEMPLATES) ? NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES : NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES;
        String aclTemplateEntries = aclNetworkLocationId != null ? this.findEntityUsingFilter(aclTemplateType, aclTemplateId, aclEntryType, NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID, aclNetworkLocationId) : this.findEntityUsingFilter(aclTemplateType, aclTemplateId, aclEntryType, NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_TYPE, "ANY");
        if (StringUtils.isNotBlank((String)aclTemplateEntries)) {
            return this.parseJson(aclTemplateEntries, aclEntryType);
        }
        return Collections.emptyList();
    }

    public Pair<Boolean, String> findOrCreateSharedResource(boolean findByExternalId, String resourceType, String staticNatNetworkUuid, String staticNatVlanGateway, String staticNatVlanNetmask, boolean staticNatVlanUnderlay, String networkName) throws NuageVspException {
        String sharedNetworkJson = this.findSharedResource(findByExternalId, resourceType, staticNatNetworkUuid, staticNatVlanGateway, staticNatVlanNetmask);
        if (StringUtils.isNotBlank((String)sharedNetworkJson)) {
            return Pair.of(false, this.getEntityId(sharedNetworkJson, NuageVspEntity.SHARED_NETWORK));
        }
        String sharedResourceId = this.createSharedResource(resourceType, null, staticNatNetworkUuid, staticNatVlanGateway, staticNatVlanNetmask, staticNatVlanUnderlay, networkName);
        return Pair.of(true, sharedResourceId);
    }

    public String findSharedResource(boolean findByExternalId, String resourceType, String staticNatNetworkUuid, String staticNatVlanGateway, String staticNatVlanNetmask) throws NuageVspException {
        HashMap<NuageVspAttribute, Object> filterMap = new HashMap<NuageVspAttribute, Object>();
        filterMap.put(NuageVspAttribute.SHARED_RESOURCE_ADRESS, NetUtils.getSubNet(staticNatVlanGateway, staticNatVlanNetmask));
        filterMap.put(NuageVspAttribute.SHARED_RESOURCE_NETMASK, staticNatVlanNetmask);
        filterMap.put(NuageVspAttribute.SHARED_RESOURCE_TYPE, resourceType);
        if (findByExternalId) {
            filterMap.put(NuageVspAttribute.EXTERNAL_ID, staticNatNetworkUuid);
        }
        return this.findEntityUsingFilterMap(NuageVspEntity.SHARED_NETWORK, null, null, filterMap);
    }

    public String createSharedResource(String resourceType, String sharedResourceParentId, String staticNatNetworkUuid, String staticNatVlanGateway, String staticNatVlanNetmask, boolean staticNatVlanUnderlay, String networkName) throws NuageVspException {
        SubnetUtils subnetUtils = new SubnetUtils(staticNatVlanGateway, staticNatVlanNetmask);
        NuageVspObject sharedNtwkEntity = this.createNuageVspObject(NuageVspEntity.SHARED_NETWORK);
        sharedNtwkEntity.set(NuageVspAttribute.SHARED_RESOURCE_NAME, resourceType.charAt(0) + "-" + staticNatNetworkUuid);
        sharedNtwkEntity.set(NuageVspAttribute.SHARED_RESOURCE_DESCRIPTION, networkName);
        sharedNtwkEntity.set(NuageVspAttribute.SHARED_RESOURCE_GATEWAY, staticNatVlanGateway);
        sharedNtwkEntity.set(NuageVspAttribute.SHARED_RESOURCE_NETMASK, staticNatVlanNetmask);
        sharedNtwkEntity.set(NuageVspAttribute.EXTERNAL_ID, staticNatNetworkUuid);
        sharedNtwkEntity.set(NuageVspAttribute.SHARED_RESOURCE_ADRESS, subnetUtils.getInfo().getNetworkAddress());
        sharedNtwkEntity.set(NuageVspAttribute.SHARED_RESOURCE_TYPE, resourceType);
        sharedNtwkEntity.set(NuageVspAttribute.SHARED_RESOURCE_UNDERLAY, staticNatVlanUnderlay);
        sharedNtwkEntity.set(NuageVspAttribute.SHARED_RESOURCE_PARENT_ID, sharedResourceParentId);
        try {
            String sharedResourceJsonString = this.createResource(sharedNtwkEntity);
            String sharedResourceId = this.getEntityId(sharedResourceJsonString, NuageVspEntity.SHARED_NETWORK);
            s_logger.debug("Nuage Vsp Shared Network is not available. So, created a new Shared Network " + staticNatNetworkUuid, new Object[0]);
            return sharedResourceId;
        }
        catch (NuageVspApiException e) {
            String errorMessage = "Failed to create SharedResource in VSP using REST API. Json response from VSP REST API is " + e.getMessage();
            s_logger.error((Object)errorMessage, new Object[0]);
            throw new NuageVspException(errorMessage);
        }
    }

    public void deleteSharedResourceInVSP(String resourceType, String staticNatNetworkUuid, String staticNatVlanGateway, String staticNatVlanNetmask) throws NuageVspException {
        String sharedResourceJson = this.findSharedResource(true, resourceType, staticNatNetworkUuid, staticNatVlanGateway, staticNatVlanNetmask);
        if (StringUtils.isNotBlank((String)sharedResourceJson)) {
            String sharedNetworkId = this.getEntityId(sharedResourceJson, NuageVspEntity.SHARED_NETWORK);
            this.deleteResource(NuageVspEntity.SHARED_NETWORK, sharedNetworkId, false);
        }
    }

    public String applyStaticNatInVsp(NetworkDetails attachedNetworkDetails, String vportId, VspStaticNat vspStaticNat) throws NuageVspException {
        String sharedNetworkId = this.findOrCreateSharedResource(false, "FLOATING", vspStaticNat.getVlanUuid(), vspStaticNat.getVlanGateway(), vspStaticNat.getVlanNetmask(), vspStaticNat.isVlanUnderlay(), null).getRight();
        if (StringUtils.isNotBlank((String)vportId)) {
            return this.allocateFIPToVPortInVsp(attachedNetworkDetails, vportId, sharedNetworkId, vspStaticNat.getIpAddress(), vspStaticNat.getIpUuid(), vspStaticNat.getVspNic().getSecondaryIpAddress(), vspStaticNat.getVspNic().getSecondaryIpUuid());
        }
        if (attachedNetworkDetails.getDomainType().equals((Object)NuageVspEntity.DOMAIN)) {
            String vportIdUsingNicUuid = this.findEntityIdByExternalUuid(NuageVspEntity.SUBNET, attachedNetworkDetails.getSubnetId(), NuageVspEntity.VPORT, vspStaticNat.getVspNic().getUuid());
            if (StringUtils.isNotBlank((String)vportIdUsingNicUuid)) {
                s_logger.warn("NIC associated to Static NAT " + vspStaticNat.getIpAddress() + "(" + vspStaticNat.getIpUuid() + ") is not present in VSD. But, VM's VPort with externalID " + vspStaticNat.getVspNic().getUuid() + " exists in VSD. So, associate the FIP to the Vport " + vportIdUsingNicUuid, new Object[0]);
                return this.allocateFIPToVPortInVsp(attachedNetworkDetails, vportId, sharedNetworkId, vspStaticNat.getIpAddress(), vspStaticNat.getIpUuid(), vspStaticNat.getVspNic().getSecondaryIpAddress(), vspStaticNat.getVspNic().getSecondaryIpUuid());
            }
            s_logger.warn("Static NAT " + vspStaticNat.getIpAddress() + "(" + vspStaticNat.getIpUuid() + ") is not associated to the VM interface because neither the interface nor the VPort with NIC's UUID " + vspStaticNat.getVspNic().getUuid() + " is not present in VSD", new Object[0]);
        }
        return null;
    }

    public String allocateFIPToVPortInVsp(NetworkDetails attachedNetworkDetails, String vportId, String vspSharedNetworkId, String staticNatIp, String staticNatIpUuid, String nicSecondaryIp4Address, String nicSecondaryIpUuid) throws NuageVspException {
        String errorMessage = "";
        String fipExternalId = attachedNetworkDetails.getDomainUuid() + ":" + staticNatIpUuid;
        String floatingIpId = this.findEntityIdByExternalUuid(attachedNetworkDetails.getDomainType(), attachedNetworkDetails.getDomainId(), NuageVspEntity.FLOATING_IP, fipExternalId);
        if (StringUtils.isBlank((String)floatingIpId)) {
            NuageVspObject floatingIpEntity = this.createNuageVspObject(NuageVspEntity.FLOATING_IP);
            floatingIpEntity.set(NuageVspAttribute.FLOATING_IP_ADDRESS, staticNatIp);
            floatingIpEntity.set(NuageVspAttribute.ASSOC_SHARED_NTWK_ID, vspSharedNetworkId);
            floatingIpEntity.set(NuageVspAttribute.EXTERNAL_ID, fipExternalId);
            try {
                String floatingIpJson = this.createResource(attachedNetworkDetails.getDomainType(), attachedNetworkDetails.getDomainId(), floatingIpEntity);
                floatingIpId = this.getEntityId(floatingIpJson, NuageVspEntity.FLOATING_IP);
                s_logger.debug("Created a new FloatingIP in Vsp " + floatingIpJson + " in FLoatingIP shared resource " + vspSharedNetworkId, new Object[0]);
            }
            catch (NuageVspApiException e1) {
                errorMessage = "Failed to create Floating in VSP using REST API " + e1.getMessage();
            }
        }
        if (StringUtils.isBlank((String)errorMessage)) {
            if (nicSecondaryIp4Address != null) {
                this.createVirtualIPWithFloatingIPId(vportId, nicSecondaryIp4Address, nicSecondaryIpUuid, floatingIpId);
                s_logger.debug("Associated the new FloatingIP " + staticNatIp + " to Virtual IP " + nicSecondaryIp4Address + " of VM with VPort " + vportId, new Object[0]);
            } else {
                this.updateVPortWithFloatingIPId(vportId, floatingIpId);
                s_logger.debug("Associated the new FloatingIP " + staticNatIp + " to VM with VPort " + vportId, new Object[0]);
            }
        }
        if (StringUtils.isNotBlank((String)errorMessage)) {
            s_logger.error((Object)errorMessage, new Object[0]);
            throw new NuageVspException(errorMessage);
        }
        return floatingIpId;
    }

    public void createVirtualIPWithFloatingIPId(String vportId, String nicSecondaryIp4Address, String nicSecondaryIpUuid, String floatingIPId) throws NuageVspException {
        block4: {
            NuageVspObject virtualIp = this.createNuageVspObject(NuageVspEntity.VIRTUAL_IP);
            virtualIp.set(NuageVspAttribute.VIRTUAL_IP_FLOATING_IP_ID, floatingIPId);
            virtualIp.set(NuageVspAttribute.VIRTUAL_IP_ADDRESS, nicSecondaryIp4Address);
            virtualIp.set(NuageVspAttribute.EXTERNAL_ID, nicSecondaryIpUuid);
            try {
                String virtualIpsJson = this.findEntityUsingFilter(NuageVspEntity.VPORT, vportId, NuageVspEntity.VIRTUAL_IP, NuageVspAttribute.VIRTUAL_IP_ADDRESS, nicSecondaryIp4Address);
                List<NuageVspObject> virtualIps = this.parseJson(virtualIpsJson, NuageVspEntity.VIRTUAL_IP);
                if (CollectionUtils.isNotEmpty(virtualIps)) {
                    NuageVspObject existingVirtualIp = (NuageVspObject)Iterables.getFirst(virtualIps, null);
                    String existingFloatingIpId = (String)existingVirtualIp.get(NuageVspAttribute.VIRTUAL_IP_FLOATING_IP_ID);
                    if (existingFloatingIpId != null && !existingFloatingIpId.equals(floatingIPId)) {
                        throw new NuageVspException("Failed to associate the FloatingIP " + floatingIPId + " to the VPort " + vportId + ". Another VirtualIP with the same vip = " + nicSecondaryIp4Address + " exists.");
                    }
                    return;
                }
                this.createResource(NuageVspEntity.VPORT, vportId, virtualIp, false);
            }
            catch (NuageVspException e) {
                if (this.isNoChangeInEntityException(e)) break block4;
                throw new NuageVspException("Failed to associate the FloatingIP " + floatingIPId + " to the VPort " + vportId, e);
            }
        }
    }

    public String updateVPortWithFloatingIPId(String vportId, String floatingIPId) {
        String errorMessage;
        block2: {
            errorMessage = "";
            NuageVspObject vportEntity = this.createNuageVspObject(NuageVspEntity.VPORT);
            vportEntity.set(NuageVspAttribute.VPORT_FLOATING_IP_ID, floatingIPId);
            try {
                this.updateResource(vportId, vportEntity, false);
            }
            catch (NuageVspApiException e) {
                if (this.isNoChangeInEntityException(e)) break block2;
                errorMessage = "Failed to associated the FloatingIP " + floatingIPId + " to the VPort " + vportId + e.getMessage();
            }
        }
        return errorMessage;
    }

    public void releaseFIPFromVsp(NetworkDetails attachedNetworkDetails, String vportId, String staticNatIpUuid, String nicSecondaryIpUuid) throws NuageVspException {
        String fipExternalId = attachedNetworkDetails.getDomainUuid() + ":" + staticNatIpUuid;
        final String floatingIpId = this.findEntityIdByExternalUuid(attachedNetworkDetails.getDomainType(), attachedNetworkDetails.getDomainId(), NuageVspEntity.FLOATING_IP, fipExternalId);
        String virtualIpId = null;
        if (nicSecondaryIpUuid != null) {
            virtualIpId = this.findEntityIdByExternalUuid(attachedNetworkDetails.getSubnetType(), attachedNetworkDetails.getSubnetId(), NuageVspEntity.VIRTUAL_IP, nicSecondaryIpUuid);
        }
        if (StringUtils.isBlank((String)floatingIpId)) {
            s_logger.debug("vportId is null and also FIP with external ID " + staticNatIpUuid + " does not exists in VSP", new Object[0]);
            return;
        }
        if (StringUtils.isBlank((String)vportId)) {
            s_logger.debug("vportId is null. This could be case where VM interface is not present in VSP. So, finding the VPort in " + attachedNetworkDetails.getSubnetId() + " that has the FIP with externalId " + staticNatIpUuid, new Object[0]);
            String vportJson = this.getResources(NuageVspEntity.FLOATING_IP, floatingIpId, NuageVspEntity.VPORT);
            if (StringUtils.isNotBlank((String)vportJson)) {
                List<NuageVspObject> vports = this.parseJson(vportJson, NuageVspEntity.VPORT);
                vportId = (String)vports.get(0).get(NuageVspAttribute.ID);
            } else {
                vportJson = this.getResources(attachedNetworkDetails.getSubnetType(), attachedNetworkDetails.getSubnetId(), NuageVspEntity.VPORT);
                List<NuageVspObject> vports = this.parseJson(vportJson, NuageVspEntity.VPORT);
                for (NuageVspObject vport : vports) {
                    String virtualIpsJson = this.getResources(NuageVspEntity.VPORT, (String)vport.get(NuageVspAttribute.ID), NuageVspEntity.VIRTUAL_IP);
                    Collection<NuageVspObject> virtualIps = this.parseJson(virtualIpsJson, NuageVspEntity.VIRTUAL_IP);
                    if (!CollectionUtils.isNotEmpty(virtualIps = Collections2.filter(virtualIps, (Predicate)new Predicate<NuageVspObject>(){

                        public boolean apply(NuageVspObject input) {
                            return input.get(NuageVspAttribute.VIRTUAL_IP_FLOATING_IP_ID).equals(floatingIpId);
                        }
                    }))) continue;
                    vportId = (String)vport.get(NuageVspAttribute.ID);
                    virtualIpId = (String)((NuageVspObject)Iterables.getFirst(virtualIps, null)).get(NuageVspAttribute.ID);
                    s_logger.debug("Found a VPort " + vport + " that is associated the stale FIP " + fipExternalId + " in network " + attachedNetworkDetails.getDomainUuid(), new Object[0]);
                    break;
                }
            }
        }
        if (StringUtils.isBlank((String)vportId)) {
            this.cleanUpVspStaleObjects(NuageVspEntity.FLOATING_IP, floatingIpId);
            return;
        }
        if (virtualIpId != null) {
            this.cleanUpVspStaleObjects(NuageVspEntity.VIRTUAL_IP, virtualIpId);
        } else {
            this.updateVPortWithFloatingIPId(vportId, null);
        }
        s_logger.debug("Removed the association of Floating IP " + fipExternalId + " with VSP VPort " + vportId, new Object[0]);
        if (!this.cleanUpVspStaleObjects(NuageVspEntity.FLOATING_IP, floatingIpId)) {
            throw new NuageVspException("Failed to remove Floating IP");
        }
    }

    private String createDefaultAclTemplate(NuageVspEntity aclTemplateType, NuageVspEntity domainType, String domainId, VspNetwork vspNetwork) throws NuageVspException {
        NuageVspObject aclTemplateEntity = this.createNuageVspObject(aclTemplateType);
        aclTemplateEntity.set(NuageVspAttribute.NAME, aclTemplateType == NuageVspEntity.INGRESS_ACLTEMPLATES ? "Ingress ACL" : "Egress ACL");
        aclTemplateEntity.set(NuageVspAttribute.EXTERNAL_ID, vspNetwork.getVpcOrSubnetInfo().getLeft());
        aclTemplateEntity.set(NuageVspAttribute.ACLTEMPLATES_ALLOW_IP, false);
        aclTemplateEntity.set(NuageVspAttribute.ACLTEMPLATES_ALLOW_NON_IP, false);
        aclTemplateEntity.set(NuageVspAttribute.ACLTEMPLATES_ACTIVE, true);
        String aclTemplateJson = this.createResource(domainType, domainId, aclTemplateEntity);
        String aclTemplateId = this.getEntityId(aclTemplateJson, aclTemplateType);
        s_logger.debug("Created ACLTemplate for network " + vspNetwork.getName() + " in VSP . Response from VSP is " + aclTemplateJson, new Object[0]);
        return aclTemplateId;
    }

    private void createDefaultEgressAcl(NuageVspEntity domainType, String domainId, String egressACLTempId, Map<Integer, NuageVspObject> defaultVspEgressAclEntries, VspNetwork vspNetwork) throws NuageVspException {
        if (egressACLTempId == null) {
            egressACLTempId = this.createDefaultAclTemplate(NuageVspEntity.EGRESS_ACLTEMPLATES, domainType, domainId, vspNetwork);
        }
        if (vspNetwork.isShared()) {
            this.createDefaultACLEntry(egressACLTempId, false, false, "ANY", "FORWARD", 10000001, "Default Allow All ACL", "ANY", null, "ANY", vspNetwork.getName());
            return;
        }
        if (!defaultVspEgressAclEntries.containsKey(0)) {
            this.createDefaultACLEntry(egressACLTempId, false, false, "ANY", "FORWARD", 0, "Default Intra-Subnet Allow ACL", "ANY", null, "ENDPOINT_SUBNET", vspNetwork.getName());
        }
        if (vspNetwork.isEgressDefaultPolicy()) {
            if (vspNetwork.shouldReuseDomain() && !defaultVspEgressAclEntries.containsKey(11000000)) {
                this.createDefaultACLEntry(egressACLTempId, false, false, "ANY", "DROP", 11000000, "Default Intra-Domain Deny ACL", "ANY", null, "ENDPOINT_DOMAIN", vspNetwork.getName());
            }
            if (!defaultVspEgressAclEntries.containsKey(11000003)) {
                this.createDefaultACLEntry(egressACLTempId, false, false, "ICMP", "FORWARD", 11000003, "Default Allow ICMP", "ANY", null, "ANY", vspNetwork.getName());
            }
        }
    }

    private void createDefaultIngressAcl(NuageVspEntity domainType, String domainId, String ingressACLTempId, Map<Integer, NuageVspObject> defaultVspIngressAclEntries, VspNetwork vspNetwork) throws NuageVspException {
        if (ingressACLTempId == null) {
            ingressACLTempId = this.createDefaultAclTemplate(NuageVspEntity.INGRESS_ACLTEMPLATES, domainType, domainId, vspNetwork);
        }
        if (vspNetwork.isShared()) {
            this.createDefaultACLEntry(ingressACLTempId, true, false, "ANY", "FORWARD", 10000001, "Default Allow All ACL", "ANY", null, "ANY", vspNetwork.getName());
            return;
        }
        if (!defaultVspIngressAclEntries.containsKey(0)) {
            this.createDefaultACLEntry(ingressACLTempId, true, false, "ANY", "FORWARD", 0, "Default Intra-Subnet Allow ACL", "ANY", null, "ENDPOINT_SUBNET", vspNetwork.getName());
        }
        if (vspNetwork.isEgressDefaultPolicy()) {
            if (!defaultVspIngressAclEntries.containsKey(11000001)) {
                this.createDefaultACLEntry(ingressACLTempId, true, true, "TCP", "FORWARD", 11000001, "Default Allow TCP", "ANY", null, "ANY", vspNetwork.getName());
            }
            if (!defaultVspIngressAclEntries.containsKey(11000002)) {
                this.createDefaultACLEntry(ingressACLTempId, true, true, "UDP", "FORWARD", 11000002, "Default Allow UDP", "ANY", null, "ANY", vspNetwork.getName());
            }
            if (!defaultVspIngressAclEntries.containsKey(11000003)) {
                this.createDefaultACLEntry(ingressACLTempId, true, false, "ICMP", "FORWARD", 11000003, "Default Allow ICMP", "ANY", null, "ANY", vspNetwork.getName());
            }
        }
    }

    private void createDefaultACLEntry(String aclTemplateId, boolean isIngress, boolean isReflexive, String protocol, String action, int aclPriority, String aclEntryDescription, String locationType, String locationId, String destinationNetwork, String networkName) throws NuageVspException {
        if (isIngress) {
            NuageVspObject ingressACLEntryEntity = this.createNuageVspObject(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES);
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ETHER_TYPE, "0x0800");
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ACTION, action);
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_TYPE, locationType);
            if (locationId != null) {
                ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID, locationId);
            }
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, destinationNetwork);
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PROTOCOL, this.getProtocolNumber(protocol));
            if (StringUtils.equals((String)protocol, (String)"TCP") || StringUtils.equals((String)protocol, (String)"UDP")) {
                ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_SOURCE_PORT, "*");
                ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DEST_PORT, "*");
            }
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DSCP, "*");
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_REFLEXIVE, isReflexive);
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DESCRIPTION, aclEntryDescription);
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY, aclPriority);
            String ingressAclEntry = this.createResource(NuageVspEntity.INGRESS_ACLTEMPLATES, aclTemplateId, ingressACLEntryEntity, false);
            s_logger.debug("Created Default IngressACLTemplateEntry for network " + networkName + " in VSP . Response from VSP is " + ingressAclEntry, new Object[0]);
        } else {
            NuageVspObject egressACLEntryEntity = this.createNuageVspObject(NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES);
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ETHER_TYPE, "0x0800");
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ACTION, action);
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_TYPE, "ANY");
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, destinationNetwork);
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PROTOCOL, this.getProtocolNumber(protocol));
            if (StringUtils.equals((String)protocol, (String)"TCP") || StringUtils.equals((String)protocol, (String)"UDP")) {
                egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_SOURCE_PORT, "*");
                egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DEST_PORT, "*");
            }
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DSCP, "*");
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_REFLEXIVE, isReflexive);
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DESCRIPTION, aclEntryDescription);
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY, aclPriority);
            String egressAclEntry = this.createResource(NuageVspEntity.EGRESS_ACLTEMPLATES, aclTemplateId, egressACLEntryEntity, false);
            s_logger.debug("Created Default egressACLTemplateEntry for network " + networkName + " in VSP . Response from VSP is " + egressAclEntry, new Object[0]);
        }
    }

    public void createEgressACLEntryInVsp(String vsdEnterpriseId, String egressAclTemplateId, VspAclRule vspAclRule, String sourceIp, String aclNetworkLocationId, long networkId, List<String> successfullyAddedEgressACls) throws NuageVspException {
        for (String sourceCidr : vspAclRule.getSourceCidrList()) {
            try {
                NuageVspObject egressACLEntryEntity = this.getEgressAclEntry(vsdEnterpriseId, vspAclRule, sourceIp, aclNetworkLocationId, networkId, sourceCidr, false, -1);
                String egressAclEntryJson = this.createResource(NuageVspEntity.EGRESS_ACLTEMPLATES, egressAclTemplateId, egressACLEntryEntity, false, Lists.newArrayList((Object[])new Integer[]{2591}));
                String egressAclEntryId = this.getEntityId(egressAclEntryJson, NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES);
                successfullyAddedEgressACls.add(egressAclEntryId);
                s_logger.debug("Created Egress ACL Entry for rule " + vspAclRule + " with CIDR " + sourceCidr + " in VSP. Response from VSP is " + egressAclEntryJson, new Object[0]);
            }
            catch (NuageVspApiException exception) {
                throw new NuageVspException("Failed to create Egress ACL Entry for rule " + vspAclRule + " in VSP enterprise " + vsdEnterpriseId + ". " + exception.getMessage());
            }
        }
    }

    public void updateEgressACLEntryInVsp(String vsdEnterpriseId, String egressAclEntryId, NuageVspObject egressEntryData, VspAclRule vspAclRule, String sourceIp, String aclNetworkLocationId, long networkId, int oldPriority) throws NuageVspException {
        for (String sourceCidr : vspAclRule.getSourceCidrList()) {
            try {
                NuageVspObject modifiedEgressACLEntryEntity = this.getEgressAclEntry(vsdEnterpriseId, vspAclRule, sourceIp, aclNetworkLocationId, networkId, sourceCidr, true, oldPriority);
                if (!this.areRulesModified(egressEntryData, modifiedEgressACLEntryEntity)) continue;
                String egressAclEntryJson = this.updateResource(egressAclEntryId, modifiedEgressACLEntryEntity, false);
                s_logger.debug("Modified Egress ACL Entry for rule " + vspAclRule + " with CIDR " + sourceCidr + " in VSP. Response from VSP is " + egressAclEntryJson, new Object[0]);
            }
            catch (NuageVspApiException exception) {
                if (this.isNoChangeInEntityException(exception)) continue;
                throw new NuageVspException("Failed to Modify Engress ACL Entry for rule " + vspAclRule + " in VSP enterprise " + vsdEnterpriseId + ". " + exception.getMessage());
            }
        }
    }

    private boolean areRulesModified(NuageVspObject origRules, NuageVspObject newRules) {
        return !origRules.entriesEqualTo(newRules);
    }

    private boolean isNoChangeInEntityException(Exception exception) {
        return exception instanceof NuageVspApiException && ((NuageVspApiException)exception).getNuageErrorCode() == 2039;
    }

    public void createIngressACLEntryInVsp(String vsdEnterpriseId, String ingressAclTemplateId, VspAclRule vspAclRule, String aclNetworkLocationId, long networkId, List<String> successfullyAddedIngressACls) throws NuageVspException {
        for (String sourceCidr : vspAclRule.getSourceCidrList()) {
            try {
                NuageVspObject ingressACLEntryEntity = this.getIngressAclEntry(vsdEnterpriseId, vspAclRule, aclNetworkLocationId, networkId, sourceCidr, false, -1);
                String ingressAclEntryJson = this.createResource(NuageVspEntity.INGRESS_ACLTEMPLATES, ingressAclTemplateId, ingressACLEntryEntity, false, Lists.newArrayList((Object[])new Integer[]{2591}));
                String ingressAclEntryId = this.getEntityId(ingressAclEntryJson, NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES);
                successfullyAddedIngressACls.add(ingressAclEntryId);
            }
            catch (NuageVspApiException exception) {
                throw new NuageVspException("Failed to create Ingress ACL Entry for rule " + vspAclRule + " with CIDR " + sourceCidr + " in VSP enterprise " + vsdEnterpriseId + ". " + exception.getMessage());
            }
        }
    }

    public void updateIngressACLEntryInVsp(String vsdEnterpriseId, String ingressAclEntryId, NuageVspObject ingressEntryData, VspAclRule vspAclRule, String aclNetworkLocationId, long networkId, int oldPriority) throws NuageVspException {
        for (String sourceCidr : vspAclRule.getSourceCidrList()) {
            try {
                NuageVspObject modifiedIngressACLEntryEntity = this.getIngressAclEntry(vsdEnterpriseId, vspAclRule, aclNetworkLocationId, networkId, sourceCidr, true, oldPriority);
                if (!this.areRulesModified(ingressEntryData, modifiedIngressACLEntryEntity)) continue;
                String ingressAclEntryJson = this.updateResource(ingressAclEntryId, modifiedIngressACLEntryEntity, false);
                s_logger.debug("Updated Ingress ACL Entry for rule " + vspAclRule + " with CIDR " + sourceCidr + " in VSP. Response from VSP is " + ingressAclEntryJson, new Object[0]);
            }
            catch (NuageVspApiException exception) {
                if (this.isNoChangeInEntityException(exception)) continue;
                throw new NuageVspException("Failed to Modify Ingress ACL Entry for rule " + vspAclRule + " with CIDR " + sourceCidr + " in VSP enterprise " + vsdEnterpriseId + ". " + exception.getMessage());
            }
        }
    }

    private NuageVspObject getAclEntry(NuageVspEntity aclEntityType, VspAclRule vspAclRule, String aclNetworkLocationId, long networkId, boolean isUpdate, int oldPriority) throws NuageVspException {
        NuageVspObject aclEntryEntity = this.createNuageVspObject(aclEntityType);
        aclEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ETHER_TYPE, "0x0800");
        String aclEntryAction = vspAclRule.getAction().equals((Object)VspAclRule.ACLAction.Allow) ? "FORWARD" : "DROP";
        aclEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ACTION, aclEntryAction);
        aclEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PROTOCOL, vspAclRule.getProtocol().getProtocolNumber());
        aclEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DSCP, "*");
        aclEntryEntity.set(NuageVspAttribute.EXTERNAL_ID, vspAclRule.getUuid());
        int aclPriority = this.getPriorityForAcl(vspAclRule, networkId, isUpdate, oldPriority);
        if (aclPriority < 0 || aclPriority >= 10000000) {
            String error = "Rule number " + aclPriority + " can not be greater than " + 10000000 + " as it is used as rule numbers for predefined rules in VSP";
            s_logger.error((Object)error, new Object[0]);
            throw new NuageVspException(error);
        }
        aclEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY, aclPriority);
        aclEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_TYPE, "SUBNET");
        aclEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID, aclNetworkLocationId);
        if (vspAclRule.getProtocol().hasPort()) {
            aclEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_DEST_PORT, vspAclRule.getPortRange());
            aclEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_SOURCE_PORT, "*");
        }
        aclEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_REFLEXIVE, vspAclRule.isReflexive());
        return aclEntryEntity;
    }

    private NuageVspObject getEgressAclEntry(String vsdEnterpriseId, VspAclRule vspAclRule, String sourceIp, String aclNetworkLocationId, long networkId, String sourceCidr, boolean isUpdate, int oldPriority) throws NuageVspException {
        NuageVspObject egressACLEntryEntity = this.getAclEntry(NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, vspAclRule, aclNetworkLocationId, networkId, isUpdate, oldPriority);
        String macroId = this.getOrCreatePublicMacroInEnterprise(vsdEnterpriseId, sourceCidr, vspAclRule.getUuid());
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, "ENTERPRISE_NETWORK");
        egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_ID, macroId);
        if (sourceIp != null) {
            egressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ADDR_OVERRIDE, sourceIp);
        }
        return egressACLEntryEntity;
    }

    private NuageVspObject getIngressAclEntry(String vsdEnterpriseId, VspAclRule vspAclRule, String aclNetworkLocationId, long networkId, String sourceCidr, boolean isUpdate, int oldPriority) throws NuageVspException {
        NuageVspObject ingressACLEntryEntity = this.getAclEntry(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, vspAclRule, aclNetworkLocationId, networkId, isUpdate, oldPriority);
        if (vspAclRule.getType().equals((Object)VspAclRule.ACLType.Firewall)) {
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_ADDR_OVERRIDE, sourceCidr);
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, "ANY");
        } else if (vspAclRule.getType().equals((Object)VspAclRule.ACLType.NetworkACL)) {
            String macroId = this.getOrCreatePublicMacroInEnterprise(vsdEnterpriseId, sourceCidr, vspAclRule.getUuid());
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_TYPE, "ENTERPRISE_NETWORK");
            ingressACLEntryEntity.set(NuageVspAttribute.ACLTEMPLATES_ENTRY_NETWORK_ID, macroId);
        }
        return ingressACLEntryEntity;
    }

    private int getPriorityForAcl(VspAclRule vspAclRule, long networkId, boolean isUpdate, int oldPriority) throws NuageVspException {
        if (vspAclRule.getType().equals((Object)VspAclRule.ACLType.NetworkACL)) {
            if (vspAclRule.getPriority() > 9999) {
                String error = "Rule number can not be greater than 9999 as it is used to generate a unique rule per tier in VSP";
                s_logger.error((Object)error, new Object[0]);
                throw new NuageVspException(error);
            }
            return Integer.valueOf(String.valueOf(networkId) + String.valueOf(vspAclRule.getPriority()));
        }
        if (vspAclRule.getType().equals((Object)VspAclRule.ACLType.Firewall)) {
            if (isUpdate) {
                return oldPriority;
            }
            Random random = new Random();
            return (int)(random.nextDouble() * 99999.0) % 1000000 + 1;
        }
        return vspAclRule.getPriority();
    }

    public String findEntityUsingFilterMap(NuageVspEntity entityType, String entityId, NuageVspEntity childEntityType, Map<NuageVspAttribute, Object> filter) throws NuageVspException {
        ArrayList<String> filters = new ArrayList<String>();
        for (Map.Entry<NuageVspAttribute, Object> entry : filter.entrySet()) {
            filters.add(NuageVspApiClientImpl.createFilter(entry.getKey(), entry.getValue()));
        }
        return this.findEntityUsingFilter(entityType, entityId, childEntityType, StringUtils.join(filters, (String)" AND "));
    }

    public String findEntityUsingFilter(NuageVspEntity entityType, String entityId, NuageVspEntity childEntityType, String filter) throws NuageVspException {
        try {
            String jsonString = childEntityType == null && entityId == null ? this.getResources(entityType, filter) : this.getResources(entityType, entityId, childEntityType, filter);
            return jsonString;
        }
        catch (NuageVspApiException exception) {
            String errorMessage = "Failed to execute REST API call to VSP to get " + (Object)((Object)entityType) + " using VSP filter " + filter + ".  Json response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
            throw new NuageVspException(errorMessage);
        }
    }

    private NuageVspObject findVMInterface(String vmInterfacesFromVSP, String macAddress) throws NuageVspException {
        boolean vmInterfaceExists = false;
        List<NuageVspObject> vmInterfaces = this.parseJson(vmInterfacesFromVSP, NuageVspEntity.VM_INTERFACE);
        for (NuageVspObject vmInterface : vmInterfaces) {
            if (!vmInterface.hasAttribute(NuageVspAttribute.VM_INTERFACE_MAC) || !StringUtils.equals((String)((String)vmInterface.get(NuageVspAttribute.VM_INTERFACE_MAC)), (String)macAddress)) continue;
            return vmInterface;
        }
        return null;
    }

    public String getEnterpriseName(String domainName, String domainPath) {
        StringTokenizer tokens = new StringTokenizer(domainPath, "/");
        if (tokens.countTokens() <= 1) {
            return domainName;
        }
        return domainPath.substring(1, domainPath.length()).replace("/", "-");
    }

    public String findEntity(NuageVspEntity entityType) throws NuageVspException {
        return this.getResources(entityType);
    }

    public String findEntityUsingFilter(NuageVspEntity entityType, String entityId, NuageVspEntity childEntityType, NuageVspAttribute filterAttr, String filterAttrValue) throws NuageVspException {
        return this.findEntityUsingFilter(entityType, entityId, childEntityType, filterAttr.getAttributeName() + " == '" + filterAttrValue + "'");
    }

    public String findEntityIdByExternalUuid(NuageVspEntity entityType, String entityId, NuageVspEntity childEntityType, String externalId) throws NuageVspException {
        String jsonString = this.findEntityUsingFilter(entityType, entityId, childEntityType, NuageVspAttribute.EXTERNAL_ID, externalId);
        return this.getEntityId(jsonString, entityType);
    }

    public <T> T findFieldValueByExternalUuid(NuageVspEntity entityType, String entityId, NuageVspEntity childEntityType, String externalId, NuageVspAttribute fieldName) throws NuageVspException {
        String jsonString = this.findEntityUsingFilter(entityType, entityId, childEntityType, NuageVspAttribute.EXTERNAL_ID, externalId);
        return this.getFieldValue(jsonString, childEntityType, fieldName);
    }

    public String findEntityByExternalUuid(NuageVspEntity entityType, String entityId, NuageVspEntity childEntityType, String externalId) throws NuageVspException {
        try {
            return this.findEntityUsingFilter(entityType, entityId, childEntityType, NuageVspAttribute.EXTERNAL_ID, externalId);
        }
        catch (NuageVspApiException exception) {
            String errorMessage = "Failed to execute REST API call to VSP to get " + (Object)((Object)entityType) + " using VSP filter " + externalId + ".  Json response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
            throw new NuageVspException(errorMessage);
        }
    }

    public String getEntityId(String jsonString, NuageVspEntity entityType) throws NuageVspException {
        String id = "";
        if (StringUtils.isNotBlank((String)jsonString)) {
            List<NuageVspObject> entityDetails = this.parseJson(jsonString, entityType);
            id = (String)entityDetails.iterator().next().get(NuageVspAttribute.ID);
        }
        return id;
    }

    public <T> T getFieldValue(String jsonString, NuageVspEntity entityType, NuageVspAttribute field) throws NuageVspException {
        T fieldValue = null;
        if (StringUtils.isNotBlank((String)jsonString)) {
            List<NuageVspObject> entityDetails = this.parseJson(jsonString, entityType);
            fieldValue = entityDetails.iterator().next().get(field);
        }
        return fieldValue;
    }

    public int getChildrenCount(NuageVspEntity entityType, String entityId, NuageVspEntity childEntityType) throws NuageVspException {
        String jsonString = this.findEntityUsingFilter(entityType, entityId, childEntityType, null);
        if (StringUtils.isNotBlank((String)jsonString)) {
            List<NuageVspObject> entityDetails = this.parseJson(jsonString, childEntityType);
            return entityDetails.size();
        }
        return 0;
    }

    @Override
    public boolean cleanUpVspStaleObjects(NuageVspEntity entityToBeCleaned, String entityIDToBeCleaned) {
        try {
            this.deleteResource(entityToBeCleaned, entityIDToBeCleaned, false);
            s_logger.debug("Successfully cleaned stale VSP entity " + (Object)((Object)entityToBeCleaned) + " with ID " + entityIDToBeCleaned, new Object[0]);
            return true;
        }
        catch (NuageVspApiException e) {
            s_logger.warn("Failed to clean " + (Object)((Object)entityToBeCleaned) + " with ID " + entityIDToBeCleaned + " from NuageVsp. Please contact Nuage Vsp csproot to clean stale objects", new Object[0]);
            return false;
        }
    }

    public void cleanUpDomainAndTemplate(String enterpriseId, String networkUuid, String domainTemplateName) throws NuageVspException {
        String networkDomainTemplateId = (String)this.findFieldValueByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN, networkUuid, NuageVspAttribute.DOMAIN_TEMPLATE_ID);
        String domainTemplateEntity = this.findEntityUsingFilter(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN_TEMPLATE, NuageVspAttribute.NAME, domainTemplateName);
        String domainTemplateId = this.getEntityId(domainTemplateEntity, NuageVspEntity.DOMAIN_TEMPLATE);
        if (networkDomainTemplateId == null) {
            return;
        }
        if (networkDomainTemplateId.equals(domainTemplateId)) {
            String vspNetworkId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN, networkUuid);
            if (StringUtils.isNotBlank((String)vspNetworkId)) {
                s_logger.debug("Found a VSP L3 network " + vspNetworkId + " that corresponds to network " + networkUuid + " in CS. So, delete it", new Object[0]);
                this.cleanUpVspStaleObjects(NuageVspEntity.DOMAIN, vspNetworkId);
            }
        } else {
            String vspNetworkId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN_TEMPLATE, networkUuid);
            if (StringUtils.isNotBlank((String)vspNetworkId)) {
                s_logger.debug("Found a VSP L3 network " + vspNetworkId + " that corresponds to network " + networkUuid + " in CS. So, delete it", new Object[0]);
                this.cleanUpVspStaleObjects(NuageVspEntity.DOMAIN_TEMPLATE, vspNetworkId);
            }
        }
    }

    private void createVportInVsp(VspNetwork vspNetwork, List<NuageVspObject> vmInterfaceList, NetworkDetails attachedNetworkDetails, DhcpOptions dhcpOptions) throws NuageVspException {
        ArrayList<String> vPortIds = new ArrayList<String>();
        for (NuageVspObject vmInterface : vmInterfaceList) {
            String networkIdToBeAttached;
            String vmInterfaceUuid = (String)vmInterface.get(NuageVspAttribute.EXTERNAL_ID);
            NuageVspEntity networkTypeToBeAttached = attachedNetworkDetails.getSubnetType();
            String vPortId = this.findEntityIdByExternalUuid(networkTypeToBeAttached, networkIdToBeAttached = attachedNetworkDetails.getSubnetId(), NuageVspEntity.VPORT, vmInterfaceUuid);
            if (StringUtils.isBlank((String)vPortId)) {
                NuageVspObject vmPortEntity = this.createNuageVspObject(NuageVspEntity.VPORT);
                vmPortEntity.set(NuageVspAttribute.VPORT_NAME, vmInterfaceUuid);
                vmPortEntity.set(NuageVspAttribute.VPORT_DESCRIPTION, vmInterface.get(NuageVspAttribute.VM_INTERFACE_MAC));
                vmPortEntity.set(NuageVspAttribute.VPORT_ACTIVE, true);
                vmPortEntity.set(NuageVspAttribute.VPORT_TYPE, "VM");
                vmPortEntity.set(NuageVspAttribute.VPORT_ADDRESSSPOOFING, "INHERITED");
                vmPortEntity.set(NuageVspAttribute.EXTERNAL_ID, vmInterfaceUuid);
                try {
                    String vPortJsonString = this.createResource(networkTypeToBeAttached, networkIdToBeAttached, vmPortEntity);
                    s_logger.debug("Created VPort for network " + (Object)((Object)networkTypeToBeAttached) + " with ID " + networkIdToBeAttached + " in Nuage. Response from VSP is " + vPortJsonString, new Object[0]);
                    vPortId = this.getEntityId(vPortJsonString, NuageVspEntity.VPORT);
                    vPortIds.add(vPortId);
                }
                catch (NuageVspApiException e) {
                    String errorMessage = "Failed to create VPort in VSP using REST API. Json response from VSP REST API is  " + e.getMessage();
                    s_logger.error((Object)errorMessage, e);
                    for (String string : vPortIds) {
                        this.cleanUpVspStaleObjects(NuageVspEntity.VPORT, string);
                    }
                    throw new NuageVspException(errorMessage);
                }
            }
            if (dhcpOptions != null) {
                for (DhcpOption dhcpOption : dhcpOptions.getOptions()) {
                    NuageVspObject dhcpOptionToCreate = this.createDhcpOption(vmInterfaceUuid, dhcpOption);
                    this.createResource(NuageVspEntity.VPORT, vPortId, dhcpOptionToCreate);
                }
            }
            if (vspNetwork.isShared() && vspNetwork.isPublicAccess()) {
                String netmask = NetUtils.getCidrNetmask(vspNetwork.getCidr());
                String externalIdFromGateway = UuidUtils.generateUuidFromExternalIdAndIp(vspNetwork.getUuid(), vspNetwork.getGateway());
                String sharedResourceJson = this.findSharedResource(true, "FLOATING", externalIdFromGateway, vspNetwork.getGateway(), netmask);
                if (StringUtils.isBlank((String)sharedResourceJson)) {
                    String errorMessage = "Failed to find the Floating IP subnet related to shared network " + vspNetwork.getUuid() + ".";
                    s_logger.error((Object)errorMessage, new Object[0]);
                    for (String vportId : vPortIds) {
                        this.cleanUpVspStaleObjects(NuageVspEntity.VPORT, vportId);
                    }
                    throw new NuageVspException(errorMessage);
                }
                String sharedResourceId = this.getEntityId(sharedResourceJson, NuageVspEntity.SHARED_NETWORK);
                String string = (String)vmInterface.get(NuageVspAttribute.VM_INTERFACE_IPADDRESS);
                this.allocateFIPToVPortInVsp(attachedNetworkDetails, vPortId, sharedResourceId, string, vmInterfaceUuid, null, null);
            }
            vmInterface.set(NuageVspAttribute.VM_INTERFACE_VPORT_ID, vPortId);
        }
    }

    public List<NuageVspObject> parseJson(String jsonString, NuageVspEntity nuageEntityType) throws NuageVspException {
        return this.parseJsonString(nuageEntityType, jsonString);
    }

    private String getPortRange(String protocolType) {
        return this.getPortRange(null, null, protocolType);
    }

    private String getPortRange(Integer startPort, Integer endPort, String protocolType) {
        String portRange = "*";
        if (endPort == null) {
            if (startPort != null) {
                portRange = String.valueOf(startPort);
            }
        } else {
            portRange = startPort + "-" + endPort;
        }
        if (this.isTCPOrUDP(protocolType)) {
            return portRange;
        }
        return null;
    }

    private String getProtocolNumber(String protocolType) {
        if (StringUtils.equalsIgnoreCase((String)protocolType, (String)"TCP") || StringUtils.equals((String)protocolType, (String)"6")) {
            return String.valueOf(6);
        }
        if (StringUtils.equalsIgnoreCase((String)protocolType, (String)"UDP") || StringUtils.equals((String)protocolType, (String)"17")) {
            return String.valueOf(17);
        }
        if (StringUtils.equalsIgnoreCase((String)protocolType, (String)"ICMP") || StringUtils.equals((String)protocolType, (String)"1")) {
            return String.valueOf(1);
        }
        if (StringUtils.equalsIgnoreCase((String)protocolType, (String)"ALL")) {
            return "ANY";
        }
        return protocolType;
    }

    private boolean isTCPOrUDP(String protocolType) {
        return StringUtils.equalsIgnoreCase((String)protocolType, (String)"TCP") || StringUtils.equals((String)protocolType, (String)"6") || StringUtils.equalsIgnoreCase((String)protocolType, (String)"UDP") || StringUtils.equals((String)protocolType, (String)"17");
    }

    public Map<String, NuageVspObject> filterDefaultACLEntries(List<NuageVspObject> aclEntries) {
        HashMap<String, NuageVspObject> externalUuidToAcl = new HashMap<String, NuageVspObject>();
        for (NuageVspObject entry : aclEntries) {
            int aclPriority = (Integer)entry.get(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY);
            String externalUuid = (String)entry.get(NuageVspAttribute.EXTERNAL_ID);
            if (this.isDefaultPriorityACL(aclPriority)) continue;
            externalUuidToAcl.put(externalUuid, entry);
        }
        return externalUuidToAcl;
    }

    public Map<Integer, NuageVspObject> getDefaultAclEntries(boolean isIngress, String aclTempId) throws NuageVspException {
        List<NuageVspObject> defaultVspAclEntries = this.getACLEntriesAssociatedToLocation(null, isIngress ? NuageVspEntity.INGRESS_ACLTEMPLATES : NuageVspEntity.EGRESS_ACLTEMPLATES, aclTempId);
        Hashtable<Integer, NuageVspObject> aclPriorityToEntry = new Hashtable<Integer, NuageVspObject>();
        for (NuageVspObject aclEntry : defaultVspAclEntries) {
            aclPriorityToEntry.put((Integer)aclEntry.get(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY), aclEntry);
        }
        return aclPriorityToEntry;
    }

    public boolean isDefaultPriorityACL(int priority) {
        return priority == 11000001 || priority == 11000002 || priority == 11000003;
    }

    public void createOrDeleteDefaultIngressSubnetBlockAcl(String networkName, Long networkId, String aclNetworkLocationId, String ingressACLTempId, boolean isAcsEgressAcls) throws NuageVspException {
        block7: {
            try {
                int priority = (int)(10800000L + networkId);
                String defaultIngressAcl = this.findEntityUsingFilter(NuageVspEntity.INGRESS_ACLTEMPLATES, ingressACLTempId, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY, String.valueOf(priority));
                if (isAcsEgressAcls) {
                    if (!StringUtils.isBlank((String)defaultIngressAcl)) break block7;
                    try {
                        this.createDefaultACLEntry(ingressACLTempId, true, false, "ANY", "DROP", priority, "Default Subnet ACL to block traffic as there is an ACL list associated with it", "SUBNET", aclNetworkLocationId, "ANY", networkName);
                        s_logger.debug("Default ACL to block subnets traffic is added with priority " + priority, new Object[0]);
                    }
                    catch (NuageVspApiException e) {
                        if (e.getHttpErrorCode() == 409 && e.getNuageErrorCode() == 2591) {
                            s_logger.debug("Looks like the ACL Entry with priority " + priority + " already exists. So, it is not re-created", new Object[0]);
                        }
                        break block7;
                    }
                }
                if (!StringUtils.isBlank((String)defaultIngressAcl)) {
                    List<NuageVspObject> ingressAclEntry = this.parseJson(defaultIngressAcl, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES);
                    s_logger.debug("There are no Egress ACLs added to the network " + networkName + ". So, delete default subnet block ACL", new Object[0]);
                    this.cleanUpVspStaleObjects(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, (String)ingressAclEntry.iterator().next().get(NuageVspAttribute.ID));
                }
            }
            catch (NuageVspException e) {
                throw new NuageVspException("Failed to create default Subnet ACL to block traffic for network " + networkName + ". Json response from VSP REST API is " + e.getMessage());
            }
        }
    }

    public List<String> cleanStaleAclsFromVsp(StaleAclRulesDetails staleAclRulesDetails) {
        ArrayList<String> cleanedUpVspAclEntryIds = new ArrayList<String>();
        if (staleAclRulesDetails.isIngressFirewallRule() != null) {
            if (staleAclRulesDetails.isIngressFirewallRule().booleanValue()) {
                for (Map.Entry<String, NuageVspObject> egressAclEntry : staleAclRulesDetails.getEgressAclEntries().entrySet()) {
                    if (this.doesACLExistsInList(staleAclRulesDetails.getVspAclRules(), egressAclEntry.getKey(), true)) continue;
                    String id = (String)egressAclEntry.getValue().get(NuageVspAttribute.ID);
                    this.cleanUpVspStaleObjects(NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, id);
                    cleanedUpVspAclEntryIds.add(id);
                }
            } else {
                for (Map.Entry<String, NuageVspObject> ingressAclEntry : staleAclRulesDetails.getIngressAclEntries().entrySet()) {
                    if (this.doesACLExistsInList(staleAclRulesDetails.getVspAclRules(), ingressAclEntry.getKey(), false)) continue;
                    String id = (String)ingressAclEntry.getValue().get(NuageVspAttribute.ID);
                    this.cleanUpVspStaleObjects(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, id);
                    cleanedUpVspAclEntryIds.add(id);
                }
            }
        } else {
            String id;
            for (Map.Entry<String, NuageVspObject> egressAclEntry : staleAclRulesDetails.getEgressAclEntries().entrySet()) {
                if (this.doesACLExistsInList(staleAclRulesDetails.getVspAclRules(), egressAclEntry.getKey(), true)) continue;
                id = (String)egressAclEntry.getValue().get(NuageVspAttribute.ID);
                this.cleanUpVspStaleObjects(NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, id);
                cleanedUpVspAclEntryIds.add(id);
            }
            for (Map.Entry<String, NuageVspObject> ingressAclEntry : staleAclRulesDetails.getIngressAclEntries().entrySet()) {
                if (this.doesACLExistsInList(staleAclRulesDetails.getVspAclRules(), ingressAclEntry.getKey(), false)) continue;
                id = (String)ingressAclEntry.getValue().get(NuageVspAttribute.ID);
                this.cleanUpVspStaleObjects(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, id);
                cleanedUpVspAclEntryIds.add(id);
            }
        }
        return cleanedUpVspAclEntryIds;
    }

    private boolean doesACLExistsInList(List<VspAclRule> vspAclRules, String aclEntryExternalUuid, boolean ingress) {
        for (VspAclRule vspAclRule : vspAclRules) {
            if (!(ingress && vspAclRule.getTrafficType() == VspAclRule.ACLTrafficType.Ingress ? NuageVspApiClientImpl.isSameACL(aclEntryExternalUuid, vspAclRule) : !ingress && vspAclRule.getTrafficType() == VspAclRule.ACLTrafficType.Egress && NuageVspApiClientImpl.isSameACL(aclEntryExternalUuid, vspAclRule))) continue;
            return true;
        }
        return false;
    }

    private static boolean isSameACL(String aclEntryExternalUuid, VspAclRule vspAclRule) {
        return vspAclRule.getUuid().equals(aclEntryExternalUuid);
    }

    public String generateCmsIdForNuageVsp(String cmsName) throws NuageVspException {
        try {
            NuageVspObject cmsEntity = this.createNuageVspObject(NuageVspEntity.CLOUD_MGMT_SYSTEMS);
            cmsEntity.set(NuageVspAttribute.CLOUD_MGMT_SYSTEM_NAME, cmsName);
            String cmsJson = this.createResource(cmsEntity);
            s_logger.debug("Retrieved CMS ID for VSP . Response from VSP is " + cmsJson, new Object[0]);
            return this.getEntityId(cmsJson, NuageVspEntity.CLOUD_MGMT_SYSTEMS);
        }
        catch (NuageVspApiException exception) {
            String errorMessage = "Failed to retrieve CMS ID VSP. Response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
            throw new NuageVspException(errorMessage);
        }
    }

    public boolean removeCmsIdForNuageVsp(String cmsId) throws NuageVspException {
        try {
            if (StringUtils.isBlank((String)cmsId)) {
                throw new NuageVspApiException("CMS Id is null while trying to remove the CMS Id.");
            }
            this.deleteResource(NuageVspEntity.CLOUD_MGMT_SYSTEMS, cmsId, false);
            s_logger.debug("Deleted CMS ID for VSP.", new Object[0]);
            return true;
        }
        catch (NuageVspApiException exception) {
            String errorMessage = "Failed to delete CMS ID VSP. Response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
            throw new NuageVspException(errorMessage);
        }
    }

    public boolean isKnownCmsIdForNuageVsp(String cmsId) throws NuageVspException {
        try {
            this.getResource(NuageVspEntity.CLOUD_MGMT_SYSTEMS, cmsId, false);
            return true;
        }
        catch (NuageVspApiException exception) {
            if (exception.getHttpErrorCode() == 404) {
                return false;
            }
            String errorMessage = "Failed to retrieve CMS ID VSP. Response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
            throw new NuageVspException(errorMessage);
        }
    }
}

