/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.impl;

import net.nuage.vsp.acs.client.api.NuageVspApiClient;
import net.nuage.vsp.acs.client.api.NuageVspClient;
import net.nuage.vsp.acs.client.api.impl.NuageVspApiClientImpl;
import net.nuage.vsp.acs.client.api.model.VspNetwork;
import net.nuage.vsp.acs.client.common.model.NetworkDetails;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;
import net.nuage.vsp.acs.client.common.model.Pair;
import net.nuage.vsp.acs.client.exception.NuageVspException;

public class NuageVspClientImpl
implements NuageVspClient {
    protected NuageVspApiClientImpl nuageVspApiClient;

    public NuageVspClientImpl(NuageVspApiClient nuageVspApiClient) {
        this.nuageVspApiClient = (NuageVspApiClientImpl)nuageVspApiClient;
    }

    @Override
    public NetworkDetails getAttachedNetworkDetails(VspNetwork vspNetwork) throws NuageVspException {
        return this.getAttachedNetworkDetails(true, vspNetwork);
    }

    @Override
    public NetworkDetails getAttachedNetworkDetails(boolean throwExceptionWhenNotFound, VspNetwork vspNetwork) throws NuageVspException {
        NetworkDetails attachedNetworkDetails = new NetworkDetails();
        String enterpriseId = this.nuageVspApiClient.getEnterprise(vspNetwork.getVspDomain().getUuid());
        attachedNetworkDetails.setEnterpriseId(enterpriseId);
        if (vspNetwork.isL3() || vspNetwork.isVpc() || vspNetwork.isShared()) {
            attachedNetworkDetails.setIsVpc(vspNetwork.isVpc());
            attachedNetworkDetails.setDomainType(NuageVspEntity.DOMAIN);
            attachedNetworkDetails.setSubnetType(NuageVspEntity.SUBNET);
            if (vspNetwork.isVpc()) {
                attachedNetworkDetails.setDomainUuid(vspNetwork.getVpcUuid());
            } else {
                attachedNetworkDetails.setDomainUuid(vspNetwork.getUuid());
            }
            Pair<String, String> vsdDomainAndSubnetId = this.nuageVspApiClient.getIsolatedSubNetwork(throwExceptionWhenNotFound, enterpriseId, vspNetwork);
            if (vsdDomainAndSubnetId == null) {
                return null;
            }
            attachedNetworkDetails.setDomainId(vsdDomainAndSubnetId.getLeft());
            attachedNetworkDetails.setSubnetId(vsdDomainAndSubnetId.getRight());
        } else {
            attachedNetworkDetails.setDomainType(NuageVspEntity.L2DOMAIN);
            attachedNetworkDetails.setSubnetType(NuageVspEntity.L2DOMAIN);
            attachedNetworkDetails.setDomainUuid(vspNetwork.getUuid());
            String domainId = this.nuageVspApiClient.getIsolatedDomain(throwExceptionWhenNotFound, enterpriseId, NuageVspEntity.L2DOMAIN, vspNetwork.getUuid());
            if (domainId == null) {
                return null;
            }
            attachedNetworkDetails.setSubnetId(domainId);
            attachedNetworkDetails.setDomainId(domainId);
        }
        return attachedNetworkDetails;
    }
}

