/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.nuage.vsp.acs.client.api.NuageVspApiClient;
import net.nuage.vsp.acs.client.api.NuageVspElementClient;
import net.nuage.vsp.acs.client.api.impl.NuageVspClientImpl;
import net.nuage.vsp.acs.client.api.model.VspAclRule;
import net.nuage.vsp.acs.client.api.model.VspDhcpDomainOption;
import net.nuage.vsp.acs.client.api.model.VspNetwork;
import net.nuage.vsp.acs.client.api.model.VspStaticNat;
import net.nuage.vsp.acs.client.common.model.AclRulesDetails;
import net.nuage.vsp.acs.client.common.model.DhcpOptions;
import net.nuage.vsp.acs.client.common.model.NetworkDetails;
import net.nuage.vsp.acs.client.common.model.NuageVspAttribute;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;
import net.nuage.vsp.acs.client.common.model.NuageVspObject;
import net.nuage.vsp.acs.client.common.model.StaleAclRulesDetails;
import net.nuage.vsp.acs.client.common.utils.Logger;
import net.nuage.vsp.acs.client.exception.NuageVspApiException;
import net.nuage.vsp.acs.client.exception.NuageVspException;
import net.nuage.vsp.acs.client.exception.NuageVspUnsupportedRequestException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;

public class NuageVspElementClientImpl
extends NuageVspClientImpl
implements NuageVspElementClient {
    private final Logger s_logger = new Logger(NuageVspElementClientImpl.class);

    public NuageVspElementClientImpl(NuageVspApiClient nuageVspApiClient) {
        super(nuageVspApiClient);
    }

    @Override
    public boolean implement(VspNetwork vspNetwork, VspDhcpDomainOption vspDhcpOptions, List<VspAclRule> ingressFirewallRules, List<VspAclRule> egressFirewallRules, List<String> floatingIpUuids) throws NuageVspException {
        block10: {
            NetworkDetails attachedNetworkDetails;
            try {
                attachedNetworkDetails = this.getAttachedNetworkDetails(vspNetwork);
            }
            catch (NuageVspApiException exception) {
                this.s_logger.error((Object)("Exception occurred while executing implement API. So, FIP clean up could not be execued successfully. Retry restarting the network " + vspNetwork.getName()), new Object[0]);
                return true;
            }
            this.s_logger.debug("Starting the sync for network " + vspNetwork.getName() + " at " + new Date(), new Object[0]);
            if (!vspNetwork.isVpc() && vspNetwork.isFirewallServiceSupported()) {
                this.s_logger.debug("Started Sync Ingress Firewall Rule for network " + vspNetwork.getName() + " at " + new Date(), new Object[0]);
                this.applyAclRules(VspAclRule.ACLType.Firewall, vspNetwork, ingressFirewallRules, false);
                this.s_logger.debug("Finished Sync Ingress Firewall Rule for network " + vspNetwork.getName() + " at " + new Date(), new Object[0]);
                this.s_logger.debug("Started Sync Egress Firewall Rule for network " + vspNetwork.getName() + " at " + new Date(), new Object[0]);
                this.applyAclRules(VspAclRule.ACLType.Firewall, vspNetwork, egressFirewallRules, false);
                this.s_logger.debug("Finished Sync Egress Firewall Rule for network " + vspNetwork.getName() + " at " + new Date(), new Object[0]);
            }
            this.s_logger.debug("Started Sync of Static NAT for network " + vspNetwork.getName() + " at " + new Date(), new Object[0]);
            try {
                this.updateDhcpOptions(vspNetwork, vspDhcpOptions, attachedNetworkDetails);
                String fipExternalIdFilter = NuageVspAttribute.EXTERNAL_ID.getAttributeName() + " beginswith '" + attachedNetworkDetails.getDomainUuid() + "'";
                String floatingIpsAssoToNetwork = this.nuageVspApiClient.findEntityUsingFilter(attachedNetworkDetails.getDomainType(), attachedNetworkDetails.getDomainId(), NuageVspEntity.FLOATING_IP, fipExternalIdFilter);
                if (vspNetwork.isPublicAccess() || !StringUtils.isNotBlank((String)floatingIpsAssoToNetwork)) break block10;
                List<NuageVspObject> fips = this.nuageVspApiClient.parseJson(floatingIpsAssoToNetwork, NuageVspEntity.FLOATING_IP);
                for (NuageVspObject fip : fips) {
                    String fipId = (String)fip.get(NuageVspAttribute.ID);
                    String externalId = (String)fip.get(NuageVspAttribute.EXTERNAL_ID);
                    String fipIp = (String)fip.get(NuageVspAttribute.FLOATING_IP_ADDRESS);
                    if (floatingIpUuids.contains(externalId.substring(externalId.indexOf(":") + 1))) continue;
                    this.s_logger.debug("Floating IP " + fipIp + " with " + externalId + " does not exists in ACS network " + vspNetwork.getName() + ". So, processing to clean the stale FIP from VSP", new Object[0]);
                    String vportJson = null;
                    try {
                        vportJson = this.nuageVspApiClient.getResources(NuageVspEntity.FLOATING_IP, fipId, NuageVspEntity.VPORT);
                    }
                    catch (NuageVspApiException e) {
                        this.s_logger.debug("Failed to get VPorts from VSP during FIP clean up. " + e.getMessage(), new Object[0]);
                    }
                    if (StringUtils.isNotBlank((String)vportJson)) {
                        List<NuageVspObject> vports = this.nuageVspApiClient.parseJson(vportJson, NuageVspEntity.VPORT);
                        for (NuageVspObject vport : vports) {
                            if (!StringUtils.equals((String)((String)vport.get(NuageVspAttribute.VPORT_FLOATING_IP_ID)), (String)fipId)) continue;
                            String vportId = (String)vport.get(NuageVspAttribute.ID);
                            this.nuageVspApiClient.updateVPortWithFloatingIPId(vportId, null);
                            this.s_logger.debug("Found a VPort " + vport + " that is associated the stale FIP in network " + vspNetwork.getName() + ". Removed the association to clean the FIP " + fipIp, new Object[0]);
                        }
                    }
                    this.s_logger.debug("Clean the stale FIP " + fipIp + " associated to network " + vspNetwork.getName() + " from VSP", new Object[0]);
                    this.nuageVspApiClient.cleanUpVspStaleObjects(NuageVspEntity.FLOATING_IP, fipId);
                }
            }
            catch (NuageVspApiException exception) {
                this.s_logger.error((Object)("Exception occurred while executing implement API. So, FIP clean up could not be execued successfully. Retry restarting the network " + vspNetwork.getName()), new Object[0]);
                return false;
            }
        }
        return true;
    }

    private boolean usesPreconfiguredDomainTemplate(String enterpriseId, String networkUuid, String domainTemplateName) throws NuageVspException {
        String networkDomainTemplateId = (String)this.nuageVspApiClient.findFieldValueByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN, networkUuid, NuageVspAttribute.DOMAIN_TEMPLATE_ID);
        String domainTemplateEntity = this.nuageVspApiClient.findEntityUsingFilter(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN_TEMPLATE, NuageVspAttribute.NAME, domainTemplateName);
        String domainTemplateId = this.nuageVspApiClient.getEntityId(domainTemplateEntity, NuageVspEntity.DOMAIN_TEMPLATE);
        return StringUtils.isNotBlank((String)networkDomainTemplateId) && StringUtils.isNotBlank((String)domainTemplateId) && networkDomainTemplateId.equals(domainTemplateId);
    }

    @Override
    public void applyStaticNats(VspNetwork vspNetwork, List<VspStaticNat> vspStaticNats) throws NuageVspException {
        NetworkDetails attachedNetworkDetails = this.getAttachedNetworkDetails(vspNetwork);
        for (VspStaticNat vspStaticNat : vspStaticNats) {
            String vspNicSecondaryIpUuid;
            String vspNicUuid = vspStaticNat.getVspNic() != null ? vspStaticNat.getVspNic().getUuid() : null;
            String string = vspNicSecondaryIpUuid = vspStaticNat.getVspNic() != null ? vspStaticNat.getVspNic().getSecondaryIpUuid() : null;
            if (vspStaticNat.getVspNic() != null && vspStaticNat.getVspNic().getMacAddress() == null && vspStaticNat.getRevoke() == Boolean.TRUE) {
                this.s_logger.debug("VM is getting deleted with out disabling the Static NAT " + vspStaticNat.getIpAddress() + "(" + vspStaticNat.getIpUuid() + "). So, floating IP is disassociated from VM and is deleted from VSP", new Object[0]);
                this.nuageVspApiClient.releaseFIPFromVsp(attachedNetworkDetails, null, vspStaticNat.getIpUuid(), vspNicSecondaryIpUuid);
                continue;
            }
            String vportId = this.nuageVspApiClient.findEntityIdByExternalUuid(attachedNetworkDetails.getDomainType(), attachedNetworkDetails.getDomainId(), NuageVspEntity.VPORT, vspNicUuid);
            if (vspStaticNat.getRevoke() == Boolean.TRUE) {
                this.s_logger.debug("Static NAT " + vspStaticNat.getIpAddress() + "(" + vspStaticNat.getIpUuid() + ") is deleted from the VM. So, disassociate the Floating IP from VM's VPort " + vportId + " and delete the Floating IP", new Object[0]);
                this.nuageVspApiClient.releaseFIPFromVsp(attachedNetworkDetails, vportId, vspStaticNat.getIpUuid(), vspNicSecondaryIpUuid);
                continue;
            }
            this.s_logger.debug("Static NAT " + vspStaticNat.getIpAddress() + "(" + vspStaticNat.getIpUuid() + ") is associated to the VM. So, create a new Floating IP " + vspStaticNat.getIpAddress() + " and associate it to VM with VPort " + vportId, new Object[0]);
            this.nuageVspApiClient.applyStaticNatInVsp(attachedNetworkDetails, vportId, vspStaticNat);
        }
    }

    @Override
    public void applyAclRules(VspAclRule.ACLType vspAclRuleType, VspNetwork vspNetwork, List<VspAclRule> vspAclRules, boolean networkReset) throws NuageVspException {
        NetworkDetails attachedNetworkDetails;
        int random = RandomUtils.nextInt((int)1000);
        long initialStartTime = System.currentTimeMillis();
        String ingressACLTempId = null;
        String egressACLTempId = null;
        Boolean ingressFirewallRules = null;
        if (vspAclRules == null) {
            vspAclRules = Lists.newArrayList();
        }
        if (CollectionUtils.isNotEmpty((Collection)vspAclRules) && vspAclRuleType == VspAclRule.ACLType.Firewall) {
            ingressFirewallRules = ((VspAclRule)vspAclRules.get(0)).getTrafficType() == VspAclRule.ACLTrafficType.Ingress;
        }
        try {
            attachedNetworkDetails = this.getAttachedNetworkDetails(vspNetwork);
        }
        catch (NuageVspException e) {
            this.s_logger.debug("Enterprise or Domain does not exists in VSP. So, ACLs update is ignored for network " + vspNetwork.getName() + ". " + e.getMessage(), new Object[0]);
            return;
        }
        boolean usesPreConfiguredDomainTemplate = this.usesPreconfiguredDomainTemplate(attachedNetworkDetails.getEnterpriseId(), attachedNetworkDetails.getDomainUuid(), vspNetwork.getDomainTemplateName());
        if (usesPreConfiguredDomainTemplate) {
            if (CollectionUtils.isNotEmpty((Collection)vspAclRules)) {
                for (VspAclRule rule : vspAclRules) {
                    if (rule.getState() == VspAclRule.ACLState.Revoke) continue;
                    this.s_logger.info("CloudStack ACLs are not supported with Nuage Preconfigured Domain Template", new Object[0]);
                    throw new NuageVspUnsupportedRequestException("CloudStack ACLs are not supported with Nuage Preconfigured Domain Template");
                }
            }
            return;
        }
        if (StringUtils.isNotBlank((String)attachedNetworkDetails.getDomainId())) {
            String aclNetworkLocationId;
            List<NuageVspObject> associatedIngressAclTemplates = this.nuageVspApiClient.getACLAssociatedToDomain(true, attachedNetworkDetails.getDomainType(), attachedNetworkDetails.getDomainId(), vspNetwork.getUuid());
            List<NuageVspObject> associatedEgressAclTemplates = this.nuageVspApiClient.getACLAssociatedToDomain(false, attachedNetworkDetails.getDomainType(), attachedNetworkDetails.getDomainId(), vspNetwork.getUuid());
            if (CollectionUtils.isNotEmpty(associatedIngressAclTemplates)) {
                NuageVspObject ingressAclTemplate = associatedIngressAclTemplates.iterator().next();
                ingressACLTempId = (String)ingressAclTemplate.get(NuageVspAttribute.ID);
            }
            if (CollectionUtils.isNotEmpty(associatedEgressAclTemplates)) {
                NuageVspObject egressAclTemplate = associatedEgressAclTemplates.iterator().next();
                egressACLTempId = (String)egressAclTemplate.get(NuageVspAttribute.ID);
            }
            if (!StringUtils.isBlank((String)(aclNetworkLocationId = attachedNetworkDetails.getSubnetId()))) {
                AclRulesDetails aclRulesDetails = new AclRulesDetails(vspAclRules, vspAclRuleType == VspAclRule.ACLType.NetworkACL, ingressFirewallRules, true, aclNetworkLocationId, ingressACLTempId, egressACLTempId);
                if (networkReset) {
                    this.s_logger.debug("Network is restarted to just cleanup the stale ACL rules and checking for default rules for " + vspNetwork.getName(), new Object[0]);
                    this.resetAllAclRulesInTheNetwork(attachedNetworkDetails.getDomainType(), attachedNetworkDetails.getDomainId(), vspNetwork, aclRulesDetails);
                    return;
                }
                if (StringUtils.isNotBlank((String)ingressACLTempId) && StringUtils.isNotBlank((String)egressACLTempId)) {
                    this.updateACLEntriesInVsp(attachedNetworkDetails.getDomainType(), attachedNetworkDetails.getDomainUuid(), attachedNetworkDetails.getEnterpriseId(), vspNetwork, aclRulesDetails);
                }
                this.s_logger.debug("Network " + vspNetwork.getName() + "(" + random + ")   total time taken to process this thread with " + vspAclRules.size() + " rules is " + (System.currentTimeMillis() - initialStartTime), new Object[0]);
            } else {
                this.s_logger.debug("VSP subnet corresponding to network " + vspNetwork.getName() + " is not found. So, skipping ACL application", new Object[0]);
            }
        }
    }

    private void resetAllAclRulesInTheNetwork(NuageVspEntity attachedNetworkType, String attachedNetworkId, VspNetwork vspNetwork, AclRulesDetails aclRulesDetails) throws NuageVspException {
        List<NuageVspObject> ingressACLEntriesAssocToSubnet = this.nuageVspApiClient.getACLEntriesAssociatedToLocation(aclRulesDetails.getAclNetworkLocationId(), NuageVspEntity.INGRESS_ACLTEMPLATES, aclRulesDetails.getIngressAclTemplateId());
        List<NuageVspObject> egressACLEntriesAssocToSubnet = this.nuageVspApiClient.getACLEntriesAssociatedToLocation(aclRulesDetails.getAclNetworkLocationId(), NuageVspEntity.EGRESS_ACLTEMPLATES, aclRulesDetails.getEgressAclTemplateId());
        Map<String, NuageVspObject> ingressAclEntries = this.nuageVspApiClient.filterDefaultACLEntries(ingressACLEntriesAssocToSubnet);
        Map<String, NuageVspObject> egressAclEntries = this.nuageVspApiClient.filterDefaultACLEntries(egressACLEntriesAssocToSubnet);
        Map<Integer, NuageVspObject> defaultIngressAclEntries = this.nuageVspApiClient.getDefaultAclEntries(true, aclRulesDetails.getIngressAclTemplateId());
        Map<Integer, NuageVspObject> defaultEgressAclEntries = this.nuageVspApiClient.getDefaultAclEntries(false, aclRulesDetails.getEgressAclTemplateId());
        StaleAclRulesDetails staleAclRulesDetails = new StaleAclRulesDetails(aclRulesDetails, ingressAclEntries, egressAclEntries, defaultIngressAclEntries, defaultEgressAclEntries);
        this.deleteStaleACLEntries(attachedNetworkType, attachedNetworkId, vspNetwork, staleAclRulesDetails);
    }

    protected List<String> deleteStaleACLEntries(NuageVspEntity attachedNetworkType, String attachedNetworkId, VspNetwork vspNetwork, StaleAclRulesDetails staleAclRulesDetails) throws NuageVspException {
        List<String> deletedEntries = null;
        if (!(vspNetwork.isEgressDefaultPolicy() || staleAclRulesDetails.getDefaultIngressAclEntries().size() <= 0 && staleAclRulesDetails.getDefaultEgressAclEntries().size() <= 0)) {
            deletedEntries = this.deleteDefaultAclEntries(vspNetwork.getName(), staleAclRulesDetails.getDefaultIngressAclEntries(), staleAclRulesDetails.getDefaultEgressAclEntries());
        }
        if (staleAclRulesDetails.isCreateDefaultRules()) {
            this.nuageVspApiClient.createDefaultAcls(attachedNetworkType, attachedNetworkId, staleAclRulesDetails.getIngressAclTemplateId(), staleAclRulesDetails.getDefaultIngressAclEntries(), staleAclRulesDetails.getEgressAclTemplateId(), staleAclRulesDetails.getDefaultEgressAclEntries(), vspNetwork);
        }
        this.nuageVspApiClient.cleanStaleAclsFromVsp(staleAclRulesDetails);
        return deletedEntries;
    }

    protected List<String> deleteDefaultAclEntries(String networkName, Map<Integer, NuageVspObject> defaultIngressAclEntries, Map<Integer, NuageVspObject> defaultEgressAclEntries) {
        String id;
        int priority;
        ArrayList<String> cleanedUpVspAclEntryIds = new ArrayList<String>();
        for (Map.Entry<Integer, NuageVspObject> defaultIngressAclEntry : defaultIngressAclEntries.entrySet()) {
            priority = defaultIngressAclEntry.getKey();
            if (priority != 0) {
                if (!this.nuageVspApiClient.isDefaultPriorityACL(priority)) continue;
                id = (String)defaultIngressAclEntry.getValue().get(NuageVspAttribute.ID);
                this.s_logger.debug("Default Ingress ACL entries for network " + networkName + " are found and egress policy is deny. Network offering default behavior has been changed. So, delete the default ACLs with VSD ID " + id, new Object[0]);
                this.nuageVspApiClient.cleanUpVspStaleObjects(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, id);
                cleanedUpVspAclEntryIds.add(id);
                continue;
            }
            this.s_logger.debug("This is a Default Ingress Subnet Allow ACL entries for network " + networkName + " So, this default ACL is not cleaned", new Object[0]);
        }
        for (Map.Entry<Integer, NuageVspObject> defaultEgressAclEntry : defaultEgressAclEntries.entrySet()) {
            priority = defaultEgressAclEntry.getKey();
            if (priority != 0) {
                if (!this.nuageVspApiClient.isDefaultPriorityACL(priority)) continue;
                id = (String)defaultEgressAclEntry.getValue().get(NuageVspAttribute.ID);
                this.s_logger.debug("Default Egress ACL entries for network " + networkName + " are found and egress policy is deny. Network offering default behavior has been changed. So, delete the default ACLs with VSD ID " + id, new Object[0]);
                this.nuageVspApiClient.cleanUpVspStaleObjects(NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, id);
                cleanedUpVspAclEntryIds.add(id);
                continue;
            }
            this.s_logger.debug("This is a Default Egress Subnet Allow ACL entries for network " + networkName + " So, this default ACL is not cleaned", new Object[0]);
        }
        return cleanedUpVspAclEntryIds;
    }

    private void updateACLEntriesInVsp(NuageVspEntity attachedNetworkType, String attachedNetworkId, String enterpriseId, VspNetwork vspNetwork, AclRulesDetails aclRulesDetails) throws NuageVspException {
        ArrayList<String> successfullyAddedIngressACls = new ArrayList<String>();
        ArrayList<String> successfullyAddedEgressACls = new ArrayList<String>();
        boolean isAcsEgressAcls = false;
        int noOfActiveAclsFrmOriginalList = 0;
        for (VspAclRule vspAclRule : aclRulesDetails.getVspAclRules()) {
            if (vspAclRule.getState().equals((Object)VspAclRule.ACLState.Add)) {
                isAcsEgressAcls |= this.createOrModifyACLitems(enterpriseId, vspNetwork, aclRulesDetails, vspAclRule, successfullyAddedIngressACls, successfullyAddedEgressACls);
            } else if (vspAclRule.getState().equals((Object)VspAclRule.ACLState.Revoke)) {
                this.revokeACLItems(vspNetwork.getName(), aclRulesDetails.getIngressAclTemplateId(), aclRulesDetails.getEgressAclTemplateId(), vspAclRule, aclRulesDetails.getAclNetworkLocationId());
            } else if (aclRulesDetails.isNetworkAcl() && vspAclRule.getState().equals((Object)VspAclRule.ACLState.Active) && vspAclRule.getTrafficType().equals((Object)VspAclRule.ACLTrafficType.Egress) && vspAclRule.getAction().equals((Object)VspAclRule.ACLAction.Allow)) {
                isAcsEgressAcls = true;
            }
            if (aclRulesDetails.isNetworkAcl() && vspAclRule.getState().equals((Object)VspAclRule.ACLState.Active)) {
                ++noOfActiveAclsFrmOriginalList;
            }
            if (aclRulesDetails.isNetworkAcl() || !vspAclRule.getState().equals((Object)VspAclRule.ACLState.Active)) continue;
            this.s_logger.debug("Firewall ACL Rule's original state in input is Active" + vspAclRule + " in network " + vspNetwork.getName(), new Object[0]);
            ++noOfActiveAclsFrmOriginalList;
        }
        if (noOfActiveAclsFrmOriginalList > 0 && noOfActiveAclsFrmOriginalList == aclRulesDetails.getVspAclRules().size()) {
            this.s_logger.debug("Number(" + noOfActiveAclsFrmOriginalList + ") of ACL rule in network " + vspNetwork.getName() + " in Active state matches the input list. This is a ACLList replace scenario or Network Restart. So, processing the ACL lists.", new Object[0]);
            this.resetAllAclRulesInTheNetwork(attachedNetworkType, attachedNetworkId, vspNetwork, aclRulesDetails);
            for (VspAclRule vspAclRule : aclRulesDetails.getVspAclRules()) {
                isAcsEgressAcls |= this.createOrModifyACLitems(enterpriseId, vspNetwork, aclRulesDetails, vspAclRule, successfullyAddedIngressACls, successfullyAddedEgressACls);
            }
        }
        if (aclRulesDetails.isNetworkAcl() && isAcsEgressAcls) {
            this.nuageVspApiClient.createOrDeleteDefaultIngressSubnetBlockAcl(vspNetwork.getName(), vspNetwork.getId(), aclRulesDetails.getAclNetworkLocationId(), aclRulesDetails.getIngressAclTemplateId(), isAcsEgressAcls);
        }
    }

    private void revokeACLItems(String networkName, String ingressACLTempId, String egressACLTempId, VspAclRule vspAclRule, String aclNetworkLocationId) throws NuageVspException {
        String filter = NuageVspAttribute.EXTERNAL_ID.getAttributeName() + " == '" + vspAclRule.getUuid() + "' and " + NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID.getAttributeName() + " == '" + aclNetworkLocationId + "'";
        if (vspAclRule.getTrafficType().equals((Object)VspAclRule.ACLTrafficType.Egress)) {
            String ingressEntry = this.nuageVspApiClient.findEntityUsingFilter(NuageVspEntity.INGRESS_ACLTEMPLATES, ingressACLTempId, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, filter);
            if (StringUtils.isNotBlank((String)ingressEntry)) {
                String ingressEntryId = this.nuageVspApiClient.getEntityId(ingressEntry, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES);
                this.s_logger.debug("ACS ACL rule " + vspAclRule + " associated to network " + networkName + " is in Revoke state. This ACL " + ingressEntryId + " exists in VSP. So, delete it", new Object[0]);
                this.nuageVspApiClient.cleanUpVspStaleObjects(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, ingressEntryId);
            } else {
                this.s_logger.debug("ACS ACL rule " + vspAclRule + " associated to network " + networkName + " is in Revoke state. But, this ACL does not exist in VSP. So, it is ignored", new Object[0]);
            }
        } else if (vspAclRule.getTrafficType().equals((Object)VspAclRule.ACLTrafficType.Ingress)) {
            String egressEntry = this.nuageVspApiClient.findEntityUsingFilter(NuageVspEntity.EGRESS_ACLTEMPLATES, egressACLTempId, NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, filter);
            if (StringUtils.isNotBlank((String)egressEntry)) {
                String egressEntryId = this.nuageVspApiClient.getEntityId(egressEntry, NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES);
                this.nuageVspApiClient.cleanUpVspStaleObjects(NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, egressEntryId);
                this.s_logger.debug("ACS ACL rule " + vspAclRule + " associated to network " + networkName + " is in Revoke state. This ACL " + egressEntryId + " exists in VSP and it is deleted", new Object[0]);
            } else {
                this.s_logger.debug("ACS ACL rule " + vspAclRule + " associated to network " + networkName + " is in Revoke state. But, this ACL does not exist in VSP. So, it is ignored", new Object[0]);
            }
        }
    }

    private boolean createOrModifyACLitems(String enterpriseId, VspNetwork vspNetwork, AclRulesDetails aclRulesDetails, VspAclRule vspAclRule, List<String> successfullyAddedIngressACls, List<String> successfullyAddedEgressACls) throws NuageVspException {
        boolean isAcsEgressAcls = false;
        String filter = NuageVspAttribute.EXTERNAL_ID.getAttributeName() + " == '" + vspAclRule.getUuid() + "' and " + NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID.getAttributeName() + " == '" + aclRulesDetails.getAclNetworkLocationId() + "'";
        if (vspAclRule.getTrafficType().equals((Object)VspAclRule.ACLTrafficType.Ingress)) {
            String egressEntry;
            String ingressEntry;
            if (aclRulesDetails.isNetworkAcl() && vspAclRule.getState().equals((Object)VspAclRule.ACLState.Add) && StringUtils.isNotBlank((String)(ingressEntry = this.nuageVspApiClient.findEntityUsingFilter(NuageVspEntity.INGRESS_ACLTEMPLATES, aclRulesDetails.getIngressAclTemplateId(), NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, filter)))) {
                String ingressEntryId = this.nuageVspApiClient.getEntityId(ingressEntry, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES);
                this.s_logger.debug("ACS Ingress " + vspAclRule + " is getting added to network " + vspNetwork.getName() + " but an VSP Ingress rule is with same UUID " + vspAclRule.getUuid() + " already exists in VSP. This means the existing CS Egress rule type has been modified to CS Ingress. So, delete this rule from VSP and create a new Egress rule", new Object[0]);
                this.nuageVspApiClient.cleanUpVspStaleObjects(NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, ingressEntryId);
            }
            if (StringUtils.isBlank((String)(egressEntry = this.nuageVspApiClient.findEntityUsingFilter(NuageVspEntity.EGRESS_ACLTEMPLATES, aclRulesDetails.getEgressAclTemplateId(), NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, filter)))) {
                this.nuageVspApiClient.createEgressACLEntryInVsp(enterpriseId, aclRulesDetails.getEgressAclTemplateId(), vspAclRule, vspAclRule.getSourceIpAddress(), aclRulesDetails.getAclNetworkLocationId(), vspNetwork.getId(), successfullyAddedEgressACls);
                this.s_logger.debug("ACS Ingress rule " + vspAclRule + " is getting added to network " + vspNetwork.getName() + " and it does not exists in VSP. The source IP is " + vspAclRule.getSourceIpAddress() + (vspAclRule.getSourceIpAddress() != null ? ". Enterprise macro with same source IP network will be either created if its not present in VSP. Then a rule will be created using the macro" : ". So, ACL rule is created on the L3 Subnet/L2 Domain with network locationId " + aclRulesDetails.getAclNetworkLocationId() + " on which the ACL rule is added."), new Object[0]);
            } else if (aclRulesDetails.isNetworkAcl()) {
                NuageVspObject egressEntryData = this.nuageVspApiClient.parseJson(egressEntry, NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES).iterator().next();
                String egressEntryId = (String)egressEntryData.get(NuageVspAttribute.ID);
                int oldPriority = (Integer)egressEntryData.get(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY);
                this.nuageVspApiClient.updateEgressACLEntryInVsp(enterpriseId, egressEntryId, egressEntryData, vspAclRule, vspAclRule.getSourceIpAddress(), aclRulesDetails.getAclNetworkLocationId(), vspNetwork.getId(), oldPriority);
            }
        } else if (vspAclRule.getTrafficType().equals((Object)VspAclRule.ACLTrafficType.Egress)) {
            String ingressEntry;
            String egressEntry;
            if (aclRulesDetails.isNetworkAcl() && vspAclRule.getState().equals((Object)VspAclRule.ACLState.Add) && StringUtils.isNotBlank((String)(egressEntry = this.nuageVspApiClient.findEntityUsingFilter(NuageVspEntity.EGRESS_ACLTEMPLATES, aclRulesDetails.getEgressAclTemplateId(), NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, filter)))) {
                String egressEntryId = this.nuageVspApiClient.getEntityId(egressEntry, NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES);
                this.nuageVspApiClient.cleanUpVspStaleObjects(NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES, egressEntryId);
                this.s_logger.debug("ACS Egress rule " + vspAclRule + " associated to network " + vspNetwork.getName() + " is getting added but an VSP Egress rule is with same UUID " + vspAclRule.getUuid() + " already exists in VSP. This means the existing CS Ingress rule type has been modified to CS Egress. So, this rule needs is deleted from VSP and a new Ingress rule is created", new Object[0]);
            }
            if (StringUtils.isBlank((String)(ingressEntry = this.nuageVspApiClient.findEntityUsingFilter(NuageVspEntity.INGRESS_ACLTEMPLATES, aclRulesDetails.getIngressAclTemplateId(), NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES, filter)))) {
                this.nuageVspApiClient.createIngressACLEntryInVsp(enterpriseId, aclRulesDetails.getIngressAclTemplateId(), vspAclRule, aclRulesDetails.getAclNetworkLocationId(), vspNetwork.getId(), successfullyAddedIngressACls);
                this.s_logger.debug("ACS Egress rule " + vspAclRule + " associated to network " + vspNetwork.getName() + " is getting added and does not exists in VSP.So, ACL rule is created on the L3 Subnet/L2 Domain with network locationId " + aclRulesDetails.getAclNetworkLocationId() + " on which the ACL rule is added.", new Object[0]);
            } else if (aclRulesDetails.isNetworkAcl()) {
                NuageVspObject ingressEntryData = this.nuageVspApiClient.parseJson(ingressEntry, NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES).iterator().next();
                String ingressEntryId = (String)ingressEntryData.get(NuageVspAttribute.ID);
                int oldPriority = (Integer)ingressEntryData.get(NuageVspAttribute.ACLTEMPLATES_ENTRY_PRIORITY);
                this.nuageVspApiClient.updateIngressACLEntryInVsp(enterpriseId, ingressEntryId, ingressEntryData, vspAclRule, aclRulesDetails.getAclNetworkLocationId(), vspNetwork.getId(), oldPriority);
            }
            isAcsEgressAcls = aclRulesDetails.isNetworkAcl() && vspAclRule.getAction().equals((Object)VspAclRule.ACLAction.Allow);
        }
        return isAcsEgressAcls;
    }

    @Override
    public boolean shutdownNetwork(VspNetwork vspNetwork, VspDhcpDomainOption vspDhcpOptions) {
        try {
            NetworkDetails attachedNetworkDetails = this.getAttachedNetworkDetails(false, vspNetwork);
            if (attachedNetworkDetails == null) {
                this.s_logger.debug("The network details corresponding to network " + vspNetwork.getUuid() + " could not be found.", new Object[0]);
                return true;
            }
            this.updateDhcpOptions(vspNetwork, vspDhcpOptions, attachedNetworkDetails);
        }
        catch (NuageVspException e) {
            this.s_logger.error((Object)("Exception occurred while executing shutdown network API. name: " + vspNetwork.getName()), new Object[0]);
            return false;
        }
        return true;
    }

    private void updateDhcpOptions(VspNetwork vspNetwork, VspDhcpDomainOption vspDhcpOptions, NetworkDetails attachedNetworkDetails) throws NuageVspException {
        if (vspDhcpOptions != null && !vspNetwork.isL2()) {
            try {
                this.s_logger.debug("Started Sync of DNS Server setting for network " + vspNetwork.getName() + " at " + new Date(), new Object[0]);
                DhcpOptions dhcpOptions = vspDhcpOptions.getVrIsDnsProvider() != false ? new DhcpOptions(vspNetwork.getVirtualRouterIp(), vspDhcpOptions.getDnsServers(), vspDhcpOptions.getNetworkDomain()) : new DhcpOptions(null, vspDhcpOptions.getDnsServers(), null);
                this.nuageVspApiClient.createDhcpOptions(false, attachedNetworkDetails, vspNetwork, dhcpOptions);
            }
            catch (NuageVspException e1) {
                this.s_logger.warn("Failed to update the DNS Server information for network " + vspNetwork.getName(), new Object[0]);
            }
            this.s_logger.debug("Finished Sync of DNS Server setting for network " + vspNetwork.getName() + " at " + new Date(), new Object[0]);
        }
    }

    @Override
    public void shutdownVpc(String domainUuid, String vpcUuid, String domainTemplateName, List<String> domainRouterUuids) throws NuageVspException {
        String enterpriseId = this.nuageVspApiClient.getEnterprise(domainUuid);
        if (StringUtils.isNotBlank((String)enterpriseId)) {
            String vspNetworkId;
            if (CollectionUtils.isNotEmpty(domainRouterUuids)) {
                for (String domainRouterUuid : domainRouterUuids) {
                    NuageVspObject domainRouter = this.nuageVspApiClient.getVMDetails(domainRouterUuid);
                    if (domainRouter == null) continue;
                    String vmId = (String)domainRouter.get(NuageVspAttribute.ID);
                    this.nuageVspApiClient.deleteVM(domainRouterUuid, vmId);
                    this.s_logger.debug("VR " + domainRouterUuid + " in VPC " + vpcUuid + " is deleted as the VPC is deleted", new Object[0]);
                }
            }
            String domainTemplateId = (String)this.nuageVspApiClient.findFieldValueByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN, vpcUuid, NuageVspAttribute.DOMAIN_TEMPLATE_ID);
            String vpcDomainTemplateEntity = this.nuageVspApiClient.findEntityUsingFilter(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN_TEMPLATE, NuageVspAttribute.NAME, domainTemplateName);
            String vpcDomainTemplateId = this.nuageVspApiClient.getEntityId(vpcDomainTemplateEntity, NuageVspEntity.DOMAIN_TEMPLATE);
            if (domainTemplateId == null) {
                return;
            }
            if (domainTemplateId.equals(vpcDomainTemplateId)) {
                vspNetworkId = this.nuageVspApiClient.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN, vpcUuid);
                if (StringUtils.isNotBlank((String)vspNetworkId)) {
                    this.s_logger.debug("Deleting VPC " + vpcUuid + " from VSP", new Object[0]);
                    this.nuageVspApiClient.cleanUpVspStaleObjects(NuageVspEntity.DOMAIN, vspNetworkId);
                }
            } else {
                vspNetworkId = this.nuageVspApiClient.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN_TEMPLATE, vpcUuid);
                if (StringUtils.isNotBlank((String)vspNetworkId)) {
                    this.s_logger.debug("Deleting VPC " + vpcUuid + " from VSP", new Object[0]);
                    this.nuageVspApiClient.cleanUpVspStaleObjects(NuageVspEntity.DOMAIN_TEMPLATE, vspNetworkId);
                } else {
                    vspNetworkId = this.nuageVspApiClient.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN, vpcUuid);
                    if (StringUtils.isNotBlank((String)vspNetworkId)) {
                        this.s_logger.debug("Deleting VPC " + vpcUuid + " from VSP", new Object[0]);
                        this.nuageVspApiClient.cleanUpVspStaleObjects(NuageVspEntity.DOMAIN, vspNetworkId);
                    }
                }
            }
        }
    }
}

