/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.impl;

import java.util.List;
import net.nuage.vsp.acs.client.api.NuageVspApiClient;
import net.nuage.vsp.acs.client.api.NuageVspGuruClient;
import net.nuage.vsp.acs.client.api.impl.NuageVspClientImpl;
import net.nuage.vsp.acs.client.api.model.VspAddressRange;
import net.nuage.vsp.acs.client.api.model.VspDhcpDomainOption;
import net.nuage.vsp.acs.client.api.model.VspDhcpVMOption;
import net.nuage.vsp.acs.client.api.model.VspNetwork;
import net.nuage.vsp.acs.client.api.model.VspNic;
import net.nuage.vsp.acs.client.api.model.VspStaticNat;
import net.nuage.vsp.acs.client.api.model.VspVm;
import net.nuage.vsp.acs.client.common.model.DhcpOptions;
import net.nuage.vsp.acs.client.common.model.NetworkDetails;
import net.nuage.vsp.acs.client.common.model.NuageVspAttribute;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;
import net.nuage.vsp.acs.client.common.model.NuageVspObject;
import net.nuage.vsp.acs.client.common.model.Pair;
import net.nuage.vsp.acs.client.common.utils.Logger;
import net.nuage.vsp.acs.client.common.utils.UuidUtils;
import net.nuage.vsp.acs.client.exception.NuageVspApiException;
import net.nuage.vsp.acs.client.exception.NuageVspException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class NuageVspGuruClientImpl
extends NuageVspClientImpl
implements NuageVspGuruClient {
    private static final Logger s_logger = new Logger(NuageVspGuruClientImpl.class);

    public NuageVspGuruClientImpl(NuageVspApiClient nuageVspApiClient) {
        super(nuageVspApiClient);
    }

    @Override
    public void implement(VspNetwork vspNetwork, VspDhcpDomainOption vspDhcpOptions) throws NuageVspException {
        if (vspNetwork.isL2()) {
            s_logger.debug("Handling implement() call back API. Check with VSP to see if a  Isolated L2 networks exist or not", new Object[0]);
            this.nuageVspApiClient.createIsolatedL2NetworkWithDefaultACLs(vspNetwork);
        } else {
            s_logger.debug("Handling implement() call back API. Check with VSP to see if a " + vspNetwork.getNetworkType().name() + " exist or not", new Object[0]);
            this.nuageVspApiClient.createNetworkConfigurationWithDefaultACLs(vspNetwork, vspDhcpOptions);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void reserve(VspNetwork vspNetwork, VspVm vspVm, VspNic vspNic, VspStaticNat vspStaticNat, VspDhcpVMOption vspDhcpVMOption) throws NuageVspException {
        List<NuageVspObject> vmInterfaces;
        NetworkDetails attachedNetworkDetails = this.getAttachedNetworkDetails(vspNetwork);
        s_logger.debug("VSP Network to create VM or attach an interface is " + (Object)((Object)attachedNetworkDetails.getSubnetType()) + "/" + attachedNetworkDetails.getSubnetId(), new Object[0]);
        NuageVspObject vm = this.nuageVspApiClient.getVMDetails(vspVm.getUuid());
        Pair<String, String> domainIdAndVPortId = null;
        DhcpOptions dhcpOptions = new DhcpOptions();
        if (vspDhcpVMOption != null) {
            dhcpOptions = new DhcpOptions(vspDhcpVMOption.defaultHasDns(), vspDhcpVMOption.getHostname(), vspDhcpVMOption.networkHasDns(), vspDhcpVMOption.isDefaultInterface(), vspDhcpVMOption.isDomainRouter());
        }
        if (vm == null) {
            vmInterfaces = this.nuageVspApiClient.createVMInVSP(vspNetwork, vspVm, vspNic, attachedNetworkDetails, dhcpOptions);
            if (!CollectionUtils.isNotEmpty(vmInterfaces)) throw new NuageVspApiException("Failed to get IP for the VM from VSP address for network " + vspNetwork.getUuid());
            domainIdAndVPortId = this.getDomainIdAndVPort(vspNic.getMacAddress(), vmInterfaces);
        } else {
            vmInterfaces = this.nuageVspApiClient.addVMInterfaceToVM(vspNetwork, vspVm, vspNic, attachedNetworkDetails, vm, dhcpOptions);
            if (CollectionUtils.isNotEmpty(vmInterfaces)) {
                domainIdAndVPortId = this.getDomainIdAndVPort(vspNic.getMacAddress(), vmInterfaces);
            } else {
                s_logger.info("Interface with MAC already exists in Nuage VSP. So, it is not added to the VM", new Object[0]);
            }
        }
        if (vspStaticNat == null || vspVm.getDomainRouter() == Boolean.TRUE || vspStaticNat.getState() != VspStaticNat.State.Allocated || vspStaticNat.getOneToOneNat() != Boolean.TRUE) return;
        s_logger.debug("Found a StaticNat(in ACS DB) " + vspStaticNat.getIpAddress() + " in Allocated state and it is associated to VM " + vspVm.getName() + ". Trying to check if this StaticNAT is in sync with VSP.", new Object[0]);
        if (vm != null && CollectionUtils.isEmpty(vmInterfaces)) {
            String vmInterfacesJson = (String)vm.get(NuageVspAttribute.VM_INTERFACES);
            vmInterfaces = this.nuageVspApiClient.parseJson(vmInterfacesJson, NuageVspEntity.VM_INTERFACE);
            domainIdAndVPortId = this.getDomainIdAndVPort(vspNic.getMacAddress(), vmInterfaces);
        }
        try {
            if (domainIdAndVPortId == null) return;
            this.nuageVspApiClient.applyStaticNatInVsp(attachedNetworkDetails, domainIdAndVPortId.getRight(), vspStaticNat);
            return;
        }
        catch (NuageVspException e) {
            s_logger.warn("Post processing of StaticNAT could not continue. Error happened while checking if StaticNat " + vspStaticNat.getIpAddress() + " is in Sync with VSP. " + e.getMessage(), new Object[0]);
        }
    }

    private Pair<String, String> getDomainIdAndVPort(String nicMacAddress, List<NuageVspObject> vmInterfaces) throws NuageVspException {
        for (NuageVspObject vmInterface : vmInterfaces) {
            String macFromNuage = (String)vmInterface.get(NuageVspAttribute.VM_INTERFACE_MAC);
            if (!StringUtils.equals((String)macFromNuage, (String)nicMacAddress)) continue;
            String domainId = (String)vmInterface.get(NuageVspAttribute.VM_INTERFACE_DOMAIN_ID);
            String vportId = (String)vmInterface.get(NuageVspAttribute.VM_INTERFACE_VPORT_ID);
            return Pair.of(domainId, vportId);
        }
        return null;
    }

    @Override
    public void deallocate(VspNetwork vspNetwork, VspVm vspVm, VspNic vspNic) throws NuageVspException {
        NuageVspObject vm = this.nuageVspApiClient.getVMDetails(vspVm.getUuid());
        if (vm != null) {
            String vmInterfaceJsonString = (String)vm.get(NuageVspAttribute.VM_INTERFACES);
            String vmId = (String)vm.get(NuageVspAttribute.ID);
            List<NuageVspObject> vmInterfaceDetails = null;
            if (!StringUtils.isBlank((String)vmInterfaceJsonString)) {
                vmInterfaceDetails = this.nuageVspApiClient.parseJson(vmInterfaceJsonString, NuageVspEntity.VM_INTERFACE);
            }
            if (vmInterfaceDetails != null && vmInterfaceDetails.size() > 0) {
                NuageVspObject deletedVmInterfaceDetail = null;
                String macAddr = null;
                for (NuageVspObject vmInterfaceDetail : vmInterfaceDetails) {
                    macAddr = (String)vmInterfaceDetail.get(NuageVspAttribute.VM_INTERFACE_MAC);
                    if (!macAddr.equals(vspNic.getMacAddress())) continue;
                    deletedVmInterfaceDetail = vmInterfaceDetail;
                    break;
                }
                if (deletedVmInterfaceDetail != null) {
                    String vmInterfaceID = (String)deletedVmInterfaceDetail.get(NuageVspAttribute.ID);
                    String vPortId = (String)deletedVmInterfaceDetail.get(NuageVspAttribute.VM_INTERFACE_VPORT_ID);
                    this.nuageVspApiClient.deleteVmInterface(vspVm.getUuid(), macAddr, vmInterfaceID);
                    s_logger.debug("Handling deallocate(). Deleted VM interface with IP " + vspNic.getIp() + " for VM " + vspVm.getName() + " with MAC " + macAddr + " from VM with UUID " + vspVm.getUuid(), new Object[0]);
                    if (vspNetwork.isShared() && vspNetwork.isPublicAccess()) {
                        NetworkDetails networkDetails = this.getAttachedNetworkDetails(vspNetwork);
                        this.nuageVspApiClient.releaseFIPFromVsp(networkDetails, vPortId, (String)deletedVmInterfaceDetail.get(NuageVspAttribute.EXTERNAL_ID), null);
                    }
                    this.nuageVspApiClient.cleanUpVspStaleObjects(NuageVspEntity.VPORT, vPortId);
                } else {
                    s_logger.debug("Handling deallocate(). VM," + vspVm.getName() + ", interface with IP " + vspNic.getIp() + " and MAC " + vspNic.getMacAddress() + " is not present in VSP", new Object[0]);
                }
            }
            if ((vmInterfaceDetails == null || vmInterfaceDetails.size() == 0 || vmInterfaceDetails.size() == 1) && vspVm.getState() == VspVm.State.Expunging) {
                s_logger.debug("Handling deallocate(). VM," + vspVm.getName() + ", with interface IP " + vspNic.getIp() + " and MAC " + vspNic.getMacAddress() + " is in Expunging state. So, delete this VM from VSP", new Object[0]);
                this.nuageVspApiClient.deleteVM(vspVm.getUuid(), vmId);
            }
        } else {
            this.cleanVMVPorts(vspNetwork, vspVm, vspNic);
        }
    }

    private void cleanVMVPorts(VspNetwork vspNetwork, VspVm vspVm, VspNic vspNic) throws NuageVspException {
        s_logger.debug("Handling deallocate(). VM " + vspVm.getName() + "  with NIC IP " + vspNic.getIp() + " is getting destroyed and it does not exists in NuageVSP.", new Object[0]);
        NetworkDetails attachedNetworkDetails = this.getAttachedNetworkDetails(false, vspNetwork);
        if (attachedNetworkDetails == null) {
            s_logger.debug("The network details corresponding to network " + vspNetwork.getUuid() + " could not be found.", new Object[0]);
            return;
        }
        String vportId = this.nuageVspApiClient.findEntityIdByExternalUuid(attachedNetworkDetails.getSubnetType(), attachedNetworkDetails.getSubnetId(), NuageVspEntity.VPORT, vspNic.getUuid());
        if (StringUtils.isNotBlank((String)vportId)) {
            this.nuageVspApiClient.cleanUpVspStaleObjects(NuageVspEntity.VPORT, vportId);
        }
    }

    @Override
    public void trash(VspNetwork vspNetwork) throws NuageVspException {
        if (vspNetwork.isShared()) {
            String enterprisesJson = this.nuageVspApiClient.getResources(NuageVspEntity.ENTERPRISE, null);
            List<NuageVspObject> enterprises = this.nuageVspApiClient.parseJson(enterprisesJson, NuageVspEntity.ENTERPRISE);
            for (NuageVspObject enterprise : enterprises) {
                String enterpriseId = (String)enterprise.get(NuageVspAttribute.ID);
                this.nuageVspApiClient.cleanUpDomainAndTemplate(enterpriseId, vspNetwork.getUuid(), vspNetwork.getDomainTemplateName());
            }
            for (VspAddressRange addressRange : vspNetwork.getAddressRanges()) {
                String externalIdFromGateway = UuidUtils.generateUuidFromExternalIdAndIp(vspNetwork.getUuid(), addressRange.getGateway());
                this.nuageVspApiClient.deleteSharedResourceInVSP("FLOATING", externalIdFromGateway, addressRange.getGateway(), addressRange.getNetmask());
                this.nuageVspApiClient.deleteSharedResourceInVSP("PUBLIC", externalIdFromGateway, addressRange.getGateway(), addressRange.getNetmask());
            }
            return;
        }
        String enterpriseId = this.nuageVspApiClient.getEnterprise(vspNetwork.getVspDomain().getUuid());
        if (StringUtils.isNotBlank((String)enterpriseId)) {
            if (vspNetwork.isL3() || vspNetwork.isVpc()) {
                if (vspNetwork.isVpc()) {
                    String vspNetworkId;
                    String vspDomainId = this.nuageVspApiClient.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN, vspNetwork.getVpcUuid());
                    if (StringUtils.isNotBlank((String)vspDomainId) && StringUtils.isNotBlank((String)(vspNetworkId = this.nuageVspApiClient.findEntityIdByExternalUuid(NuageVspEntity.DOMAIN, vspDomainId, NuageVspEntity.SUBNET, vspNetwork.getSubnetExternalId())))) {
                        s_logger.debug("Found a VSP L3 network " + vspNetworkId + " that corresponds to tier " + vspNetwork.getUuid() + " in CS. So, delete it", new Object[0]);
                        this.nuageVspApiClient.cleanUpVspStaleObjects(NuageVspEntity.SUBNET, vspNetworkId);
                    }
                } else {
                    this.nuageVspApiClient.cleanUpDomainAndTemplate(enterpriseId, vspNetwork.getUuid(), vspNetwork.getDomainTemplateName());
                }
            } else {
                String vspNetworkId = this.nuageVspApiClient.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.L2DOMAIN_TEMPLATE, vspNetwork.getUuid());
                if (StringUtils.isNotBlank((String)vspNetworkId)) {
                    this.nuageVspApiClient.cleanUpVspStaleObjects(NuageVspEntity.L2DOMAIN_TEMPLATE, vspNetworkId);
                    s_logger.debug("Found a VSP L2 network " + vspNetworkId + " that corresponds to network " + vspNetwork.getUuid() + " in CS and deleted it", new Object[0]);
                }
            }
        }
    }

    @Override
    public void applyDhcpOptions(List<VspDhcpVMOption> vspDhcpOptions, VspNetwork vspNetwork) throws NuageVspException {
        NetworkDetails attachedNetworkDetails = this.getAttachedNetworkDetails(vspNetwork);
        for (VspDhcpVMOption vspDhcpOption : vspDhcpOptions) {
            DhcpOptions dhcpOptions = new DhcpOptions(vspDhcpOption.defaultHasDns(), vspDhcpOption.getHostname(), vspDhcpOption.networkHasDns(), vspDhcpOption.isDefaultInterface(), vspDhcpOption.isDomainRouter());
            String vportVsdId = this.nuageVspApiClient.findEntityIdByExternalUuid(NuageVspEntity.SUBNET, attachedNetworkDetails.getSubnetId(), NuageVspEntity.VPORT, vspDhcpOption.getNicUuid());
            this.nuageVspApiClient.createDhcpOptions(false, NuageVspEntity.VPORT, vportVsdId, vspDhcpOption.getNicUuid(), vspNetwork, dhcpOptions);
        }
    }
}

