/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.impl;

import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import net.nuage.vsp.acs.client.api.model.NuageVspPaging;
import net.nuage.vsp.acs.client.api.model.NuageVspUser;
import net.nuage.vsp.acs.client.api.model.Protocol;
import net.nuage.vsp.acs.client.api.model.VspHost;
import net.nuage.vsp.acs.client.common.FilterProcessor;
import net.nuage.vsp.acs.client.common.NuageVspApiVersion;
import net.nuage.vsp.acs.client.common.RequestType;
import net.nuage.vsp.acs.client.common.model.Acl;
import net.nuage.vsp.acs.client.common.model.NuageVspAttribute;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;
import net.nuage.vsp.acs.client.common.model.NuageVspObject;
import net.nuage.vsp.acs.client.common.model.Pair;
import net.nuage.vsp.acs.client.common.model.gson.CodedEnumTypeAdapter;
import net.nuage.vsp.acs.client.common.model.gson.NuageVspObjectTypeAdapter;
import net.nuage.vsp.acs.client.common.model.gson.ProtocolTypeAdapter;
import net.nuage.vsp.acs.client.common.ssl.TLSSocketFactory;
import net.nuage.vsp.acs.client.common.utils.Logger;
import net.nuage.vsp.acs.client.exception.NuageJsonParsingException;
import net.nuage.vsp.acs.client.exception.NuageVspApiException;
import net.nuage.vsp.acs.client.exception.NuageVspAuthenticationException;
import net.nuage.vsp.acs.client.exception.NuageVspConnectivityException;
import net.nuage.vsp.acs.client.exception.NuageVspException;
import net.nuage.vsp.acs.client.exception.UnsupportedNuageEntityException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;

public class NuageVspRestApi {
    private static final Logger s_logger = new Logger(NuageVspRestApi.class);
    private static final long DELAY_FACTOR = 2L;
    private static volatile String apiKey = "";
    protected VspHost vspHost;
    private PoolingClientConnectionManager s_httpClientManager = null;
    private HttpClient client;
    private ObjectMapper mapper = new ObjectMapper();

    public NuageVspRestApi(VspHost vspHost) {
        this.vspHost = vspHost;
    }

    public String createResource(NuageVspObject nuageVspObject) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.CREATE, nuageVspObject.getEntityType(), nuageVspObject.getId(), null, nuageVspObject, true, null, null, null);
    }

    public String createResource(NuageVspObject entity, String proxyUserUuid, String proxyUserDomainUuid) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.CREATE, entity.getEntityType(), null, null, entity, true, null, null, new NuageVspUser(proxyUserDomainUuid, proxyUserUuid));
    }

    public String createResource(NuageVspEntity parentEntityType, String parentEntityId, NuageVspObject childEntity) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.CREATE, parentEntityType, parentEntityId, childEntity.getEntityType(), childEntity, true, null, null, null);
    }

    public String createResource(NuageVspEntity parentEntityType, String parentEntityId, NuageVspObject childEntity, boolean checkWarning) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.CREATE, parentEntityType, parentEntityId, childEntity.getEntityType(), childEntity, checkWarning, null, null, null);
    }

    public String createResource(NuageVspEntity parentEntityType, String parentEntityId, NuageVspObject childEntity, boolean checkWarning, List<Integer> retryNuageErrorCodes) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.CREATE, parentEntityType, parentEntityId, childEntity.getEntityType(), childEntity, checkWarning, retryNuageErrorCodes, null, null);
    }

    public String createResource(NuageVspEntity parentEntityType, String parentEntityId, NuageVspObject childEntity, String proxyUserUuid, String proxyUserDomainUuid) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.CREATE, parentEntityType, parentEntityId, childEntity.getEntityType(), childEntity, true, null, null, new NuageVspUser(proxyUserDomainUuid, proxyUserUuid));
    }

    public String createResource(NuageVspEntity nuageEntityType, Object entityDetails) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.CREATE, nuageEntityType, null, null, entityDetails, true, null, null, null);
    }

    public String createResource(NuageVspEntity nuageEntityType, Object entityDetails, String proxyUserUuid, String proxyUserDomainUuid) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.CREATE, nuageEntityType, null, null, entityDetails, true, null, null, new NuageVspUser(proxyUserDomainUuid, proxyUserUuid));
    }

    public String createResource(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType, Object entityDetails) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.CREATE, nuageEntityType, entityId, nuageChildEntityType, entityDetails, true, null, null, null);
    }

    public String createResource(NuageVspObject parent, NuageVspObject child, boolean checkWarning) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.CREATE, parent.getEntityType(), parent.getId(), child.getEntityType(), child, checkWarning, null, null, null);
    }

    public String createResource(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType, Object entityDetails, boolean checkWarning) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.CREATE, nuageEntityType, entityId, nuageChildEntityType, entityDetails, checkWarning, null, null, null);
    }

    public String createResource(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType, Object entityDetails, boolean checkWarning, List<Integer> retryNuageErrorCodes) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.CREATE, nuageEntityType, entityId, nuageChildEntityType, entityDetails, checkWarning, retryNuageErrorCodes, null, null);
    }

    public String createResource(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType, Object entityDetails, String proxyUserUuid, String proxyUserDomainUuid) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.CREATE, nuageEntityType, entityId, nuageChildEntityType, entityDetails, true, null, null, new NuageVspUser(proxyUserDomainUuid, proxyUserUuid));
    }

    public String updateResource(NuageVspObject nuageVspObject, boolean checkWarning) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.MODIFY, nuageVspObject.getEntityType(), nuageVspObject.getId(), null, nuageVspObject, checkWarning, null, null, null);
    }

    public String updateResource(NuageVspObject nuageVspObject) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.MODIFY, nuageVspObject.getEntityType(), nuageVspObject.getId(), null, nuageVspObject, true, null, null, null);
    }

    public String updateResource(String entityId, NuageVspObject entity, boolean checkWarning) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.MODIFY, entity.getEntityType(), entityId, null, entity, checkWarning, null, null, null);
    }

    public String updateResource(NuageVspEntity parentEntityType, String parentEntityId, NuageVspEntity childEntityType, Object childEntity) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.MODIFYRELATED, parentEntityType, parentEntityId, childEntityType, childEntity, false, null, null, null);
    }

    public String deleteResource(NuageVspEntity entityType, String entityId, boolean checkWarning) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.DELETE, entityType, entityId, null, null, checkWarning, null, null, null);
    }

    public String deleteResource(NuageVspObject nuageVspObject) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.DELETE, nuageVspObject.getEntityType(), nuageVspObject.getId(), null, null, true, null, null, null);
    }

    public String deleteResource(NuageVspObject nuageVspObject, boolean checkWarning) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.DELETE, nuageVspObject.getEntityType(), nuageVspObject.getId(), null, null, checkWarning, null, null, null);
    }

    public String getResource(NuageVspEntity nuageEntityType, String entityId) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.GET, nuageEntityType, entityId, null, null, true, null, null, null);
    }

    public String getResource(NuageVspObject nuageVspObject) throws NuageVspApiException {
        return this.getResource(nuageVspObject.getEntityType(), nuageVspObject.getId());
    }

    public String getResources(NuageVspEntity nuageEntityType, String filter) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.GETALL, nuageEntityType, null, null, null, true, null, NuageVspPaging.paging().filter(filter), null);
    }

    public String getResources(NuageVspEntity nuageEntityType) throws NuageVspApiException {
        return this.getResources(nuageEntityType, null);
    }

    public String getResource(NuageVspEntity nuageEntityType, String entityId, boolean checkWarning) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.GET, nuageEntityType, entityId, null, null, checkWarning, null, null, null);
    }

    public String getResources(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.GETRELATED, nuageEntityType, entityId, nuageChildEntityType, null, true, null, null, null);
    }

    public String getResources(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType, String filter) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.GETRELATED, nuageEntityType, entityId, nuageChildEntityType, null, true, null, NuageVspPaging.paging().filter(filter), null);
    }

    public String getResources(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType, NuageVspAttribute filterAttribute, Object filterValue) throws NuageVspApiException {
        return this.executeRestApiWithRetry(RequestType.GETRELATED, nuageEntityType, entityId, nuageChildEntityType, null, true, null, NuageVspPaging.paging().filter(NuageVspRestApi.createFilter(filterAttribute, filterValue)), null);
    }

    private Set<String> getLinkedEntities(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType) throws NuageVspApiException {
        String currentRelatedEntitiesJson = this.getResources(nuageEntityType, entityId, nuageChildEntityType);
        List<NuageVspObject> currentRelatedEntities = this.parseJsonString(nuageChildEntityType, currentRelatedEntitiesJson);
        TreeSet<String> currentChildEntityIds = new TreeSet<String>();
        for (NuageVspObject currentRelatedEntity : currentRelatedEntities) {
            currentChildEntityIds.add(currentRelatedEntity.getId());
        }
        return currentChildEntityIds;
    }

    protected boolean saveLinkedEntities(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType, Set<String> oldNuageChildEntityIds, Set<String> newNuageChildEntityIds) throws NuageVspApiException {
        boolean isModified;
        boolean bl = isModified = !oldNuageChildEntityIds.equals(newNuageChildEntityIds);
        if (isModified) {
            this.updateResource(nuageEntityType, entityId, nuageChildEntityType, newNuageChildEntityIds);
        }
        return isModified;
    }

    public boolean linkRelatedEntity(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType, String nuageChildEntityId) throws NuageVspException {
        Set<String> currentChildEntityIds = this.getLinkedEntities(nuageEntityType, entityId, nuageChildEntityType);
        TreeSet<String> nuageChildEntityIds = new TreeSet<String>(currentChildEntityIds);
        nuageChildEntityIds.add(nuageChildEntityId);
        return this.saveLinkedEntities(nuageEntityType, entityId, nuageChildEntityType, currentChildEntityIds, nuageChildEntityIds);
    }

    public boolean unlinkRelatedEntity(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType, String nuageChildEntityId) throws NuageVspException {
        Set<String> currentChildEntityIds = this.getLinkedEntities(nuageEntityType, entityId, nuageChildEntityType);
        TreeSet<String> nuageChildEntityIds = new TreeSet<String>(currentChildEntityIds);
        nuageChildEntityIds.remove(nuageChildEntityId);
        return this.saveLinkedEntities(nuageEntityType, entityId, nuageChildEntityType, currentChildEntityIds, nuageChildEntityIds);
    }

    public boolean setRelatedEntities(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType, Set<String> nuageChildEntityIds) throws NuageVspException {
        Set<String> currentChildEntityIds = this.getLinkedEntities(nuageEntityType, entityId, nuageChildEntityType);
        return this.saveLinkedEntities(nuageEntityType, entityId, nuageChildEntityType, currentChildEntityIds, nuageChildEntityIds);
    }

    protected static String createFilter(NuageVspAttribute filterAttr, Object filterAttrValue) {
        String operator = filterAttr == NuageVspAttribute.EXTERNAL_ID ? " BEGINSWITH " : " == ";
        return filterAttr.getAttributeName() + operator + (filterAttrValue instanceof String ? "'" + filterAttrValue + "'" : filterAttrValue);
    }

    public static String createFilter(Map<NuageVspAttribute, Object> filter) {
        LinkedList<String> filters = new LinkedList<String>();
        for (Map.Entry<NuageVspAttribute, Object> entry : filter.entrySet()) {
            filters.add(NuageVspRestApi.createFilter(entry.getKey(), entry.getValue()));
        }
        return StringUtils.join(filters, (String)" AND ");
    }

    public NuageVspObject getOnlyJsonEntity(NuageVspEntity entityType, String jsonString) throws NuageVspApiException {
        return (NuageVspObject)Iterables.getOnlyElement(this.parseJsonString(entityType, jsonString));
    }

    public NuageVspObject getFirstJsonEntity(NuageVspEntity entityType, String jsonString) throws NuageVspApiException {
        return (NuageVspObject)Iterables.getFirst(this.parseJsonString(entityType, jsonString), null);
    }

    public NuageVspObject getEntityByExternalId(NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType, String externalId) throws NuageVspApiException {
        return this.getFirstJsonEntity(nuageChildEntityType, this.getResources(nuageEntityType, entityId, nuageChildEntityType, NuageVspRestApi.createFilter(NuageVspAttribute.EXTERNAL_ID, externalId)));
    }

    public String getEntityId(NuageVspEntity entityType, String jsonString) throws NuageVspApiException {
        String id = "";
        if (StringUtils.isNotBlank((String)jsonString)) {
            id = this.getOnlyJsonEntity(entityType, jsonString).getId();
        }
        return id;
    }

    public boolean cleanUpVspStaleObjects(NuageVspEntity entityToBeCleaned, String entityIDToBeCleaned) {
        try {
            this.deleteResource(entityToBeCleaned, entityIDToBeCleaned, false);
            s_logger.debug("Successfully cleaned stale VSP entity " + (Object)((Object)entityToBeCleaned) + " with ID " + entityIDToBeCleaned, new Object[0]);
            return true;
        }
        catch (NuageVspApiException e) {
            s_logger.warn("Failed to clean " + (Object)((Object)entityToBeCleaned) + " with ID " + entityIDToBeCleaned + " from NuageVsp. Please contact Nuage Vsp csproot to clean stale objects", new Object[0]);
            return false;
        }
    }

    private String executeRestApiWithRetry(RequestType type, NuageVspEntity nuageEntityType, String entityId, NuageVspEntity nuageChildEntityType, Object entityDetails, boolean checkWarning, List<Integer> retryNuageErrorCodes, NuageVspPaging paging, NuageVspUser proxyUser) throws NuageVspApiException {
        int attempt = 1;
        long sleepTime = this.vspHost.getRetryInterval();
        NuageVspApiException exception = null;
        while (true) {
            Pair<String, String> urlAndResponse = Pair.of("", "");
            try {
                urlAndResponse = this.executeNuageApi(nuageEntityType, entityId, nuageChildEntityType, entityDetails, type, checkWarning, paging, proxyUser);
                if (attempt > 1) {
                    s_logger.trace(String.format("After %s attempt, exception %s was handled and method %s was successfully executed ", --attempt, exception.getMessage(), "executeHttpRequestWithRetry"), new Object[0]);
                }
                return urlAndResponse.getRight();
            }
            catch (NuageVspApiException e) {
                exception = e;
                if (attempt < true) continue;
                if (attempt <= this.vspHost.getNoofRetry() && !this.handleException(attempt, sleepTime, e, "executeHttpRequestWithRetry", urlAndResponse.getLeft(), retryNuageErrorCodes)) {
                    throw e;
                }
                ++attempt;
                sleepTime *= 2L;
                if (attempt <= this.vspHost.getNoofRetry() + 1) continue;
                s_logger.error((Object)String.format("Failed to execute %s method even after %s attempts, due to exception %s ", "executeHttpRequestWithRetry", this.vspHost.getNoofRetry(), exception.getMessage()), new Object[0]);
                throw exception;
            }
            break;
        }
    }

    public Pair<String, String> executeNuageApi(NuageVspEntity entityType, String entityId, NuageVspEntity childEntityType, Object entityDetails, RequestType type, boolean checkWarning, NuageVspPaging paging, NuageVspUser proxyUser, String restRelativePath) {
        return null;
    }

    public Pair<String, String> executeNuageApi(NuageVspEntity entityType, String entityId, NuageVspEntity childEntityType, Object entityDetails, RequestType type, boolean checkWarning, NuageVspPaging paging, NuageVspUser proxyUser) throws NuageVspApiException {
        assert (childEntityType != null == type.requiresIdAndChildEntityType());
        StringBuilder restUrl = new StringBuilder();
        if (entityType != NuageVspEntity.VERSION) {
            restUrl.append(this.vspHost.getRestRelativePath()).append("/").append(entityType.getEntityType());
        } else {
            restUrl.append(this.vspHost.getRootPath()).append("/").append(entityType.getEntityType());
        }
        if (childEntityType != null) {
            restUrl.append("/").append(entityId).append("/").append(childEntityType.getEntityType());
        } else if (type.requiresId()) {
            restUrl.append("/").append(entityId);
        }
        String jsonString = null;
        if (!type.isIdempotent()) {
            jsonString = entityDetails instanceof Set || entityDetails instanceof List || entityDetails instanceof Map || entityDetails instanceof NuageVspObject ? this.getJsonString(entityDetails) : "";
        }
        String entity = this.executeHttpMethod(restUrl, jsonString, type, apiKey, checkWarning, childEntityType, entityType, paging, proxyUser);
        return Pair.of(restUrl.toString(), entity);
    }

    private String executeHttpMethod(StringBuilder url, String jsonString, RequestType type, String apiKey, boolean checkWarning, NuageVspEntity childEntityType, NuageVspEntity entityType, NuageVspPaging paging, NuageVspUser proxyUser) throws NuageVspApiException {
        return this.executeHttpMethod(type, url, jsonString, proxyUser, entityType, childEntityType, checkWarning, this.vspHost.getNuageVspCmsId(), paging);
    }

    private String executeHttpMethod(RequestType type, StringBuilder url, String jsonString, NuageVspUser proxyUser, NuageVspEntity entityType, NuageVspEntity childEntityType, boolean checkWarning, String nuageVspCmsId, NuageVspPaging paging) throws NuageVspApiException {
        HttpPost httpMethod = null;
        HttpResponse response = null;
        String returnJsonString = null;
        try {
            FilterProcessor.processFilter(paging, nuageVspCmsId);
            if (!checkWarning) {
                url.append("?responseChoice=1");
            }
            URI uri = new URI(url.toString());
            switch (type) {
                case CREATE: {
                    httpMethod = new HttpPost(uri);
                    break;
                }
                case MODIFY: 
                case MODIFYRELATED: {
                    httpMethod = new HttpPut(uri);
                    break;
                }
                case DELETE: {
                    httpMethod = new HttpDelete(uri);
                    break;
                }
                default: {
                    httpMethod = new HttpGet(uri);
                }
            }
            this.setHttpHeaders((HttpRequestBase)httpMethod, url, paging, proxyUser);
            if (httpMethod instanceof HttpEntityEnclosingRequestBase) {
                httpMethod.setHeader("Content-Type", "application/json");
                StringEntity entity = new StringEntity(jsonString);
                ((HttpEntityEnclosingRequestBase)httpMethod).setEntity((HttpEntity)entity);
            }
            long time = System.currentTimeMillis();
            if (this.client == null) {
                this.createHttpClient();
                s_logger.debug("Http client is not initialized. So, it is re-initialized to execute https %s with url %s.", httpMethod, url);
            }
            response = this.client.execute((HttpUriRequest)httpMethod);
            s_logger.trace("Total time taken to execute HTTPS method %s %s - %d ms.", new Object[]{type, url, System.currentTimeMillis() - time});
            returnJsonString = this.parseHttpResponse(response, childEntityType != null ? childEntityType : entityType, type);
            String string = this.initResponseJson(returnJsonString, this.vspHost.getNuageVspCmsId());
            return string;
        }
        catch (NuageVspApiException e) {
            throw e;
        }
        catch (SSLPeerUnverifiedException e) {
            this.client = null;
            try {
                this.createHttpClient();
                s_logger.debug("Reinitialized HTTP client because of new SSL certificate", new Object[0]);
                throw new NuageVspApiException(500, 0, "Throwing exception to trigger retry with reinitialized HTTP client", e);
            }
            catch (GeneralSecurityException e2) {
                throw new NuageVspConnectivityException("Failed to setup HTTPS", e2);
            }
        }
        catch (GeneralSecurityException e) {
            throw new NuageVspConnectivityException("Failed to setup HTTPS", e);
        }
        catch (SSLException e) {
            throw new NuageVspConnectivityException("Failed to setup SSL", e);
        }
        catch (ClientProtocolException e) {
            throw new NuageVspConnectivityException("Failed to setup SSL", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new NuageJsonParsingException("Unsupported Encoding", e);
        }
        catch (IOException ioe) {
            s_logger.error((Object)("Error while executing HTTPS method " + (Object)((Object)type) + " " + url), ioe);
            throw new NuageVspConnectivityException("Error while executing HTTPS method " + (Object)((Object)type) + " " + url, ioe);
        }
        catch (URISyntaxException urise) {
            s_logger.error((Object)("Error while building URI " + url.toString()), urise);
            throw new NuageVspApiException("Error while building URI " + url.toString(), urise);
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    public void createHttpClient() throws GeneralSecurityException {
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)120000);
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
        if (this.s_httpClientManager == null) {
            this.s_httpClientManager = new PoolingClientConnectionManager(TLSSocketFactory.createSchemeRegistry());
            this.s_httpClientManager.setDefaultMaxPerRoute(200);
            this.s_httpClientManager.setMaxTotal(200);
        }
        this.client = new DefaultHttpClient((ClientConnectionManager)this.s_httpClientManager, (HttpParams)params);
    }

    public String initContentJson(String json, String nuageVspCmsId) throws NuageVspApiException {
        try {
            Object entity;
            if (StringUtils.isNotBlank((String)json) && StringUtils.isNotBlank((String)nuageVspCmsId) && (entity = this.mapper.readValue(json, Object.class)) instanceof Map) {
                this.processJsonEntity((Map)entity, nuageVspCmsId, true, false);
                return this.mapper.writeValueAsString(entity);
            }
            return json;
        }
        catch (IOException ioe) {
            s_logger.error((Object)"Error while reading / writing content JSON", ioe);
            throw new NuageVspApiException("Error while reading / writing content JSON", ioe);
        }
    }

    public String initResponseJson(String json, String nuageVspCmsId) throws NuageVspApiException {
        try {
            if (StringUtils.isNotBlank((String)json) && StringUtils.isNotBlank((String)nuageVspCmsId)) {
                Object response = this.mapper.readValue(json, Object.class);
                if (response instanceof Map) {
                    this.processJsonEntity((Map)response, nuageVspCmsId, false, true);
                } else if (response instanceof List) {
                    List entities = (List)response;
                    for (Map entity : entities) {
                        this.processJsonEntity(entity, nuageVspCmsId, false, true);
                    }
                } else {
                    return json;
                }
                return this.mapper.writeValueAsString(response);
            }
            return json;
        }
        catch (IOException ioe) {
            s_logger.error((Object)"Error while reading / writing response JSON", ioe);
            throw new NuageVspApiException("Error while reading / writing response JSON", ioe);
        }
    }

    private void processJsonEntity(Map<String, Object> jsonEntity, String nuageVspCmsId, boolean build, boolean revert) {
        String externalIdSuffix = "@" + nuageVspCmsId;
        for (String field : jsonEntity.keySet()) {
            Object value;
            if (FilterProcessor.EXTERNAL_ID_FIELDS.contains((Object)NuageVspAttribute.lookup(this.vspHost.getApiVersion(), field))) {
                value = (String)jsonEntity.get(field);
                if (!StringUtils.isNotBlank((String)value)) continue;
                boolean endsWithSuffix = ((String)value).endsWith(externalIdSuffix);
                if (revert && endsWithSuffix) {
                    String[] externalIdSplitted = ((String)value).split("@");
                    jsonEntity.put(field, externalIdSplitted[0]);
                    continue;
                }
                if (!build || endsWithSuffix) continue;
                String vsdExternalId = (String)value + externalIdSuffix;
                jsonEntity.put(field, vsdExternalId);
                continue;
            }
            value = jsonEntity.get(field);
            if (value != null && value instanceof Map) {
                this.processJsonEntity((Map)value, nuageVspCmsId, build, revert);
                continue;
            }
            if (value == null || !(value instanceof List)) continue;
            for (Object entity : (List)value) {
                if (!(entity instanceof Map)) continue;
                this.processJsonEntity((Map)entity, nuageVspCmsId, build, revert);
            }
        }
    }

    private void setHttpHeaders(HttpRequestBase httpMethod, StringBuilder url, NuageVspPaging paging, NuageVspUser proxyUser) {
        NuageVspUser cmsUserInfo = this.vspHost.getCmsUserInfo();
        StringBuilder authStr = new StringBuilder().append(cmsUserInfo.getUserName()).append(":");
        if (url.toString().endsWith(NuageVspEntity.ME.getEntityType())) {
            authStr.append(cmsUserInfo.getPassword());
        } else {
            authStr.append(apiKey);
        }
        String encoding = Base64.encodeBase64String((byte[])authStr.toString().getBytes());
        httpMethod.setHeader("Authorization", "Basic " + encoding);
        httpMethod.setHeader("content-type", "application/json");
        httpMethod.setHeader("X-Nuage-Organization", cmsUserInfo.getEnterpriseName());
        if (proxyUser != null) {
            String proxyUserHeader = proxyUser.getUserName().replace("-", "") + "@" + proxyUser.getEnterpriseName();
            httpMethod.setHeader("X-Nuage-ProxyUser", proxyUserHeader);
        }
        if (paging != null) {
            if (paging.hasFilter()) {
                httpMethod.setHeader("X-Nuage-Filter", paging.getFilter());
            }
            if (paging.hasOrderBy()) {
                httpMethod.setHeader("X-Nuage-OrderBy", paging.getOrderBy());
            }
            if (paging.hasPageSize()) {
                httpMethod.setHeader("X-Nuage-Page", String.valueOf(paging.getPageSize()));
            }
        }
    }

    public void login() throws NuageVspException {
        try {
            String groupJson;
            NuageVspObject cmsGroup;
            StringBuilder meUrl = new StringBuilder(this.vspHost.getRestRelativePath());
            meUrl.append("/").append(NuageVspEntity.ME.getEntityType());
            String meJson = this.executeHttpMethod(RequestType.GET, meUrl, null, null, NuageVspEntity.ME, null, true, null, null);
            NuageVspObject me = (NuageVspObject)Iterables.getFirst(this.parseJsonString(NuageVspEntity.ME, meJson), null);
            if (me == null) {
                apiKey = "";
                return;
            }
            apiKey = (String)me.get(NuageVspAttribute.APIKEY);
            String systemEnterpriseId = (String)me.get(NuageVspAttribute.ENTERPRISE_ID);
            if (StringUtils.isNotBlank((String)systemEnterpriseId) && (cmsGroup = (NuageVspObject)Iterables.getOnlyElement(this.parseJsonString(NuageVspEntity.GROUP, groupJson = this.getResources(NuageVspEntity.ENTERPRISE, systemEnterpriseId, NuageVspEntity.GROUP, NuageVspAttribute.GROUP_ROLE.getAttributeName() + " == 'CMS'")), null)) != null) {
                String cmsUsersJson = this.getResources(NuageVspEntity.GROUP, (String)cmsGroup.get(NuageVspAttribute.ID), NuageVspEntity.USER);
                List<NuageVspObject> cmsUsers = this.parseJsonString(NuageVspEntity.USER, cmsUsersJson);
                for (NuageVspObject cmsUser : cmsUsers) {
                    String cmsUsername = (String)cmsUser.get(NuageVspAttribute.USER_USERNAME);
                    if (!cmsUsername.equals(this.vspHost.getCmsUserLogin())) continue;
                    return;
                }
            }
        }
        catch (Exception e) {
            String errorMessage = "Failed to check if the user is part of the CMS group";
            if (e instanceof NuageVspAuthenticationException) {
                errorMessage = "Failed to authenticate on Nuage VSP device. Provided credentials are invalid.";
            }
            s_logger.error((Object)errorMessage, e);
            throw new NuageVspException(errorMessage);
        }
        s_logger.error((Object)("User '" + this.vspHost.getCmsUserLogin() + "' is not part of the CMS group!"), new Object[0]);
        throw new NuageVspException("User '" + this.vspHost.getCmsUserLogin() + "' is not part of the CMS group!");
    }

    public String getJsonString(Object entityDetails) throws NuageJsonParsingException {
        String jsonString = "";
        try {
            jsonString = this.getGsonInstance(null).toJson(entityDetails);
            return jsonString;
        }
        catch (JsonSyntaxException jsonException) {
            s_logger.error((Object)"Error while retrieving JSON from complex data", jsonException);
            throw new NuageJsonParsingException("Error while retrieving JSON from complex data", jsonException);
        }
    }

    private String parseHttpResponse(HttpResponse httpResponse, NuageVspEntity entityType, RequestType type) throws NuageVspApiException, IOException {
        String jsonResult = NuageVspRestApi.getJsonFromResponse(httpResponse);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        String errorMessage = "NUAGE HTTP REQUEST %s: HTTP Response code: %d: Response : %s";
        if (statusCode >= 402 && statusCode <= 599) {
            Pair<Integer, String> error = this.parseJsonError(jsonResult);
            if (statusCode == 404) {
                error = Pair.of(200, null);
            }
            Integer nuageErrorCode = error.getLeft();
            String nuageErrorDetails = error.getRight();
            if (nuageErrorCode != null || nuageErrorDetails != null) {
                if (nuageErrorCode == 2591) {
                    s_logger.warn(errorMessage, "FAILED", statusCode, jsonResult);
                } else {
                    if (type == RequestType.DELETE && nuageErrorCode == 200) {
                        s_logger.info(errorMessage, "FAILED", statusCode, jsonResult);
                        return jsonResult;
                    }
                    if (nuageErrorCode != 2039) {
                        s_logger.error((Object)errorMessage, "FAILED", statusCode, jsonResult);
                    }
                }
                throw new NuageVspApiException(statusCode, errorMessage, nuageErrorCode, nuageErrorDetails, entityType.getEntityType(), type);
            }
        } else {
            if (statusCode == 400) {
                s_logger.trace(errorMessage, statusCode, jsonResult);
                throw new NuageVspApiException(httpResponse.getStatusLine().getStatusCode(), errorMessage, 0, "The request sent by the client was syntactically incorrect", entityType.getEntityType(), type);
            }
            if (statusCode == 401) {
                s_logger.trace(errorMessage, new Object[0]);
                throw new NuageVspAuthenticationException(errorMessage);
            }
            if (statusCode >= 200 && statusCode <= 299) {
                s_logger.trace(errorMessage, "RESULT", statusCode, jsonResult);
            }
        }
        return jsonResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getJsonFromResponse(HttpResponse httpResponse) throws NuageJsonParsingException {
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) return "";
        try (InputStream inputStream = entity.getContent();){
            String string = IOUtils.toString((InputStream)inputStream);
            return string;
        }
        catch (IOException ioe) {
            throw new NuageJsonParsingException(null, ioe);
        }
    }

    private Pair<Integer, String> parseJsonError(String jsonResult) throws NuageJsonParsingException {
        JsonNode actualObj;
        ObjectMapper mapper = new ObjectMapper();
        JsonFactory factory = mapper.getJsonFactory();
        try {
            JsonParser jp = factory.createJsonParser(jsonResult);
            actualObj = mapper.readTree(jp);
        }
        catch (IOException ioe) {
            throw new NuageJsonParsingException(null, ioe);
        }
        JsonNode internalErrorCodeNode = actualObj.get("internalErrorCode");
        JsonNode internalErrorDetailsNode = actualObj.get("errors");
        Integer internalErrorCode = null;
        String internalErrorDetails = null;
        if (internalErrorCodeNode != null) {
            internalErrorCode = internalErrorCodeNode.getIntValue();
        }
        if (internalErrorDetailsNode != null) {
            internalErrorDetails = internalErrorDetailsNode.toString();
        }
        return Pair.of(internalErrorCode, internalErrorDetails);
    }

    public List<NuageVspObject> parseJsonString(NuageVspEntity nuageEntity, String jsonResult) throws NuageJsonParsingException, UnsupportedNuageEntityException {
        return this.parseJsonString(nuageEntity, jsonResult, null);
    }

    public List<NuageVspObject> parseJsonString(NuageVspEntity nuageEntity, String jsonResult, String jsonNodeName) throws NuageJsonParsingException, UnsupportedNuageEntityException {
        JsonNode actualObj;
        LinkedList<NuageVspObject> entityDetails = new LinkedList<NuageVspObject>();
        NuageVspApiVersion apiVersion = this.vspHost.getApiVersion();
        List<String> attributeNames = nuageEntity.getAttributeNameList(apiVersion);
        if (attributeNames == null) {
            throw new UnsupportedNuageEntityException(nuageEntity.getEntityType() + " is not defined in NuageEntity enum. Please add it if it needs to be supported");
        }
        if (StringUtils.isBlank((String)jsonResult)) {
            return entityDetails;
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonFactory factory = mapper.getJsonFactory();
        try (JsonParser jp = factory.createJsonParser(jsonResult);){
            actualObj = mapper.readTree(jp);
        }
        catch (IOException ioe) {
            throw new NuageJsonParsingException("Failed to parse the Json response from VSP REST API. Json string is " + jsonResult, ioe);
        }
        if (actualObj != null) {
            if (StringUtils.isNotBlank((String)jsonNodeName)) {
                actualObj = actualObj.path(jsonNodeName);
            }
            Iterator iterator = actualObj.getElements();
            while (iterator.hasNext()) {
                NuageVspObject attributeValues = new NuageVspObject(apiVersion, nuageEntity);
                JsonNode entity = (JsonNode)iterator.next();
                Iterator fieldIterator = entity.getFields();
                while (fieldIterator.hasNext()) {
                    Map.Entry entityField = (Map.Entry)fieldIterator.next();
                    String key = (String)entityField.getKey();
                    if (!attributeNames.contains(key)) continue;
                    NuageVspAttribute field = NuageVspAttribute.lookup(apiVersion, key, nuageEntity);
                    Object value = null;
                    JsonNode jsonValue = (JsonNode)entityField.getValue();
                    if (jsonValue.isBoolean()) {
                        value = jsonValue.getBooleanValue();
                    } else if (jsonValue.isInt()) {
                        value = jsonValue.getIntValue();
                    } else if (jsonValue.isLong()) {
                        value = jsonValue.getLongValue();
                    } else if (jsonValue.isTextual()) {
                        value = jsonValue.getTextValue();
                    } else if (!jsonValue.isNull()) {
                        value = jsonValue.toString();
                    }
                    attributeValues.set(field, value);
                }
                entityDetails.add(attributeValues);
            }
        }
        return entityDetails;
    }

    private Gson getGsonInstance(NuageVspEntity nuageEntity) {
        return new GsonBuilder().registerTypeAdapter(NuageVspObject.class, (Object)new NuageVspObjectTypeAdapter(nuageEntity, this.vspHost.getApiVersion(), this.vspHost.getNuageVspCmsId())).registerTypeAdapter(Protocol.class, (Object)new ProtocolTypeAdapter()).registerTypeAdapter(Acl.AclEtherType.class, new CodedEnumTypeAdapter()).serializeNulls().create();
    }

    protected NuageVspObject createNuageVspObject(NuageVspEntity entity) {
        return new NuageVspObject(this.vspHost.getApiVersion(), entity);
    }

    protected NuageVspObject createNuageVspObject(NuageVspEntity entity, String entityId) {
        return new NuageVspObject(this.vspHost.getApiVersion(), entity, entityId);
    }

    protected static NuageVspApiException handleException(String message, NuageVspException cause, Object ... args) {
        if (cause instanceof NuageVspApiException) {
            return (NuageVspApiException)cause;
        }
        if (args.length > 0) {
            message = String.format(message, args);
        }
        s_logger.error((Object)message, cause);
        return new NuageVspApiException(message, cause);
    }

    private boolean handleException(int attempt, long sleepTime, Exception e, String methodName, String url, List<Integer> retryNuageErrorCodes) throws NuageVspApiException {
        NuageVspApiException exception;
        boolean retry = false;
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
        Throwable throwable = rootCause = rootCause == null ? e : rootCause;
        if (rootCause instanceof NuageVspAuthenticationException) {
            s_logger.trace(String.format("Authentication failed so failed to execute Nuage VSP API %s", url), new Object[0]);
            NuageVspRestApi.printRetryMessage(attempt, sleepTime, methodName, url, rootCause);
            try {
                retry = true;
                Thread.sleep(sleepTime);
                this.login();
            }
            catch (InterruptedException e1) {
                s_logger.warn("Retry sleeping got interrupted", new Object[0]);
                throw new NuageVspApiException("Retry sleeping got interrupted", e);
            }
            catch (NuageVspException nve) {
                s_logger.error((Object)"Failed to login to VSD", nve);
                throw new NuageVspApiException("Failed to login to VSD", nve);
            }
        } else if (rootCause instanceof SSLException || e instanceof SSLException) {
            NuageVspRestApi.printRetryMessage(attempt, sleepTime, methodName, url, rootCause);
            retry = NuageVspRestApi.setRetryFlag(sleepTime);
        } else if (rootCause instanceof NuageVspApiException && ((exception = (NuageVspApiException)rootCause).getHttpErrorCode() == 500 || retryNuageErrorCodes != null && retryNuageErrorCodes.contains(exception.getNuageErrorCode()))) {
            NuageVspRestApi.printRetryMessage(attempt, sleepTime, methodName, url, rootCause);
            retry = NuageVspRestApi.setRetryFlag(sleepTime);
        }
        return retry;
    }

    private static void printRetryMessage(int attempt, long sleepTime, String methodName, String url, Throwable rootCause) {
        s_logger.trace("Failed to execute Nuage VSP API %s : %s", url, rootCause.getMessage());
        s_logger.trace("Attempt %s to re-execute the method %s", attempt, methodName);
        s_logger.trace("Waiting %s millis before re-executing the method %s", sleepTime, methodName);
    }

    private static boolean setRetryFlag(long sleepTime) throws NuageVspApiException {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            s_logger.warn("Retry sleeping got interrupted", new Object[0]);
            throw new NuageVspApiException("Retry sleeping got interrupted", e);
        }
        return true;
    }
}

