/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Protocol {
    public static final Protocol TCP = new Protocol("6");
    public static final Protocol UDP = new Protocol("17");
    public static final Protocol ICMP = new Protocol("1");
    public static final Protocol ANY = new Protocol("ANY");
    private static final Map<String, Protocol> PROTOCOL_MAP = new HashMap<String, Protocol>();
    private String protocolNumber;

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    private Protocol(String protocolNumber) {
        this.protocolNumber = protocolNumber;
    }

    public String getProtocolNumber() {
        return this.protocolNumber;
    }

    public boolean hasPort() {
        return this.equals(TCP) || this.equals(UDP);
    }

    public static Protocol fromString(String protocolString) {
        Protocol protocol = PROTOCOL_MAP.get(protocolString.toUpperCase());
        if (protocol == null) {
            protocol = new Protocol(protocolString);
        }
        return protocol;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("protocolNumber", (Object)this.protocolNumber).toString();
    }

    static {
        PROTOCOL_MAP.put("TCP", TCP);
        PROTOCOL_MAP.put("UDP", UDP);
        PROTOCOL_MAP.put("ICMP", ICMP);
        PROTOCOL_MAP.put("ANY", ANY);
        PROTOCOL_MAP.put("ALL", ANY);
        PROTOCOL_MAP.put("6", TCP);
        PROTOCOL_MAP.put("17", UDP);
        PROTOCOL_MAP.put("1", ICMP);
    }
}

