/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.model;

import net.nuage.vsp.acs.client.api.model.NuageVspUser;
import net.nuage.vsp.acs.client.api.model.VspBuilder;
import net.nuage.vsp.acs.client.api.model.VspObject;
import net.nuage.vsp.acs.client.common.NuageVspApiVersion;

public class VspHost
extends VspObject {
    private final String restRelativePath;
    private final String rootPath;
    private final NuageVspUser cmsUser;
    private final int noofRetry;
    private final long retryInterval;
    private final String nuageVspCmsId;
    private final NuageVspApiVersion apiVersion;

    private VspHost(NuageVspApiVersion apiVersion, String restRelativePath, String rootPath, NuageVspUser cmsUser, int noofRetry, long retryInterval, String nuageVspCmsId) {
        this.apiVersion = apiVersion;
        this.restRelativePath = restRelativePath;
        this.rootPath = rootPath;
        this.cmsUser = cmsUser;
        this.noofRetry = noofRetry;
        this.retryInterval = retryInterval;
        this.nuageVspCmsId = nuageVspCmsId;
    }

    public NuageVspApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public String getRestRelativePath() {
        return this.restRelativePath;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public String getCmsUserEnterprise() {
        return this.cmsUser.getEnterpriseName();
    }

    public String getCmsUserLogin() {
        return this.cmsUser.getUserName();
    }

    public String getCmsUserPassword() {
        return this.cmsUser.getPassword();
    }

    public NuageVspUser getCmsUserInfo() {
        return this.cmsUser;
    }

    public int getNoofRetry() {
        return this.noofRetry;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public String getNuageVspCmsId() {
        return this.nuageVspCmsId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VspHost)) {
            return false;
        }
        VspHost vspHost = (VspHost)o;
        if (this.noofRetry != vspHost.noofRetry) {
            return false;
        }
        if (this.retryInterval != vspHost.retryInterval) {
            return false;
        }
        if (this.cmsUser != null ? !this.cmsUser.equals(vspHost.cmsUser) : vspHost.cmsUser != null) {
            return false;
        }
        if (this.nuageVspCmsId != null ? !this.nuageVspCmsId.equals(vspHost.nuageVspCmsId) : vspHost.nuageVspCmsId != null) {
            return false;
        }
        if (this.restRelativePath != null ? !this.restRelativePath.equals(vspHost.restRelativePath) : vspHost.restRelativePath != null) {
            return false;
        }
        return !(this.rootPath != null ? !this.rootPath.equals(vspHost.rootPath) : vspHost.rootPath != null);
    }

    public int hashCode() {
        int result = this.restRelativePath != null ? this.restRelativePath.hashCode() : 0;
        result = 31 * result + (this.cmsUser != null ? this.cmsUser.hashCode() : 0);
        result = 31 * result + this.noofRetry;
        result = 31 * result + (int)(this.retryInterval ^ this.retryInterval >>> 32);
        result = 31 * result + (this.nuageVspCmsId != null ? this.nuageVspCmsId.hashCode() : 0);
        return result;
    }

    public static class Builder
    extends VspBuilder<Builder, VspHost> {
        private String restRelativePath;
        private String rootPath;
        private String cmsUserEnterprise;
        private String cmsUserLogin;
        private String cmsUserPassword;
        private NuageVspUser cmsUser;
        private int noofRetry;
        private long retryInterval;
        private String nuageVspCmsId;
        private NuageVspApiVersion apiVersion;

        public Builder apiVersion(NuageVspApiVersion apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder restRelativePath(String restRelativePath) {
            this.restRelativePath = restRelativePath;
            return this;
        }

        public Builder rootPath(String rootPath) {
            this.rootPath = rootPath;
            return this;
        }

        public Builder cmsUser(NuageVspUser cmsUser) {
            this.cmsUser = cmsUser;
            return this;
        }

        public Builder cmsUserEnterprise(String cmsUserEnterprise) {
            this.cmsUserEnterprise = cmsUserEnterprise;
            return this;
        }

        public Builder cmsUserLogin(String cmsUserLogin) {
            this.cmsUserLogin = cmsUserLogin;
            return this;
        }

        public Builder cmsUserPassword(String cmsUserPassword) {
            this.cmsUserPassword = cmsUserPassword;
            return this;
        }

        public Builder noofRetry(int noofRetry) {
            this.noofRetry = noofRetry;
            return this;
        }

        public Builder retryInterval(long retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public Builder nuageVspCmsId(String nuageVspCmsId) {
            this.nuageVspCmsId = nuageVspCmsId;
            return this;
        }

        @Override
        public VspHost build() {
            if (this.cmsUser == null) {
                this.cmsUser = new NuageVspUser(this.cmsUserEnterprise, this.cmsUserLogin, this.cmsUserPassword);
            }
            return new VspHost(this.apiVersion, this.restRelativePath, this.rootPath, this.cmsUser, this.noofRetry, this.retryInterval, this.nuageVspCmsId);
        }

        @Override
        public Builder fromObject(VspHost obj) {
            return new Builder().apiVersion(obj.getApiVersion()).restRelativePath(obj.getRestRelativePath()).cmsUserEnterprise(obj.getCmsUserEnterprise()).cmsUserLogin(obj.getCmsUserLogin()).cmsUserPassword(obj.getCmsUserPassword()).noofRetry(obj.getNoofRetry()).retryInterval(obj.getRetryInterval()).nuageVspCmsId(obj.getNuageVspCmsId());
        }
    }
}

