/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.model;

import net.nuage.vsp.acs.client.api.model.VspBuilder;
import net.nuage.vsp.acs.client.api.model.VspNic;
import net.nuage.vsp.acs.client.api.model.VspObject;

public class VspStaticNat
extends VspObject {
    private final State state;
    private final String ipUuid;
    private final String ipAddress;
    private final VspNic vspNic;
    private final Boolean revoke;
    private final Boolean oneToOneNat;
    private final String vlanUuid;
    private final String vlanGateway;
    private final String vlanNetmask;
    private final boolean vlanUnderlay;

    private VspStaticNat(State state, String ipUuid, String ipAddress, VspNic vspNic, Boolean revoke, Boolean oneToOneNat, String vlanUuid, String vlanGateway, String vlanNetmask, boolean vlanUnderlay) {
        this.state = state;
        this.ipUuid = ipUuid;
        this.ipAddress = ipAddress;
        this.vspNic = vspNic;
        this.revoke = revoke;
        this.oneToOneNat = oneToOneNat;
        this.vlanUuid = vlanUuid;
        this.vlanGateway = vlanGateway;
        this.vlanNetmask = vlanNetmask;
        this.vlanUnderlay = vlanUnderlay;
    }

    public State getState() {
        return this.state;
    }

    public String getIpUuid() {
        return this.ipUuid;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public VspNic getVspNic() {
        return this.vspNic;
    }

    public Boolean getRevoke() {
        return this.revoke;
    }

    public Boolean getOneToOneNat() {
        return this.oneToOneNat;
    }

    public String getVlanUuid() {
        return this.vlanUuid;
    }

    public String getVlanGateway() {
        return this.vlanGateway;
    }

    public String getVlanNetmask() {
        return this.vlanNetmask;
    }

    public boolean isVlanUnderlay() {
        return this.vlanUnderlay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VspStaticNat)) {
            return false;
        }
        VspStaticNat that = (VspStaticNat)o;
        if (this.vlanUnderlay != that.vlanUnderlay) {
            return false;
        }
        if (this.ipAddress != null ? !this.ipAddress.equals(that.ipAddress) : that.ipAddress != null) {
            return false;
        }
        if (this.ipUuid != null ? !this.ipUuid.equals(that.ipUuid) : that.ipUuid != null) {
            return false;
        }
        if (this.oneToOneNat != null ? !this.oneToOneNat.equals(that.oneToOneNat) : that.oneToOneNat != null) {
            return false;
        }
        if (this.revoke != null ? !this.revoke.equals(that.revoke) : that.revoke != null) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        if (this.vlanGateway != null ? !this.vlanGateway.equals(that.vlanGateway) : that.vlanGateway != null) {
            return false;
        }
        if (this.vlanNetmask != null ? !this.vlanNetmask.equals(that.vlanNetmask) : that.vlanNetmask != null) {
            return false;
        }
        if (this.vlanUuid != null ? !this.vlanUuid.equals(that.vlanUuid) : that.vlanUuid != null) {
            return false;
        }
        return !(this.vspNic != null ? !this.vspNic.equals(that.vspNic) : that.vspNic != null);
    }

    public int hashCode() {
        int result = this.state != null ? this.state.hashCode() : 0;
        result = 31 * result + (this.ipUuid != null ? this.ipUuid.hashCode() : 0);
        result = 31 * result + (this.ipAddress != null ? this.ipAddress.hashCode() : 0);
        result = 31 * result + (this.vspNic != null ? this.vspNic.hashCode() : 0);
        result = 31 * result + (this.revoke != null ? this.revoke.hashCode() : 0);
        result = 31 * result + (this.oneToOneNat != null ? this.oneToOneNat.hashCode() : 0);
        result = 31 * result + (this.vlanUuid != null ? this.vlanUuid.hashCode() : 0);
        result = 31 * result + (this.vlanGateway != null ? this.vlanGateway.hashCode() : 0);
        result = 31 * result + (this.vlanNetmask != null ? this.vlanNetmask.hashCode() : 0);
        result = 31 * result + (this.vlanUnderlay ? 1 : 0);
        return result;
    }

    public static class Builder
    extends VspBuilder<Builder, VspStaticNat> {
        private State state;
        private String ipUuid;
        private String ipAddress;
        private VspNic vspNic;
        private Boolean revoke;
        private Boolean oneToOneNat;
        private String vlanUuid;
        private String vlanGateway;
        private String vlanNetmask;
        private boolean vlanUnderlay;

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder ipUuid(String ipUuid) {
            this.ipUuid = ipUuid;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder nic(VspNic vspNic) {
            this.vspNic = vspNic;
            return this;
        }

        public Builder revoke(Boolean revoke) {
            this.revoke = revoke;
            return this;
        }

        public Builder oneToOneNat(Boolean oneToOneNat) {
            this.oneToOneNat = oneToOneNat;
            return this;
        }

        public Builder vlanUuid(String vlanUuid) {
            this.vlanUuid = vlanUuid;
            return this;
        }

        public Builder vlanGateway(String vlanGateway) {
            this.vlanGateway = vlanGateway;
            return this;
        }

        public Builder vlanNetmask(String vlanNetmask) {
            this.vlanNetmask = vlanNetmask;
            return this;
        }

        public Builder vlanUnderlay(boolean vlanUnderlay) {
            this.vlanUnderlay = vlanUnderlay;
            return this;
        }

        @Override
        public VspStaticNat build() {
            return new VspStaticNat(this.state, this.ipUuid, this.ipAddress, this.vspNic, this.revoke, this.oneToOneNat, this.vlanUuid, this.vlanGateway, this.vlanNetmask, this.vlanUnderlay);
        }

        @Override
        public Builder fromObject(VspStaticNat obj) {
            return new Builder().state(obj.getState()).ipUuid(obj.getIpUuid()).ipAddress(obj.getIpAddress()).nic(obj.getVspNic()).revoke(obj.getRevoke()).oneToOneNat(obj.getOneToOneNat()).vlanUuid(obj.getVlanUuid()).vlanGateway(obj.getVlanGateway()).vlanNetmask(obj.getVlanNetmask()).vlanUnderlay(obj.isVlanUnderlay());
        }
    }

    public static enum State {
        Allocating,
        Allocated,
        Releasing,
        Free;

    }
}

