/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common;

import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.nuage.vsp.acs.client.api.model.NuageVspPaging;
import net.nuage.vsp.acs.client.common.model.NuageVspAttribute;
import org.apache.commons.lang.StringUtils;

public class FilterProcessor {
    public static final Set<NuageVspAttribute> EXTERNAL_ID_FIELDS = EnumSet.of(NuageVspAttribute.EXTERNAL_ID);

    public static void processFilter(NuageVspPaging paging, String nuageVspCmsId) {
        if (paging != null && paging.hasFilter()) {
            paging.filter(FilterProcessor.processFilter(paging.getFilter(), nuageVspCmsId));
        }
    }

    public static String processFilter(String filter, String nuageVspCmsId) {
        if (filter == null) {
            return null;
        }
        if (nuageVspCmsId == null) {
            return filter;
        }
        for (NuageVspAttribute externalIdField : EXTERNAL_ID_FIELDS) {
            if (!filter.contains(externalIdField.getAttributeName())) continue;
            String regex = ".*?" + (Object)((Object)externalIdField) + ".*?['\"](.*?)['\"]( (?i)and ['\"](.*?)['\"])?";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(filter);
            StringBuilder newFilter = new StringBuilder();
            StringBuilder oldFilter = new StringBuilder();
            while (matcher.find()) {
                String output = FilterProcessor.replaceOldExternalId(matcher.group(0), matcher.group(1), nuageVspCmsId);
                if (matcher.group(3) != null) {
                    output = FilterProcessor.replaceOldExternalId(output, matcher.group(3), nuageVspCmsId);
                }
                newFilter.append(output);
                oldFilter.append(matcher.group(0));
            }
            filter = newFilter.toString() + filter.substring(oldFilter.length());
        }
        return filter;
    }

    private static String replaceOldExternalId(String input, String oldExternalId, String nuageVspCmsId) {
        if (StringUtils.isNotBlank((String)oldExternalId) && !oldExternalId.endsWith(nuageVspCmsId)) {
            String newExternalId = oldExternalId + "@" + nuageVspCmsId;
            return input.replaceAll(oldExternalId, newExternalId);
        }
        return input;
    }
}

