/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang3.StringUtils;

public class NuageVspApiVersion
implements Comparable<NuageVspApiVersion> {
    private static final Pattern versionRegEx = Pattern.compile("v(\\d+)_(\\d+)");
    public static final NuageVspApiVersion V3_2 = new NuageVspApiVersion(3, 2);
    public static final NuageVspApiVersion V4_0;
    public static final NuageVspApiVersion CURRENT;
    public static final NuageVspApiVersion[] SUPPORTED_VERSIONS;
    public static final NuageVspApiVersion[] VERSIONS_REQUIRING_UPGRADE;
    private Integer major;
    private Integer minor;

    public NuageVspApiVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public NuageVspApiVersion(String version) {
        Matcher matcher = versionRegEx.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Bad version");
        }
        this.major = Integer.valueOf(matcher.group(1));
        this.minor = Integer.valueOf(matcher.group(2));
    }

    public static NuageVspApiVersion fromString(String version) {
        version = version.toLowerCase().replace('.', '_');
        for (NuageVspApiVersion suppVersion : SUPPORTED_VERSIONS) {
            if (!StringUtils.equals((CharSequence)suppVersion.toString(), (CharSequence)version)) continue;
            return suppVersion;
        }
        return new NuageVspApiVersion(version);
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    @Override
    public int compareTo(NuageVspApiVersion other) {
        int compare = this.major.compareTo(other.major);
        if (compare == 0) {
            compare = this.minor.compareTo(other.minor);
        }
        return compare;
    }

    public String toString() {
        return String.format("v%d_%d", this.major, this.minor);
    }

    public boolean isSupported() {
        return ArrayUtils.contains((Object[])SUPPORTED_VERSIONS, (Object)this);
    }

    static {
        CURRENT = V4_0 = new NuageVspApiVersion(4, 0);
        SUPPORTED_VERSIONS = new NuageVspApiVersion[]{V3_2, V4_0};
        VERSIONS_REQUIRING_UPGRADE = new NuageVspApiVersion[]{V3_2, V4_0};
    }

    public static enum Status {
        UNSUPPORTED,
        DEPRECATED,
        CURRENT;

    }
}

