/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common.model;

import com.google.common.net.InetAddresses;
import com.google.common.primitives.Bytes;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class DhcpOption {
    String code;
    String length;
    String value;

    public DhcpOption(int code, byte b) {
        this.setCode(code);
        byte[] value = new byte[]{b};
        this.setValue(value);
    }

    public DhcpOption(int code, String value) {
        this.setCode(code);
        this.setValue(value.getBytes(Charset.forName("UTF-8")));
    }

    public DhcpOption(int code, List<String> ipAdresses) {
        this.setCode(code);
        LinkedList<Byte> bytes = new LinkedList<Byte>();
        for (String ip : ipAdresses) {
            bytes.addAll(Arrays.asList(ArrayUtils.toObject((byte[])InetAddresses.forString((String)ip).getAddress())));
        }
        this.setValue(Bytes.toArray(bytes));
    }

    public String getCode() {
        return this.code;
    }

    public String getLength() {
        return this.length;
    }

    public String getValue() {
        return this.value;
    }

    private void setValue(byte[] value) {
        this.length = String.format("%02x", value.length);
        Formatter formatter = new Formatter();
        for (byte b : value) {
            formatter.format("%02x", b);
        }
        this.value = formatter.toString();
    }

    private void setCode(int code) {
        this.code = String.format("%02x", code);
    }
}

