/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.nuage.vsp.acs.client.common.model.DhcpOption;

public class DhcpOptions {
    List<DhcpOption> options = Lists.newArrayList();

    public DhcpOptions() {
    }

    public DhcpOptions(String vrIp, List<String> dnsServers, String networkDomain) {
        ArrayList allsDnsServers;
        ArrayList arrayList = allsDnsServers = vrIp == null ? Lists.newArrayList() : Lists.newArrayList((Object[])new String[]{vrIp});
        if (dnsServers != null) {
            allsDnsServers.addAll(dnsServers);
        }
        if (!allsDnsServers.isEmpty()) {
            this.options.add(new DhcpOption(6, allsDnsServers));
        }
        if (networkDomain != null && !networkDomain.isEmpty()) {
            this.options.add(new DhcpOption(15, networkDomain));
        }
    }

    public DhcpOptions(boolean defaultHasDns, String hostname, boolean networkHasDns, boolean defaultInterface, boolean domainRouter) {
        if (!domainRouter) {
            if (defaultHasDns) {
                if (defaultInterface) {
                    this.options.add(new DhcpOption(12, hostname));
                } else {
                    this.options.add(new DhcpOption(3, 0));
                    this.options.add(new DhcpOption(6, 0));
                    if (networkHasDns) {
                        this.options.add(new DhcpOption(15, 0));
                        this.options.add(new DhcpOption(12, hostname));
                    }
                }
            } else if (!defaultInterface) {
                this.options.add(new DhcpOption(3, 0));
                if (networkHasDns) {
                    this.options.add(new DhcpOption(6, 0));
                    this.options.add(new DhcpOption(15, 0));
                    this.options.add(new DhcpOption(12, hostname));
                }
            }
        }
    }

    public List<DhcpOption> getOptions() {
        return this.options;
    }
}

