/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.nuage.vsp.acs.client.api.model.Protocol;
import net.nuage.vsp.acs.client.common.NuageVspApiVersion;
import net.nuage.vsp.acs.client.common.NuageVspConstants;
import net.nuage.vsp.acs.client.common.model.Acl;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;
import net.nuage.vsp.acs.client.common.model.gson.NuageVspObjectTypeAdapter;

public enum NuageVspAttribute {
    ID("ID", (Type)((Object)String.class)),
    EXTERNAL_ID("externalID", (Type)((Object)String.class)),
    CMS_ID("cmsId", (Type)((Object)String.class)),
    VERSION("version"),
    VERSION_STATUS("status"),
    PARENT_ID("parentID", (Type)((Object)String.class)),
    TEMPLATE_ID("templateID", (Type)((Object)String.class)),
    APIKEY("APIKey", (Type)((Object)String.class)),
    ENTERPRISE_ID("enterpriseID", (Type)((Object)String.class)),
    LASTUPDATED("lastUpdatedDate"),
    NAME("name", (Type)((Object)String.class)),
    DESCRIPTION("description", (Type)((Object)String.class)),
    ENTERPRISE_NAME("name"),
    ENTERPRISE_DESCRIPTION("description"),
    ENTERPRISE_PROFILE_ID("enterpriseProfileID", (Type)((Object)String.class)),
    GROUP_NAME("name"),
    GROUP_DESCRIPTION("description"),
    GROUP_PRIVATE("private"),
    GROUP_ROLE("role", (Type)((Object)String.class)),
    USER_USERNAME("userName", (Type)((Object)String.class)),
    USER_DESCRIPTION("description"),
    USER_FIRSTNAME("firstName", (Type)((Object)String.class)),
    USER_LASTNAME("lastName", (Type)((Object)String.class)),
    USER_PASSWORD("password", (Type)((Object)String.class)),
    USER_EMAIL("email", (Type)((Object)String.class)),
    DOMAIN_TEMPLATE_NAME("name"),
    DOMAIN_TEMPLATE_DESCRIPTION("description"),
    L2DOMAIN_TEMPLATE_NAME("name"),
    L2DOMAIN_TEMPLATE_DESCRIPTION("description"),
    L2DOMAIN_TEMPLATE_ADDRESS("address", (Type)((Object)String.class)),
    L2DOMAIN_TEMPLATE_NETMASK("netmask", (Type)((Object)String.class)),
    L2DOMAIN_TEMPLATE_GATEWAY("gateway", (Type)((Object)String.class)),
    ZONE_TEMPLATE_NAME("name"),
    ZONE_TEMPLATE_DESCRIPTION("description"),
    DOMAIN_NAME("name"),
    DOMAIN_DESCRIPTION("description"),
    DOMAIN_TEMPLATE_ID("templateID"),
    DOMAIN_PATENABLED("PATEnabled", (Type)((Object)Boolean.class)),
    DOMAIN_UNDERLAYENABLED("underlayEnabled", (Type)((Object)Boolean.class)),
    ZONE_NAME("name"),
    ZONE_DESCRIPTION("description"),
    ZONE_PUBLIC("publicZone"),
    SUBNET_NAME("name"),
    SUBNET_DESCRIPTION("description"),
    SUBNET_ADDRESS("address"),
    SUBNET_NETMASK("netmask"),
    SUBNET_GATEWAY("gateway"),
    ADDRESS_RANGE_MIN("minAddress"),
    ADDRESS_RANGE_MAX("maxAddress"),
    L2DOMAIN_NAME("name"),
    L2DOMAIN_DESCRIPTION("description"),
    L2DOMAIN_ADDRESS("address"),
    L2DOMAIN_NETMASK("netmask"),
    L2DOMAIN_GATEWAY("gateway"),
    L2DOMAIN_TEMPLATE_ID("templateID"),
    DHCP_OPTIONS_LENGTH("length"),
    DHCP_OPTIONS_TYPE("type"),
    DHCP_OPTIONS_VALUE("value"),
    DHCP_OPTIONS_ACTUAL_TYPE("actualType", (Type)((Object)Integer.class)),
    DHCP_OPTIONS_ACTUAL_VALUES("actualValues", Types.LIST_OF_STRINGS),
    ACLTEMPLATES_ACTIVE("active", (Type)((Object)Boolean.class)),
    ACLTEMPLATES_PRIORITY("priority", (Type)((Object)Integer.class)),
    ACLTEMPLATES_PRIORITY_TYPE("priorityType", (Type)((Object)Acl.AclTemplatePriorityType.class)),
    ACLTEMPLATES_POLICY_STATE("policyState", (Type)((Object)Acl.AclPolicyState.class)),
    ACLTEMPLATES_ENTRIES("ACLEntries", NuageVspObjectTypeAdapter.LIST_TYPE),
    ACLTEMPLATES_ALLOW_NON_IP("defaultAllowNonIP", (Type)((Object)Boolean.class)),
    ACLTEMPLATES_ALLOW_IP("defaultAllowIP", (Type)((Object)Boolean.class)),
    ACLTEMPLATES_ENTRY_LOCATION_TYPE("locationType", (Type)((Object)Acl.AclEntryLocationType.class)),
    ACLTEMPLATES_ENTRY_NETWORK_TYPE("networkType", (Type)((Object)Acl.AclEntryNetworkType.class)),
    ACLTEMPLATES_ENTRY_LOCATION_ID("locationID"),
    ACLTEMPLATES_ENTRY_NETWORK_ID("networkID"),
    ACLTEMPLATES_ENTRY_SOURCE_PORT("sourcePort"),
    ACLTEMPLATES_ENTRY_DEST_PORT("destinationPort"),
    ACLTEMPLATES_ENTRY_PROTOCOL("protocol", (Type)((Object)Protocol.class)),
    ACLTEMPLATES_ENTRY_PRIORITY("priority", (Type)((Object)Integer.class)),
    ACLTEMPLATES_ENTRY_ACTION("action", (Type)((Object)Acl.AclAction.class)),
    ACLTEMPLATES_ENTRY_ETHER_TYPE("etherType", (Type)((Object)Acl.AclEtherType.class)),
    ACLTEMPLATES_ENTRY_ADDR_OVERRIDE("addressOverride"),
    ACLTEMPLATES_ENTRY_REFLEXIVE((Map<NuageVspApiVersion, String>)ImmutableMap.of((Object)NuageVspApiVersion.V3_2, (Object)"reflexive", (Object)NuageVspApiVersion.V4_0, (Object)"stateful")),
    ACLTEMPLATES_ENTRY_DSCP("DSCP"),
    ACLTEMPLATES_ENTRY_DESCRIPTION("description"),
    FIP_RATE_LIMITING_QOS_DESCRIPTION("description"),
    FIP_RATE_LIMITING_QOS_FIP_PEAK_INFORMATION_RATE("FIPPeakInformationRate"),
    FIP_RATE_LIMITING_QOS_FIP_RATE_LIMITING_ACTIVE("FIPRateLimitingActive"),
    FIP_RATE_LIMITING_QOS_FIP_PEAK_BURST_SIZE("FIPPeakBurstSize"),
    FIP_RATE_LIMITING_QOS_NAME("name"),
    FIP_RATE_LIMITING_QOS_ACTIVE("active", (Type)((Object)Boolean.class)),
    VM_NAME("name"),
    VM_DESCRIPTION("description"),
    VM_UUID("UUID"),
    VM_STATUS("status"),
    VM_INTERFACES("interfaces", NuageVspObjectTypeAdapter.LIST_TYPE),
    VM_INTERFACE_NAME("name"),
    VM_INTERFACE_MAC("MAC"),
    VM_INTERFACE_ATTACHED_NETWORK_ID("attachedNetworkID"),
    VM_INTERFACE_ATTACHED_NETWORK_TYPE("attachedNetworkType"),
    VM_INTERFACE_GATEWAY("gateway"),
    VM_INTERFACE_IPADDRESS("IPAddress"),
    VM_INTERFACE_NETMASK("netmask"),
    VM_INTERFACE_VPORT_ID("VPortID"),
    VM_INTERFACE_DOMAIN_ID("domainID"),
    VM_INTERFACE_DOMAIN_NAME("domainName"),
    VM_INTERFACE_ZONE_NAME("zoneName"),
    VM_INTERFACE_NETWORK_NAME("networkName"),
    VM_INTERFACE_VPORT_NAME("VPortName"),
    VM_INTERFACE_ASSOCIATED_FIP("associatedFloatingIPAddress"),
    VM_INTERFACE_VM_UUID("VMUUID"),
    SHARED_RESOURCE_ADRESS("address"),
    SHARED_RESOURCE_GATEWAY("gateway"),
    SHARED_RESOURCE_NETMASK("netmask"),
    SHARED_RESOURCE_NAME("name"),
    SHARED_RESOURCE_DESCRIPTION("description"),
    SHARED_RESOURCE_TYPE("type", (Type)((Object)NuageVspConstants.SharedNetworkType.class)),
    SHARED_RESOURCE_UNDERLAY("underlay", (Type)((Object)Boolean.class)),
    SHARED_RESOURCE_PARENT_ID("sharedResourceParentID"),
    ASSOC_SHARED_NTWK_ID("associatedSharedNetworkResourceID"),
    FLOATING_IP_ADDRESS("address"),
    FLOATING_IP_ASSIGNED("assigned"),
    FLOATING_IP_ACCESS_CONTROL("accessControl"),
    VIRTUAL_IP_MAC("MAC"),
    VIRTUAL_IP_ADDRESS("virtualIP"),
    VIRTUAL_IP_FLOATING_IP_ID("associatedFloatingIPID"),
    VPORT_NAME("name"),
    VPORT_TYPE("type"),
    VPORT_ACTIVE("active"),
    VPORT_ADDRESSSPOOFING("addressSpoofing", (Type)((Object)NuageVspConstants.AddressSpoofing.class)),
    VPORT_DESCRIPTION("description"),
    VPORT_FLOATING_IP_ID("associatedFloatingIPID"),
    ENTERPRISE_NTWK_MACRO_NAME("name"),
    ENTERPRISE_NTWK_MACRO_DESCRIPTION("description"),
    ENTERPRISE_NTWK_MACRO_ADDRESS("address"),
    ENTERPRISE_NTWK_MACRO_NETMASK("netmask"),
    ENTERPRISE_PROFILE_NAME("name"),
    ENTERPRISE_PROFILE_DESCRIPTION("description"),
    ENTERPRISE_PROFILE_FLOATING_IP_QUOTA("floatingIPsQuota"),
    ENTERPRISE_PROFILE_GATEWAY_MGMT("allowGatewayManagement"),
    ENTERPRISE_PROFILE_FWD_CLASSES("allowedForwardingClasses", Types.LIST_OF_STRINGS),
    ENTERPRISE_PROFILE_ADV_QOS("allowAdvancedQOSConfiguration"),
    POLICY_GROUP_TYPE("type"),
    POLICY_GROUP_EXTERNAL("external"),
    POLICY_GROUP_TEMPLATE_ID("templateID"),
    GATEWAY_SYSTEMID("systemID"),
    WAN_SERVICE_VPN_CONNECT_ID("associatedVPNConnectID"),
    VPN_CONNECTION_WANSERVICE_ID("associatedWANServiceID"),
    VPN_CONNECTION_WANSERVICE_NAME("name"),
    STATIC_ROUTE_ADDRESS("address"),
    STATIC_ROUTE_NETMASK("netmask"),
    STATIC_ROUTE_NEXTHOP("nextHopIp"),
    ENTERPRISEPERMISSION_PERMITTED_ENTITYID("permittedEntityID"),
    ENTERPRISEPERMISSION_PERMITTED_ENTITYYPE("permittedEntityType"),
    ENTERPRISEPERMISSION_PERMITTED_ACTION("permittedAction"),
    CLOUD_MGMT_SYSTEM_NAME("name");

    private static Map<NuageVspApiVersion, Map<String, NuageVspAttribute>> lookup;
    private Type type;
    private Map<NuageVspApiVersion, String> attributeName = Maps.newHashMap();

    private NuageVspAttribute(String attributeName, Type type) {
        for (NuageVspApiVersion apiVersion : NuageVspApiVersion.SUPPORTED_VERSIONS) {
            this.attributeName.put(apiVersion, attributeName);
        }
        this.type = type;
    }

    private NuageVspAttribute(Map<NuageVspApiVersion, String> attributeNames, Type type) {
        if (attributeNames.size() > NuageVspApiVersion.SUPPORTED_VERSIONS.length) {
            throw new IllegalArgumentException("Can't specify more attribute names (" + attributeNames.size() + ") than there are supported versions (" + NuageVspApiVersion.SUPPORTED_VERSIONS.length + ")");
        }
        for (NuageVspApiVersion apiVersion : NuageVspApiVersion.SUPPORTED_VERSIONS) {
            if (!attributeNames.containsKey(apiVersion)) {
                throw new IllegalArgumentException("Please specify the attribute name for each supported version. Attribute " + this.name() + " is missing attribute name for " + apiVersion);
            }
            this.attributeName.put(apiVersion, attributeNames.get(apiVersion));
        }
        this.type = type;
    }

    private NuageVspAttribute(String attributeName) {
        this(attributeName, (Type)((Object)String.class));
    }

    private NuageVspAttribute(Map<NuageVspApiVersion, String> attributeNames) {
        this(attributeNames, (Type)((Object)String.class));
    }

    @Deprecated
    public String getAttributeName() {
        return this.attributeName.get(NuageVspApiVersion.CURRENT);
    }

    public String getAttributeName(NuageVspApiVersion apiVersion) {
        return this.attributeName.get(apiVersion);
    }

    public static NuageVspAttribute lookup(NuageVspApiVersion apiVersion, String attributeName) {
        return lookup.get(apiVersion).get(attributeName);
    }

    public static NuageVspAttribute lookup(NuageVspApiVersion apiVersion, String attributeName, NuageVspEntity entityType) {
        for (NuageVspAttribute attr : entityType.getAttributes()) {
            if (!attr.getAttributeName(apiVersion).equals(attributeName)) continue;
            return attr;
        }
        return null;
    }

    public String toString() {
        return this.getAttributeName(NuageVspApiVersion.CURRENT);
    }

    public Type getType() {
        return this.type;
    }

    static {
        lookup = new HashMap<NuageVspApiVersion, Map<String, NuageVspAttribute>>();
        for (NuageVspApiVersion apiVersion : NuageVspApiVersion.SUPPORTED_VERSIONS) {
            HashMap<String, NuageVspAttribute> attributes = new HashMap<String, NuageVspAttribute>();
            lookup.put(apiVersion, attributes);
            for (NuageVspAttribute attribute : NuageVspAttribute.values()) {
                attributes.put(attribute.getAttributeName(apiVersion), attribute);
            }
        }
    }

    private static class Types {
        public static final Type LIST_OF_STRINGS = new TypeToken<List<String>>(){}.getType();

        private Types() {
        }
    }
}

