/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common.model;

import com.google.common.base.Function;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import net.nuage.vsp.acs.client.common.NuageVspApiVersion;
import net.nuage.vsp.acs.client.common.model.NuageVspAttribute;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;
import org.apache.commons.lang.ObjectUtils;

public class NuageVspObject
implements Serializable {
    private EnumMap<NuageVspAttribute, Object> data;
    private NuageVspEntity entity;
    private NuageVspApiVersion apiVersion;
    private final Function<NuageVspAttribute, String> getAttributeValueFunction = new Function<NuageVspAttribute, String>(){

        public String apply(NuageVspAttribute attribute) {
            return (String)NuageVspObject.this.get(attribute);
        }
    };

    public NuageVspObject(NuageVspApiVersion apiVersion, NuageVspEntity entity) {
        this.data = new EnumMap(NuageVspAttribute.class);
        this.apiVersion = apiVersion;
        this.entity = entity;
    }

    public NuageVspObject(NuageVspApiVersion apiVersion, NuageVspEntity entity, String entityId) {
        this(apiVersion, entity);
        this.setId(entityId);
    }

    public <T> T get(NuageVspAttribute field) {
        assert (this.entity.hasAttribute(field));
        return (T)this.data.get((Object)field);
    }

    public void set(NuageVspAttribute field, Object value) {
        assert (this.entity.hasAttribute(field));
        this.data.put(field, value);
    }

    public boolean hasAttribute(NuageVspAttribute field) {
        return this.data.containsKey((Object)field);
    }

    public NuageVspApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public NuageVspEntity getEntityType() {
        return this.entity;
    }

    public void setExternalId(String value) {
        this.set(NuageVspAttribute.EXTERNAL_ID, value);
    }

    public void setId(String value) {
        this.set(NuageVspAttribute.ID, value);
    }

    public String getId() {
        return (String)this.get(NuageVspAttribute.ID);
    }

    public String getExternalId() {
        return (String)this.get(NuageVspAttribute.EXTERNAL_ID);
    }

    public String getName() {
        return (String)this.entity.getNameAttribute().transform(this.getAttributeValueFunction).orNull();
    }

    public String getDescription() {
        try {
            return (String)this.entity.getDescriptionAttribute().transform(this.getAttributeValueFunction).orNull();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public boolean entriesEqualTo(Object o) {
        if (o == null || !(o instanceof NuageVspObject)) {
            return false;
        }
        NuageVspObject other = (NuageVspObject)o;
        if (!this.entity.equals((Object)other.getEntityType())) {
            return false;
        }
        for (Map.Entry<NuageVspAttribute, Object> entry : other.data.entrySet()) {
            Object thatValue;
            Object thisValue = this.data.get((Object)entry.getKey());
            if (ObjectUtils.equals((Object)thisValue, (Object)(thatValue = entry.getValue()))) continue;
            return false;
        }
        return true;
    }

    public Set<Map.Entry<NuageVspAttribute, Object>> entrySet() {
        return this.data.entrySet();
    }

    public String toString() {
        return this.data.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NuageVspObject)) {
            return false;
        }
        NuageVspObject other = (NuageVspObject)obj;
        return this.data.equals((Object)other.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }
}

