/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common.model.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.nuage.vsp.acs.client.common.FilterProcessor;
import net.nuage.vsp.acs.client.common.NuageVspApiVersion;
import net.nuage.vsp.acs.client.common.model.NuageVspAttribute;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;
import net.nuage.vsp.acs.client.common.model.NuageVspObject;

public class NuageVspObjectTypeAdapter
implements JsonDeserializer<NuageVspObject>,
JsonSerializer<NuageVspObject> {
    public static final Type LIST_TYPE = new TypeToken<List<NuageVspObject>>(){}.getType();
    private NuageVspEntity entity;
    private NuageVspApiVersion apiVersion;
    private String externalIdSuffix;
    private String cmsId;

    public NuageVspObjectTypeAdapter(NuageVspEntity entity, NuageVspApiVersion apiVersion, String cmsId) {
        this.entity = entity;
        this.apiVersion = apiVersion;
        this.cmsId = cmsId;
        this.externalIdSuffix = "@" + cmsId;
    }

    public void setEntity(NuageVspEntity entity) {
        this.entity = entity;
    }

    public NuageVspObject deserialize(JsonElement src, Type srcType, JsonDeserializationContext context) throws JsonParseException {
        return this.deserialize(this.entity, src, context);
    }

    private NuageVspObject deserialize(NuageVspEntity entity, JsonElement src, JsonDeserializationContext context) throws JsonParseException {
        NuageVspObject obj = new NuageVspObject(this.apiVersion, entity);
        JsonObject json = src.getAsJsonObject();
        for (Map.Entry entry : json.entrySet()) {
            NuageVspAttribute attribute = NuageVspAttribute.lookup(this.apiVersion, (String)entry.getKey(), entity);
            JsonElement jsonValue = (JsonElement)entry.getValue();
            if (jsonValue.isJsonNull()) continue;
            Object value = null;
            if (jsonValue.isJsonPrimitive()) {
                value = this.deserializePrimitive(context, obj, attribute, jsonValue);
                if (value == null) {
                    continue;
                }
            } else if (jsonValue.isJsonObject()) {
                value = context.deserialize(jsonValue, NuageVspObject.class);
            } else if (jsonValue.isJsonArray()) {
                if (attribute.getType().equals(LIST_TYPE)) {
                    value = this.deserializeChild(entity, context, jsonValue);
                } else {
                    context.deserialize(jsonValue, List.class);
                }
            }
            if (value == null) continue;
            obj.set(attribute, value);
        }
        return obj;
    }

    private Object deserializePrimitive(JsonDeserializationContext context, NuageVspObject obj, NuageVspAttribute attribute, JsonElement jsonValue) {
        Object value = null;
        JsonPrimitive primitive = jsonValue.getAsJsonPrimitive();
        if (primitive.isBoolean()) {
            value = primitive.getAsBoolean();
        } else if (primitive.isNumber()) {
            Number n = jsonValue.getAsNumber();
            value = attribute.getType() == Integer.class ? (Number)n.intValue() : (Number)(attribute.getType() == Long.class ? (Number)n.longValue() : (Number)n);
        } else if (primitive.isString()) {
            String primitiveAsString = primitive.getAsString();
            if (FilterProcessor.EXTERNAL_ID_FIELDS.contains((Object)attribute) && primitiveAsString.endsWith(this.externalIdSuffix)) {
                value = primitiveAsString.substring(0, primitiveAsString.length() - this.externalIdSuffix.length());
                obj.set(NuageVspAttribute.CMS_ID, this.cmsId);
            } else {
                value = context.deserialize(jsonValue, attribute.getType());
            }
        }
        return value;
    }

    private Object deserializeChild(NuageVspEntity entity, JsonDeserializationContext context, JsonElement jsonValue) {
        NuageVspEntity childEntity;
        switch (entity) {
            case EGRESS_ACLTEMPLATES: {
                childEntity = NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES;
                break;
            }
            case EGRESS_DOMAIN_FIP_ACLTEMPLATES: {
                childEntity = NuageVspEntity.EGRESS_DOMAIN_FIP_ACLTEMPLATES_ENTRIES;
                break;
            }
            case INGRESS_ACLTEMPLATES: {
                childEntity = NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES;
                break;
            }
            case VM: {
                childEntity = NuageVspEntity.VM_INTERFACE;
                break;
            }
            default: {
                throw new JsonParseException("Unexpected Child entity");
            }
        }
        LinkedList<NuageVspObject> elements = new LinkedList<NuageVspObject>();
        for (JsonElement element : jsonValue.getAsJsonArray()) {
            elements.add(this.deserialize(childEntity, element, context));
        }
        LinkedList<NuageVspObject> value = elements;
        return value;
    }

    public JsonElement serialize(NuageVspObject entity, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        for (NuageVspAttribute attribute : entity.getEntityType().getAttributes()) {
            if (!entity.hasAttribute(attribute)) continue;
            Object o = entity.get(attribute);
            Object value = FilterProcessor.EXTERNAL_ID_FIELDS.contains((Object)attribute) ? new JsonPrimitive(o.toString() + this.externalIdSuffix) : context.serialize(o);
            jsonObject.add(attribute.getAttributeName(this.apiVersion), value);
        }
        return jsonObject;
    }
}

