/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common.utils;

import java.lang.reflect.Array;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.net.util.SubnetUtils;

public class NetUtils {
    private static final int MAX_CIDR = 32;

    public static boolean isValidIp(String ip) {
        if (ip.endsWith(".")) {
            return false;
        }
        String[] ipAsList = ip.split("\\.");
        if (Array.getLength(ipAsList) != 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            int octet;
            String octetString = ipAsList[i];
            try {
                octet = Integer.parseInt(octetString);
            }
            catch (Exception e) {
                return false;
            }
            if (octet < 0 || octet > 255) {
                return false;
            }
            if (octetString.length() >= 1 && octetString.length() <= 3) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidCIDR(String cidr) {
        if (cidr == null || cidr.isEmpty()) {
            return false;
        }
        String[] cidrPair = cidr.split("\\/");
        if (cidrPair.length != 2) {
            return false;
        }
        String cidrAddress = cidrPair[0];
        String cidrSize = cidrPair[1];
        if (!NetUtils.isValidIp(cidrAddress)) {
            return false;
        }
        int cidrSizeNum = -1;
        try {
            cidrSizeNum = Integer.parseInt(cidrSize);
        }
        catch (Exception e) {
            return false;
        }
        return cidrSizeNum >= 0 && cidrSizeNum <= 32;
    }

    public static Long[] cidrToLong(String cidr) {
        if (cidr == null || cidr.isEmpty()) {
            return null;
        }
        String[] cidrPair = cidr.split("\\/");
        if (cidrPair.length != 2) {
            return null;
        }
        String cidrAddress = cidrPair[0];
        String cidrSize = cidrPair[1];
        if (!NetUtils.isValidIp(cidrAddress)) {
            return null;
        }
        int cidrSizeNum = -1;
        try {
            cidrSizeNum = Integer.parseInt(cidrSize);
        }
        catch (Exception e) {
            return null;
        }
        long numericNetmask = -1 >> 32 - cidrSizeNum << 32 - cidrSizeNum;
        long ipAddr = NetUtils.ip2Long(cidrAddress);
        Long[] cidrlong = new Long[]{ipAddr & numericNetmask, cidrSizeNum};
        return cidrlong;
    }

    public static String getCidrSubNet(String cidr) {
        int cidrSizeNum;
        if (cidr == null || cidr.isEmpty()) {
            return null;
        }
        String[] cidrPair = cidr.split("/");
        if (cidrPair.length != 2) {
            return null;
        }
        String cidrAddress = cidrPair[0];
        String cidrSize = cidrPair[1];
        if (!NetUtils.isValidIp(cidrAddress)) {
            return null;
        }
        try {
            cidrSizeNum = Integer.parseInt(cidrSize);
        }
        catch (Exception e) {
            return null;
        }
        long numericNetmask = -1 >> 32 - cidrSizeNum << 32 - cidrSizeNum;
        String netmask = NetUtils.long2Ip(numericNetmask);
        return NetUtils.getSubNet(cidrAddress, netmask);
    }

    public static String getCidrNetmask(long cidrSize) {
        long numericNetmask = -1 >> (int)(32L - cidrSize) << (int)(32L - cidrSize);
        return NetUtils.long2Ip(numericNetmask);
    }

    public static String getCidrNetmask(String cidr) {
        String[] cidrPair = cidr.split("/");
        long guestCidrSize = Long.parseLong(cidrPair[1]);
        return NetUtils.getCidrNetmask(guestCidrSize);
    }

    public static Pair<String, String> cidrToSubnetNetmask(String sourceCidr) {
        String subnet = NetUtils.getCidrSubNet(sourceCidr);
        long cidrSize = new Long(sourceCidr.substring(sourceCidr.indexOf("/") + 1));
        String netmask = cidrSize == 0L ? "0.0.0.0" : NetUtils.getCidrNetmask(sourceCidr);
        return Pair.of((Object)subnet, (Object)netmask);
    }

    public static String long2Ip(long ip) {
        return String.valueOf(ip >> 24 & 0xFFL) + "." + (ip >> 16 & 0xFFL) + "." + (ip >> 8 & 0xFFL) + "." + (ip & 0xFFL);
    }

    public static String getSubNet(String ip, String netmask) {
        long ipAddr = NetUtils.ip2Long(ip);
        long subnet = NetUtils.ip2Long(netmask);
        long result = ipAddr & subnet;
        return NetUtils.long2Ip(result);
    }

    public static long ip2Long(String ip) {
        String[] tokens = ip.split("[.]");
        assert (tokens.length == 4);
        long result = 0L;
        for (String token : tokens) {
            try {
                result = result << 8 | (long)Integer.parseInt(token);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Incorrect number", e);
            }
        }
        return result;
    }

    public static boolean isIpWithinCidrRange(String ipAddress, String cidr) {
        if (!NetUtils.isValidIp(ipAddress)) {
            return false;
        }
        if (!NetUtils.isValidCIDR(cidr)) {
            return false;
        }
        SubnetUtils subnetUtils = new SubnetUtils(cidr);
        subnetUtils.setInclusiveHostCount(true);
        boolean isInRange = subnetUtils.getInfo().isInRange(ipAddress);
        return isInRange;
    }
}

