/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common.utils;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.UUID;
import net.nuage.vsp.acs.client.common.utils.NetUtils;

public class UuidUtils {
    public static String generateUuidFromExternalIdAndIp(String externalId, String ip) {
        byte[] externalIdBytes = externalId.getBytes();
        byte[] ipBytes = ip.getBytes();
        ByteBuffer bb = ByteBuffer.wrap(new byte[externalIdBytes.length + ipBytes.length]);
        bb.put(externalIdBytes);
        bb.put(ipBytes);
        UUID uuid = UUID.nameUUIDFromBytes(bb.array());
        return uuid.toString();
    }

    public static String generateUuidFromString(String string, String base) {
        byte[] bytes = string.getBytes();
        if (base != null) {
            int size = bytes.length + 16;
            ByteBuffer bb = ByteBuffer.wrap(new byte[size]);
            UUID namespace = UUID.fromString(base);
            bb.putLong(namespace.getMostSignificantBits());
            bb.putLong(namespace.getLeastSignificantBits());
            bb.put(bytes);
            bytes = bb.array();
        }
        UUID uuid = UUID.nameUUIDFromBytes(bytes);
        return uuid.toString();
    }

    public static String generateUuidFromCidr(String cidrList) {
        return UuidUtils.generateUuidFromCidr(cidrList, null);
    }

    public static String generateUuidFromCidr(String cidrList, String base) {
        TreeSet<String> cidrs = new TreeSet<String>(Arrays.asList(cidrList.split(",\\s*")));
        int size = cidrs.size() * 12;
        if (base != null) {
            size += 16;
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[size]);
        if (base != null) {
            UUID namespace = UUID.fromString(base);
            bb.putLong(namespace.getMostSignificantBits());
            bb.putLong(namespace.getLeastSignificantBits());
        }
        for (String cidr : cidrs) {
            Long[] cidrAsLong = NetUtils.cidrToLong(cidr);
            bb.putLong(cidrAsLong[0]);
            bb.putInt(cidrAsLong[1].intValue());
        }
        UUID uuid = UUID.nameUUIDFromBytes(bb.array());
        return uuid.toString();
    }
}

