/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.api;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import net.nuage.vsp.acs.client.api.model.VspAclRule;
import net.nuage.vsp.acs.client.api.model.VspNetwork;
import net.nuage.vsp.acs.client.api.model.VspStaticRoute;
import net.nuage.vsp.acs.client.common.model.Acl;
import net.nuage.vsp.acs.client.common.model.AclRulesDetails;
import net.nuage.vsp.acs.client.common.model.NetworkDetails;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;
import net.nuage.vsp.acs.client.common.model.NuageVspObject;
import net.nuage.vsp.acs.client.exception.NuageVspApiException;
import net.nuage.vsp.acs.client.exception.NuageVspException;

import org.apache.commons.lang3.tuple.Pair;

import com.google.common.collect.Lists;

public interface NuageVspAclClient {
    NuageVspObject findACLTemplate(NuageVspEntity parentType, String parentId, NuageVspEntity aclTemplateType, Acl.AclTemplatePriorityType priorityType, Integer priority) throws
            NuageVspApiException;

    NuageVspObject findOrCreateACLTemplate(String vpcOrSubnetUuid, NuageVspEntity parentType, String parentId, NuageVspEntity aclTemplateType,
            Acl.AclTemplatePriorityType priorityType, Integer priority) throws NuageVspApiException;

    List<NuageVspObject> getACLTemplatesAssociatedToDomain(String networkUuid, NuageVspEntity domainType, String domainId, NuageVspEntity aclTemplateType,
            Acl.AclTemplatePriorityType priorityType,
            boolean throwExceptionIfNotPresent) throws NuageVspException;

    List<NuageVspObject> getACLEntriesAssociatedToLocation(String aclNetworkLocationId, NuageVspEntity aclTemplateType, String aclTemplateId) throws NuageVspApiException;

    Map<String, NuageVspObject> getACLEntriesAssociatedToLocationByExternalId(String aclNetworkLocationId, NuageVspEntity aclTemplateType, String aclTemplateId) throws
            NuageVspApiException;

    void createDefaultRules(VspNetwork vspNetwork, NuageVspEntity nuageVspEntity, String nuageVspEntityId)
            throws NuageVspApiException;

    Pair<NuageVspObject, NuageVspObject> findOrCreateAclTemplates(NetworkDetails networkDetails, Integer priority) throws NuageVspApiException;

    void saveAclRule(String enterpriseId, VspNetwork network, AclRulesDetails aclRulesDetails, AclProgress state, VspAclRule vspAclRule)
            throws NuageVspApiException;

    void createOrDeleteDefaultIngressSubnetBlockAcl(VspNetwork vspNetwork, AclRulesDetails aclRulesDetails) throws NuageVspException;

    void removeAclRule(VspNetwork vspNetwork, AclRulesDetails aclRulesDetails, VspAclRule vspAclRule) throws NuageVspException;

    void resetAllAclRulesInTheNetwork(VspNetwork vspNetwork, NetworkDetails networkDetails, AclRulesDetails aclRulesDetails) throws NuageVspException;

    void applyFIPAccessControl(NuageVspEntity domainType, String domainId, String networkUuid, String staticNatIpUuid, boolean accessControl) throws NuageVspApiException;

    void applyStaticRoutes(NetworkDetails networkDetails, Collection<VspStaticRoute> staticRoutes) throws NuageVspApiException;

    public static class AclProgress {
        public List<String> successfullyAddedIngressACls = Lists.newLinkedList();
        public List<String> successfullyAddedEgressACls  = Lists.newLinkedList();
    }
}
