/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.api;

import net.nuage.vsp.acs.client.api.impl.NuageVspAclClientImpl;
import net.nuage.vsp.acs.client.api.impl.NuageVspApiClientImpl;
import net.nuage.vsp.acs.client.api.impl.NuageVspElementClientImpl;
import net.nuage.vsp.acs.client.api.impl.NuageVspGuruClientImpl;
import net.nuage.vsp.acs.client.api.impl.NuageVspManagerClientImpl;
import net.nuage.vsp.acs.client.api.impl.NuageVspRestApi;
import net.nuage.vsp.acs.client.api.model.VspHost;
import net.nuage.vsp.acs.client.common.NuageVspApiVersion;

import org.apache.log4j.Logger;


public class NuageVspPluginClientLoader {

    private static final Logger s_logger = Logger.getLogger(NuageVspPluginClientLoader.class);

    private VspHost _vspHost;
    private NuageVspApiClient _nuageVspApiClient;
    private NuageVspAclClient _nuageVspAclClient;
    private NuageVspElementClient _nuageVspElementClient;
    private NuageVspGuruClient _nuageVspGuruClient;
    private NuageVspManagerClient _nuageVspManagerClient;

    private NuageVspPluginClientLoader(VspHost vspHost) {
        this._vspHost = vspHost;

        NuageVspRestApi api = new NuageVspRestApi(vspHost);
        _nuageVspAclClient = new NuageVspAclClientImpl(api);
        _nuageVspApiClient = new NuageVspApiClientImpl(api, _nuageVspAclClient);
        _nuageVspElementClient = new NuageVspElementClientImpl(_nuageVspApiClient, _nuageVspAclClient);
        _nuageVspGuruClient = new NuageVspGuruClientImpl(_nuageVspApiClient, _nuageVspAclClient);
        _nuageVspManagerClient = new NuageVspManagerClientImpl(_nuageVspApiClient, _nuageVspAclClient);
    }


    public static NuageVspPluginClientLoader getClientLoader(VspHost vspHost) {
        NuageVspPluginClientLoader nuageVspPluginClientClassloader = new NuageVspPluginClientLoader(vspHost);
        return nuageVspPluginClientClassloader;
    }

    public NuageVspApiClient getNuageVspApiClient() {
        return _nuageVspApiClient;
    }

    public NuageVspAclClient getNuageVspAclClient() {
        return _nuageVspAclClient;
    }

    public NuageVspElementClient getNuageVspElementClient() {
        return _nuageVspElementClient;
    }

    public NuageVspGuruClient getNuageVspGuruClient() {
        return _nuageVspGuruClient;
    }

    public NuageVspManagerClient getNuageVspManagerClient() {
        return _nuageVspManagerClient;
    }
}
