/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.api.model;

import net.nuage.vsp.acs.client.common.model.NuageVspFilter;

/**
 * Created by maximusf on 5/7/15.
 */
public class NuageVspPaging {
    NuageVspFilter filter;
    Long pageSize;
    Integer page;

    public static NuageVspPaging paging() {
        return new NuageVspPaging();
    }

    public NuageVspPaging filter(NuageVspFilter filter) {
        this.filter = filter;
        return this;
    }

    public NuageVspPaging pageSize(Long pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public NuageVspPaging page(Integer page) {
        this.page = page;
        return this;
    }

    public NuageVspFilter getFilter() {
        return filter;
    }

    public Long getPageSize() {
        return pageSize;
    }

    public Integer getPage() {
        return page;
    }

    public boolean hasFilter() {
        return filter != null;
    }

    public boolean hasPageSize() {
        return pageSize != null;
    }

    public boolean hasPage() {
        return page != null;
    }
}
