/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.api.model;

public class VspApiDefaults extends VspObject {
    private final String version;
    private final Long retryCount;
    private final Long retryInterval;

    private VspApiDefaults(String version, Long retryCount, Long retryInterval) {
        this.version = version;
        this.retryCount = retryCount;
        this.retryInterval = retryInterval;
    }

    public String getVersion() {
        return version;
    }

    public Long getRetryCount() {
        return retryCount;
    }

    public Long getRetryInterval() {
        return retryInterval;
    }

    public static class Builder extends VspBuilder<Builder, VspApiDefaults> {
        private String version;
        private Long retryCount;
        private Long retryInterval;

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder retryCount(Long retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public Builder retryInterval(Long retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        @Override
        public VspApiDefaults build() {
            return new VspApiDefaults(version, retryCount, retryInterval);
        }

        @Override
        public Builder fromObject(VspApiDefaults obj) {
            return new Builder().version(obj.getVersion()).retryCount(obj.getRetryCount()).retryInterval(obj.getRetryInterval());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof VspApiDefaults)) return false;

        VspApiDefaults that = (VspApiDefaults) o;

        if (retryCount != null ? !retryCount.equals(that.retryCount) : that.retryCount != null) return false;
        if (retryInterval != null ? !retryInterval.equals(that.retryInterval) : that.retryInterval != null)
            return false;
        if (version != null ? !version.equals(that.version) : that.version != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = version != null ? version.hashCode() : 0;
        result = 31 * result + (retryCount != null ? retryCount.hashCode() : 0);
        result = 31 * result + (retryInterval != null ? retryInterval.hashCode() : 0);
        return result;
    }
}
