/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.api.model;

import java.util.List;
import java.util.Objects;

public class VspDhcpDomainOption {

    private final Boolean vrIsDnsProvider;
    private final String networkDomain;
    private final List<String> dnsServers;

    private VspDhcpDomainOption(Boolean vrIsDnsProvider, String networkDomain, List<String> dnsSerevers) {
        this.vrIsDnsProvider = vrIsDnsProvider;
        this.networkDomain = networkDomain;
        this.dnsServers = dnsSerevers;
    }

    public Boolean getVrIsDnsProvider() {
        return vrIsDnsProvider;
    }

    public String getNetworkDomain() {
        return networkDomain;
    }

    public List<String> getDnsServers() {
        return dnsServers;
    }

    public static class Builder extends VspBuilder<Builder, VspDhcpDomainOption> {
        private Boolean vrIsDnsProvider;
        private String networkDomain;
        private List<String> dnsServers;

        public Builder vrIsDnsProvider(Boolean vrIsDnsProvider) {
            this.vrIsDnsProvider = vrIsDnsProvider;
            return this;
        }

        public Builder networkDomain(String networkDomain) {
            this.networkDomain = networkDomain;
            return this;
        }

        public Builder dnsServers(List<String> dnsServers) {
            this.dnsServers = dnsServers;
            return this;
        }

        @Override
        public VspDhcpDomainOption build() {
            return new VspDhcpDomainOption(vrIsDnsProvider, networkDomain, dnsServers);
        }

        @Override
        public Builder fromObject(VspDhcpDomainOption obj) {
            return new Builder().vrIsDnsProvider(obj.getVrIsDnsProvider()).networkDomain(obj.getNetworkDomain()).dnsServers(obj.getDnsServers());
        }
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VspDhcpDomainOption)) {
            return false;
        }

        VspDhcpDomainOption that = (VspDhcpDomainOption) o;

        return Objects.equals(dnsServers, that.dnsServers)
            && Objects.equals(networkDomain, that.networkDomain)
            && Objects.equals(vrIsDnsProvider, that.vrIsDnsProvider);
    }

    @Override
    public int hashCode() {
        return Objects.hash(vrIsDnsProvider, networkDomain, dnsServers);
    }
}
