/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.api.model;

/**
 * WARNING:
 * Despite the name, this object contains information of a CloudStack domain,
 * Not about a VSD Domain
 */
public class VspDomain extends VspObject {
    private final String uuid;
    private final String name;
    private final String path;

    private VspDomain(String uuid, String name, String path) {
        this.uuid = uuid;
        this.name = name;
        this.path = path;
    }

    public String getUuid() {
        return uuid;
    }

    public String getName() {
        return name;
    }

    public String getPath() {
        return path;
    }

    public static class Builder extends VspBuilder<Builder, VspDomain> {
        private String uuid;
        private String name;
        private String path;

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        @Override
        public VspDomain build() {
            return new VspDomain(uuid, name, path);
        }

        @Override
        public Builder fromObject(VspDomain obj) {
            return new Builder().uuid(obj.getUuid()).name(obj.getName()).path(obj.getPath());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof VspDomain)) return false;

        VspDomain vspDomain = (VspDomain) o;

        if (name != null ? !name.equals(vspDomain.name) : vspDomain.name != null) return false;
        if (path != null ? !path.equals(vspDomain.path) : vspDomain.path != null) return false;
        if (uuid != null ? !uuid.equals(vspDomain.uuid) : vspDomain.uuid != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = uuid != null ? uuid.hashCode() : 0;
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + (path != null ? path.hashCode() : 0);
        return result;
    }
}
