/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.api.model;

import java.util.Objects;

public class VspStaticNat extends VspObject {
    public enum State {
        Allocating, Allocated, Releasing, Free
    }

    private final State state;
    private final String ipUuid;
    private final String ipAddress;
    private final VspNic vspNic;
    private final Boolean revoke;
    private final Boolean oneToOneNat;
    private final String vlanUuid;
    private final String vlanGateway;
    private final String vlanNetmask;
    private final boolean vlanUnderlay;

    private VspStaticNat(State state, String ipUuid, String ipAddress, VspNic vspNic, Boolean revoke, Boolean oneToOneNat, String vlanUuid,
                         String vlanGateway, String vlanNetmask, boolean vlanUnderlay) {
        this.state = state;
        this.ipUuid = ipUuid;
        this.ipAddress = ipAddress;
        this.vspNic = vspNic;
        this.revoke = revoke;
        this.oneToOneNat = oneToOneNat;
        this.vlanUuid = vlanUuid;
        this.vlanGateway = vlanGateway;
        this.vlanNetmask = vlanNetmask;
        this.vlanUnderlay = vlanUnderlay;
    }

    public State getState() {
        return state;
    }

    public String getIpUuid() {
        return ipUuid;
    }

    public String getIpAddress() {
        return ipAddress;
    }

    public VspNic getVspNic() {
        return vspNic;
    }

    public Boolean getRevoke() {
        return revoke;
    }

    public Boolean getOneToOneNat() {
        return oneToOneNat;
    }

    public String getVlanUuid() {
        return vlanUuid;
    }

    public String getVlanGateway() {
        return vlanGateway;
    }

    public String getVlanNetmask() {
        return vlanNetmask;
    }

    public boolean isVlanUnderlay() {
        return vlanUnderlay;
    }

    public static class Builder extends VspBuilder<Builder, VspStaticNat> {
        private State state;
        private String ipUuid;
        private String ipAddress;
        private VspNic vspNic;
        private Boolean revoke;
        private Boolean oneToOneNat;
        private String vlanUuid;
        private String vlanGateway;
        private String vlanNetmask;
        private boolean vlanUnderlay;

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder ipUuid(String ipUuid) {
            this.ipUuid = ipUuid;
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder nic(VspNic vspNic) {
            this.vspNic = vspNic;
            return this;
        }

        public Builder revoke(Boolean revoke) {
            this.revoke = revoke;
            return this;
        }

        public Builder oneToOneNat(Boolean oneToOneNat) {
            this.oneToOneNat = oneToOneNat;
            return this;
        }

        public Builder vlanUuid(String vlanUuid) {
            this.vlanUuid = vlanUuid;
            return this;
        }

        public Builder vlanGateway(String vlanGateway) {
            this.vlanGateway = vlanGateway;
            return this;
        }

        public Builder vlanNetmask(String vlanNetmask) {
            this.vlanNetmask = vlanNetmask;
            return this;
        }

        public Builder vlanUnderlay(boolean vlanUnderlay) {
            this.vlanUnderlay = vlanUnderlay;
            return this;
        }

        @Override
        public VspStaticNat build() {
            return new VspStaticNat(state, ipUuid, ipAddress, vspNic, revoke, oneToOneNat, vlanUuid, vlanGateway, vlanNetmask, vlanUnderlay);
        }

        @Override
        public Builder fromObject(VspStaticNat obj) {
            return new Builder().state(obj.getState()).ipUuid(obj.getIpUuid()).ipAddress(obj.getIpAddress())
                    .nic(obj.getVspNic()).revoke(obj.getRevoke()).oneToOneNat(obj.getOneToOneNat()).vlanUuid(obj.getVlanUuid())
                    .vlanGateway(obj.getVlanGateway()).vlanNetmask(obj.getVlanNetmask()).vlanUnderlay(obj.isVlanUnderlay());

        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof VspStaticNat)) return false;

        VspStaticNat that = (VspStaticNat) o;

        return Objects.equals(this.vlanUnderlay, that.vlanUnderlay)
                && Objects.equals(this.ipAddress, that.ipAddress)
                && Objects.equals(this.ipUuid, that.ipUuid)
                && Objects.equals(this.oneToOneNat, that.oneToOneNat)
                && Objects.equals(this.revoke, that.revoke)
                && Objects.equals(this.state, that.state)
                && Objects.equals(this.vlanGateway, that.vlanGateway)
                && Objects.equals(this.vlanNetmask, that.vlanNetmask)
                && Objects.equals(this.vlanUuid, that.vlanUuid)
                && Objects.equals(this.vspNic, that.vspNic);
    }

    @Override
    public int hashCode() {
        int result = state != null ? state.hashCode() : 0;
        result = 31 * result + (ipUuid != null ? ipUuid.hashCode() : 0);
        result = 31 * result + (ipAddress != null ? ipAddress.hashCode() : 0);
        result = 31 * result + (vspNic != null ? vspNic.hashCode() : 0);
        result = 31 * result + (revoke != null ? revoke.hashCode() : 0);
        result = 31 * result + (oneToOneNat != null ? oneToOneNat.hashCode() : 0);
        result = 31 * result + (vlanUuid != null ? vlanUuid.hashCode() : 0);
        result = 31 * result + (vlanGateway != null ? vlanGateway.hashCode() : 0);
        result = 31 * result + (vlanNetmask != null ? vlanNetmask.hashCode() : 0);
        result = 31 * result + (vlanUnderlay ? 1 : 0);
        return result;
    }
}
