/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.api.model;

/**
 *
 */
public class VspStaticRoute extends VspObject {
    private String uuid;
    private String cidr;
    private String nextHop;
    private boolean revoke;

    public VspStaticRoute(String uuid, String cidr, String nextHop, boolean revoke) {
        this.uuid = uuid;
        this.cidr = cidr;
        this.nextHop = nextHop;
        this.revoke = revoke;
    }

    public String getUuid() {
        return uuid;
    }

    public String getCidr() {
        return cidr;
    }

    public String getNextHop() {
        return nextHop;
    }

    public boolean isRevoke() {
        return revoke;
    }
}
