/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.common;

import java.util.Set;

import net.nuage.vsp.acs.client.common.model.IntCodedEnum;

import com.google.common.collect.ImmutableSet;

public interface NuageVspConstants {

    public interface DefaultAcl {
        int SUBNET_ALLOW_ACL_PRIORITY = 0;
        int VPN_VR_ALLOW_ACL_PRIORITY = 1;

        int SUBNET_BLOCK_ACL_PRIORITY = 10800000;
        int ALLOW_ALL_ACL_PRIORITY = 10000001;

        int DOMAIN_BLOCK_ACL_PRIORITY = 0;

        Set<Integer> FIP_ACL_BLOCKED_PORTS = ImmutableSet.of(80, 8080, 443, 8443);
        int FIP_ACL_BLOCK_PRIORITY = 1;

        int TCP_ALLOW_ACL_PRIORITY = 1;
        int UDP_ALLOW_ACL_PRIORITY = 2;
        int ICMP_ALLOW_ACL_PRIORITY = 3;

        String SUBNET_ALLOW_ACL = "Default Intra-Subnet Allow ACL";
        String VPN_VR_ALLOW_ACL = "VPN Virtual Router Allow ACL";
        String SUBNET_BLOCK_ACL = "Default Subnet ACL to block traffic as there is an ACL list associated with it";
        String DOMAIN_BLOCK_ACL = "Default Intra-Domain Deny ACL";
        String FIP_ACL_BLOCK = "Default Deny FIP ACL TCP Port ";
        String INGRESS_ALLOW_ALL_ACL = "Default Allow All";
        String INGRESS_ALLOW_TCP_ACL = "Default Allow TCP";
        String INGRESS_ALLOW_UDP_ACL = "Default Allow UDP";
        String INGRESS_ALLOW_ICMP_ACL = "Default Allow ICMP";
    }

    public enum SharedNetworkType {
        PUBLIC, L2DOMAIN, UPLINK_SUBNET, FLOATING
    }

    public enum AddressSpoofing {
        ENABLED, DISABLED, INHERITED
    }

    public enum ErrorCode implements IntCodedEnum {
        RESOURCE_NOT_FOUND(200),
        NO_CHANGE_IN_ENTITY(2039),
        DUPLICATE_ACL_PRIORITY(2591),
        NETWORK_MODIFICATION(2506);

        int code;

        ErrorCode(int code) {
            this.code = code;
        }

        public int getCode() {
            return code;
        }
    }

    interface EnterpriseProfileDefaults {
        int FLOATING_IP_QUOTA = 100;
        boolean ALLOW_GATEWAY_MANAGEMENT = false;
        String FWD_CLASSES = "C,D,E,F,G,H";
        boolean ALLOW_ADVANCED_QOS = false;
    }

    public static final String CMS_USER_ENTEPRISE_NAME = "CSP";

    public static final int FLOATING_IP_QUOTA = 249999;

    public static final String DEFAULT_FWD_CLASS = "H";

    public static final String STAR = "*";

    public static final String USER_FIRST_NAME = "FN";
    public static final String USER_LAST_NAME = "LN";
    public static final String USER_EMAIL = "defaultemail@email.com";
    public static final String USER_PASSWORD = "default";

    public static final String ZONE_NAME = "zone";

    public static final String VSP_DEFAULT_PROPERTIES = "vsp-defaults.properties";

    public static final int MIN_ACL_PRIORITY = 9999;
    public static final int MAX_ACL_PRIORITY = 10000000;

    public static final int NUM_OF_PERIODIC_THREADS = 5;

    public static final int SYNC_UP_INTERVAL_IN_MINUTES = 60 * 8;

    public static final String EXTERNAL_ID_DELIMITER = "@";

    public static final Long DEFAULT_API_RETRY_COUNT = 4L;
    public static final Long DEFAULT_API_RETRY_INTERVAL = 60L;
}
