/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.common.model;

import java.util.Map;

public class StaleAclRulesDetails extends AclRulesDetails {
    private final Map<String, NuageVspObject> ingressAclEntries;
    private final Map<String, NuageVspObject> egressAclEntries;
    private final Map<Integer, NuageVspObject> defaultIngressAclEntries;
    private final Map<Integer, NuageVspObject> defaultEgressAclEntries;

    public StaleAclRulesDetails(AclRulesDetails aclRulesDetails, Map<String, NuageVspObject> ingressAclEntries, Map<String, NuageVspObject> egressAclEntries,
            Map<Integer, NuageVspObject> defaultIngressAclEntries, Map<Integer, NuageVspObject> defaultEgressAclEntries) {
        super(aclRulesDetails.getVspAclRules(), aclRulesDetails.isNetworkAcl(), aclRulesDetails.isIngressFirewallRule(), aclRulesDetails.isCreateDefaultRules(),
                aclRulesDetails.getAclNetworkLocationId(), aclRulesDetails.getIngressAclTemplate(), aclRulesDetails.getEgressAclTemplate());
        this.ingressAclEntries = ingressAclEntries;
        this.egressAclEntries = egressAclEntries;
        this.defaultIngressAclEntries = defaultIngressAclEntries;
        this.defaultEgressAclEntries = defaultEgressAclEntries;
    }

    public Map<String, NuageVspObject> getIngressAclEntries() {
        return ingressAclEntries;
    }

    public Map<String, NuageVspObject> getEgressAclEntries() {
        return egressAclEntries;
    }

    public Map<Integer, NuageVspObject> getDefaultIngressAclEntries() {
        return defaultIngressAclEntries;
    }

    public Map<Integer, NuageVspObject> getDefaultEgressAclEntries() {
        return defaultEgressAclEntries;
    }
}
