/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.exception;

import net.nuage.vsp.acs.client.common.NuageVspConstants;
import net.nuage.vsp.acs.client.common.RequestType;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;

public class NuageVspApiException extends NuageVspException {
    private static final long serialVersionUID = 1L;

    private int httpErrorCode;

    private NuageVspConstants.ErrorCode nuageErrorCode;

    private NuageVspEntity entityType;

    private RequestType requestType;

    private String nuageErrorDetails;

    public NuageVspApiException(int httpErrorCode, NuageVspConstants.ErrorCode nuageErrorCode, String errorMessage) {
        super(errorMessage);
        this.httpErrorCode = httpErrorCode;
        this.nuageErrorCode = nuageErrorCode;
    }

    public NuageVspApiException(int httpErrorCode, NuageVspConstants.ErrorCode nuageErrorCode, String errorMessage, Throwable cause) {
        super(errorMessage, cause);
        this.httpErrorCode = httpErrorCode;
        this.nuageErrorCode = nuageErrorCode;
    }

    public NuageVspApiException(int httpErrorCode, String errorMessage, NuageVspConstants.ErrorCode nuageErrorCode, String nuageErrorDetails, NuageVspEntity entityType, RequestType requestType) {
        super(errorMessage);
        this.httpErrorCode = httpErrorCode;
        this.entityType = entityType;
        this.requestType = requestType;
        this.nuageErrorCode = nuageErrorCode;
        this.nuageErrorDetails = nuageErrorDetails;
    }

    public NuageVspApiException(int httpErrorCode, String errorMessage, NuageVspEntity entityType, RequestType requestType) {
        super(errorMessage);
        this.httpErrorCode = httpErrorCode;
        this.entityType = entityType;
        this.requestType = requestType;
    }

    public NuageVspApiException(String errorMessage) {
        super(errorMessage);
    }

    public NuageVspApiException(String errorMessage, Throwable cause) {
        super(errorMessage, cause);
    }

    public int getHttpErrorCode() {
        return httpErrorCode;
    }

    public NuageVspEntity getEntityType() {
        return entityType;
    }

    public void setEntityType(NuageVspEntity entityType) {
        this.entityType = entityType;
    }

    public RequestType getRequestType() {
        return requestType;
    }

    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    public void setHttpErrorCode(int httpErrorCode) {
        this.httpErrorCode = httpErrorCode;
    }

    public NuageVspConstants.ErrorCode getNuageErrorCode() {
        return nuageErrorCode;
    }

    public void setNuageErrorCode(NuageVspConstants.ErrorCode nuageErrorCode) {
        this.nuageErrorCode = nuageErrorCode;
    }

    public String getNuageErrorDetails() {
        return nuageErrorDetails;
    }

    public void setNuageErrorDetails(String nuageErrorDetails) {
        this.nuageErrorDetails = nuageErrorDetails;
    }

    public boolean isNoChangeInEntityException() {
        return nuageErrorCode == NuageVspConstants.ErrorCode.NO_CHANGE_IN_ENTITY;
    }
}
