/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.nuage.vsp.acs.client.api.NuageVspAclClient;
import net.nuage.vsp.acs.client.api.NuageVspApiClient;
import net.nuage.vsp.acs.client.api.impl.NuageVspRestApi;
import net.nuage.vsp.acs.client.api.model.VspAddressRange;
import net.nuage.vsp.acs.client.api.model.VspDhcpDomainOption;
import net.nuage.vsp.acs.client.api.model.VspNetwork;
import net.nuage.vsp.acs.client.api.model.VspNic;
import net.nuage.vsp.acs.client.api.model.VspStaticNat;
import net.nuage.vsp.acs.client.api.model.VspVm;
import net.nuage.vsp.acs.client.common.ConfigUtil;
import net.nuage.vsp.acs.client.common.NuageVspConstants;
import net.nuage.vsp.acs.client.common.model.Acl;
import net.nuage.vsp.acs.client.common.model.Dhcp;
import net.nuage.vsp.acs.client.common.model.DhcpOption;
import net.nuage.vsp.acs.client.common.model.DhcpOptions;
import net.nuage.vsp.acs.client.common.model.NetworkDetails;
import net.nuage.vsp.acs.client.common.model.NuageVspAttribute;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;
import net.nuage.vsp.acs.client.common.model.NuageVspFilter;
import net.nuage.vsp.acs.client.common.model.NuageVspObject;
import net.nuage.vsp.acs.client.common.model.Pair;
import net.nuage.vsp.acs.client.common.utils.Logger;
import net.nuage.vsp.acs.client.common.utils.NetUtils;
import net.nuage.vsp.acs.client.common.utils.UuidUtils;
import net.nuage.vsp.acs.client.exception.NuageVspApiException;
import net.nuage.vsp.acs.client.exception.NuageVspException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.util.SubnetUtils;

public class NuageVspApiClientImpl
implements NuageVspApiClient {
    private static final Logger s_logger = new Logger(NuageVspApiClientImpl.class);
    protected final NuageVspRestApi api;
    private NuageVspAclClient aclClient;

    public NuageVspApiClientImpl(NuageVspRestApi api, NuageVspAclClient aclClient) {
        this.api = api;
        this.aclClient = aclClient;
    }

    @Override
    public boolean entityExists(NuageVspEntity entityType, String entityUuid) throws NuageVspException {
        NuageVspObject entity = this.api.getEntityByExternalId(entityType, null, null, entityUuid);
        return entity != null;
    }

    @Override
    public List<NuageVspObject> createVMInVSP(VspNetwork vspNetwork, VspVm vspVm, VspNic vspNic, NetworkDetails attachedNetworkDetails, DhcpOptions dhcpOptions) throws NuageVspException {
        s_logger.debug("VM with UUID " + vspVm.getUuid() + " does not exist in VSP. So, just add the new VM", new Object[0]);
        List<NuageVspObject> vmInterfacesList = this.buildVmInterfacesList(vspVm, vspNic);
        this.createVportInVsp(vspNic, vspNetwork, vmInterfacesList, attachedNetworkDetails, dhcpOptions);
        NuageVspObject vmEntity = this.api.createNuageVspObject(NuageVspEntity.VM);
        vmEntity.set(NuageVspAttribute.NAME, vspVm.getName());
        vmEntity.set(NuageVspAttribute.VM_UUID, vspVm.getUuid());
        vmEntity.set(NuageVspAttribute.VM_INTERFACES, vmInterfacesList);
        vmEntity.setExternalId(vspVm.getUuid());
        try {
            NuageVspObject vm = this.api.createResource(vmEntity, vspNetwork.getAccountUuid(), vspNetwork.getVspDomain().getUuid());
            s_logger.debug("Created VM in Nuage. Response from VSP is " + vm, new Object[0]);
            return (List)vm.get(NuageVspAttribute.VM_INTERFACES);
        }
        catch (NuageVspApiException e) {
            throw NuageVspRestApi.handleException("Failed to create VM in VSP using REST API", e, new Object[0]);
        }
    }

    @Override
    public List<NuageVspObject> addVMInterfaceToVM(VspNetwork vspNetwork, VspVm vspVm, VspNic vspNic, NetworkDetails attachedNetworkDetails, NuageVspObject vm, DhcpOptions dhcpOptions) throws NuageVspException {
        s_logger.debug("VM with UUID " + vspVm.getUuid() + " already exists in VSP. So, just add the VM new VM interface", new Object[0]);
        String vmId = (String)vm.get(NuageVspAttribute.ID);
        List vmInterfacesFromNuageVSP = (List)vm.get(NuageVspAttribute.VM_INTERFACES);
        NuageVspObject vmInterface = this.findVMInterface(vmInterfacesFromNuageVSP, vspNic.getMacAddress());
        if (vmInterface == null) {
            try {
                List<NuageVspObject> vmInterfacesList = this.buildVmInterfacesList(vspVm, vspNic);
                this.createVportInVsp(vspNic, vspNetwork, vmInterfacesList, attachedNetworkDetails, dhcpOptions);
                NuageVspObject vmInterfaceJson = this.api.createResource(NuageVspEntity.VM, vmId, vmInterfacesList.get(0), vspNetwork.getAccountUuid(), vspNetwork.getVspDomain().getUuid());
                s_logger.debug("Added VM interface to VM in Nuage. Response from VSP is " + vmInterfaceJson, new Object[0]);
                return Arrays.asList(vmInterfaceJson);
            }
            catch (NuageVspApiException exception) {
                throw NuageVspRestApi.handleException("Failed to add VM Interface for the VM with UUID %s for network %s. Json response from VSP REST API is  %s", exception, vspVm.getUuid(), vspNetwork.getUuid(), exception.getMessage());
            }
        }
        String vmInterfaceIp = (String)vmInterface.get(NuageVspAttribute.VM_INTERFACE_IPADDRESS);
        if (!StringUtils.equals((String)vmInterfaceIp, (String)vspNic.getIp())) {
            try {
                if (vspNetwork.isShared()) {
                    boolean subnetMove;
                    String vportId = (String)vmInterface.get(NuageVspAttribute.VM_INTERFACE_VPORT_ID);
                    String vmInterfaceUuid = vmInterface.getExternalId();
                    if (vspNetwork.isPublicAccess()) {
                        this.releaseFIPFromVsp(attachedNetworkDetails, vportId, vmInterfaceUuid, null);
                    }
                    boolean bl = subnetMove = !NetUtils.isIpWithinCidrRange(vmInterfaceIp, vspNetwork.getCidr());
                    if (subnetMove) {
                        NuageVspObject vmInterfaceJson = this.moveVport(vspNetwork, vspVm, vspNic, attachedNetworkDetails, dhcpOptions, vmId, vmInterface, vportId);
                        return Arrays.asList(vmInterfaceJson);
                    }
                    if (vspNetwork.isPublicAccess()) {
                        this.makeInterfacePubliclyReachable(vspNetwork, vspNic.getIp(), attachedNetworkDetails, vportId, vmInterfaceUuid);
                    }
                }
                String vmInterfaceId = (String)vmInterface.get(NuageVspAttribute.ID);
                NuageVspObject updatedVmInterface = this.api.createNuageVspObject(NuageVspEntity.VM_INTERFACE);
                updatedVmInterface.setId(vmInterfaceId);
                updatedVmInterface.set(NuageVspAttribute.VM_INTERFACE_IPADDRESS, vspNic.getIp());
                this.api.updateResource(updatedVmInterface);
                s_logger.debug("Updated VM interface IP from " + vmInterfaceIp + " to " + vspNic.getIp(), new Object[0]);
            }
            catch (NuageVspApiException exception) {
                throw NuageVspRestApi.handleException("Failed to update VM Interface with a new IP for the VM with UUID %s for network %s", exception, vspVm.getUuid(), vspNetwork.getUuid());
            }
        }
        if (dhcpOptions != null) {
            String vportVsdId = this.findEntityIdByExternalUuid(NuageVspEntity.SUBNET, attachedNetworkDetails.getSubnetId(), NuageVspEntity.VPORT, vspNic.getUuid());
            this.createDhcpOptions(false, NuageVspEntity.VPORT, vportVsdId, vspNic.getUuid(), vspNetwork, dhcpOptions);
        }
        return null;
    }

    private void makeInterfacePubliclyReachable(VspNetwork vspNetwork, String nicIp, NetworkDetails attachedNetworkDetails, String vportId, String vmInterfaceUuid) throws NuageVspException {
        String netmask = NetUtils.getCidrNetmask(vspNetwork.getCidr());
        String externalIdFromGateway = vspNetwork.getSubnetExternalId();
        String sharedResourceJson = this.findSharedResource(true, NuageVspConstants.SharedNetworkType.FLOATING, externalIdFromGateway, vspNetwork.getGateway(), netmask);
        if (StringUtils.isBlank((String)sharedResourceJson)) {
            String errorMessage = "Failed to find the Floating IP subnet related to shared network " + vspNetwork.getUuid() + ".";
            s_logger.error((Object)errorMessage, new Object[0]);
            throw new NuageVspException(errorMessage);
        }
        String sharedResourceId = this.getEntityId(sharedResourceJson, NuageVspEntity.SHARED_NETWORK);
        this.allocateFIPToVPortInVsp(attachedNetworkDetails, vportId, sharedResourceId, nicIp, vmInterfaceUuid, null, null);
    }

    private NuageVspObject moveVport(VspNetwork vspNetwork, VspVm vspVm, VspNic vspNic, NetworkDetails attachedNetworkDetails, DhcpOptions dhcpOptions, String vmId, NuageVspObject vmInterface, String vportId) throws NuageVspException {
        this.api.deleteQuietly(NuageVspEntity.VM_INTERFACE, (String)vmInterface.get(NuageVspAttribute.ID));
        this.api.deleteQuietly(NuageVspEntity.VPORT, vportId);
        List<NuageVspObject> vmInterfacesList = this.buildVmInterfacesList(vspVm, vspNic);
        this.createVportInVsp(vspNic, vspNetwork, vmInterfacesList, attachedNetworkDetails, dhcpOptions);
        NuageVspObject vmInterfaceJson = this.api.createResource(NuageVspEntity.VM, vmId, vmInterfacesList.get(0), vspNetwork.getAccountUuid(), vspNetwork.getVspDomain().getUuid());
        s_logger.debug("Added VM interface to VM in Nuage. Response from VSP is " + vmInterfaceJson, new Object[0]);
        return vmInterfaceJson;
    }

    @Override
    public List<NuageVspObject> buildVmInterfacesList(VspVm vspVm, VspNic ... vspNics) {
        ArrayList<NuageVspObject> vmInterfaceList = new ArrayList<NuageVspObject>(vspNics.length);
        for (VspNic vspNic : vspNics) {
            NuageVspObject vmInterfaces = this.api.createNuageVspObject(NuageVspEntity.VM_INTERFACE);
            vmInterfaces.set(NuageVspAttribute.NAME, vspNic.getUuid());
            vmInterfaces.set(NuageVspAttribute.VM_INTERFACE_MAC, vspNic.getMacAddress());
            vmInterfaces.setExternalId(vspNic.getUuid());
            if (vspVm.getDomainRouter() == Boolean.TRUE) {
                vmInterfaces.set(NuageVspAttribute.VM_INTERFACE_IPADDRESS, vspVm.getDomainRouterIp());
            } else if (vspNic.getUseStaticIp() == Boolean.TRUE) {
                vmInterfaces.set(NuageVspAttribute.VM_INTERFACE_IPADDRESS, vspNic.getIp());
            }
            vmInterfaceList.add(vmInterfaces);
        }
        return vmInterfaceList;
    }

    @Override
    public void deleteVmInterface(String vmUuid, String macAddr, String vmInterfaceID) throws NuageVspException {
        try {
            this.api.deleteResource(NuageVspEntity.VM_INTERFACE, vmInterfaceID);
            s_logger.debug("VM Interface is getting destroyed for VM with UUID " + vmUuid + " and it exists in NuageVSP. Deleted the VM interface " + vmInterfaceID + " from Nuage VSP", new Object[0]);
        }
        catch (NuageVspApiException exception) {
            String errorMessage = "Failed to delete VM Interface with MAC " + macAddr + " for the VM with UUID " + vmUuid + " from NUAGE VSP. Json response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
        }
    }

    @Override
    public void deleteVM(String vmUuid, String vmId) {
        try {
            this.api.deleteResource(NuageVspEntity.VM, vmId);
            s_logger.debug("VM " + vmUuid + " is getting destroyed and it exists in NuageVSP. Deleted the VM " + vmId + " from Nuage VSP", new Object[0]);
        }
        catch (NuageVspApiException exception) {
            s_logger.error((Object)("VM " + vmUuid + " is getting destroyed. REST API failed to delete the VM " + vmId + " from NuageVsp. Json response from REST API is " + exception.getMessage()), exception);
        }
    }

    @Override
    public NuageVspObject getVMDetails(String vmUuid) throws NuageVspException {
        String vmJsonString;
        try {
            vmJsonString = this.api.getResources(NuageVspEntity.VM, NuageVspFilter.where(NuageVspAttribute.VM_UUID).eq(vmUuid));
        }
        catch (NuageVspApiException exception) {
            String errorMessage = "Failed to execute REST API call to VSP to get VM with UUID " + vmUuid + ". So, Failed to get IP for the VM from VSP address for VM " + vmUuid + ".  Json response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
            throw new NuageVspException(errorMessage);
        }
        return (NuageVspObject)Iterables.getFirst(this.api.parseJsonString(NuageVspEntity.VM, vmJsonString), null);
    }

    @Override
    public String getOrCreateVSPEnterprise(String domainUuid, String domainName, String domainPath) throws NuageVspException {
        String enterpriseId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, null, null, domainUuid);
        if (StringUtils.isBlank((String)enterpriseId)) {
            enterpriseId = this.createEnterpriseInVSP(domainUuid, this.getEnterpriseName(domainName, domainPath));
        }
        return enterpriseId;
    }

    @Override
    public Pair<String, String> getOrCreateVSPEnterpriseAndGroup(String networksDomainName, String networksDomainPath, String networksDomainUuid, String networksAccountName, String networksAccountUuid) throws NuageVspException {
        NuageVspObject userGroup;
        String userId;
        String enterpriseId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, null, null, networksDomainUuid);
        if (StringUtils.isBlank((String)enterpriseId)) {
            enterpriseId = this.createEnterpriseInVSP(networksDomainUuid, this.getEnterpriseName(networksDomainName, networksDomainPath));
        }
        if (StringUtils.isBlank((String)(userId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.USER, networksAccountUuid)))) {
            userId = this.createUserInEnterprise(enterpriseId, networksAccountUuid, "FN_" + networksAccountUuid, "LN_" + networksAccountUuid, "defaultemail@email.com", DigestUtils.shaHex((String)"default"));
        }
        if ((userGroup = this.api.getEntityByExternalId(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.GROUP, networksAccountUuid)) == null) {
            userGroup = this.createGroupInEnterprise(networksAccountName, networksAccountUuid, enterpriseId);
        }
        this.api.linkRelatedEntity(userGroup, NuageVspEntity.USER, userId);
        return Pair.of(enterpriseId, userGroup.getId());
    }

    @Override
    public String createEnterpriseInVSP(String enterpriseExternalUuid, String enterpriseDescription) throws NuageVspException {
        s_logger.debug("Enterprise with domainUuid " + enterpriseDescription + " does not exist in VSP. So, just create the new Enterprise", new Object[0]);
        String enterpriseProfileId = this.createEnterpriseProfileInVsp(enterpriseExternalUuid, enterpriseDescription);
        NuageVspObject enterpriseEntity = this.api.createNuageVspObject(NuageVspEntity.ENTERPRISE);
        enterpriseEntity.set(NuageVspAttribute.NAME, enterpriseExternalUuid);
        enterpriseEntity.set(NuageVspAttribute.DESCRIPTION, enterpriseDescription);
        enterpriseEntity.setExternalId(enterpriseExternalUuid);
        enterpriseEntity.set(NuageVspAttribute.ENTERPRISE_PROFILE_ID, enterpriseProfileId);
        try {
            NuageVspObject enterprise = this.api.createResource(enterpriseEntity);
            return enterprise.getId();
        }
        catch (NuageVspApiException e) {
            String errorMessage = "Failed to create Enterprise in VSP using REST API. So, Enterprise could not be created in VSP  for domain " + enterpriseExternalUuid + ".  Json response from VSP REST API is  " + e.getMessage();
            s_logger.error((Object)errorMessage, e);
            this.api.deleteQuietly(NuageVspEntity.ENTERPRISE_PROFILE, enterpriseProfileId);
            throw new NuageVspException(errorMessage);
        }
    }

    private String createEnterpriseProfileInVsp(String enterpriseExternalUuid, String enterpriseDescription) throws NuageVspException {
        String enterpriseProfileId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE_PROFILE, null, null, enterpriseExternalUuid);
        if (StringUtils.isBlank((String)enterpriseProfileId)) {
            NuageVspObject enterpriseProfileEntity = this.api.createNuageVspObject(NuageVspEntity.ENTERPRISE_PROFILE);
            enterpriseProfileEntity.set(NuageVspAttribute.NAME, enterpriseExternalUuid);
            enterpriseProfileEntity.set(NuageVspAttribute.DESCRIPTION, enterpriseDescription);
            enterpriseProfileEntity.setExternalId(enterpriseExternalUuid);
            Integer floatingIpQuota = ConfigUtil.getPropertyInteger("floatingIPQuota", 100);
            Boolean allowGatewayMgmt = ConfigUtil.getPropertyBoolean("allowGatewayMgmt", false);
            Boolean allowAdvancedQOS = ConfigUtil.getPropertyBoolean("allowAdvancedQOS", false);
            enterpriseProfileEntity.set(NuageVspAttribute.ENTERPRISE_PROFILE_ADV_QOS, allowAdvancedQOS);
            enterpriseProfileEntity.set(NuageVspAttribute.ENTERPRISE_PROFILE_FLOATING_IP_QUOTA, floatingIpQuota);
            enterpriseProfileEntity.set(NuageVspAttribute.ENTERPRISE_PROFILE_GATEWAY_MGMT, allowGatewayMgmt);
            String availableFwdClass = ConfigUtil.getProperty("availableFwdClass", "C,D,E,F,G,H");
            enterpriseProfileEntity.set(NuageVspAttribute.ENTERPRISE_PROFILE_FWD_CLASSES, Arrays.asList(availableFwdClass.split(",")));
            try {
                NuageVspObject enterpriseProfile = this.api.createResource(enterpriseProfileEntity);
                return enterpriseProfile.getId();
            }
            catch (NuageVspApiException e) {
                String errorMessage = "Failed to create Enterprise Profile in VSP using REST API. So, Enterprise could not be created in VSP  for domain " + enterpriseExternalUuid + ".  Json response from VSP REST API is  " + e.getMessage();
                s_logger.error((Object)errorMessage, e);
                throw new NuageVspException(errorMessage);
            }
        }
        return enterpriseProfileId;
    }

    @Override
    public void deleteEnterpriseInVsp(String enterpriseExternalUuid, String enterpriseDescription) throws NuageVspException {
        try {
            String enterpriseId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, null, null, enterpriseExternalUuid);
            if (StringUtils.isNotBlank((String)enterpriseId)) {
                this.api.deleteResource(NuageVspEntity.ENTERPRISE, enterpriseId);
                s_logger.debug("Enterprise " + enterpriseDescription + " is getting removed and it exists in NuageVSP. Deleted the enterprise " + enterpriseId + " from Nuage VSP", new Object[0]);
                this.deleteEnterpriseProfileInVsp(enterpriseExternalUuid, enterpriseDescription);
            }
        }
        catch (NuageVspApiException e) {
            String errorMessage = "Failed to delete Enterprise in VPS using REST API. Json response from VSP REST API is " + e.getMessage();
            s_logger.error((Object)errorMessage, e);
            throw new NuageVspException(errorMessage);
        }
    }

    private void deleteEnterpriseProfileInVsp(String enterpriseExternalUuid, String enterpriseDescription) throws NuageVspException {
        try {
            String enterpriseProfileId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE_PROFILE, null, null, enterpriseExternalUuid);
            if (StringUtils.isNotBlank((String)enterpriseProfileId)) {
                this.api.deleteResource(NuageVspEntity.ENTERPRISE_PROFILE, enterpriseProfileId);
                s_logger.debug("Enterprise Profile " + enterpriseDescription + " is getting removed and it exists in NuageVSP. Deleted the enterprise profile " + enterpriseProfileId + " from Nuage VSP", new Object[0]);
            }
        }
        catch (NuageVspApiException e) {
            String errorMessage = "Failed to delete Enterprise Profile in VPS using REST API. Json response from VSP REST API is " + e.getMessage();
            s_logger.error((Object)errorMessage, e);
            throw new NuageVspException(errorMessage);
        }
    }

    @Override
    public String createUserInEnterprise(String vsdEnterpriseId, String userNameUuid, String firstName, String lastName, String email, String password) throws NuageVspException {
        try {
            NuageVspObject userEntity = this.api.createNuageVspObject(NuageVspEntity.USER);
            userEntity.setExternalId(userNameUuid);
            userEntity.set(NuageVspAttribute.USER_USERNAME, userNameUuid.replaceAll("-", ""));
            userEntity.set(NuageVspAttribute.USER_EMAIL, email);
            userEntity.set(NuageVspAttribute.USER_PASSWORD, password);
            userEntity.set(NuageVspAttribute.USER_FIRSTNAME, firstName);
            userEntity.set(NuageVspAttribute.USER_LASTNAME, lastName);
            NuageVspObject userJson = this.api.createResource(NuageVspEntity.ENTERPRISE, vsdEnterpriseId, userEntity);
            s_logger.debug("Created user in VSP. Response from VSP is " + userJson, new Object[0]);
            return userJson.getId();
        }
        catch (NuageVspApiException exception) {
            String errorMessage = "Failed to create User for VSP enterprise " + vsdEnterpriseId + ".  Json response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
            throw new NuageVspException(errorMessage);
        }
    }

    public void addPermission(NuageVspEntity entityType, String entityId, Set<String> groupIds) throws NuageVspException {
        try {
            this.api.setRelatedEntities(entityType, entityId, NuageVspEntity.GROUP, groupIds);
            s_logger.debug("Added permission for entity " + (Object)((Object)entityType) + " id " + entityId + " with groups " + groupIds, new Object[0]);
        }
        catch (NuageVspApiException exception) {
            String errorMessage = "Failed to add permission for entity " + (Object)((Object)entityType) + " id " + entityId + ".  Json response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
            throw new NuageVspException(errorMessage);
        }
    }

    @Override
    public NuageVspObject createGroupInEnterprise(String projectOrAccountName, String projectOrAccountUuid, String vsdEnterpriseId) throws NuageVspException {
        try {
            NuageVspObject groupEntity = this.api.createNuageVspObject(NuageVspEntity.GROUP);
            groupEntity.set(NuageVspAttribute.NAME, projectOrAccountUuid);
            groupEntity.set(NuageVspAttribute.DESCRIPTION, projectOrAccountName);
            groupEntity.setExternalId(projectOrAccountUuid);
            NuageVspObject groupJson = this.api.createResource(NuageVspEntity.ENTERPRISE, vsdEnterpriseId, groupEntity);
            s_logger.debug("Created group for project or account " + projectOrAccountUuid + " in VSP . Response from VSP is " + groupJson, new Object[0]);
            return groupJson;
        }
        catch (NuageVspApiException exception) {
            String errorMessage = "Failed to create Group for project or account " + projectOrAccountUuid + ".  Json response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
            throw new NuageVspException(errorMessage);
        }
    }

    public void addUserToGroup(String vsdGroupId, String userId) throws NuageVspException {
        try {
            this.api.linkRelatedEntity(NuageVspEntity.GROUP, vsdGroupId, NuageVspEntity.USER, userId);
        }
        catch (NuageVspApiException exception) {
            String errorMessage = "Failed to add Users for project or account in VSD " + vsdGroupId + ".  Json response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
            throw new NuageVspException(errorMessage);
        }
    }

    @Override
    public Pair<String, String> createNetworkConfigurationWithDefaultACLs(VspNetwork vspNetwork, VspDhcpDomainOption vspDhcpOptions) throws NuageVspException {
        String subnetId;
        String domainId;
        block13: {
            boolean predefinedDomainTemplateSet;
            Pair<String, String> enterpriseAndGroupId = this.getOrCreateVSPEnterpriseAndGroup(vspNetwork.getVspDomain().getName(), vspNetwork.getVspDomain().getPath(), vspNetwork.getVspDomain().getUuid(), vspNetwork.getAccountName(), vspNetwork.getAccountUuid());
            s_logger.debug("Create or find a VPC/Isolated/Shared network associated to network " + vspNetwork.getName() + " in VSP", new Object[0]);
            boolean isVpc = vspNetwork.isVpc();
            Pair<String, String> vpcOrSubnetInfo = vspNetwork.getVpcOrSubnetInfo();
            String domainTemplateId = null;
            String vsdDomainTemplateId = null;
            String vsdDomainTemplateName = null;
            if (StringUtils.isNotBlank((String)vspNetwork.getDomainTemplateName())) {
                String vsdDomainTemplateEntity = this.findEntityUsingFilter(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), NuageVspEntity.DOMAIN_TEMPLATE, NuageVspAttribute.NAME, vspNetwork.getDomainTemplateName());
                NuageVspObject vsdDomainTemplate = this.api.getFirstJsonEntity(NuageVspEntity.DOMAIN_TEMPLATE, vsdDomainTemplateEntity);
                if (vsdDomainTemplate != null) {
                    vsdDomainTemplateId = vsdDomainTemplate.getId();
                    vsdDomainTemplateName = vsdDomainTemplate.getName();
                }
                if (StringUtils.isBlank(vsdDomainTemplateId) || !StringUtils.equals((String)vsdDomainTemplateName, (String)vspNetwork.getDomainTemplateName())) {
                    String errorMessage = "Preconfigured DomainTemplate '" + vspNetwork.getDomainTemplateName() + "' could not be found.";
                    if (isVpc) {
                        errorMessage = errorMessage + " Please remove the VPC Tier before trying again.";
                    }
                    s_logger.error((Object)errorMessage, new Object[0]);
                    throw new NuageVspException(errorMessage);
                }
            }
            boolean createDefaultAcls = !(predefinedDomainTemplateSet = StringUtils.isNotBlank(vsdDomainTemplateId));
            try {
                if (predefinedDomainTemplateSet) {
                    domainId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), NuageVspEntity.DOMAIN, vpcOrSubnetInfo.getLeft());
                    if (StringUtils.isNotBlank((String)domainId)) {
                        subnetId = this.validateDomain(domainId, vspNetwork, vspDhcpOptions);
                    } else {
                        Pair<String, String> domainAndSubnetId = this.createDomainZoneAndSubnet(enterpriseAndGroupId, vsdDomainTemplateId, createDefaultAcls, vspNetwork, vspDhcpOptions);
                        domainId = domainAndSubnetId.getLeft();
                        subnetId = domainAndSubnetId.getRight();
                    }
                    break block13;
                }
                domainTemplateId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), NuageVspEntity.DOMAIN_TEMPLATE, vpcOrSubnetInfo.getLeft());
                if (StringUtils.isNotBlank((String)domainTemplateId)) {
                    s_logger.debug("Domain Template " + domainTemplateId + " already exists for network " + vspNetwork.getName() + " in VSP", new Object[0]);
                    domainId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), NuageVspEntity.DOMAIN, vpcOrSubnetInfo.getLeft());
                    if (StringUtils.isNotBlank((String)domainId)) {
                        subnetId = this.validateDomain(domainId, vspNetwork, vspDhcpOptions);
                        break block13;
                    }
                    throw new NuageVspException("Domain is not found under the DomainTemplate " + domainTemplateId + " for network " + vspNetwork.getName() + " in VSP. There is a network sync issue with VSD");
                }
                NuageVspObject domainTemplateEntity = this.api.createNuageVspObject(NuageVspEntity.DOMAIN_TEMPLATE);
                domainTemplateEntity.set(NuageVspAttribute.NAME, vpcOrSubnetInfo.getLeft());
                domainTemplateEntity.set(NuageVspAttribute.DESCRIPTION, vpcOrSubnetInfo.getRight());
                domainTemplateEntity.setExternalId(vpcOrSubnetInfo.getLeft());
                try {
                    NuageVspObject domainTemplateJson = this.api.createResource(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), domainTemplateEntity);
                    s_logger.debug("Created DomainTemplate for network " + vspNetwork.getName() + " in VSP . Response from VSP is " + domainTemplateJson, new Object[0]);
                    domainTemplateId = domainTemplateJson.getId();
                }
                catch (NuageVspApiException exception) {
                    throw new NuageVspException(" Failed to create DomainTemplate for network " + vspNetwork.getName() + ". Json response from VSP REST API is " + exception.getMessage());
                }
                Pair<String, String> domainAndSubnetId = this.createDomainZoneAndSubnet(enterpriseAndGroupId, domainTemplateId, createDefaultAcls, vspNetwork, vspDhcpOptions);
                domainId = domainAndSubnetId.getLeft();
                subnetId = domainAndSubnetId.getRight();
            }
            catch (NuageVspException e) {
                this.api.deleteQuietly(NuageVspEntity.DOMAIN_TEMPLATE, domainTemplateId);
                throw e;
            }
        }
        return Pair.of(domainId, subnetId);
    }

    private String validateDomain(String domainId, VspNetwork vspNetwork, VspDhcpDomainOption vspDhcpOptions) throws NuageVspException {
        String subnetId = this.findEntityIdByExternalUuid(NuageVspEntity.DOMAIN, domainId, NuageVspEntity.SUBNET, vspNetwork.getSubnetExternalId());
        if (!vspNetwork.shouldReuseDomain() && StringUtils.isBlank((String)subnetId)) {
            throw new NuageVspException("Subnet is not found under the Domain " + domainId + " for network " + vspNetwork.getName() + " in VSP. There is a network sync issue with VSD");
        }
        if (vspNetwork.shouldReuseDomain()) {
            String zoneExternalUuid = vspNetwork.getVpcOrSubnetInfo().getLeft();
            String zoneId = this.findEntityIdByExternalUuid(NuageVspEntity.DOMAIN, domainId, NuageVspEntity.ZONE, zoneExternalUuid);
            if (StringUtils.isBlank((String)zoneId)) {
                throw new NuageVspException("Zone corresponding to network " + zoneExternalUuid + " does not exist in VSP. There is a data sync issue. Please a check VSP or create a new network");
            }
            if (StringUtils.isBlank((String)subnetId)) {
                subnetId = this.createL3Subnet(zoneId, vspNetwork, vspDhcpOptions);
            } else {
                s_logger.debug(" Subnet " + subnetId + " already exists for network " + vspNetwork.getName() + " in VSP", new Object[0]);
            }
        } else {
            s_logger.debug(" Domain and Subnet " + subnetId + " already exists for network " + vspNetwork.getName() + " in VSP", new Object[0]);
        }
        return subnetId;
    }

    private Pair<String, String> createDomainZoneAndSubnet(Pair<String, String> enterpriseAndGroupId, String domainTemplateId, boolean createDefaultAcls, VspNetwork vspNetwork, VspDhcpDomainOption vspDhcpOptions) throws NuageVspException {
        String zoneId;
        String domainId;
        Object ingressAclTemplId = null;
        Object egressAclTemplId = null;
        Pair<String, String> vpcOrSubnetInfo = vspNetwork.getVpcOrSubnetInfo();
        try {
            NuageVspObject domainEntity = this.api.createNuageVspObject(NuageVspEntity.DOMAIN);
            domainEntity.set(NuageVspAttribute.NAME, vpcOrSubnetInfo.getLeft());
            domainEntity.set(NuageVspAttribute.DESCRIPTION, vpcOrSubnetInfo.getRight());
            domainEntity.setExternalId(vpcOrSubnetInfo.getLeft());
            domainEntity.set(NuageVspAttribute.TEMPLATE_ID, domainTemplateId);
            domainEntity.set(NuageVspAttribute.DOMAIN_PATENABLED, "ENABLED");
            domainEntity.set(NuageVspAttribute.DOMAIN_UNDERLAYENABLED, "ENABLED");
            NuageVspObject domainJson = this.api.createResource(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), domainEntity);
            s_logger.debug("Created Domain for network " + vspNetwork.getName() + " in VSP . Response from VSP is " + domainJson, new Object[0]);
            domainId = domainJson.getId();
        }
        catch (NuageVspException exception) {
            throw new NuageVspException("Failed to instantiate DomainTemplate for network " + vspNetwork.getName() + ". Json response from VSP REST API is " + exception.getMessage());
        }
        if (createDefaultAcls) {
            this.aclClient.createDefaultRules(vspNetwork, NuageVspEntity.DOMAIN, domainId);
        }
        try {
            NuageVspObject zoneEntity = this.api.createNuageVspObject(NuageVspEntity.ZONE);
            zoneEntity.set(NuageVspAttribute.NAME, "zone_" + vpcOrSubnetInfo.getLeft());
            zoneEntity.set(NuageVspAttribute.DESCRIPTION, vpcOrSubnetInfo.getRight());
            zoneEntity.setExternalId(vpcOrSubnetInfo.getLeft());
            zoneEntity.set(NuageVspAttribute.ZONE_PUBLIC, vspNetwork.isShared());
            NuageVspObject zoneJson = this.api.createResource(NuageVspEntity.DOMAIN, domainId, zoneEntity);
            zoneId = zoneJson.getId();
            s_logger.debug("Created Zone for network " + vspNetwork.getName() + " in VSP. Response from VSP is " + zoneJson, new Object[0]);
            ImmutableSet groupIds = ImmutableSet.of((Object)enterpriseAndGroupId.getRight());
            this.addPermission(NuageVspEntity.ZONE, zoneId, (Set<String>)groupIds);
        }
        catch (NuageVspException exception) {
            throw new NuageVspException("Failed to create Zone for network " + vspNetwork.getName() + ". Json response from VSP REST API is " + exception.getMessage());
        }
        String subnetId = this.createL3Subnet(zoneId, vspNetwork, vspDhcpOptions);
        return Pair.of(domainId, subnetId);
    }

    private String createL3Subnet(String zoneId, VspNetwork vspNetwork, VspDhcpDomainOption vspDhcpOptions) throws NuageVspException {
        String subnetId;
        try {
            SubnetUtils.SubnetInfo subnetInfo = new SubnetUtils(vspNetwork.getCidr()).getInfo();
            NuageVspObject subnetEntity = this.api.createNuageVspObject(NuageVspEntity.SUBNET);
            subnetEntity.set(NuageVspAttribute.NAME, vspNetwork.getSubnetExternalId());
            subnetEntity.set(NuageVspAttribute.DESCRIPTION, vspNetwork.getName());
            subnetEntity.set(NuageVspAttribute.SUBNET_ADDRESS, subnetInfo.getNetworkAddress());
            subnetEntity.set(NuageVspAttribute.SUBNET_NETMASK, subnetInfo.getNetmask());
            subnetEntity.set(NuageVspAttribute.SUBNET_GATEWAY, vspNetwork.getGateway());
            subnetEntity.setExternalId(vspNetwork.getSubnetExternalId());
            DhcpOptions dhcpOptions = null;
            if (vspDhcpOptions != null) {
                dhcpOptions = vspDhcpOptions.getVrIsDnsProvider() != false ? new DhcpOptions(vspNetwork.getVirtualRouterIp(), vspDhcpOptions.getDnsServers(), vspDhcpOptions.getNetworkDomain()) : new DhcpOptions(null, vspDhcpOptions.getDnsServers(), null);
            }
            if (vspNetwork.isShared()) {
                String sharedL3SubnetId = this.createL3SubnetSharedResources(vspNetwork, subnetInfo, dhcpOptions);
                subnetEntity.set(NuageVspAttribute.ASSOC_SHARED_NTWK_ID, sharedL3SubnetId);
            }
            NuageVspObject subnetJson = this.api.createResource(NuageVspEntity.ZONE, zoneId, subnetEntity);
            s_logger.debug("Created subnet for network " + vspNetwork.getName() + " in VSP. Response from VSP is " + subnetJson, new Object[0]);
            subnetId = subnetJson.getId();
            if (!vspNetwork.isShared() && dhcpOptions != null) {
                this.createDhcpOptions(true, NuageVspEntity.SUBNET, subnetId, vspNetwork.getUuid(), vspNetwork, dhcpOptions);
            }
        }
        catch (NuageVspException exception) {
            throw new NuageVspException("Failed to create Subnet for network " + vspNetwork.getName() + ". Json response from VSP REST API is " + exception.getMessage());
        }
        return subnetId;
    }

    private String createL3SubnetSharedResources(VspNetwork vspNetwork, SubnetUtils.SubnetInfo subnetInfo, DhcpOptions dhcpOptions) throws NuageVspException {
        String sharedL3SubnetId = null;
        EnumSet<NuageVspConstants.SharedNetworkType> resourceTypes = vspNetwork.isPublicAccess() ? EnumSet.of(NuageVspConstants.SharedNetworkType.FLOATING, NuageVspConstants.SharedNetworkType.PUBLIC) : EnumSet.of(NuageVspConstants.SharedNetworkType.PUBLIC);
        String externalIdFromGateway = vspNetwork.getSubnetExternalId();
        for (NuageVspConstants.SharedNetworkType resourceType : resourceTypes) {
            Object sharedResource;
            String sharedResourceJson = this.findSharedResource(true, resourceType, externalIdFromGateway, vspNetwork.getGateway(), subnetInfo.getNetmask());
            if (StringUtils.isNotBlank((String)sharedResourceJson)) {
                s_logger.debug("Shared resource with UUID " + externalIdFromGateway + " and gateway " + vspNetwork.getGateway() + " is already created", new Object[0]);
                if (resourceType != NuageVspConstants.SharedNetworkType.PUBLIC) continue;
                sharedResource = (NuageVspObject)Iterables.getFirst(this.api.parseJsonString(NuageVspEntity.SHARED_NETWORK, sharedResourceJson), null);
                sharedL3SubnetId = (String)((NuageVspObject)sharedResource).get(NuageVspAttribute.ID);
                continue;
            }
            sharedResource = vspNetwork.getAddressRanges().iterator();
            while (sharedResource.hasNext()) {
                VspAddressRange vspAddressRange = sharedResource.next();
                String externalId = UuidUtils.generateUuidFromExternalIdAndIp(vspNetwork.getUuid(), vspAddressRange.getGateway());
                sharedResourceJson = this.findSharedResource(true, resourceType, externalId, vspAddressRange.getGateway(), vspAddressRange.getNetmask());
                if (!StringUtils.isNotBlank((String)sharedResourceJson)) continue;
                break;
            }
            String sharedResourceParentId = (sharedResource = (NuageVspObject)Iterables.getFirst(this.api.parseJsonString(NuageVspEntity.SHARED_NETWORK, sharedResourceJson), null)) != null ? (String)((NuageVspObject)sharedResource).get(NuageVspAttribute.PARENT_ID) : null;
            String sharedResourceId = this.createSharedResource(resourceType, sharedResourceParentId, externalIdFromGateway, vspNetwork.getGateway(), subnetInfo.getNetmask(), resourceType.equals((Object)NuageVspConstants.SharedNetworkType.FLOATING) ? vspNetwork.isVlanUnderlay() : false, vspNetwork.getName());
            if (dhcpOptions != null) {
                this.createDhcpOptions(true, NuageVspEntity.SHARED_NETWORK, sharedResourceId, externalIdFromGateway, vspNetwork, dhcpOptions);
            }
            if (resourceType != NuageVspConstants.SharedNetworkType.PUBLIC) continue;
            sharedL3SubnetId = sharedResourceId;
        }
        return sharedL3SubnetId;
    }

    @Override
    public void createDhcpOptions(NuageVspApiClient.ExistingDhcpOptionStrategy existingOptionStrategy, NetworkDetails attachedNetworkDetails, VspNetwork vspNetwork, DhcpOptions dhcpOptions) throws NuageVspException {
        if (vspNetwork.isShared()) {
            String externalIdFromGateway = vspNetwork.getSubnetExternalId();
            String sharedResourceJson = this.findSharedResource(true, NuageVspConstants.SharedNetworkType.PUBLIC, externalIdFromGateway, vspNetwork.getGateway(), NetUtils.getCidrNetmask(vspNetwork.getCidr()));
            String sharedResourceId = this.getEntityId(sharedResourceJson, NuageVspEntity.SHARED_NETWORK);
            this.createDhcpOptions(existingOptionStrategy, NuageVspEntity.SHARED_NETWORK, externalIdFromGateway, sharedResourceId, vspNetwork, dhcpOptions);
        } else {
            this.createDhcpOptions(existingOptionStrategy, attachedNetworkDetails.getSubnetType(), vspNetwork.getUuid(), attachedNetworkDetails.getSubnetId(), vspNetwork, dhcpOptions);
        }
    }

    public void createDhcpOptions(boolean isCreateDhcpOption, NuageVspEntity nuageVspEntity, String nuageVspEntityId, String nuageVspEntityUuid, VspNetwork vspNetwork, DhcpOptions dhcpOptions) throws NuageVspException {
        NuageVspApiClient.ExistingDhcpOptionStrategy existingOptionStrategy = isCreateDhcpOption ? NuageVspApiClient.ExistingDhcpOptionStrategy.IGNORE : NuageVspApiClient.ExistingDhcpOptionStrategy.FETCH_AND_DELETE;
        this.createDhcpOptions(existingOptionStrategy, nuageVspEntity, nuageVspEntityUuid, nuageVspEntityId, vspNetwork, dhcpOptions);
    }

    @Override
    public void createDhcpOptions(NuageVspApiClient.ExistingDhcpOptionStrategy existingOptionStrategy, NuageVspEntity nuageVspEntity, String nuageVspEntityUuid, String nuageVspEntityId, VspNetwork vspNetwork, DhcpOptions dhcpOptions) throws NuageVspException {
        String dhcpOptionsJson;
        List<NuageVspObject> existingDhcpOptions = Arrays.asList(new NuageVspObject[0]);
        if (existingOptionStrategy.isFetch() && !StringUtils.isBlank((String)(dhcpOptionsJson = this.findEntityByExternalUuid(nuageVspEntity, nuageVspEntityId, NuageVspEntity.DHCP_OPTIONS, nuageVspEntityUuid)))) {
            existingDhcpOptions = this.api.parseJsonString(NuageVspEntity.DHCP_OPTIONS, dhcpOptionsJson);
        }
        for (DhcpOption dhcpOption : dhcpOptions.getOptions()) {
            Optional<NuageVspObject> optionalExistingDhcpOption = existingDhcpOptions.stream().filter(option -> ((Integer)option.get(NuageVspAttribute.DHCP_OPTIONS_ACTUAL_TYPE)).intValue() == dhcpOption.getCode()).findFirst();
            if (optionalExistingDhcpOption.isPresent()) {
                boolean dhcpOptionValueChanged;
                Object dhcpOptionValue;
                NuageVspObject existingDhcpOption = optionalExistingDhcpOption.get();
                if (dhcpOption.getOptionType() == Dhcp.DhcpOptionType.RAW) {
                    dhcpOptionValue = (String)existingDhcpOption.get(NuageVspAttribute.DHCP_OPTIONS_VALUE);
                    dhcpOptionValueChanged = !((String)dhcpOptionValue).equals(dhcpOption.getValueAsHex());
                } else {
                    dhcpOptionValue = (List)existingDhcpOption.get(NuageVspAttribute.DHCP_OPTIONS_ACTUAL_VALUES);
                    boolean bl = dhcpOptionValueChanged = !dhcpOptionValue.equals(dhcpOption.getValue());
                }
                if (dhcpOptionValueChanged) {
                    this.updateDhcpOption(existingDhcpOption, dhcpOption);
                    this.api.updateResource(existingDhcpOption);
                    s_logger.debug("Network (" + vspNetwork.getName() + ") DNS server's setting is changed to new value " + dhcpOption.getValue() + ". So, the DHCPOption for the network is updated", new Object[0]);
                }
                existingDhcpOptions.remove(existingDhcpOption);
                continue;
            }
            NuageVspObject dhcpOptionToCreate = this.createDhcpOption(nuageVspEntityUuid, dhcpOption);
            NuageVspObject dhcpResponseJson = this.api.createResource(nuageVspEntity, nuageVspEntityId, dhcpOptionToCreate);
            s_logger.debug("Created DHCP options for network " + vspNetwork.getName() + " in VSP. Response from VSP is " + dhcpResponseJson, new Object[0]);
        }
        if (existingDhcpOptions != null && existingOptionStrategy.isDeleteUnspecified()) {
            for (NuageVspObject dhcpOptionToRemove : existingDhcpOptions) {
                s_logger.debug("Network (" + nuageVspEntityUuid + ") DNS server's setting " + dhcpOptionToRemove.get(NuageVspAttribute.DHCP_OPTIONS_VALUE) + " is removed. So, delete the DHCPOption for the network", new Object[0]);
                String dhcpOptionId = dhcpOptionToRemove.getId();
                this.api.deleteQuietly(NuageVspEntity.DHCP_OPTIONS, dhcpOptionId);
            }
        }
    }

    @Override
    public void removeAllDhcpOptionsWithCode(NuageVspEntity nuageVspEntity, String externalUuid, String entityId, Set<Integer> dhcpOptionCodesToRemove) throws NuageVspException {
        List<NuageVspObject> foundDhcpOptions = this.api.parseJsonString(NuageVspEntity.DHCP_OPTIONS, this.findEntityByExternalUuid(nuageVspEntity, entityId, NuageVspEntity.DHCP_OPTIONS, externalUuid));
        foundDhcpOptions.stream().filter(vspObject -> dhcpOptionCodesToRemove.contains(vspObject.get(NuageVspAttribute.DHCP_OPTIONS_ACTUAL_TYPE))).forEach(this.api::deleteQuietly);
    }

    private NuageVspObject updateDhcpOption(NuageVspObject existingDhcpOption, DhcpOption dhcpOption) {
        if (dhcpOption.getOptionType() == Dhcp.DhcpOptionType.RAW) {
            existingDhcpOption.set(NuageVspAttribute.DHCP_OPTIONS_LENGTH, dhcpOption.getLengthAsHex());
            existingDhcpOption.set(NuageVspAttribute.DHCP_OPTIONS_TYPE, dhcpOption.getCodeAsHex());
            existingDhcpOption.set(NuageVspAttribute.DHCP_OPTIONS_VALUE, dhcpOption.getValueAsHex());
            existingDhcpOption.unset(NuageVspAttribute.DHCP_OPTIONS_ACTUAL_TYPE);
            existingDhcpOption.unset(NuageVspAttribute.DHCP_OPTIONS_ACTUAL_VALUES);
        } else {
            existingDhcpOption.set(NuageVspAttribute.DHCP_OPTIONS_ACTUAL_TYPE, dhcpOption.getCode());
            existingDhcpOption.set(NuageVspAttribute.DHCP_OPTIONS_ACTUAL_VALUES, dhcpOption.getValue());
            existingDhcpOption.unset(NuageVspAttribute.DHCP_OPTIONS_LENGTH);
            existingDhcpOption.unset(NuageVspAttribute.DHCP_OPTIONS_TYPE);
            existingDhcpOption.unset(NuageVspAttribute.DHCP_OPTIONS_VALUE);
        }
        return existingDhcpOption;
    }

    private NuageVspObject createDhcpOption(String externalId, DhcpOption dhcpOption) {
        NuageVspObject existingDhcpOption = this.api.createNuageVspObject(NuageVspEntity.DHCP_OPTIONS);
        if (dhcpOption.getOptionType() == Dhcp.DhcpOptionType.RAW) {
            existingDhcpOption.set(NuageVspAttribute.DHCP_OPTIONS_LENGTH, dhcpOption.getLengthAsHex());
            existingDhcpOption.set(NuageVspAttribute.DHCP_OPTIONS_TYPE, dhcpOption.getCodeAsHex());
            existingDhcpOption.set(NuageVspAttribute.DHCP_OPTIONS_VALUE, dhcpOption.getValueAsHex());
        } else {
            existingDhcpOption.set(NuageVspAttribute.DHCP_OPTIONS_ACTUAL_TYPE, dhcpOption.getCode());
            existingDhcpOption.set(NuageVspAttribute.DHCP_OPTIONS_ACTUAL_VALUES, dhcpOption.getValue());
        }
        existingDhcpOption.setExternalId(externalId);
        return existingDhcpOption;
    }

    private String getPaddedHexValue(String dnsServer) {
        String value = Long.toHexString(this.ip2Long(dnsServer));
        int valueLength = 8 - value.length();
        if (valueLength > 0) {
            StringBuilder pad = new StringBuilder();
            for (int i = 0; i < valueLength; ++i) {
                pad.append("0");
            }
            value = pad + value;
        }
        return value;
    }

    private long ip2Long(String ip) {
        String[] tokens = ip.split("[.]");
        assert (tokens.length == 4);
        long result = 0L;
        for (String token : tokens) {
            try {
                result = result << 8 | (long)Integer.parseInt(token);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Incorrect number", e);
            }
        }
        return result;
    }

    @Override
    public String createIsolatedL2NetworkWithDefaultACLs(VspNetwork vspNetwork) throws NuageVspException {
        Pair<String, String> enterpriseAndGroupId = this.getOrCreateVSPEnterpriseAndGroup(vspNetwork.getVspDomain().getName(), vspNetwork.getVspDomain().getPath(), vspNetwork.getVspDomain().getUuid(), vspNetwork.getAccountName(), vspNetwork.getAccountUuid());
        ImmutableSet groupIds = ImmutableSet.of((Object)enterpriseAndGroupId.getRight());
        SubnetUtils.SubnetInfo subnetInfo = new SubnetUtils(vspNetwork.getCidr()).getInfo();
        s_logger.debug("Create or find Isolated L2 Domain for network " + vspNetwork.getUuid() + " in VSP", new Object[0]);
        String l2DomainId = null;
        StringBuffer errorMessage = new StringBuffer();
        String l2DomainTemplateId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), NuageVspEntity.L2DOMAIN_TEMPLATE, vspNetwork.getUuid());
        if (StringUtils.isNotBlank((String)l2DomainTemplateId)) {
            s_logger.debug("L2Domain Template " + l2DomainTemplateId + " already exists.", new Object[0]);
            l2DomainId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), NuageVspEntity.L2DOMAIN, vspNetwork.getUuid());
            if (StringUtils.isNotBlank((String)l2DomainId)) {
                s_logger.debug("L2Domain " + l2DomainId + " already exists for network " + vspNetwork.getName() + " in VSP.", new Object[0]);
            } else {
                errorMessage.append("L2Domain is not found under the L2DomainTemplate ").append(l2DomainTemplateId).append(" for network ").append(vspNetwork.getName()).append(" in VSP. There is a network sync issue with VSD");
            }
        } else {
            NuageVspObject l2DomainTemplateEntity = this.api.createNuageVspObject(NuageVspEntity.L2DOMAIN_TEMPLATE);
            l2DomainTemplateEntity.set(NuageVspAttribute.NAME, vspNetwork.getUuid());
            l2DomainTemplateEntity.set(NuageVspAttribute.DESCRIPTION, vspNetwork.getName());
            l2DomainTemplateEntity.setExternalId(vspNetwork.getUuid());
            l2DomainTemplateEntity.set(NuageVspAttribute.L2DOMAIN_TEMPLATE_ADDRESS, subnetInfo.getNetworkAddress());
            l2DomainTemplateEntity.set(NuageVspAttribute.L2DOMAIN_TEMPLATE_NETMASK, subnetInfo.getNetmask());
            l2DomainTemplateEntity.set(NuageVspAttribute.L2DOMAIN_TEMPLATE_GATEWAY, vspNetwork.getGateway());
            try {
                NuageVspObject l2DomainTemplateJson = this.api.createResource(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), l2DomainTemplateEntity);
                s_logger.debug("Created L2DomainTemplate for network " + vspNetwork.getName() + " in VSP . Response from VSP is " + l2DomainTemplateJson, new Object[0]);
                l2DomainTemplateId = l2DomainTemplateJson.getId();
            }
            catch (NuageVspApiException exception) {
                String error = "Failed to create L2DomainTemplate for network " + vspNetwork.getName() + ".  Json response from VSP REST API is  " + exception.getMessage();
                s_logger.error((Object)error, exception);
                throw new NuageVspException(error);
            }
            try {
                if (errorMessage.length() == 0) {
                    NuageVspObject l2DomainEntity = this.api.createNuageVspObject(NuageVspEntity.L2DOMAIN);
                    l2DomainEntity.set(NuageVspAttribute.NAME, vspNetwork.getUuid());
                    l2DomainEntity.set(NuageVspAttribute.DESCRIPTION, vspNetwork.getName());
                    l2DomainEntity.setExternalId(vspNetwork.getUuid());
                    l2DomainEntity.set(NuageVspAttribute.TEMPLATE_ID, l2DomainTemplateId);
                    NuageVspObject l2DomainJson = this.api.createResource(NuageVspEntity.ENTERPRISE, enterpriseAndGroupId.getLeft(), l2DomainEntity);
                    s_logger.debug("Created L2Domain for network " + vspNetwork.getName() + " in VSP . Response from VSP is " + l2DomainJson, new Object[0]);
                    l2DomainId = l2DomainJson.getId();
                    l2DomainEntity.setId(l2DomainId);
                    try {
                        this.addPermission(NuageVspEntity.L2DOMAIN, l2DomainId, (Set<String>)groupIds);
                    }
                    catch (Exception e) {
                        errorMessage.append(e.getMessage());
                    }
                }
            }
            catch (NuageVspApiException exception) {
                errorMessage.append("Failed to instantiate L2DomainTemplate for network ").append(vspNetwork.getName()).append(".  Json response from VSP REST API is  ").append(exception.getMessage());
            }
            this.aclClient.createDefaultRules(vspNetwork, NuageVspEntity.L2DOMAIN_TEMPLATE, l2DomainTemplateId);
        }
        if (errorMessage.length() != 0) {
            s_logger.error((Object)errorMessage, new Object[0]);
            this.api.deleteQuietly(NuageVspEntity.L2DOMAIN_TEMPLATE, l2DomainTemplateId);
            throw new NuageVspException(errorMessage.toString());
        }
        return l2DomainId;
    }

    @Override
    public String getEnterprise(String domainUuid) throws NuageVspException {
        String enterpriseId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, null, null, domainUuid);
        if (StringUtils.isBlank((String)enterpriseId)) {
            String errorMessage = "Enterprise corresponding to CS domain " + domainUuid + " does not exist in VSP. There is a data sync issue. Please a check VSP or create a new network";
            s_logger.error((Object)errorMessage, new Object[0]);
            throw new NuageVspException(errorMessage);
        }
        return enterpriseId;
    }

    @Override
    public Pair<String, String> getIsolatedSubNetwork(String enterpriseId, VspNetwork vspNetwork) throws NuageVspException {
        return this.getIsolatedSubNetwork(true, enterpriseId, vspNetwork);
    }

    @Override
    public Pair<String, String> getIsolatedSubNetwork(boolean throwExceptionWhenNotFound, String enterpriseId, VspNetwork vspNetwork) throws NuageVspException {
        Pair<String, String> vpcOrSubnetInfo = vspNetwork.getVpcOrSubnetInfo();
        try {
            String domainId = this.getIsolatedDomain(enterpriseId, NuageVspEntity.DOMAIN, vpcOrSubnetInfo.getLeft());
            if (domainId == null) {
                return null;
            }
            String zoneId = this.findEntityIdByExternalUuid(NuageVspEntity.DOMAIN, domainId, NuageVspEntity.ZONE, vpcOrSubnetInfo.getLeft());
            if (StringUtils.isBlank((String)zoneId)) {
                if (throwExceptionWhenNotFound) {
                    throw new NuageVspException("Zone corresponding to network " + vpcOrSubnetInfo.getLeft() + " does not exist in VSP. There is a data sync issue. Please a check VSP or create a new network");
                }
                return null;
            }
            String subnetId = this.findEntityIdByExternalUuid(NuageVspEntity.ZONE, zoneId, NuageVspEntity.SUBNET, vspNetwork.getSubnetExternalId());
            if (StringUtils.isBlank((String)subnetId)) {
                if (throwExceptionWhenNotFound) {
                    throw new NuageVspException("Subnet corresponding to network " + vspNetwork.getUuid() + " does not exist in VSP. There is a data sync issue. Please a check VSP or create a new network");
                }
                return null;
            }
            return Pair.of(domainId, subnetId);
        }
        catch (NuageVspApiException exception) {
            String errorMessage = "Failed to get Subnet corresponding to network " + vspNetwork.getUuid() + ".  Json response from VSP REST API is  " + exception.getMessage();
            s_logger.error((Object)errorMessage, exception);
            throw new NuageVspException(errorMessage);
        }
    }

    @Override
    public String getIsolatedDomain(String enterpriseId, NuageVspEntity attachedNetworkType, String vpcOrSubnetUuid) throws NuageVspException {
        return this.getIsolatedDomain(true, enterpriseId, attachedNetworkType, vpcOrSubnetUuid);
    }

    @Override
    public String getIsolatedDomain(boolean throwExceptionWhenNotFound, String enterpriseId, NuageVspEntity attachedNetworkType, String vpcOrSubnetUuid) throws NuageVspException {
        String domainId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, attachedNetworkType, vpcOrSubnetUuid);
        if (StringUtils.isBlank((String)domainId)) {
            if (throwExceptionWhenNotFound) {
                throw new NuageVspException((Object)((Object)attachedNetworkType) + " corresponding to network " + vpcOrSubnetUuid + " does not exist in VSP. There is a data sync issue. Please a check VSP or create a new network");
            }
            return null;
        }
        return domainId;
    }

    public List<NuageVspObject> getACLAssociatedToDomain(boolean ingress, NuageVspEntity domainType, String domainUuid, String networkUuid) throws NuageVspException {
        NuageVspEntity aclType = ingress ? NuageVspEntity.INGRESS_ACLTEMPLATES : NuageVspEntity.EGRESS_ACLTEMPLATES;
        String aclTemplates = this.api.getResources(domainType, domainUuid, aclType);
        if (StringUtils.isNotBlank((String)aclTemplates)) {
            return this.api.parseJsonString(aclType, aclTemplates);
        }
        throw new NuageVspException((Object)((Object)aclType) + " ACL corresponding to network " + networkUuid + " does not exist in VSP. There is a data sync issue. Please a check VSP or create a new network");
    }

    public List<NuageVspObject> getACLEntriesAssociatedToLocation(String aclNetworkLocationId, NuageVspEntity aclTemplateType, String aclTemplateId) throws NuageVspException {
        NuageVspEntity aclEntryType = aclTemplateType.equals((Object)NuageVspEntity.INGRESS_ACLTEMPLATES) ? NuageVspEntity.INGRESS_ACLTEMPLATES_ENTRIES : NuageVspEntity.EGRESS_ACLTEMPLATES_ENTRIES;
        String aclTemplateEntries = aclNetworkLocationId != null ? this.findEntityUsingFilter(aclTemplateType, aclTemplateId, aclEntryType, NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_ID, aclNetworkLocationId) : this.findEntityUsingFilter(aclTemplateType, aclTemplateId, aclEntryType, NuageVspAttribute.ACLTEMPLATES_ENTRY_LOCATION_TYPE, (Object)Acl.AclEntryLocationType.ANY);
        if (StringUtils.isNotBlank((String)aclTemplateEntries)) {
            return this.api.parseJsonString(aclEntryType, aclTemplateEntries);
        }
        return Collections.emptyList();
    }

    @Override
    public Pair<Boolean, String> findOrCreateSharedResource(boolean findByExternalId, NuageVspConstants.SharedNetworkType resourceType, String staticNatNetworkUuid, String staticNatVlanGateway, String staticNatVlanNetmask, boolean staticNatVlanUnderlay, String networkName) throws NuageVspException {
        String sharedNetworkJson = this.findSharedResource(findByExternalId, resourceType, staticNatNetworkUuid, staticNatVlanGateway, staticNatVlanNetmask);
        if (StringUtils.isNotBlank((String)sharedNetworkJson)) {
            return Pair.of(false, this.getEntityId(sharedNetworkJson, NuageVspEntity.SHARED_NETWORK));
        }
        String sharedResourceId = this.createSharedResource(resourceType, null, staticNatNetworkUuid, staticNatVlanGateway, staticNatVlanNetmask, staticNatVlanUnderlay, networkName);
        return Pair.of(true, sharedResourceId);
    }

    public com.google.common.base.Optional<NuageVspObject> findSharedResourceWithFallback(boolean findByExternalId, NuageVspConstants.SharedNetworkType resourceType, final String staticNatNetworkUuid, String staticNatVlanGateway, String staticNatVlanNetmask) throws NuageVspException {
        String vspSharedNetworkJson = this.findSharedResource(findByExternalId, resourceType, staticNatNetworkUuid, staticNatVlanGateway, staticNatVlanNetmask);
        if (StringUtils.isNotBlank((String)vspSharedNetworkJson)) {
            List<NuageVspObject> sharedNetworks = this.api.parseJsonString(NuageVspEntity.SHARED_NETWORK, vspSharedNetworkJson);
            com.google.common.base.Optional firstSharedNetwork = com.google.common.base.Optional.of((Object)sharedNetworks.get(0));
            if (sharedNetworks.size() == 1) {
                return firstSharedNetwork;
            }
            String cidr = NetUtils.getCidrFromGatewayAndNetmask(staticNatVlanGateway, staticNatVlanNetmask);
            final String externalId = UuidUtils.generateUuidFromCidr(cidr);
            Predicate<NuageVspObject> hasCidrBasedUuid = new Predicate<NuageVspObject>(){

                public boolean apply(NuageVspObject input) {
                    return externalId.equals(input.getExternalId());
                }
            };
            Predicate<NuageVspObject> hasSubnetUuidBasedUuid = new Predicate<NuageVspObject>(){

                public boolean apply(NuageVspObject input) {
                    return StringUtils.equals((String)staticNatNetworkUuid, (String)input.getExternalId());
                }
            };
            com.google.common.base.Optional match = Iterables.tryFind(sharedNetworks, (Predicate)hasCidrBasedUuid);
            if (!match.isPresent()) {
                match = Iterables.tryFind(sharedNetworks, (Predicate)hasSubnetUuidBasedUuid);
            }
            return match.or(firstSharedNetwork);
        }
        return com.google.common.base.Optional.absent();
    }

    public String findSharedResource(boolean findByExternalId, NuageVspConstants.SharedNetworkType resourceType, String staticNatNetworkUuid, String staticNatVlanGateway, String staticNatVlanNetmask) throws NuageVspException {
        String address = NetUtils.getSubNet(staticNatVlanGateway, staticNatVlanNetmask);
        NuageVspFilter filter = NuageVspFilter.where().field(NuageVspAttribute.SHARED_RESOURCE_ADRESS).eq(address).and().field(NuageVspAttribute.SHARED_RESOURCE_NETMASK).eq(staticNatVlanNetmask).and().field(NuageVspAttribute.SHARED_RESOURCE_TYPE).eq((Object)resourceType);
        if (findByExternalId) {
            filter = filter.and().field(NuageVspAttribute.EXTERNAL_ID).eq(staticNatNetworkUuid);
        }
        return this.findEntityUsingFilter(NuageVspEntity.SHARED_NETWORK, null, null, filter);
    }

    public String createSharedResource(NuageVspConstants.SharedNetworkType resourceType, String sharedResourceParentId, String staticNatNetworkUuid, String staticNatVlanGateway, String staticNatVlanNetmask, boolean staticNatVlanUnderlay, String networkName) throws NuageVspException {
        SubnetUtils subnetUtils = new SubnetUtils(staticNatVlanGateway, staticNatVlanNetmask);
        NuageVspObject sharedNtwkEntity = this.api.createNuageVspObject(NuageVspEntity.SHARED_NETWORK);
        sharedNtwkEntity.set(NuageVspAttribute.NAME, resourceType.name().charAt(0) + "-" + staticNatNetworkUuid);
        sharedNtwkEntity.set(NuageVspAttribute.DESCRIPTION, networkName);
        sharedNtwkEntity.setExternalId(staticNatNetworkUuid);
        sharedNtwkEntity.set(NuageVspAttribute.SHARED_RESOURCE_GATEWAY, staticNatVlanGateway);
        sharedNtwkEntity.set(NuageVspAttribute.SHARED_RESOURCE_NETMASK, staticNatVlanNetmask);
        sharedNtwkEntity.set(NuageVspAttribute.SHARED_RESOURCE_ADRESS, subnetUtils.getInfo().getNetworkAddress());
        sharedNtwkEntity.set(NuageVspAttribute.SHARED_RESOURCE_TYPE, (Object)resourceType);
        sharedNtwkEntity.set(NuageVspAttribute.SHARED_RESOURCE_UNDERLAY, staticNatVlanUnderlay);
        sharedNtwkEntity.set(NuageVspAttribute.SHARED_RESOURCE_PARENT_ID, sharedResourceParentId);
        try {
            sharedNtwkEntity = this.api.createResource(sharedNtwkEntity);
            String sharedResourceId = sharedNtwkEntity.getId();
            s_logger.debug("Nuage Vsp Shared Network is not available. So, created a new Shared Network " + staticNatNetworkUuid, new Object[0]);
            return sharedResourceId;
        }
        catch (NuageVspApiException e) {
            String errorMessage = "Failed to create SharedResource in VSP using REST API. Json response from VSP REST API is " + e.getMessage();
            s_logger.error((Object)errorMessage, new Object[0]);
            throw new NuageVspException(errorMessage);
        }
    }

    @Override
    public void deleteSharedResourceInVSP(NuageVspConstants.SharedNetworkType resourceType, String staticNatNetworkUuid, String staticNatVlanGateway, String staticNatVlanNetmask) throws NuageVspException {
        String sharedResourceJson = this.findSharedResource(true, resourceType, staticNatNetworkUuid, staticNatVlanGateway, staticNatVlanNetmask);
        if (StringUtils.isNotBlank((String)sharedResourceJson)) {
            String sharedNetworkId = this.getEntityId(sharedResourceJson, NuageVspEntity.SHARED_NETWORK);
            this.api.deleteResource(NuageVspEntity.SHARED_NETWORK, sharedNetworkId);
        }
    }

    @Override
    public String applyStaticNatInVsp(NetworkDetails attachedNetworkDetails, String vportId, VspStaticNat vspStaticNat) throws NuageVspException {
        String sharedNetworkId = this.findOrCreateSharedResource(false, NuageVspConstants.SharedNetworkType.FLOATING, vspStaticNat.getVlanUuid(), vspStaticNat.getVlanGateway(), vspStaticNat.getVlanNetmask(), vspStaticNat.isVlanUnderlay(), null).getRight();
        if (StringUtils.isNotBlank((String)vportId)) {
            return this.allocateFIPToVPortInVsp(attachedNetworkDetails, vportId, sharedNetworkId, vspStaticNat.getIpAddress(), vspStaticNat.getIpUuid(), vspStaticNat.getVspNic().getSecondaryIpAddress(), vspStaticNat.getVspNic().getSecondaryIpUuid());
        }
        if (attachedNetworkDetails.getDomainType().equals((Object)NuageVspEntity.DOMAIN)) {
            String vportIdUsingNicUuid = this.findEntityIdByExternalUuid(NuageVspEntity.SUBNET, attachedNetworkDetails.getSubnetId(), NuageVspEntity.VPORT, vspStaticNat.getVspNic().getUuid());
            if (StringUtils.isNotBlank((String)vportIdUsingNicUuid)) {
                s_logger.warn("NIC associated to Static NAT " + vspStaticNat.getIpAddress() + "(" + vspStaticNat.getIpUuid() + ") is not present in VSD. But, VM's VPort with externalID " + vspStaticNat.getVspNic().getUuid() + " exists in VSD. So, associate the FIP to the Vport " + vportIdUsingNicUuid, new Object[0]);
                return this.allocateFIPToVPortInVsp(attachedNetworkDetails, vportId, sharedNetworkId, vspStaticNat.getIpAddress(), vspStaticNat.getIpUuid(), vspStaticNat.getVspNic().getSecondaryIpAddress(), vspStaticNat.getVspNic().getSecondaryIpUuid());
            }
            s_logger.warn("Static NAT " + vspStaticNat.getIpAddress() + "(" + vspStaticNat.getIpUuid() + ") is not associated to the VM interface because neither the interface nor the VPort with NIC's UUID " + vspStaticNat.getVspNic().getUuid() + " is not present in VSD", new Object[0]);
        }
        return null;
    }

    @Override
    public String allocateFIPToVPortInVsp(NetworkDetails attachedNetworkDetails, String vportId, String vspSharedNetworkId, String staticNatIp, String staticNatIpUuid, String nicSecondaryIp4Address, String nicSecondaryIpUuid) throws NuageVspException {
        String fipExternalId = attachedNetworkDetails.getDomainUuid() + ":" + staticNatIpUuid;
        String floatingIpId = null;
        boolean isFipCreated = false;
        try {
            floatingIpId = this.findEntityIdByExternalUuid(attachedNetworkDetails.getDomainType(), attachedNetworkDetails.getDomainId(), NuageVspEntity.FLOATING_IP, fipExternalId);
            if (StringUtils.isBlank((String)floatingIpId)) {
                NuageVspObject floatingIpEntity = this.api.createNuageVspObject(NuageVspEntity.FLOATING_IP);
                floatingIpEntity.set(NuageVspAttribute.FLOATING_IP_ADDRESS, staticNatIp);
                floatingIpEntity.set(NuageVspAttribute.ASSOC_SHARED_NTWK_ID, vspSharedNetworkId);
                floatingIpEntity.setExternalId(fipExternalId);
                isFipCreated = true;
                NuageVspObject floatingIpJson = this.api.createResource(attachedNetworkDetails.getDomainType(), attachedNetworkDetails.getDomainId(), floatingIpEntity);
                floatingIpId = floatingIpJson.getId();
                s_logger.debug("Created a new FloatingIP in Vsp " + floatingIpJson + " in FLoatingIP shared resource " + vspSharedNetworkId, new Object[0]);
            }
            if (nicSecondaryIp4Address != null) {
                this.createVirtualIPWithFloatingIPId(vportId, nicSecondaryIp4Address, nicSecondaryIpUuid, floatingIpId);
                s_logger.debug("Associated the new FloatingIP " + staticNatIp + " to Virtual IP " + nicSecondaryIp4Address + " of VM with VPort " + vportId, new Object[0]);
            } else {
                this.updateVPortWithFloatingIPId(vportId, floatingIpId);
                s_logger.debug("Associated the new FloatingIP " + staticNatIp + " to VM with VPort " + vportId, new Object[0]);
            }
        }
        catch (NuageVspApiException e1) {
            if (isFipCreated && !this.api.deleteQuietly(NuageVspEntity.FLOATING_IP, floatingIpId)) {
                s_logger.warn("Failed to rollback the creation of the FIP", new Object[0]);
            }
            throw new NuageVspException("Failed to create Floating in VSP using REST API " + e1.getMessage());
        }
        return floatingIpId;
    }

    public void createVirtualIPWithFloatingIPId(String vportId, String nicSecondaryIp4Address, String nicSecondaryIpUuid, String floatingIPId) throws NuageVspException {
        block4: {
            NuageVspObject virtualIp = this.api.createNuageVspObject(NuageVspEntity.VIRTUAL_IP);
            virtualIp.set(NuageVspAttribute.VIRTUAL_IP_FLOATING_IP_ID, floatingIPId);
            virtualIp.set(NuageVspAttribute.VIRTUAL_IP_ADDRESS, nicSecondaryIp4Address);
            virtualIp.setExternalId(nicSecondaryIpUuid);
            try {
                String virtualIpsJson = this.findEntityUsingFilter(NuageVspEntity.VPORT, vportId, NuageVspEntity.VIRTUAL_IP, NuageVspAttribute.VIRTUAL_IP_ADDRESS, nicSecondaryIp4Address);
                List<NuageVspObject> virtualIps = this.api.parseJsonString(NuageVspEntity.VIRTUAL_IP, virtualIpsJson);
                if (CollectionUtils.isNotEmpty(virtualIps)) {
                    NuageVspObject existingVirtualIp = (NuageVspObject)Iterables.getFirst(virtualIps, null);
                    String existingFloatingIpId = (String)existingVirtualIp.get(NuageVspAttribute.VIRTUAL_IP_FLOATING_IP_ID);
                    if (existingFloatingIpId != null && !existingFloatingIpId.equals(floatingIPId)) {
                        throw new NuageVspException("Failed to associate the FloatingIP " + floatingIPId + " to the VPort " + vportId + ". Another VirtualIP with the same vip = " + nicSecondaryIp4Address + " exists.");
                    }
                    return;
                }
                this.api.createResource(NuageVspEntity.VPORT, vportId, virtualIp);
            }
            catch (NuageVspException e) {
                if (e.isNoChangeInEntityException()) break block4;
                throw new NuageVspException("Failed to associate the FloatingIP " + floatingIPId + " to the VPort " + vportId, e);
            }
        }
    }

    @Override
    public void updateVPortWithFloatingIPId(String vportId, String floatingIPId) throws NuageVspException {
        block2: {
            NuageVspObject vportEntity = this.api.createNuageVspObject(NuageVspEntity.VPORT);
            vportEntity.setId(vportId);
            vportEntity.set(NuageVspAttribute.VPORT_FLOATING_IP_ID, floatingIPId);
            try {
                this.api.updateResource(vportEntity);
            }
            catch (NuageVspApiException e) {
                if (e.isNoChangeInEntityException()) break block2;
                throw NuageVspRestApi.handleException("Failed to associated the FloatingIP %s to the VPort %s", e, floatingIPId, vportId);
            }
        }
    }

    @Override
    public void releaseFIPFromVsp(NetworkDetails attachedNetworkDetails, String vportId, String staticNatIpUuid, String nicSecondaryIpUuid) throws NuageVspException {
        String fipExternalId = attachedNetworkDetails.getDomainUuid() + ":" + staticNatIpUuid;
        final String floatingIpId = this.findEntityIdByExternalUuid(attachedNetworkDetails.getDomainType(), attachedNetworkDetails.getDomainId(), NuageVspEntity.FLOATING_IP, fipExternalId);
        String virtualIpId = null;
        if (nicSecondaryIpUuid != null) {
            virtualIpId = this.findEntityIdByExternalUuid(attachedNetworkDetails.getSubnetType(), attachedNetworkDetails.getSubnetId(), NuageVspEntity.VIRTUAL_IP, nicSecondaryIpUuid);
        }
        if (StringUtils.isBlank((String)floatingIpId)) {
            s_logger.debug("vportId is null and also FIP with external ID " + staticNatIpUuid + " does not exists in VSP", new Object[0]);
            return;
        }
        if (StringUtils.isBlank((String)vportId)) {
            s_logger.debug("vportId is null. This could be case where VM interface is not present in VSP. So, finding the VPort in " + attachedNetworkDetails.getSubnetId() + " that has the FIP with externalId " + staticNatIpUuid, new Object[0]);
            String vportJson = this.api.getResources(NuageVspEntity.FLOATING_IP, floatingIpId, NuageVspEntity.VPORT);
            if (StringUtils.isNotBlank((String)vportJson)) {
                List<NuageVspObject> vports = this.api.parseJsonString(NuageVspEntity.VPORT, vportJson);
                vportId = (String)vports.get(0).get(NuageVspAttribute.ID);
            } else {
                vportJson = this.api.getResources(attachedNetworkDetails.getSubnetType(), attachedNetworkDetails.getSubnetId(), NuageVspEntity.VPORT);
                List<NuageVspObject> vports = this.api.parseJsonString(NuageVspEntity.VPORT, vportJson);
                for (NuageVspObject vport : vports) {
                    String virtualIpsJson = this.api.getResources(NuageVspEntity.VPORT, (String)vport.get(NuageVspAttribute.ID), NuageVspEntity.VIRTUAL_IP);
                    Collection<NuageVspObject> virtualIps = this.api.parseJsonString(NuageVspEntity.VIRTUAL_IP, virtualIpsJson);
                    if (!CollectionUtils.isNotEmpty(virtualIps = Collections2.filter(virtualIps, (Predicate)new Predicate<NuageVspObject>(){

                        public boolean apply(NuageVspObject input) {
                            return input.get(NuageVspAttribute.VIRTUAL_IP_FLOATING_IP_ID).equals(floatingIpId);
                        }
                    }))) continue;
                    vportId = (String)vport.get(NuageVspAttribute.ID);
                    virtualIpId = (String)((NuageVspObject)Iterables.getFirst(virtualIps, null)).get(NuageVspAttribute.ID);
                    s_logger.debug("Found a VPort " + vport + " that is associated the stale FIP " + fipExternalId + " in network " + attachedNetworkDetails.getDomainUuid(), new Object[0]);
                    break;
                }
            }
        }
        if (StringUtils.isBlank((String)vportId)) {
            this.api.deleteQuietly(NuageVspEntity.FLOATING_IP, floatingIpId);
            return;
        }
        if (virtualIpId != null) {
            this.api.deleteQuietly(NuageVspEntity.VIRTUAL_IP, virtualIpId);
        } else {
            this.updateVPortWithFloatingIPId(vportId, null);
        }
        s_logger.debug("Removed the association of Floating IP " + fipExternalId + " with VSP VPort " + vportId, new Object[0]);
        if (!this.api.deleteQuietly(NuageVspEntity.FLOATING_IP, floatingIpId)) {
            throw new NuageVspException("Failed to remove Floating IP");
        }
    }

    @Override
    public String findEntityUsingFilter(NuageVspEntity entityType, String entityId, NuageVspEntity childEntityType, NuageVspFilter filter) throws NuageVspException {
        try {
            String jsonString = childEntityType == null && entityId == null ? this.api.getResources(entityType, filter) : this.api.getResources(entityType, entityId, childEntityType, filter);
            return jsonString;
        }
        catch (NuageVspApiException exception) {
            throw NuageVspRestApi.handleException("Failed to execute REST API call to VSP to get %s using VSP filter %s.  Json response from VSP REST API is %s", exception, new Object[]{entityType, filter, exception.getMessage()});
        }
    }

    private NuageVspObject findVMInterface(List<NuageVspObject> vmInterfaces, String macAddress) throws NuageVspException {
        for (NuageVspObject vmInterface : vmInterfaces) {
            if (!vmInterface.hasAttribute(NuageVspAttribute.VM_INTERFACE_MAC) || !StringUtils.equals((String)((String)vmInterface.get(NuageVspAttribute.VM_INTERFACE_MAC)), (String)macAddress)) continue;
            return vmInterface;
        }
        return null;
    }

    @Override
    public String getEnterpriseName(String domainName, String domainPath) {
        if (!StringUtils.contains((String)(domainPath = StringUtils.removeStart((String)domainPath, (String)"/")), (String)"/")) {
            return domainName;
        }
        return domainPath.replace("/", "-");
    }

    @Override
    public String getResources(NuageVspEntity entityType) throws NuageVspException {
        return this.api.getResources(entityType);
    }

    @Override
    public <T> T getResources(NuageVspEntity entityType, Class<T> type) throws NuageVspException {
        String json = this.api.getResources(entityType);
        return this.api.parseJsonString(entityType, json, type);
    }

    @Override
    public String findEntityUsingFilter(NuageVspEntity entityType, String entityId, NuageVspEntity childEntityType, NuageVspAttribute filterAttr, Object filterAttrValue) throws NuageVspException {
        return this.findEntityUsingFilter(entityType, entityId, childEntityType, NuageVspRestApi.createFilter(filterAttr, filterAttrValue));
    }

    @Override
    public String findEntityIdByExternalUuid(NuageVspEntity entityType, String entityId, NuageVspEntity childEntityType, String externalId) throws NuageVspException {
        NuageVspObject entity = this.api.getEntityByExternalId(entityType, entityId, childEntityType, externalId);
        return entity != null ? entity.getId() : null;
    }

    @Override
    public <T> T findFieldValueByExternalUuid(NuageVspEntity entityType, String entityId, NuageVspEntity childEntityType, String externalId, NuageVspAttribute fieldName) throws NuageVspException {
        NuageVspObject entity = this.api.getEntityByExternalId(entityType, entityId, childEntityType, externalId);
        return entity != null ? (T)entity.get(fieldName) : null;
    }

    @Override
    public String findEntityByExternalUuid(NuageVspEntity entityType, String entityId, NuageVspEntity childEntityType, String externalId) throws NuageVspException {
        try {
            return this.findEntityUsingFilter(entityType, entityId, childEntityType, NuageVspAttribute.EXTERNAL_ID, externalId);
        }
        catch (NuageVspApiException exception) {
            throw NuageVspRestApi.handleException("Failed to execute REST API call to VSP to get %s using VSP filter %s. ", exception, new Object[]{entityType, externalId});
        }
    }

    @Override
    public String getEntityId(String jsonString, NuageVspEntity entityType) throws NuageVspException {
        String id = "";
        if (StringUtils.isNotBlank((String)jsonString)) {
            List<NuageVspObject> entityDetails = this.api.parseJsonString(entityType, jsonString);
            id = (String)entityDetails.iterator().next().get(NuageVspAttribute.ID);
        }
        return id;
    }

    @Override
    public void cleanUpDomainAndTemplate(String enterpriseId, String networkUuid, String domainTemplateName) throws NuageVspException {
        String networkDomainTemplateId = (String)this.findFieldValueByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN, networkUuid, NuageVspAttribute.TEMPLATE_ID);
        String domainTemplateEntity = this.findEntityUsingFilter(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN_TEMPLATE, NuageVspAttribute.NAME, domainTemplateName);
        String domainTemplateId = this.getEntityId(domainTemplateEntity, NuageVspEntity.DOMAIN_TEMPLATE);
        if (networkDomainTemplateId == null) {
            return;
        }
        if (networkDomainTemplateId.equals(domainTemplateId)) {
            String vspNetworkId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN, networkUuid);
            if (StringUtils.isNotBlank((String)vspNetworkId)) {
                s_logger.debug("Found a VSP L3 network " + vspNetworkId + " that corresponds to network " + networkUuid + " in CS. So, delete it", new Object[0]);
                this.api.deleteQuietly(NuageVspEntity.DOMAIN, vspNetworkId);
            }
        } else {
            String vspNetworkId = this.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN_TEMPLATE, networkUuid);
            if (StringUtils.isNotBlank((String)vspNetworkId)) {
                s_logger.debug("Found a VSP L3 network " + vspNetworkId + " that corresponds to network " + networkUuid + " in CS. So, delete it", new Object[0]);
                this.api.deleteQuietly(NuageVspEntity.DOMAIN_TEMPLATE, vspNetworkId);
            }
        }
    }

    @Override
    public void createVportInVsp(VspNic vspNic, VspNetwork vspNetwork, List<NuageVspObject> vmInterfaceList, NetworkDetails attachedNetworkDetails, DhcpOptions dhcpOptions) throws NuageVspException {
        ArrayList<String> vPortIds = new ArrayList<String>();
        for (NuageVspObject vmInterface : vmInterfaceList) {
            String networkIdToBeAttached;
            String vmInterfaceUuid = vmInterface.getExternalId();
            NuageVspEntity networkTypeToBeAttached = attachedNetworkDetails.getSubnetType();
            String vPortId = this.findEntityIdByExternalUuid(networkTypeToBeAttached, networkIdToBeAttached = attachedNetworkDetails.getSubnetId(), NuageVspEntity.VPORT, vmInterfaceUuid);
            if (StringUtils.isBlank((String)vPortId)) {
                NuageVspConstants.AddressSpoofing spoofing = vspNic.isRequiresSpoofing() ? NuageVspConstants.AddressSpoofing.ENABLED : NuageVspConstants.AddressSpoofing.INHERITED;
                NuageVspObject vmPortEntity = this.api.createNuageVspObject(NuageVspEntity.VPORT).set(NuageVspAttribute.NAME, vmInterfaceUuid).set(NuageVspAttribute.DESCRIPTION, vmInterface.get(NuageVspAttribute.VM_INTERFACE_MAC)).set(NuageVspAttribute.VPORT_ACTIVE, true).set(NuageVspAttribute.VPORT_TYPE, "VM").set(NuageVspAttribute.VPORT_ADDRESSSPOOFING, (Object)spoofing).setExternalId(vmInterfaceUuid);
                try {
                    NuageVspObject vport = this.api.createResource(networkTypeToBeAttached, networkIdToBeAttached, vmPortEntity);
                    s_logger.debug("Created VPort for network " + (Object)((Object)networkTypeToBeAttached) + " with ID " + networkIdToBeAttached + " in Nuage. Response from VSP is " + vport, new Object[0]);
                    vPortId = vport.getId();
                    vPortIds.add(vPortId);
                }
                catch (NuageVspApiException e) {
                    for (String vportId : vPortIds) {
                        this.api.deleteQuietly(NuageVspEntity.VPORT, vportId);
                    }
                    throw NuageVspRestApi.handleException("Failed to create VPort in VSP using REST API. Json response from VSP REST API is %s ", e, e.getMessage());
                }
            }
            if (dhcpOptions != null) {
                for (DhcpOption dhcpOption : dhcpOptions.getOptions()) {
                    NuageVspObject dhcpOptionToCreate = this.createDhcpOption(vmInterfaceUuid, dhcpOption);
                    this.api.createResource(NuageVspEntity.VPORT, vPortId, dhcpOptionToCreate);
                }
            }
            if (vspNetwork.isShared() && vspNetwork.isPublicAccess()) {
                try {
                    String nicIp = (String)vmInterface.get(NuageVspAttribute.VM_INTERFACE_IPADDRESS);
                    this.makeInterfacePubliclyReachable(vspNetwork, nicIp, attachedNetworkDetails, vPortId, vmInterfaceUuid);
                }
                catch (NuageVspException e) {
                    for (String vportId : vPortIds) {
                        this.api.deleteQuietly(NuageVspEntity.VPORT, vportId);
                    }
                    throw e;
                }
            }
            vmInterface.set(NuageVspAttribute.VM_INTERFACE_VPORT_ID, vPortId);
        }
    }

    @Override
    public String generateCmsIdForNuageVsp(String cmsName) throws NuageVspException {
        try {
            NuageVspObject cmsEntity = this.api.createNuageVspObject(NuageVspEntity.CLOUD_MGMT_SYSTEMS);
            cmsEntity.set(NuageVspAttribute.NAME, cmsName);
            NuageVspObject cms = this.api.createResource(cmsEntity);
            s_logger.debug("Retrieved CMS ID for VSP . Response from VSP is " + cms, new Object[0]);
            return cms.getId();
        }
        catch (NuageVspApiException e) {
            throw NuageVspRestApi.handleException("Failed to retrieve CMS ID VSP.", e, new Object[0]);
        }
    }

    @Override
    public boolean removeCmsIdForNuageVsp(String cmsId) throws NuageVspException {
        try {
            if (StringUtils.isBlank((String)cmsId)) {
                throw new NuageVspApiException("CMS Id is null while trying to remove the CMS Id.");
            }
            this.api.deleteResource(NuageVspEntity.CLOUD_MGMT_SYSTEMS, cmsId);
            s_logger.debug("Deleted CMS ID for VSP.", new Object[0]);
            return true;
        }
        catch (NuageVspApiException exception) {
            throw NuageVspRestApi.handleException("Failed to delete CMS ID VSP.", exception, new Object[0]);
        }
    }

    @Override
    public boolean isKnownCmsIdForNuageVsp(String cmsId) throws NuageVspException {
        try {
            this.api.getResource(NuageVspEntity.CLOUD_MGMT_SYSTEMS, cmsId, false);
            return true;
        }
        catch (NuageVspApiException exception) {
            if (exception.getHttpErrorCode() == 404) {
                return false;
            }
            throw NuageVspRestApi.handleException("Failed to retrieve CMS ID VSP.", exception, new Object[0]);
        }
    }

    @Override
    public List<NuageVspObject> parseJsonString(NuageVspEntity entity, String json) throws NuageVspException {
        return this.api.parseJsonString(entity, json);
    }

    @Override
    public <T> T parseJsonString(NuageVspEntity entity, String json, Class<T> type) throws NuageVspException {
        return this.api.parseJsonString(entity, json, type);
    }

    @Override
    public void deleteQuietly(NuageVspEntity entityType, String entityId) {
        this.api.deleteQuietly(entityType, entityId);
    }

    @Override
    public void login() throws NuageVspApiException {
        this.api.login();
    }

    @Override
    public String getResources(NuageVspEntity enterprise, NuageVspFilter filter) throws NuageVspApiException {
        return this.api.getResources(enterprise, filter);
    }

    @Override
    public String getResources(NuageVspObject parent, NuageVspEntity childEntityType) throws NuageVspApiException {
        return this.api.getResources(parent, childEntityType);
    }
}

