/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.nuage.vsp.acs.client.api.NuageVspAclClient;
import net.nuage.vsp.acs.client.api.NuageVspApiClient;
import net.nuage.vsp.acs.client.api.NuageVspManagerClient;
import net.nuage.vsp.acs.client.api.impl.NuageVspClientImpl;
import net.nuage.vsp.acs.client.api.model.VspApiDefaults;
import net.nuage.vsp.acs.client.api.model.VspDomain;
import net.nuage.vsp.acs.client.api.model.VspDomainCleanUp;
import net.nuage.vsp.acs.client.api.model.VspDomainTemplate;
import net.nuage.vsp.acs.client.common.NuageVspApiVersion;
import net.nuage.vsp.acs.client.common.NuageVspConstants;
import net.nuage.vsp.acs.client.common.model.NuageVspAttribute;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;
import net.nuage.vsp.acs.client.common.model.NuageVspFilter;
import net.nuage.vsp.acs.client.common.model.NuageVspObject;
import net.nuage.vsp.acs.client.common.model.NuageVspVersions;
import net.nuage.vsp.acs.client.common.model.Pair;
import net.nuage.vsp.acs.client.exception.NuageVspException;
import org.apache.commons.lang.StringUtils;

public class NuageVspManagerClientImpl
extends NuageVspClientImpl
implements NuageVspManagerClient {
    public NuageVspManagerClientImpl(NuageVspApiClient nuageVspApiClient, NuageVspAclClient nuageVspAclClient) {
        super(nuageVspApiClient, nuageVspAclClient);
    }

    @Override
    public Pair<Boolean, String> auditNuageVspCmsId(String nuageVspCmsId, boolean auditOnly) throws NuageVspException {
        if (StringUtils.isNotBlank((String)nuageVspCmsId)) {
            boolean knownCmsId = this.nuageVspApiClient.isKnownCmsIdForNuageVsp(nuageVspCmsId);
            if (!knownCmsId) {
                return Pair.of(false, nuageVspCmsId);
            }
            return Pair.of(true, nuageVspCmsId);
        }
        if (!auditOnly && StringUtils.isNotBlank((String)(nuageVspCmsId = this.registerNuageVspCmsId()))) {
            return Pair.of(true, nuageVspCmsId);
        }
        return Pair.of(false, null);
    }

    @Override
    public String registerNuageVspCmsId() throws NuageVspException {
        return this.nuageVspApiClient.generateCmsIdForNuageVsp("CMS-System");
    }

    @Override
    public boolean unregisterNuageVspCmsId(String nuageVspCmsId) throws NuageVspException {
        return this.nuageVspApiClient.removeCmsIdForNuageVsp(nuageVspCmsId);
    }

    @Override
    public boolean isSupportedApiVersion(String version) throws NuageVspException {
        NuageVspApiVersion apiVersion = NuageVspApiVersion.fromString(version);
        return apiVersion.isSupported() && this.isSupportedVersionVSD(apiVersion);
    }

    @Override
    public VspApiDefaults getApiDefaults() throws NuageVspException {
        return new VspApiDefaults.Builder().version(NuageVspApiVersion.CURRENT.toString()).retryCount(NuageVspConstants.DEFAULT_API_RETRY_COUNT).retryInterval(NuageVspConstants.DEFAULT_API_RETRY_INTERVAL).build();
    }

    @Override
    public boolean syncDomainWithNuageVsp(VspDomain vspDomain, boolean add, boolean remove) throws NuageVspException {
        if (add) {
            this.addDomain(vspDomain);
        } else if (remove) {
            this.deleteDomain(vspDomain);
        }
        return true;
    }

    @Override
    public void addDomain(VspDomain vspDomain) throws NuageVspException {
        this.nuageVspApiClient.getOrCreateVSPEnterprise(vspDomain.getUuid(), vspDomain.getName(), vspDomain.getPath());
    }

    @Override
    public void deleteDomain(VspDomain vspDomain) throws NuageVspException {
        this.nuageVspApiClient.deleteEnterpriseInVsp(vspDomain.getUuid(), this.nuageVspApiClient.getEnterpriseName(vspDomain.getName(), vspDomain.getPath()));
    }

    @Override
    public boolean cleanUpDomain(VspDomainCleanUp vspDomainCleanUp) throws NuageVspException {
        if (vspDomainCleanUp.getSharedNetworkUuids() != null) {
            String enterpriseId = this.nuageVspApiClient.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, null, null, vspDomainCleanUp.getUuid());
            for (Map.Entry<String, List<String>> entry : vspDomainCleanUp.getSharedNetworkUuids().entrySet()) {
                for (String sharedNetworkUuid : entry.getValue()) {
                    this.nuageVspApiClient.cleanUpDomainAndTemplate(enterpriseId, sharedNetworkUuid, entry.getKey());
                }
            }
        }
        return true;
    }

    @Override
    public List<VspDomainTemplate> getDomainTemplates(VspDomain vspDomain, String name) throws NuageVspException {
        NuageVspFilter filter = name != null ? NuageVspFilter.where().field(NuageVspAttribute.NAME).contains(name) : null;
        String enterpriseId = this.nuageVspApiClient.findEntityIdByExternalUuid(NuageVspEntity.ENTERPRISE, null, null, vspDomain.getUuid());
        String json = this.nuageVspApiClient.findEntityUsingFilter(NuageVspEntity.ENTERPRISE, enterpriseId, NuageVspEntity.DOMAIN_TEMPLATE, filter);
        List<NuageVspObject> domainTemplates = this.nuageVspApiClient.parseJsonString(NuageVspEntity.DOMAIN_TEMPLATE, json);
        LinkedList<VspDomainTemplate> result = new LinkedList<VspDomainTemplate>();
        for (NuageVspObject domainTemplate : domainTemplates) {
            if (!StringUtils.isBlank((String)domainTemplate.getExternalId())) continue;
            result.add(new VspDomainTemplate(domainTemplate.getName(), domainTemplate.getDescription()));
        }
        return result;
    }

    @Override
    public List<NuageVspApiVersion> getSupportedVersionList() throws NuageVspException {
        NuageVspVersions versions = this.nuageVspApiClient.getResources(NuageVspEntity.VERSION, NuageVspVersions.class);
        LinkedList<NuageVspApiVersion> result = new LinkedList<NuageVspApiVersion>();
        for (NuageVspObject version : versions.getVersions()) {
            NuageVspApiVersion.Status status = (NuageVspApiVersion.Status)((Object)version.get(NuageVspAttribute.VERSION_STATUS));
            if (status == NuageVspApiVersion.Status.UNSUPPORTED) continue;
            NuageVspApiVersion versionObj = NuageVspApiVersion.fromString((String)version.get(NuageVspAttribute.VERSION));
            result.add(versionObj);
        }
        return result;
    }

    @Override
    @Deprecated
    public Map<NuageVspApiVersion, NuageVspApiVersion.Status> getSupportedVersions() throws NuageVspException {
        NuageVspVersions versions = this.nuageVspApiClient.getResources(NuageVspEntity.VERSION, NuageVspVersions.class);
        HashMap<NuageVspApiVersion, NuageVspApiVersion.Status> result = new HashMap<NuageVspApiVersion, NuageVspApiVersion.Status>();
        for (NuageVspObject version : versions.getVersions()) {
            NuageVspApiVersion.Status status = (NuageVspApiVersion.Status)((Object)version.get(NuageVspAttribute.VERSION_STATUS));
            if (status == NuageVspApiVersion.Status.UNSUPPORTED) continue;
            NuageVspApiVersion versionObj = NuageVspApiVersion.fromString((String)version.get(NuageVspAttribute.VERSION));
            result.put(versionObj, status);
        }
        return result;
    }

    private boolean isSupportedVersionVSD(NuageVspApiVersion version) throws NuageVspException {
        return this.getSupportedVersionList().contains(version);
    }
}

