/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.model;

import com.google.common.collect.Lists;
import java.util.List;
import net.nuage.vsp.acs.client.api.model.Protocol;
import net.nuage.vsp.acs.client.api.model.VspBuilder;
import net.nuage.vsp.acs.client.api.model.VspObject;

public class VspAclRule
extends VspObject {
    private final String uuid;
    private final Protocol protocol;
    private final Integer startPort;
    private final Integer endPort;
    private final ACLState state;
    private final ACLTrafficType trafficType;
    private final ACLAction action;
    private final String sourceIpAddress;
    private final List<String> sourceCidrList;
    private final Integer priority;
    private final ACLType type;

    private VspAclRule(String uuid, Protocol protocol, Integer startPort, Integer endPort, ACLState state, ACLTrafficType trafficType, ACLAction action, String sourceIpAddress, List<String> sourceCidrList, Integer priority, ACLType type) {
        this.uuid = uuid;
        this.protocol = protocol;
        this.startPort = startPort;
        this.endPort = endPort;
        this.state = state;
        this.trafficType = trafficType;
        this.action = action;
        this.sourceIpAddress = sourceIpAddress;
        this.sourceCidrList = sourceCidrList;
        this.priority = priority;
        this.type = type;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Integer getStartPort() {
        return this.startPort;
    }

    public Integer getEndPort() {
        return this.endPort;
    }

    public ACLState getState() {
        return this.state;
    }

    public ACLTrafficType getTrafficType() {
        return this.trafficType;
    }

    public ACLAction getAction() {
        return this.action;
    }

    public String getSourceIpAddress() {
        return this.sourceIpAddress;
    }

    public List<String> getSourceCidrList() {
        return this.sourceCidrList != null ? Lists.newCopyOnWriteArrayList(this.sourceCidrList) : null;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public ACLType getType() {
        return this.type;
    }

    public boolean isReflexive() {
        return this.action == ACLAction.Allow && this.protocol.hasPort();
    }

    public boolean isAddedNetworkAclRule() {
        return this.state == ACLState.Add && this.type == ACLType.NetworkACL;
    }

    public String getPortRange() {
        if (!this.protocol.hasPort()) {
            return null;
        }
        String portRange = "*";
        if (this.startPort != null && this.endPort != null) {
            portRange = String.format("%d-%d", this.startPort, this.endPort);
        } else if (this.startPort != null) {
            portRange = String.valueOf(this.startPort);
        }
        return portRange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VspAclRule)) {
            return false;
        }
        VspAclRule that = (VspAclRule)o;
        if (this.action != that.action) {
            return false;
        }
        if (this.endPort != null ? !this.endPort.equals(that.endPort) : that.endPort != null) {
            return false;
        }
        if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) {
            return false;
        }
        if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) {
            return false;
        }
        if (this.sourceCidrList != null ? !this.sourceCidrList.equals(that.sourceCidrList) : that.sourceCidrList != null) {
            return false;
        }
        if (this.sourceIpAddress != null ? !this.sourceIpAddress.equals(that.sourceIpAddress) : that.sourceIpAddress != null) {
            return false;
        }
        if (this.startPort != null ? !this.startPort.equals(that.startPort) : that.startPort != null) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        if (this.trafficType != that.trafficType) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return !(this.uuid != null ? !this.uuid.equals(that.uuid) : that.uuid != null);
    }

    public int hashCode() {
        int result = this.uuid != null ? this.uuid.hashCode() : 0;
        result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
        result = 31 * result + (this.startPort != null ? this.startPort.hashCode() : 0);
        result = 31 * result + (this.endPort != null ? this.endPort.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.trafficType != null ? this.trafficType.hashCode() : 0);
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        result = 31 * result + (this.sourceIpAddress != null ? this.sourceIpAddress.hashCode() : 0);
        result = 31 * result + (this.sourceCidrList != null ? this.sourceCidrList.hashCode() : 0);
        result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public static class Builder
    extends VspBuilder<Builder, VspAclRule> {
        private String uuid;
        private Protocol protocol;
        private Integer startPort;
        private Integer endPort;
        private ACLState state;
        private ACLTrafficType trafficType;
        private ACLAction action;
        private String sourceIpAddress;
        private List<String> sourceCidrList;
        private Integer priority;
        private ACLType type;

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = Protocol.fromString(protocol);
            return this;
        }

        public Builder startPort(Integer startPort) {
            this.startPort = startPort;
            return this;
        }

        public Builder endPort(Integer endPort) {
            this.endPort = endPort;
            return this;
        }

        public Builder state(ACLState state) {
            this.state = state;
            return this;
        }

        public Builder trafficType(ACLTrafficType trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        public Builder action(ACLAction action) {
            this.action = action;
            return this;
        }

        public Builder sourceIpAddress(String sourceIpAddress) {
            this.sourceIpAddress = sourceIpAddress;
            return this;
        }

        public Builder sourceCidrList(List<String> sourceCidrList) {
            this.sourceCidrList = sourceCidrList;
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public Builder type(ACLType type) {
            this.type = type;
            return this;
        }

        @Override
        public VspAclRule build() {
            return new VspAclRule(this.uuid, this.protocol, this.startPort, this.endPort, this.state, this.trafficType, this.action, this.sourceIpAddress, this.sourceCidrList, this.priority, this.type);
        }

        @Override
        public Builder fromObject(VspAclRule obj) {
            return new Builder().uuid(obj.getUuid()).protocol(obj.getProtocol()).startPort(obj.getStartPort()).endPort(obj.getEndPort()).state(obj.getState()).trafficType(obj.getTrafficType()).action(obj.getAction()).sourceIpAddress(obj.getSourceIpAddress()).sourceCidrList(obj.getSourceCidrList()).priority(obj.getPriority()).type(obj.getType());
        }
    }

    public static enum ACLType {
        Firewall,
        NetworkACL;

    }

    public static enum ACLAction {
        Allow,
        Deny;

    }

    public static enum ACLTrafficType {
        Ingress,
        Egress;

    }

    public static enum ACLState {
        Active,
        Add,
        Revoke;

    }
}

