/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.model;

import net.nuage.vsp.acs.client.api.model.VspBuilder;
import net.nuage.vsp.acs.client.api.model.VspObject;

public class VspApiDefaults
extends VspObject {
    private final String version;
    private final Long retryCount;
    private final Long retryInterval;

    private VspApiDefaults(String version, Long retryCount, Long retryInterval) {
        this.version = version;
        this.retryCount = retryCount;
        this.retryInterval = retryInterval;
    }

    public String getVersion() {
        return this.version;
    }

    public Long getRetryCount() {
        return this.retryCount;
    }

    public Long getRetryInterval() {
        return this.retryInterval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VspApiDefaults)) {
            return false;
        }
        VspApiDefaults that = (VspApiDefaults)o;
        if (this.retryCount != null ? !this.retryCount.equals(that.retryCount) : that.retryCount != null) {
            return false;
        }
        if (this.retryInterval != null ? !this.retryInterval.equals(that.retryInterval) : that.retryInterval != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.version != null ? this.version.hashCode() : 0;
        result = 31 * result + (this.retryCount != null ? this.retryCount.hashCode() : 0);
        result = 31 * result + (this.retryInterval != null ? this.retryInterval.hashCode() : 0);
        return result;
    }

    public static class Builder
    extends VspBuilder<Builder, VspApiDefaults> {
        private String version;
        private Long retryCount;
        private Long retryInterval;

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder retryCount(Long retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public Builder retryInterval(Long retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        @Override
        public VspApiDefaults build() {
            return new VspApiDefaults(this.version, this.retryCount, this.retryInterval);
        }

        @Override
        public Builder fromObject(VspApiDefaults obj) {
            return new Builder().version(obj.getVersion()).retryCount(obj.getRetryCount()).retryInterval(obj.getRetryInterval());
        }
    }
}

