/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.api.model;

import java.util.List;
import net.nuage.vsp.acs.client.api.model.NuageVspUser;
import net.nuage.vsp.acs.client.api.model.VspAddressRange;
import net.nuage.vsp.acs.client.api.model.VspBuilder;
import net.nuage.vsp.acs.client.api.model.VspDomain;
import net.nuage.vsp.acs.client.api.model.VspObject;
import net.nuage.vsp.acs.client.common.model.Pair;
import net.nuage.vsp.acs.client.common.utils.UuidUtils;

public class VspNetwork
extends VspObject {
    private final long id;
    private final String uuid;
    private final String name;
    private final VspDomain vspDomain;
    private final String accountName;
    private final String accountUuid;
    private final String vpcUuid;
    private final String vpcName;
    private final NetworkType networkType;
    private final boolean firewallServiceSupported;
    private final boolean egressDefaultPolicy;
    private final String domainTemplateName;
    private final String cidr;
    private final String gateway;
    private final String virtualRouterIp;
    private final boolean publicAccess;
    private final List<VspAddressRange> addressRanges;
    private final Pair<String, String> vpcOrSubnetInfo;
    private final boolean vlanUnderlay;

    private VspNetwork(long id, String uuid, String name, VspDomain vspDomain, String accountName, String accountUuid, String vpcUuid, String vpcName, NetworkType networkType, boolean firewallServiceSupported, boolean egressDefaultPolicy, String domainTemplateName, String cidr, String gateway, String virtualRouterIp, boolean publicAccess, List<VspAddressRange> addressRanges, boolean vlanUnderlay) {
        this.id = id;
        this.uuid = uuid;
        this.name = name;
        this.vspDomain = vspDomain;
        this.accountName = accountName;
        this.accountUuid = accountUuid;
        this.vpcUuid = vpcUuid;
        this.vpcName = vpcName;
        this.networkType = networkType;
        this.firewallServiceSupported = firewallServiceSupported;
        this.egressDefaultPolicy = egressDefaultPolicy;
        this.domainTemplateName = domainTemplateName;
        this.cidr = cidr;
        this.gateway = gateway;
        this.virtualRouterIp = virtualRouterIp;
        this.publicAccess = publicAccess;
        this.addressRanges = addressRanges;
        this.vlanUnderlay = vlanUnderlay;
        this.vpcOrSubnetInfo = this.isVpc() ? Pair.of(this.vpcUuid, "VPC_" + this.vpcName) : Pair.of(this.uuid, this.name);
    }

    public long getId() {
        return this.id;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public VspDomain getVspDomain() {
        return this.vspDomain;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getAccountUuid() {
        return this.accountUuid;
    }

    public String getVpcUuid() {
        return this.vpcUuid;
    }

    public String getVpcName() {
        return this.vpcName;
    }

    public boolean isL2() {
        return this.networkType == NetworkType.L2;
    }

    public boolean isL3() {
        return this.networkType == NetworkType.L3;
    }

    public boolean isShared() {
        return this.networkType == NetworkType.Shared;
    }

    public boolean isVpc() {
        return this.networkType == NetworkType.Vpc;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public boolean isFirewallServiceSupported() {
        return this.firewallServiceSupported;
    }

    public boolean isEgressDefaultPolicy() {
        return this.egressDefaultPolicy;
    }

    public String getDomainTemplateName() {
        return this.domainTemplateName;
    }

    public String getCidr() {
        return this.cidr;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getVirtualRouterIp() {
        return this.virtualRouterIp;
    }

    public boolean isPublicAccess() {
        return this.publicAccess;
    }

    public List<VspAddressRange> getAddressRanges() {
        return this.addressRanges;
    }

    public Pair<String, String> getVpcOrSubnetInfo() {
        return this.vpcOrSubnetInfo;
    }

    public boolean shouldReuseDomain() {
        return this.networkType == NetworkType.Vpc || this.networkType == NetworkType.Shared;
    }

    public String getSubnetExternalId() {
        return this.isShared() ? UuidUtils.generateUuidFromExternalIdAndIp(this.uuid, this.gateway) : this.uuid;
    }

    public boolean isVlanUnderlay() {
        return this.vlanUnderlay;
    }

    public NuageVspUser getProxyUser() {
        return new NuageVspUser(this.getAccountUuid(), this.getVspDomain().getUuid());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VspNetwork)) {
            return false;
        }
        VspNetwork that = (VspNetwork)o;
        if (this.egressDefaultPolicy != that.egressDefaultPolicy) {
            return false;
        }
        if (this.firewallServiceSupported != that.firewallServiceSupported) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.publicAccess != that.publicAccess) {
            return false;
        }
        if (this.accountName != null ? !this.accountName.equals(that.accountName) : that.accountName != null) {
            return false;
        }
        if (this.accountUuid != null ? !this.accountUuid.equals(that.accountUuid) : that.accountUuid != null) {
            return false;
        }
        if (this.addressRanges != null ? !this.addressRanges.equals(that.addressRanges) : that.addressRanges != null) {
            return false;
        }
        if (this.cidr != null ? !this.cidr.equals(that.cidr) : that.cidr != null) {
            return false;
        }
        if (this.domainTemplateName != null ? !this.domainTemplateName.equals(that.domainTemplateName) : that.domainTemplateName != null) {
            return false;
        }
        if (this.gateway != null ? !this.gateway.equals(that.gateway) : that.gateway != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.networkType != that.networkType) {
            return false;
        }
        if (this.uuid != null ? !this.uuid.equals(that.uuid) : that.uuid != null) {
            return false;
        }
        if (this.virtualRouterIp != null ? !this.virtualRouterIp.equals(that.virtualRouterIp) : that.virtualRouterIp != null) {
            return false;
        }
        if (this.vpcName != null ? !this.vpcName.equals(that.vpcName) : that.vpcName != null) {
            return false;
        }
        if (this.vpcUuid != null ? !this.vpcUuid.equals(that.vpcUuid) : that.vpcUuid != null) {
            return false;
        }
        if (this.vspDomain != null ? !this.vspDomain.equals(that.vspDomain) : that.vspDomain != null) {
            return false;
        }
        return this.vlanUnderlay == that.vlanUnderlay;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.uuid != null ? this.uuid.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.vspDomain != null ? this.vspDomain.hashCode() : 0);
        result = 31 * result + (this.accountName != null ? this.accountName.hashCode() : 0);
        result = 31 * result + (this.accountUuid != null ? this.accountUuid.hashCode() : 0);
        result = 31 * result + (this.vpcUuid != null ? this.vpcUuid.hashCode() : 0);
        result = 31 * result + (this.vpcName != null ? this.vpcName.hashCode() : 0);
        result = 31 * result + (this.networkType != null ? this.networkType.hashCode() : 0);
        result = 31 * result + (this.firewallServiceSupported ? 1 : 0);
        result = 31 * result + (this.egressDefaultPolicy ? 1 : 0);
        result = 31 * result + (this.domainTemplateName != null ? this.domainTemplateName.hashCode() : 0);
        result = 31 * result + (this.cidr != null ? this.cidr.hashCode() : 0);
        result = 31 * result + (this.gateway != null ? this.gateway.hashCode() : 0);
        result = 31 * result + (this.virtualRouterIp != null ? this.virtualRouterIp.hashCode() : 0);
        result = 31 * result + (this.publicAccess ? 1 : 0);
        result = 31 * result + (this.addressRanges != null ? this.addressRanges.hashCode() : 0);
        result = 31 * result + (this.vlanUnderlay ? 1 : 0);
        return result;
    }

    public static class Builder
    extends VspBuilder<Builder, VspNetwork> {
        private long id;
        private String uuid;
        private String name;
        private VspDomain vspDomain;
        private String accountName;
        private String accountUuid;
        private String vpcUuid;
        private String vpcName;
        private NetworkType networkType;
        private boolean firewallServiceSupported;
        private boolean egressDefaultPolicy;
        private String domainTemplateName;
        private String cidr;
        private String gateway;
        private String virtualRouterIp;
        private boolean publicAccess;
        private List<VspAddressRange> addressRanges;
        private boolean vlanUnderlay;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder domain(VspDomain vspDomain) {
            this.vspDomain = vspDomain;
            return this;
        }

        public Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public Builder accountUuid(String accountUuid) {
            this.accountUuid = accountUuid;
            return this;
        }

        public Builder vpcUuid(String vpcUuid) {
            this.vpcUuid = vpcUuid;
            return this;
        }

        public Builder vpcName(String vpcName) {
            this.vpcName = vpcName;
            return this;
        }

        public Builder networkType(NetworkType networkType) {
            this.networkType = networkType;
            return this;
        }

        public Builder firewallServiceSupported(boolean firewallServiceSupported) {
            this.firewallServiceSupported = firewallServiceSupported;
            return this;
        }

        public Builder egressDefaultPolicy(boolean egressDefaultPolicy) {
            this.egressDefaultPolicy = egressDefaultPolicy;
            return this;
        }

        public Builder domainTemplateName(String domainTemplateName) {
            this.domainTemplateName = domainTemplateName;
            return this;
        }

        public Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public Builder virtualRouterIp(String virtualRouterIp) {
            this.virtualRouterIp = virtualRouterIp;
            return this;
        }

        public Builder publicAccess(boolean publicAccess) {
            this.publicAccess = publicAccess;
            return this;
        }

        public Builder addressRanges(List<VspAddressRange> addressRanges) {
            this.addressRanges = addressRanges;
            return this;
        }

        public Builder vlanUnderlay(boolean vlanUnderlay) {
            this.vlanUnderlay = vlanUnderlay;
            return this;
        }

        @Override
        public VspNetwork build() {
            return new VspNetwork(this.id, this.uuid, this.name, this.vspDomain, this.accountName, this.accountUuid, this.vpcUuid, this.vpcName, this.networkType, this.firewallServiceSupported, this.egressDefaultPolicy, this.domainTemplateName, this.cidr, this.gateway, this.virtualRouterIp, this.publicAccess, this.addressRanges, this.vlanUnderlay);
        }

        @Override
        public Builder fromObject(VspNetwork obj) {
            return new Builder().id(obj.getId()).uuid(obj.getUuid()).name(obj.getName()).domain(obj.getVspDomain()).accountName(obj.getAccountName()).accountUuid(obj.getAccountUuid()).vpcUuid(obj.getVpcUuid()).vpcName(obj.getVpcName()).networkType(obj.getNetworkType()).firewallServiceSupported(obj.isFirewallServiceSupported()).egressDefaultPolicy(obj.isEgressDefaultPolicy()).domainTemplateName(obj.getDomainTemplateName()).cidr(obj.getCidr()).gateway(obj.getGateway()).virtualRouterIp(obj.getVirtualRouterIp()).publicAccess(obj.isPublicAccess()).addressRanges(obj.getAddressRanges()).vlanUnderlay(obj.isVlanUnderlay());
        }
    }

    public static enum NetworkType {
        L2,
        L3,
        Shared,
        Vpc;

    }
}

