/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import net.nuage.vsp.acs.client.common.utils.Logger;

public final class ConfigUtil {
    private static final Logger logger = new Logger(ConfigUtil.class);
    private static final String VSP_CONFIG_FILENAME_PROPERTY = "vsp.default.config";
    private static final String CONFIG_FILE = "/META-INF/vsp-defaults.properties";
    public static final String FLOATING_IP_QUOTA = "floatingIPQuota";
    public static final String ALLOW_GATEWAY_MANAGEMENT = "allowGatewayMgmt";
    public static final String ALLOW_ADVANCED_QOS = "allowAdvancedQOS";
    public static final String AVAILABLE_FWD_CLASS = "availableFwdClass";
    private static final Properties properties = new Properties();

    public static String getProperty(String key, String defaultValue) {
        return properties.getProperty(key, defaultValue);
    }

    public static int getPropertyInteger(String key, int defaultValue) {
        int intValue;
        String value = properties.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            logger.error((Object)("invalid value format for key = " + key + " value = " + value), e);
            intValue = defaultValue;
        }
        return intValue;
    }

    public static boolean getPropertyBoolean(String key, boolean defaultValue) {
        boolean booleanValue;
        String value = properties.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            booleanValue = Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            logger.error((Object)("invalid value format for key = " + key + " value = " + value), e);
            booleanValue = defaultValue;
        }
        return booleanValue;
    }

    static {
        try {
            String path = System.getProperty(VSP_CONFIG_FILENAME_PROPERTY);
            InputStream in = null;
            if (path != null) {
                in = new BufferedInputStream(new FileInputStream(path));
            } else {
                path = CONFIG_FILE;
                URL url = ConfigUtil.class.getClassLoader().getResource(path);
                if (url != null) {
                    in = url.openStream();
                }
            }
            if (in != null) {
                properties.load(in);
                in.close();
            } else {
                logger.warn("Failed to load the config file " + path, new Object[0]);
            }
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to load the config file.", e);
        }
    }
}

