/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common;

import java.util.Comparator;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang3.StringUtils;

public class NuageVspApiVersion
implements Comparable<NuageVspApiVersion> {
    private static final Pattern versionRegEx = Pattern.compile("v(\\d+)_(\\d+)(?:_(\\d+))?");
    public static final NuageVspApiVersion V3_2 = new NuageVspApiVersion(3, 2);
    public static final NuageVspApiVersion V4_0;
    public static final NuageVspApiVersion CURRENT;
    public static final NuageVspApiVersion[] SUPPORTED_VERSIONS;
    public static final NuageVspApiVersion[] VERSIONS_REQUIRING_UPGRADE;
    private Integer major;
    private Integer minor;
    private final Optional<Integer> patch;

    public NuageVspApiVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
        this.patch = Optional.empty();
    }

    public NuageVspApiVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = Optional.of(patch);
    }

    public NuageVspApiVersion(String version) {
        Matcher matcher = versionRegEx.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Bad version");
        }
        this.major = Integer.valueOf(matcher.group(1));
        this.minor = Integer.valueOf(matcher.group(2));
        this.patch = Optional.ofNullable(matcher.group(3)).map(Integer::valueOf);
    }

    public static NuageVspApiVersion fromString(String version) {
        version = version.toLowerCase().replace('.', '_');
        for (NuageVspApiVersion suppVersion : SUPPORTED_VERSIONS) {
            if (!StringUtils.equals((CharSequence)suppVersion.toString(), (CharSequence)version)) continue;
            return suppVersion;
        }
        return new NuageVspApiVersion(version);
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    @Override
    public int compareTo(NuageVspApiVersion other) {
        return Comparator.comparingInt(v -> v.major).thenComparing(v -> v.minor).thenComparing(v -> v.patch.orElse(0)).compare(this, other);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("v").append(this.major).append("_").append(this.minor);
        this.patch.ifPresent(p -> sb.append("_").append(p));
        return sb.toString();
    }

    public boolean isSupported() {
        return ArrayUtils.contains((Object[])SUPPORTED_VERSIONS, (Object)this);
    }

    static {
        CURRENT = V4_0 = new NuageVspApiVersion(4, 0);
        SUPPORTED_VERSIONS = new NuageVspApiVersion[]{V3_2, V4_0};
        VERSIONS_REQUIRING_UPGRADE = new NuageVspApiVersion[]{V3_2, V4_0};
    }

    public static enum Status {
        UNSUPPORTED,
        DEPRECATED,
        CURRENT;

    }
}

