/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common.model;

import com.google.common.net.InetAddresses;
import com.google.common.primitives.Bytes;
import java.util.Arrays;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import net.nuage.vsp.acs.client.common.model.Dhcp;
import org.apache.commons.lang.ArrayUtils;

public class DhcpOption {
    private String hexCode;
    private String hexLength;
    private String hexValue;
    private int code;
    private List<String> value;
    private Dhcp.DhcpOptionType optionType;

    public DhcpOption(int code, byte b) {
        this.setCode(code);
        this.setHexValue(new byte[]{b});
    }

    public DhcpOption(int code, String value) {
        this.setCode(code);
        this.value = new LinkedList<String>();
        this.optionType = (Dhcp.DhcpOptionType)((Object)Dhcp.dhcpCodeToType.get((Object)Dhcp.DhcpOptionCode.valueOf(code)));
        if (this.optionType == Dhcp.DhcpOptionType.LIST_OF_IPv4 || this.optionType == Dhcp.DhcpOptionType.LIST_OF_STRINGS) {
            this.value.addAll(Arrays.asList(value.split(",")));
        } else {
            this.value.add(value);
        }
        if (this.optionType == Dhcp.DhcpOptionType.RAW) {
            this.setHexValue(DatatypeConverter.parseHexBinary((String)value));
        }
    }

    public DhcpOption(int code, List<String> ipAdresses) {
        this.setCode(code);
        this.value = ipAdresses;
        this.optionType = (Dhcp.DhcpOptionType)((Object)Dhcp.dhcpCodeToType.get((Object)Dhcp.DhcpOptionCode.valueOf(code)));
        if (this.optionType == Dhcp.DhcpOptionType.RAW) {
            LinkedList<Byte> bytes = new LinkedList<Byte>();
            for (String ip : ipAdresses) {
                bytes.addAll(Arrays.asList(ArrayUtils.toObject((byte[])InetAddresses.forString((String)ip).getAddress())));
            }
            this.setHexValue(Bytes.toArray(bytes));
        }
    }

    public String getCodeAsHex() {
        return this.hexCode;
    }

    public int getCode() {
        return this.code;
    }

    public String getLengthAsHex() {
        return this.hexLength;
    }

    public String getValueAsHex() {
        return this.hexValue;
    }

    public List<String> getValue() {
        return this.value;
    }

    public Dhcp.DhcpOptionType getOptionType() {
        return this.optionType;
    }

    public void setOptionType(Dhcp.DhcpOptionType optionType) {
        this.optionType = optionType;
    }

    private void setHexValue(byte[] value) {
        this.hexLength = String.format("%02x", value.length);
        Formatter formatter = new Formatter();
        for (byte b : value) {
            formatter.format("%02x", b);
        }
        this.hexValue = formatter.toString();
    }

    private void setCode(int code) {
        this.code = code;
        this.hexCode = String.format("%02x", code);
    }
}

