/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common.model;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.nuage.vsp.acs.client.common.model.DhcpOption;
import org.apache.commons.lang.StringUtils;

public class DhcpOptions {
    public static final String CLEAR_IP = "0.0.0.0";
    public static final String CLEAR = "\u0000";
    public static final String CLEAR_DNS = "00";
    public static final int GATEWAY = 3;
    public static final int DNS_SERVERS = 6;
    public static final int HOST_NAME = 12;
    public static final int DOMAIN_NAME = 15;
    List<DhcpOption> options = Lists.newLinkedList();
    Set<Integer> toBeRemoved = new HashSet<Integer>();

    public DhcpOptions() {
    }

    public DhcpOptions(String vrIp, List<String> dnsServers, String networkDomain) {
        ArrayList allsDnsServers;
        ArrayList arrayList = allsDnsServers = vrIp == null ? Lists.newArrayList() : Lists.newArrayList((Object[])new String[]{vrIp});
        if (dnsServers != null) {
            allsDnsServers.addAll(dnsServers);
        }
        if (!allsDnsServers.isEmpty()) {
            this.options.add(new DhcpOption(6, allsDnsServers));
        }
        if (StringUtils.isNotBlank((String)networkDomain)) {
            this.options.add(new DhcpOption(15, networkDomain));
        }
    }

    public DhcpOptions(boolean defaultHasDns, String hostname, boolean networkHasDns, boolean defaultInterface, boolean domainRouter) {
        if (!domainRouter) {
            if (defaultHasDns) {
                if (defaultInterface) {
                    this.options.add(new DhcpOption(12, hostname));
                } else {
                    this.options.add(new DhcpOption(3, CLEAR_IP));
                    this.options.add(new DhcpOption(6, CLEAR_DNS));
                    if (networkHasDns) {
                        this.options.add(new DhcpOption(15, CLEAR));
                        this.options.add(new DhcpOption(12, hostname));
                    }
                }
            } else if (!defaultInterface) {
                this.options.add(new DhcpOption(3, CLEAR_IP));
                if (networkHasDns) {
                    this.options.add(new DhcpOption(6, CLEAR_DNS));
                    this.options.add(new DhcpOption(15, CLEAR));
                    this.options.add(new DhcpOption(12, hostname));
                }
            }
        }
    }

    public List<DhcpOption> getOptions() {
        return this.options;
    }

    public void addOption(DhcpOption option) {
        this.options.add(option);
    }

    public void addOptions(Iterable<DhcpOption> options) {
        Iterables.addAll(this.options, options);
    }

    public void addOptionToRemove(Integer optionCode) {
        this.toBeRemoved.add(optionCode);
    }

    public Set<Integer> getOptionsToBeRemoved() {
        return this.toBeRemoved;
    }
}

