/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common.ssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import javax.net.ssl.SSLSocket;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public class TLSSocketFactory
extends SSLSocketFactory {
    public static final TrustStrategy TRUST_ALL_CERTIFICATES_STRATEGY = new TrustStrategy(){

        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            return true;
        }
    };

    public TLSSocketFactory(TrustStrategy trustStategy, X509HostnameVerifier hostNameVerifier) throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        super(trustStategy, hostNameVerifier);
    }

    protected void prepareSocket(SSLSocket socket) throws IOException {
        String[] protocols = socket.getSupportedProtocols();
        HashSet<String> set = new HashSet<String>();
        for (String s : protocols) {
            if (s.equals("SSLv3") || s.equals("SSLv2Hello")) continue;
            set.add(s);
        }
        socket.setEnabledProtocols(set.toArray(new String[0]));
    }

    public static TLSSocketFactory getSocketFactory() {
        try {
            return new TLSSocketFactory(TRUST_ALL_CERTIFICATES_STRATEGY, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (GeneralSecurityException ex) {
            throw new SSLInitializationException("Failure initializing default SSL context", (Throwable)ex);
        }
    }

    public static SchemeRegistry createSchemeRegistry() {
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        registry.register(new Scheme("https", 443, (SchemeSocketFactory)TLSSocketFactory.getSocketFactory()));
        return registry;
    }
}

