/*
 * Decompiled with CFR 0.152.
 */
package net.nuage.vsp.acs.client.common.utils;

import java.nio.ByteBuffer;
import java.util.TreeSet;
import java.util.UUID;
import net.nuage.vsp.acs.client.common.utils.NetUtils;
import org.apache.commons.net.util.SubnetUtils;

public class UuidUtils {
    public static String generateUuidFromExternalIdAndIp(String externalId, String ip) {
        byte[] externalIdBytes = externalId.getBytes();
        byte[] ipBytes = ip.getBytes();
        ByteBuffer bb = ByteBuffer.wrap(new byte[externalIdBytes.length + ipBytes.length]);
        bb.put(externalIdBytes);
        bb.put(ipBytes);
        UUID uuid = UUID.nameUUIDFromBytes(bb.array());
        return uuid.toString();
    }

    public static String generateUuidFromString(String string, String base) {
        byte[] bytes = string.getBytes();
        if (base != null) {
            int size = bytes.length + 16;
            ByteBuffer bb = ByteBuffer.wrap(new byte[size]);
            UUID namespace = UUID.fromString(base);
            bb.putLong(namespace.getMostSignificantBits());
            bb.putLong(namespace.getLeastSignificantBits());
            bb.put(bytes);
            bytes = bb.array();
        }
        UUID uuid = UUID.nameUUIDFromBytes(bytes);
        return uuid.toString();
    }

    public static String generateUuidFromCidr(String cidrList) {
        return UuidUtils.generateUuidFromCidr(cidrList, null);
    }

    public static String generateUuidFromCidr(String cidrList, String base) {
        TreeSet<CIDR> cidrs = new TreeSet<CIDR>();
        for (String string : cidrList.split(",\\s*")) {
            cidrs.add(new CIDR(string));
        }
        int size = cidrs.size() * 12;
        if (base != null) {
            size += 16;
        }
        ByteBuffer bb = ByteBuffer.wrap(new byte[size]);
        if (base != null) {
            UUID namespace = UUID.fromString(base);
            bb.putLong(namespace.getMostSignificantBits());
            bb.putLong(namespace.getLeastSignificantBits());
        }
        for (CIDR cIDR : cidrs) {
            bb.putLong(cIDR.cidrAsLong[0]);
            bb.putInt(cIDR.cidrAsLong[1].intValue());
        }
        UUID uuid = UUID.nameUUIDFromBytes(bb.array());
        return uuid.toString();
    }

    private static final class CIDR
    implements Comparable<CIDR> {
        Long[] cidrAsLong;
        String lowAddress;
        String highAddress;
        SubnetUtils.SubnetInfo subnet;

        CIDR(String cidrString) {
            this.cidrAsLong = NetUtils.cidrToLong(cidrString);
            if (this.cidrAsLong[1] == 0L) {
                this.lowAddress = "0.0.0.0";
                this.highAddress = "255.255.255.255";
            } else {
                this.subnet = new SubnetUtils(cidrString).getInfo();
                this.lowAddress = this.subnet.getLowAddress();
                this.highAddress = this.subnet.getHighAddress();
            }
        }

        @Override
        public int compareTo(CIDR o) {
            int result = this.lowAddress.compareTo(o.lowAddress);
            if (result != 0) {
                return result;
            }
            return o.highAddress.compareTo(this.highAddress);
        }
    }
}

