/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.api;

import java.util.List;

import net.nuage.vsp.acs.client.api.model.VspDhcpDomainOption;
import net.nuage.vsp.acs.client.api.model.VspDhcpVMOption;
import net.nuage.vsp.acs.client.api.model.VspNetwork;
import net.nuage.vsp.acs.client.api.model.NetworkRelatedVsdIds;
import net.nuage.vsp.acs.client.api.model.VspNic;
import net.nuage.vsp.acs.client.api.model.VspStaticNat;
import net.nuage.vsp.acs.client.api.model.VspVm;
import net.nuage.vsp.acs.client.exception.NuageVspException;

public interface NuageVspGuruClient extends NuageVspClient {

    /**
     * Implement a network
     * @param vspNetwork The network to implement
     * @param vspDhcpOptions The list of Dhcp options to be configured
     * @throws NuageVspException
     */
    NetworkRelatedVsdIds implement(VspNetwork vspNetwork, VspDhcpDomainOption vspDhcpOptions) throws NuageVspException;

    /**
     * Implement a network
     * @param vspNetwork The network to implement
     * @param vspDhcpOptions The list of Dhcp options to be configured
     * @throws NuageVspException
     */
    VspNetwork findIsolatedL3Network(VspNetwork vsdSubnetId) throws NuageVspException;

    /**
     * Reserve an interface for a VM in a network
     * @param vspNetwork The network
     * @param vspVm The VM to reserve an interface for
     * @param vspNic The interface to reserve
     * @param vspStaticNat The static NAT details
     * @throws NuageVspException
     */
    void reserve(VspNetwork vspNetwork, VspVm vspVm, VspNic vspNic, VspStaticNat vspStaticNat, VspDhcpVMOption vspDhcpVMOption) throws NuageVspException;

    /**
     * Deallocate an interface from a VM in a network
     * @param vspNetwork The network
     * @param vspVm The VM to deallocate an interface from
     * @param vspNic The interface to be deallocated
     * @throws NuageVspException
     */
    void deallocate(VspNetwork vspNetwork, VspVm vspVm, VspNic vspNic) throws NuageVspException;

    /**
     * Destroy a network
     * @param vspNetwork The network to be destroyed
     * @throws NuageVspException
     */
    void trash(VspNetwork vspNetwork) throws NuageVspException;

    /**
     * Update the dhcp option on the list of VM's
     * @param dhcpOptions The list VM's with there dhcp options to apply
     * @param vspNetwork The network off these VM's
     * @throws NuageVspException
     */
    void applyDhcpOptions(List<VspDhcpVMOption> dhcpOptions, VspNetwork vspNetwork) throws NuageVspException;

}
