/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.api;

import net.nuage.vsp.acs.client.common.RequestType;
import net.nuage.vsp.acs.client.common.model.NuageVspEntity;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

/**
 * Created by sgoeminn on 1/24/17.
 */
public interface NuageVspStatistics {

    /**
     * Report a call to the VSD
     * @param entity that is been queried
     * @param requestType that is used
     */
    void reportVSDCall(NuageVspEntity entity, RequestType requestType);

    Map<NuageVspEntity, Map<RequestType, AtomicLong>> getVsdCountReport();

    /**
     *
     * @param entity
     * @param type
     * @return count of all VSD calls with EntityType entity and RequestType type
     */
    long getVsdCount(NuageVspEntity entity, RequestType type);

    /**
     *
     * @param entity
     * @return count of all VSD calls with EntityType entity
     */
    long getVsdCount(NuageVspEntity entity);

    /**
     *
     * @param type
     * @return count of all VSD calls with requestType type
     */
    long getVsdCount(RequestType type);

    /**
     *
     * @return global count of all calls to VSD since start up
     */
    long getVsdCount();
}
