/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.api.model;

import com.google.common.base.Objects;


import java.io.Serializable;
import java.util.Optional;

public class NetworkRelatedVsdIds implements Serializable {
    private final String vsdEnterpriseId;
    private final String vsdDomainId;
    private final String vsdZoneId;
    private final String vsdSubnetId;

    private NetworkRelatedVsdIds(String vsdEnterpriseId, String vsdDomainId, String vsdZoneId, String vsdSubnetId) {
        this.vsdEnterpriseId = vsdEnterpriseId;
        this.vsdDomainId = vsdDomainId;
        this.vsdZoneId = vsdZoneId;
        this.vsdSubnetId = vsdSubnetId;
    }

    public Optional<String> getVsdEnterpriseId() {
        return Optional.ofNullable(vsdEnterpriseId);
    }

    public Optional<String> getVsdDomainId() {
        return Optional.ofNullable(vsdDomainId);
    }

    public Optional<String> getVsdZoneId() {
        return Optional.ofNullable(vsdZoneId);
    }

    public Optional<String> getVsdSubnetId() {
        return Optional.ofNullable(vsdSubnetId);
    }

    public static class Builder extends VspBuilder<Builder, NetworkRelatedVsdIds> {
        private String vsdEnterpriseId;
        private String vsdDomainId;
        private String vsdZoneId;
        private String vsdSubnetId;

        public Builder vsdEnterpriseId(String enterpriseId) {
            this.vsdEnterpriseId = enterpriseId;
            return this;
        }

        public Builder vsdDomainId(String vsdDomainId) {
            this.vsdDomainId = vsdDomainId;
            return this;
        }

        public Builder vsdZoneId(String vsdZoneId) {
            this.vsdZoneId = vsdZoneId;
            return this;
        }

        public Builder vsdSubnetId(String vsdSubnetId) {
            this.vsdSubnetId = vsdSubnetId;
            return this;
        }

        @Override
        public NetworkRelatedVsdIds build() {
            return new NetworkRelatedVsdIds(vsdEnterpriseId, vsdDomainId, vsdZoneId, vsdSubnetId);
        }

        @Override
        public Builder fromObject(NetworkRelatedVsdIds obj) {
            return  this
                    .vsdEnterpriseId(obj.getVsdEnterpriseId().orElse(null))
                    .vsdDomainId(obj.getVsdDomainId().orElse(null))
                    .vsdZoneId(obj.getVsdZoneId().orElse(null))
                    .vsdSubnetId(obj.getVsdSubnetId().orElse(null));
        }

    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        NetworkRelatedVsdIds that = (NetworkRelatedVsdIds) o;
        return Objects.equal(vsdEnterpriseId, that.vsdEnterpriseId) &&
                Objects.equal(vsdDomainId, that.vsdDomainId) &&
                Objects.equal(vsdZoneId, that.vsdZoneId) &&
                Objects.equal(vsdSubnetId, that.vsdSubnetId);
    }

    @Override
    public int hashCode() {
        int result = vsdEnterpriseId != null ? vsdEnterpriseId.hashCode() : 0;
        result = 31 * result + (vsdDomainId != null ? vsdDomainId.hashCode() : 0);
        result = 31 * result + (vsdZoneId != null ? vsdZoneId.hashCode() : 0);
        result = 31 * result + (vsdSubnetId != null ? vsdSubnetId.hashCode() : 0);
        return result;
    }
}