/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.api.model;

public class VspAddressRange extends VspObject {
    private final String gateway;
    private final String netmask;

    private VspAddressRange(String gateway, String netmask) {
        this.gateway = gateway;
        this.netmask = netmask;
    }

    public String getGateway() {
        return gateway;
    }

    public String getNetmask() {
        return netmask;
    }

    public static class Builder extends VspBuilder<Builder, VspAddressRange> {
        private String gateway;
        private String netmask;

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public Builder netmask(String netmask) {
            this.netmask = netmask;
            return this;
        }

        @Override
        public VspAddressRange build() {
            return new VspAddressRange(gateway, netmask);
        }

        @Override
        public Builder fromObject(VspAddressRange obj) {
            return new Builder().gateway(obj.getGateway()).netmask(obj.getNetmask());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof VspAddressRange)) return false;

        VspAddressRange that = (VspAddressRange) o;

        if (gateway != null ? !gateway.equals(that.gateway) : that.gateway != null) return false;
        if (netmask != null ? !netmask.equals(that.netmask) : that.netmask != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = gateway != null ? gateway.hashCode() : 0;
        result = 31 * result + (netmask != null ? netmask.hashCode() : 0);
        return result;
    }
}
