/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.api.model;

import java.util.Objects;

import org.apache.commons.lang.builder.ToStringBuilder;

public class VspDhcpVMOption {

    private final String hostname, nicUuid;
    private final Boolean defaultHasDns, networkHasDns, domainRouter, defaultInterface;

    private VspDhcpVMOption(String nicUuid, Boolean defaultHasDns, String hostname, Boolean networkHasDns, Boolean defaultInterface, Boolean domainRouter){
        this.nicUuid= nicUuid;
        this.hostname= hostname;
        this.defaultHasDns = defaultHasDns;
        this.networkHasDns = networkHasDns;
        this.domainRouter = domainRouter;
        this.defaultInterface = defaultInterface;
    }


    public String getHostname() {
        return hostname;
    }

    public String getNicUuid() {
        return nicUuid;
    }

    public Boolean defaultHasDns() {
        return defaultHasDns;
    }

    public Boolean networkHasDns() {
        return networkHasDns;
    }

    public Boolean isDomainRouter() {
        return domainRouter;
    }

    public Boolean isDefaultInterface() {
        return defaultInterface;
    }

    public static class Builder extends VspBuilder<Builder, VspDhcpVMOption> {
        private String hostname, nicUuid;
        private Boolean defaultHasDns, networkHasDns, domainRouter, defaultInterface;

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder nicUuid(String nicUuid) {
            this.nicUuid = nicUuid;
            return this;
        }

        public Builder defaultHasDns(Boolean defaultHasDns) {
            this.defaultHasDns = defaultHasDns;
            return this;
        }

        public Builder networkHasDns(Boolean networkHasDns) {
            this.networkHasDns = networkHasDns;
            return this;
        }

        public Builder domainRouter(Boolean domainRouter) {
            this.domainRouter = domainRouter;
            return this;
        }

        public Builder isDefaultInterface(Boolean defaultInterface) {
            this.defaultInterface = defaultInterface;
            return this;
        }

        @Override
        public VspDhcpVMOption build() {
            return new VspDhcpVMOption(nicUuid, defaultHasDns, hostname, networkHasDns, defaultInterface, domainRouter);
        }

        @Override
        public Builder fromObject(VspDhcpVMOption obj) {
            return new Builder()
                    .nicUuid(obj.getNicUuid())
                    .defaultHasDns(obj.defaultHasDns())
                    .hostname(obj.getHostname())
                    .networkHasDns(obj.networkHasDns())
                    .isDefaultInterface(obj.isDefaultInterface())
                    .domainRouter(obj.isDomainRouter());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (!(o instanceof VspDhcpVMOption)) {
            return false;
        }

        VspDhcpVMOption that = (VspDhcpVMOption) o;
        return Objects.equals(nicUuid, that.nicUuid)
                && Objects.equals(hostname, that.hostname)
                && Objects.equals(defaultHasDns, that.defaultHasDns)
                && Objects.equals(defaultInterface, that.defaultInterface)
                && Objects.equals(domainRouter, that.domainRouter)
                && Objects.equals(networkHasDns, that.networkHasDns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(nicUuid, hostname, defaultInterface, defaultHasDns, networkHasDns, domainRouter);
    }

    @Override public String toString() {
        return new ToStringBuilder(this)
                .append("nicUuid", nicUuid)
                .append("hostname", hostname)
                .append("defaultInterface", defaultInterface)
                .append("defaultHasDns", defaultHasDns)
                .append("networkHasDns", networkHasDns)
                .append("domainRouter", domainRouter)
                .toString();
    }
}
