/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.api.model;

import java.util.List;
import java.util.Map;

public class VspDomainCleanUp {
    private final String uuid;

    // Key : Domain template name
    // Value : List of shared network UUIDs that use this domain template name
    private final Map<String, List<String>> sharedNetworkUuids;

    private VspDomainCleanUp(String uuid, Map<String, List<String>> sharedNetworkUuids) {
        this.uuid = uuid;
        this.sharedNetworkUuids = sharedNetworkUuids;
    }

    public String getUuid() {
        return uuid;
    }

    public Map<String, List<String>> getSharedNetworkUuids() {
        return sharedNetworkUuids;
    }

    public static class Builder extends VspBuilder<Builder, VspDomainCleanUp> {
        private String uuid;
        private Map<String, List<String>> sharedNetworkUuids;

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder sharedNetworkUuids(Map<String, List<String>> sharedNetworkUuids) {
            this.sharedNetworkUuids = sharedNetworkUuids;
            return this;
        }

        @Override
        public VspDomainCleanUp build() {
            return new VspDomainCleanUp(uuid, sharedNetworkUuids);
        }

        @Override
        public Builder fromObject(VspDomainCleanUp obj) {
            return new Builder().uuid(obj.getUuid()).sharedNetworkUuids(obj.getSharedNetworkUuids());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof VspDomainCleanUp)) return false;

        VspDomainCleanUp that = (VspDomainCleanUp) o;

        if (sharedNetworkUuids != null ? !sharedNetworkUuids.equals(that.sharedNetworkUuids) : that.sharedNetworkUuids != null)
            return false;
        if (uuid != null ? !uuid.equals(that.uuid) : that.uuid != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = uuid != null ? uuid.hashCode() : 0;
        result = 31 * result + (sharedNetworkUuids != null ? sharedNetworkUuids.hashCode() : 0);
        return result;
    }
}
