/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.api.model;

public class VspVm extends VspObject {
    public enum State {
        Starting, Running, Stopping, Stopped, Destroyed, Expunging, Migrating, Error, Unknown, Shutdowned
    }

    private final State state;
    private final String uuid;
    private final String name;
    private final Boolean domainRouter;
    private final String domainRouterIp;

    private VspVm(State state, String uuid, String name, Boolean domainRouter, String domainRouterIp) {
        this.state = state;
        this.uuid = uuid;
        this.name = name;
        this.domainRouter = domainRouter;
        this.domainRouterIp = domainRouterIp;
    }

    public State getState() {
        return state;
    }

    public String getUuid() {
        return uuid;
    }

    public String getName() {
        return name;
    }

    public Boolean getDomainRouter() {
        return domainRouter;
    }

    public String getDomainRouterIp() {
        return domainRouterIp;
    }

    public static class Builder extends VspBuilder<Builder, VspVm> {
        private State state;
        private String uuid;
        private String name;
        private Boolean domainRouter;
        private String domainRouterIp;

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder domainRouter(Boolean domainRouter) {
            this.domainRouter = domainRouter;
            return this;
        }

        public Builder domainRouterIp(String domainRouterIp) {
            this.domainRouterIp = domainRouterIp;
            return this;
        }

        @Override
        public VspVm build() {
            return new VspVm(state, uuid, name, domainRouter, domainRouterIp);
        }

        @Override
        public Builder fromObject(VspVm obj) {
            return new Builder().state(obj.getState()).uuid(obj.getUuid()).name(obj.getName())
                    .domainRouter(obj.getDomainRouter()).domainRouterIp(obj.getDomainRouterIp());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof VspVm)) return false;

        VspVm vspVm = (VspVm) o;

        if (domainRouter != null ? !domainRouter.equals(vspVm.domainRouter) : vspVm.domainRouter != null) return false;
        if (domainRouterIp != null ? !domainRouterIp.equals(vspVm.domainRouterIp) : vspVm.domainRouterIp != null)
            return false;
        if (name != null ? !name.equals(vspVm.name) : vspVm.name != null) return false;
        if (state != vspVm.state) return false;
        if (uuid != null ? !uuid.equals(vspVm.uuid) : vspVm.uuid != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = state != null ? state.hashCode() : 0;
        result = 31 * result + (uuid != null ? uuid.hashCode() : 0);
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + (domainRouter != null ? domainRouter.hashCode() : 0);
        result = 31 * result + (domainRouterIp != null ? domainRouterIp.hashCode() : 0);
        return result;
    }
}
