/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.common.model;

import java.util.List;

import net.nuage.vsp.acs.client.common.NuageVspConstants;

public class NuageVspError {
    public static class Description {
        private String title;
        private String description;

        public String getTitle() {
            return title;
        }

        public String getDescription() {
            return description;
        }
    }

    public static class Detail {
        private String property;
        private List<Description> descriptions;

        public List<Description> getDescriptions() {
            return descriptions;
        }

        public void setDescriptions(List<Description> descriptions) {
            this.descriptions = descriptions;
        }
    }

    private NuageVspConstants.ErrorCode internalErrorCode;
    private String title;
    private String description;
    private List<Detail> errors;
    private String stackTrace;

    public NuageVspError(NuageVspConstants.ErrorCode internalErrorCode, List<Detail> errors, String stackTrace) {
        this.internalErrorCode = internalErrorCode;
        this.errors = errors;
        this.stackTrace = stackTrace;
    }

    public NuageVspConstants.ErrorCode getInternalErrorCode() {
        return internalErrorCode;
    }

    public List<Detail> getErrors() {
        return errors;
    }

    public String getStackTrace() {
        return stackTrace;
    }

    public String getTitle() {
        return title;
    }

    public String getDescription() {
        return description;
    }

    public void setInternalErrorCode(NuageVspConstants.ErrorCode internalErrorCode) {
        this.internalErrorCode = internalErrorCode;
    }
}
