/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.common.model;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by sgoeminn on 3/20/17.
 */
//TODO:Rename class to more appropriate name
public class NuageVspNetworkVsdInformation {
    public enum VsdInformation {
        ENTITY_TYPE("entityType"), VSD_ENTERPRISE_ID("vsdEnterpriseId"), VSD_DOMAIN_ID("vsdDomainId"), VSD_SUBNET_ID("vsdSubnetId");

        private String value;

        VsdInformation(String value) {
            this.value = value;
        }
    }

    private Map<String,String> networkInformation = new HashMap<>();

    public NuageVspNetworkVsdInformation(){

    }

    public NuageVspNetworkVsdInformation(String entityType, String enterpriseId, String domainId, String subnetId){
        addItem(VsdInformation.ENTITY_TYPE, entityType);
        addItem(VsdInformation.VSD_ENTERPRISE_ID, enterpriseId);
        addItem(VsdInformation.VSD_DOMAIN_ID, domainId);
        addItem(VsdInformation.VSD_SUBNET_ID, subnetId);
    }

    public void addItem(VsdInformation vsdInformation, String value) {
        networkInformation.put(vsdInformation.value, value);
    }

    public Map<String, String> getNetworkInformation() {
        return networkInformation;
    }

}
