/**
 * Copyright © 2016 Nokia
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.nuage.vsp.acs.client.common.model.gson;

import java.lang.reflect.Type;

import net.nuage.vsp.acs.client.common.model.CodedEnum;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;

@SuppressWarnings("rawtypes")
public class CodedEnumTypeAdapter<T> implements JsonDeserializer<CodedEnum>, JsonSerializer<CodedEnum> {

    @Override
    public CodedEnum deserialize(JsonElement src, Type srcType, JsonDeserializationContext context) throws JsonParseException {
        Object value = src.getAsString();

        Class<CodedEnum> clazz = (Class<CodedEnum>)srcType;

        for (CodedEnum codedEnum : clazz.getEnumConstants()) {
            if (codedEnum.getCode().equals(value)) {
                return codedEnum;
            }
        }

        return null;

    }

    @Override public JsonElement serialize(CodedEnum entity, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(entity.getCode().toString());
    }
}
